/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportEditorInput;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.FragmentResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.PathResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.views.ReportResourceChangeEvent;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.editors.IPathEditorInputFactory;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerTreeViewPage;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ReportElementEntry;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ReportResourceEntry;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ResourceEntryWrapper;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.IReportResourceChangeEvent;
import org.eclipse.birt.report.designer.ui.views.IReportResourceSynchronizer;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceAction
extends Action {
    private static final String BUNDLE_PROTOCOL = "bundleresource://";
    private static final Collection<File> createdFiles = new HashSet<File>();
    private final LibraryExplorerTreeViewPage viewerPage;

    public ResourceAction(String actionText, LibraryExplorerTreeViewPage viewer) {
        super(actionText);
        this.setToolTipText(actionText);
        this.viewerPage = viewer;
    }

    protected TreeViewer getTreeViewer() {
        return this.viewerPage.getTreeViewer();
    }

    protected Shell getShell() {
        return this.viewerPage.getSite().getShell();
    }

    protected void refreshAll() {
        Display display = this.getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (ResourceAction.this.viewerPage != null) {
                    ResourceAction.this.viewerPage.refreshRoot();
                }
            }
        });
    }

    protected Collection<?> expandResources(Collection<?> resources) {
        HashSet<Object> libraries = new HashSet<Object>();
        if (resources != null && !resources.isEmpty()) {
            this.retrieveReources(libraries, resources);
        }
        return libraries.size() > 0 ? libraries : null;
    }

    private void retrieveReources(Collection<Object> libraries, Collection<?> files) {
        for (Object element : files) {
            LibraryHandle library;
            if (element instanceof ResourceEntryWrapper && ((ResourceEntryWrapper)element).getType() == 0) {
                library = (LibraryHandle)((ResourceEntryWrapper)element).getAdapter(LibraryHandle.class);
                if (library.getFileName().startsWith(BUNDLE_PROTOCOL)) {
                    return;
                }
                libraries.add(library);
                continue;
            }
            if (element instanceof ResourceEntryWrapper && ((ResourceEntryWrapper)element).getType() == 1) {
                library = (CssStyleSheetHandle)((ResourceEntryWrapper)element).getAdapter(CssStyleSheetHandle.class);
                if (library.getFileName().startsWith(BUNDLE_PROTOCOL)) {
                    return;
                }
                libraries.add(library);
                continue;
            }
            if (element instanceof LibraryHandle) {
                library = (LibraryHandle)element;
                if (library.getFileName().startsWith(BUNDLE_PROTOCOL)) {
                    return;
                }
                libraries.add(library);
                continue;
            }
            if (element instanceof CssStyleSheetHandle) {
                library = (CssStyleSheetHandle)element;
                if (library.getFileName().startsWith(BUNDLE_PROTOCOL)) {
                    return;
                }
                libraries.add(library);
                continue;
            }
            if (element instanceof ReportResourceEntry && ((ReportResourceEntry)element).getReportElement() instanceof LibraryHandle) {
                library = (LibraryHandle)((ReportResourceEntry)element).getReportElement();
                if (library.getFileName().startsWith(BUNDLE_PROTOCOL)) {
                    return;
                }
                libraries.add(library);
                continue;
            }
            if (element instanceof ReportResourceEntry && ((ReportResourceEntry)element).getReportElement() instanceof CssStyleSheetHandle) {
                library = (CssStyleSheetHandle)((ReportResourceEntry)element).getReportElement();
                if (library.getFileName().startsWith(BUNDLE_PROTOCOL)) {
                    return;
                }
                libraries.add(library);
                continue;
            }
            if (element instanceof PathResourceEntry) {
                libraries.add(element);
                if (((PathResourceEntry)element).isFile()) continue;
                this.retrieveReources(libraries, Arrays.asList(((PathResourceEntry)element).getChildren()));
                continue;
            }
            if (!(element instanceof FragmentResourceEntry)) continue;
            libraries.add(element);
        }
    }

    protected Collection<?> getSelectedResources() {
        ISelection selection;
        ArrayList resources = new ArrayList();
        ISelection iSelection = selection = this.viewerPage == null ? null : this.viewerPage.getSelection();
        if (selection instanceof IStructuredSelection) {
            resources.addAll(((IStructuredSelection)selection).toList());
        }
        return resources;
    }

    protected boolean canModifySelectedResources() {
        Collection<?> resources = this.getSelectedResources();
        if (resources == null || resources.isEmpty()) {
            return false;
        }
        for (Object resource : resources) {
            if (resource instanceof ResourceEntryWrapper) {
                if (!(((ResourceEntryWrapper)resource).getParent() instanceof FragmentResourceEntry)) continue;
                return false;
            }
            if (resource instanceof PathResourceEntry) {
                if (!((PathResourceEntry)resource).isRoot()) continue;
                return false;
            }
            if (resource instanceof FragmentResourceEntry) {
                return false;
            }
            if (!(resource instanceof ReportElementEntry)) continue;
            return false;
        }
        return true;
    }

    protected boolean canInsertIntoSelectedContainer() throws IOException {
        return this.getSelectedContainer() != null;
    }

    protected Collection<File> getSelectedFiles() throws IOException {
        Collection<?> currentResource = this.getSelectedResources();
        HashSet<File> files = new HashSet<File>();
        if (currentResource == null) {
            return files;
        }
        for (Object resource : currentResource) {
            File file = null;
            if (resource instanceof LibraryHandle) {
                file = new File(((LibraryHandle)resource).getFileName());
            } else if (resource instanceof CssStyleSheetHandle) {
                CssStyleSheetHandle node = (CssStyleSheetHandle)resource;
                ModuleHandle module = SessionHandleAdapter.getInstance().getReportDesignHandle();
                URL url = module.findResource(node.getFileName(), 3);
                file = ResourceAction.convertToFile(url);
            } else if (resource instanceof ResourceEntry) {
                file = ResourceAction.convertToFile(((ResourceEntry)resource).getURL());
            }
            if (file == null || !file.exists()) continue;
            files.add(file);
        }
        return files;
    }

    protected File getSelectedContainer() throws IOException {
        if (this.includeFragment(this.getSelectedResources())) {
            return null;
        }
        Collection<File> files = this.getSelectedFiles();
        File folder = null;
        for (File file : files) {
            File container;
            File file2 = container = file.isDirectory() ? file : file.getParentFile();
            if (container == null) {
                return null;
            }
            if (folder == null) {
                folder = container;
                continue;
            }
            if (folder.equals(container)) continue;
            return null;
        }
        return folder == null ? null : folder;
    }

    protected boolean includeFragment(Collection<?> resources) {
        for (Object resource : resources) {
            if (!(resource instanceof ResourceEntryWrapper ? ((ResourceEntryWrapper)resource).getParent() instanceof FragmentResourceEntry : resource instanceof FragmentResourceEntry)) continue;
            return true;
        }
        return false;
    }

    protected IRunnableWithProgress createCopyFileRunnable(final File srcFile, final File targetFile) {
        return new IRunnableWithProgress(){

            public final synchronized void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(null, -1);
                try {
                    try {
                        if (srcFile != null && srcFile.exists()) {
                            if (srcFile.isDirectory()) {
                                ResourceAction.copyFolder(srcFile, targetFile, monitor);
                            } else {
                                ResourceAction.copyFile(srcFile, targetFile);
                            }
                            if (targetFile != null) {
                                ResourceAction.this.fireResourceChanged(targetFile.getAbsolutePath());
                            }
                        }
                    }
                    catch (IOException e) {
                        ExceptionUtil.handle((Throwable)e);
                        monitor.done();
                        createdFiles.clear();
                    }
                }
                finally {
                    monitor.done();
                    createdFiles.clear();
                }
            }
        };
    }

    public static void copyFolder(File srcFolder, File targetFolder) throws IOException {
        ResourceAction.copyFolder(srcFolder, targetFolder, null);
    }

    public static void copyFolder(File srcFolder, File targetFolder, IProgressMonitor monitor) throws IOException {
        if (targetFolder == null) {
            throw new IOException(Messages.getString((String)"PublishResourceAction.wizard.notvalidfolder"));
        }
        if (createdFiles.contains(srcFolder)) {
            return;
        }
        File[] children = srcFolder.listFiles();
        if (targetFolder.mkdirs()) {
            createdFiles.add(targetFolder);
        }
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File source = fileArray[n2];
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            File target = new Path(targetFolder.getAbsolutePath()).append(source.getName()).toFile();
            if (source.isDirectory()) {
                ResourceAction.copyFolder(source, target, monitor);
            } else {
                ResourceAction.copyFile(source, target);
            }
            ++n2;
        }
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        if (destFile == null) {
            throw new IOException(Messages.getString((String)"PublishResourceAction.wizard.notvalidfolder"));
        }
        if (srcFile.equals(destFile)) {
            return;
        }
        if (destFile.createNewFile()) {
            createdFiles.add(destFile);
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel fcin = null;
        AbstractInterruptibleChannel fcout = null;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFile);
            fcin = fis.getChannel();
            fcout = fos.getChannel();
            ((FileChannel)fcin).transferTo(0L, ((FileChannel)fcin).size(), (WritableByteChannel)((Object)fcout));
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (fcin != null) {
                fcin.close();
            }
            if (fcout != null) {
                fcout.close();
            }
        }
    }

    public static File convertToFile(URL url) throws IOException {
        if (url == null) {
            throw new IOException(Messages.getString((String)"ResourceAction.ConvertToFile.URLIsNull"));
        }
        URL fileURL = FileLocator.toFileURL((URL)url);
        Path path = new Path(fileURL.getPath());
        String ref = fileURL.getRef();
        String fullPath = path.toFile().getAbsolutePath();
        if (ref != null) {
            ref = "#" + ref;
            if (path.toString().endsWith("/")) {
                return path.append(ref).toFile();
            }
            fullPath = String.valueOf(fullPath) + ref;
        }
        return new File(fullPath);
    }

    protected void openLibrary(File file, boolean forceRefresh) {
        if (file != null) {
            ResourceAction.openLibrary(this.viewerPage, file, forceRefresh);
        }
    }

    public static void openLibrary(final LibraryExplorerTreeViewPage viewer, final File file, final boolean forceRefresh) {
        if (file == null || !file.exists() || !file.isFile()) {
            return;
        }
        Display display = viewer != null ? viewer.getSite().getShell().getDisplay() : Display.getCurrent();
        display.asyncExec(new Runnable(){

            public void run() {
                block9: {
                    block8: {
                        try {
                            try {
                                IFile file2;
                                IWorkbenchPage page;
                                IWorkbench workbench = PlatformUI.getWorkbench();
                                IWorkbenchWindow window = workbench == null ? null : workbench.getActiveWorkbenchWindow();
                                IWorkbenchPage iWorkbenchPage = page = window == null ? null : window.getActivePage();
                                if (page == null) break block8;
                                ReportEditorInput input = null;
                                Object adapter = Platform.getAdapterManager().getAdapter((Object)viewer, IPathEditorInputFactory.class);
                                if (adapter instanceof IPathEditorInputFactory && (file2 = (IFile)(input = ((IPathEditorInputFactory)adapter).create((IPath)new Path(file.getAbsolutePath()))).getAdapter(IFile.class)) != null) {
                                    try {
                                        file2.refreshLocal(2, null);
                                    }
                                    catch (CoreException coreException) {}
                                }
                                if (input == null) {
                                    input = new ReportEditorInput(file);
                                }
                                page.openEditor(input, "org.eclipse.birt.report.designer.ui.editors.LibraryEditor", true);
                            }
                            catch (PartInitException e) {
                                ExceptionUtil.handle((Throwable)e);
                                viewer.selectPath(new String[]{file.getAbsolutePath()}, forceRefresh);
                                break block9;
                            }
                        }
                        catch (Throwable throwable) {
                            viewer.selectPath(new String[]{file.getAbsolutePath()}, forceRefresh);
                            throw throwable;
                        }
                    }
                    viewer.selectPath(new String[]{file.getAbsolutePath()}, forceRefresh);
                }
            }
        });
    }

    protected void fireResourceChanged(String ... fileNames) {
        if (fileNames == null || fileNames.length == 0) {
            return;
        }
        this.refreshAll();
        IReportResourceSynchronizer synchronizer = ReportPlugin.getDefault().getResourceSynchronizerService();
        if (synchronizer != null) {
            if (fileNames.length == 1) {
                synchronizer.notifyResourceChanged((IReportResourceChangeEvent)new ReportResourceChangeEvent((Object)this.viewerPage, (Object)Path.fromOSString((String)fileNames[0]), 1));
            } else {
                IPath[] paths = new IPath[fileNames.length];
                int i = 0;
                while (i < fileNames.length) {
                    paths[i] = Path.fromOSString((String)fileNames[i]);
                    ++i;
                }
                synchronizer.notifyResourceChanged((IReportResourceChangeEvent)new ReportResourceChangeEvent((Object)this.viewerPage, (Object)paths, 1));
            }
        }
    }

    protected IRunnableWithProgress createDeleteRunnable(final Collection<File> files) {
        return new IRunnableWithProgress(){

            public final synchronized void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(null, -1);
                try {
                    boolean isOK = true;
                    for (File file : files) {
                        isOK &= ResourceAction.this.remove(file, monitor);
                    }
                    ResourceAction.this.fireResourceChanged(new File(ReportPlugin.getDefault().getResourceFolder()).getAbsolutePath());
                    if (!isOK) {
                        throw new InvocationTargetException(null, Messages.getString((String)"ResourceAction.FileRemoveFailure"));
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    protected IRunnableWithProgress createRenameFileRunnable(final File srcFile, final File targetFile) {
        return new IRunnableWithProgress(){

            public final synchronized void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(null, -1);
                try {
                    if (srcFile != null && targetFile != null && srcFile.exists() && !targetFile.exists() && ResourceAction.this.renameFile(srcFile, targetFile)) {
                        ResourceAction.this.fireResourceChanged(targetFile.getAbsolutePath(), srcFile.getAbsolutePath());
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    private boolean renameFile(File srcFile, File destFile) {
        if (srcFile == null || destFile == null || srcFile.equals(destFile)) {
            return false;
        }
        return srcFile.renameTo(destFile);
    }

    private boolean remove(File file) {
        return this.remove(file, null);
    }

    private boolean remove(File file, IProgressMonitor monitor) {
        String[] children = file.list();
        boolean isOK = true;
        if (children != null) {
            String[] stringArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                if (monitor != null && monitor.isCanceled()) {
                    return isOK;
                }
                isOK &= this.remove(new File(file.getAbsolutePath(), child));
                ++n2;
            }
        }
        return isOK &= this.removeFile(file);
    }

    private boolean removeFile(File file) {
        boolean isOK = false;
        if (file != null) {
            isOK = file.delete();
        }
        return isOK;
    }
}

