/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer;

import org.eclipse.birt.report.designer.internal.ui.resourcelocator.FragmentResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.PathResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ContextMenuProvider;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerTreeViewPage;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.AddElementtoReport;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.AddResourceAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.AddSelectedLibToCurrentReportDesignAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.ApplyThemeAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.CopyResourceAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.DeleteResourceAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.FilterResourceAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.MoveResourceAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.NewFolderAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.NewLibraryAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.PasteResourceAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.RefreshResourceExplorerAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.RenameResourceAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.UseCSSAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ReportResourceEntry;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ResourceEntryWrapper;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;

public class LibraryExplorerContextMenuProvider
extends ContextMenuProvider {
    private final IAction filterAction;
    private final IAction refreshExplorerAction;
    private final IAction useCSSAction;
    private final IAction useLibraryAction;
    private final IAction deleteResourceAction;
    private final IAction renameResourceAction;
    private final IAction pasteResourceAction;
    private final IAction copyResourceAction;
    private final IAction moveResourceAction;
    private final IAction addResourceAction;
    private final IAction newFolderAction;
    private final IAction newLibraryAction;
    private final LibraryExplorerTreeViewPage page;
    private Clipboard clipboard;

    public LibraryExplorerContextMenuProvider(LibraryExplorerTreeViewPage page) {
        super((ISelectionProvider)page.getTreeViewer());
        this.page = page;
        this.clipboard = new Clipboard(page.getSite().getShell().getDisplay());
        this.filterAction = new FilterResourceAction(page);
        this.refreshExplorerAction = new RefreshResourceExplorerAction(page);
        this.useCSSAction = new UseCSSAction(page);
        this.useLibraryAction = new AddSelectedLibToCurrentReportDesignAction((StructuredViewer)page.getTreeViewer());
        this.deleteResourceAction = new DeleteResourceAction(page);
        this.addResourceAction = new AddResourceAction(page);
        this.renameResourceAction = new RenameResourceAction(page);
        this.newFolderAction = new NewFolderAction(page);
        this.moveResourceAction = new MoveResourceAction(page);
        this.newLibraryAction = new NewLibraryAction(page);
        this.copyResourceAction = new CopyResourceAction(page, this.clipboard);
        this.pasteResourceAction = new PasteResourceAction(page, this.clipboard);
        this.handleGlobalAction();
        page.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LibraryExplorerContextMenuProvider.this.resetActionStatus();
                LibraryExplorerContextMenuProvider.this.updateActionBars();
            }
        });
    }

    private void handleGlobalAction() {
        IActionBars actionBars;
        IPageSite pageSite = this.page == null ? null : this.page.getSite();
        IActionBars iActionBars = actionBars = pageSite == null ? null : pageSite.getActionBars();
        if (actionBars != null) {
            String copyID = ActionFactory.COPY.getId();
            String pasteID = ActionFactory.PASTE.getId();
            String deleteID = ActionFactory.DELETE.getId();
            String moveID = ActionFactory.MOVE.getId();
            String renameID = ActionFactory.RENAME.getId();
            String refreshID = ActionFactory.REFRESH.getId();
            actionBars.setGlobalActionHandler(copyID, this.copyResourceAction);
            actionBars.setGlobalActionHandler(pasteID, this.pasteResourceAction);
            actionBars.setGlobalActionHandler(deleteID, this.deleteResourceAction);
            actionBars.setGlobalActionHandler(moveID, this.moveResourceAction);
            actionBars.setGlobalActionHandler(renameID, this.renameResourceAction);
            actionBars.setGlobalActionHandler(refreshID, this.refreshExplorerAction);
            IMenuManager menuManager = actionBars.getMenuManager();
            IToolBarManager toolBarManager = actionBars.getToolBarManager();
            if (menuManager != null) {
                menuManager.add(this.filterAction);
            }
            if (toolBarManager != null) {
                toolBarManager.add(this.refreshExplorerAction);
            }
        }
    }

    private void updateActionBars() {
        IActionBars actionBars;
        IPageSite site = this.page == null ? null : this.page.getSite();
        IActionBars iActionBars = actionBars = site == null ? null : site.getActionBars();
        if (actionBars != null) {
            actionBars.updateActionBars();
        }
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }

    public void buildContextMenu(IMenuManager menu) {
        if (Policy.TRACING_MENU_SHOW) {
            System.out.println("Menu(for Views) >> Shows for library");
        }
        this.resetActionStatus();
        menu.removeAll();
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator());
        IStructuredSelection selection = (IStructuredSelection)this.page.getSelection();
        MenuManager newMenuGroup = new MenuManager(Messages.getString((String)"NewResource.MenuGroup.Text"));
        newMenuGroup.add(this.newFolderAction);
        newMenuGroup.add(this.newLibraryAction);
        if (selection != null && selection.getFirstElement() != null) {
            Object selected = selection.getFirstElement();
            if (selected instanceof ReportResourceEntry) {
                selected = ((ReportResourceEntry)selected).getReportElement();
            }
            if (selected instanceof ResourceEntryWrapper) {
                int type = ((ResourceEntryWrapper)selected).getType();
                if (type == 0) {
                    menu.add(this.useLibraryAction);
                } else if (type == 1) {
                    menu.add(this.useCSSAction);
                }
                if (((ResourceEntryWrapper)selected).getParent() instanceof PathResourceEntry) {
                    menu.add((IContributionItem)new Separator());
                    menu.add((IContributionItem)newMenuGroup);
                    menu.add(this.addResourceAction);
                }
                menu.add((IContributionItem)new Separator());
                menu.add(this.copyResourceAction);
                if (((ResourceEntryWrapper)selected).getParent() instanceof PathResourceEntry) {
                    menu.add(this.pasteResourceAction);
                    menu.add(this.deleteResourceAction);
                    menu.add(this.moveResourceAction);
                    menu.add(this.renameResourceAction);
                    menu.add((IContributionItem)new Separator());
                }
            } else if (selected instanceof LibraryHandle) {
                menu.add(this.useLibraryAction);
                menu.add((IContributionItem)new Separator());
            } else if (selected instanceof CssStyleSheetHandle) {
                menu.add(this.useCSSAction);
                menu.add((IContributionItem)new Separator());
            } else if (selected instanceof PathResourceEntry) {
                menu.add((IContributionItem)newMenuGroup);
                menu.add(this.addResourceAction);
                menu.add((IContributionItem)new Separator());
                menu.add(this.copyResourceAction);
                menu.add(this.pasteResourceAction);
                menu.add(this.deleteResourceAction);
                menu.add(this.moveResourceAction);
                menu.add(this.renameResourceAction);
                menu.add((IContributionItem)new Separator());
            } else if (selected instanceof FragmentResourceEntry && this.copyResourceAction.isEnabled()) {
                menu.add(this.copyResourceAction);
                menu.add((IContributionItem)new Separator());
            }
            if (this.canAddtoReport(selected)) {
                if (selection.size() == 1) {
                    AddElementtoReport addElementAction = new AddElementtoReport((StructuredViewer)this.getViewer());
                    addElementAction.setSelectedElement(selected);
                    menu.add((IAction)addElementAction);
                    menu.add((IContributionItem)new Separator());
                }
            } else if (this.isTheme(selected) && selection.size() == 1) {
                ApplyThemeAction applyThemeAction = new ApplyThemeAction();
                applyThemeAction.setSelectedTheme(selected);
                menu.add((IAction)applyThemeAction);
                menu.add((IContributionItem)new Separator());
            }
            menu.add((IContributionItem)new Separator());
            menu.add(this.refreshExplorerAction);
        } else {
            menu.add(this.addResourceAction);
            menu.add((IContributionItem)new Separator());
            menu.add(this.refreshExplorerAction);
        }
    }

    private void resetActionStatus() {
        this.filterAction.setEnabled(this.isEnabled());
        this.refreshExplorerAction.setEnabled(this.refreshExplorerAction.isEnabled());
        this.useCSSAction.setEnabled(this.useCSSAction.isEnabled());
        this.useLibraryAction.setEnabled(this.useLibraryAction.isEnabled());
        this.deleteResourceAction.setEnabled(this.deleteResourceAction.isEnabled());
        this.addResourceAction.setEnabled(this.addResourceAction.isEnabled());
        this.renameResourceAction.setEnabled(this.renameResourceAction.isEnabled());
        this.newFolderAction.setEnabled(this.newFolderAction.isEnabled());
        this.moveResourceAction.setEnabled(this.moveResourceAction.isEnabled());
        this.newLibraryAction.setEnabled(this.newLibraryAction.isEnabled());
        this.copyResourceAction.setEnabled(this.copyResourceAction.isEnabled());
        this.pasteResourceAction.setEnabled(this.pasteResourceAction.isEnabled());
    }

    protected boolean isTheme(Object transfer) {
        if (transfer instanceof ReportResourceEntry) {
            transfer = ((ReportResourceEntry)transfer).getReportElement();
        }
        return transfer instanceof ThemeHandle;
    }

    protected boolean canAddtoReport(Object transfer) {
        if (transfer instanceof ReportResourceEntry) {
            transfer = ((ReportResourceEntry)transfer).getReportElement();
        }
        if (transfer instanceof ReportElementHandle || transfer instanceof EmbeddedImageHandle) {
            if (transfer instanceof ScalarParameterHandle && ((ScalarParameterHandle)transfer).getContainer() instanceof CascadingParameterGroupHandle) {
                return false;
            }
            if (transfer instanceof StyleHandle && ((StyleHandle)transfer).getContainer() instanceof ThemeHandle) {
                return false;
            }
            return !(transfer instanceof ThemeHandle);
        }
        return false;
    }
}

