/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.samplesview.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.samplesview.sampleslocator.SampleIncludedSourceEntry;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class PlaceResources {
    public static void copy(Shell shell, String path, String reportName, String reportDesignFile) {
        URL sampleReportURL = null;
        try {
            sampleReportURL = new URL(reportDesignFile);
        }
        catch (IOException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        PlaceResources.copy(shell, path, reportName, sampleReportURL);
    }

    public static void copy(Shell shell, String path, String desFileName, URL srcURL) {
        block22: {
            File targetfile = new File(path, desFileName);
            if (targetfile.exists() && !MessageDialog.openConfirm((Shell)shell, (String)Messages.getString((String)"SampleReportsView.MessageDialog.Title"), (String)Messages.getFormattedString((String)"SampleReportsView.MessageDialog.Message", (Object[])new Object[]{desFileName}))) {
                return;
            }
            FileOutputStream output = null;
            InputStream input = null;
            try {
                try {
                    int offset;
                    output = new FileOutputStream(targetfile);
                    input = srcURL.openStream();
                    byte[] buf = new byte[4096];
                    while ((offset = input.read(buf)) > -1) {
                        ((OutputStream)output).write(buf, 0, offset);
                    }
                }
                catch (IOException e) {
                    ExceptionUtil.handle((Throwable)e);
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e2) {
                            ExceptionUtil.handle((Throwable)e2);
                        }
                    }
                    if (output == null) break block22;
                    try {
                        ((OutputStream)output).close();
                    }
                    catch (IOException e3) {
                        ExceptionUtil.handle((Throwable)e3);
                    }
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        ExceptionUtil.handle((Throwable)e);
                    }
                }
                if (output != null) {
                    try {
                        ((OutputStream)output).close();
                    }
                    catch (IOException e) {
                        ExceptionUtil.handle((Throwable)e);
                    }
                }
            }
        }
    }

    public static void copyIncludedLibraries(Shell shell, String projectPath) {
        Enumeration enumeration = SampleIncludedSourceEntry.getIncludedLibraries();
        while (enumeration.hasMoreElements()) {
            URL libraryURL = (URL)enumeration.nextElement();
            String filename = libraryURL.getFile();
            String desFileName = filename.substring(filename.lastIndexOf(47) + 1);
            PlaceResources.copy(shell, projectPath, desFileName, libraryURL);
        }
    }

    public static void copyIncludedPng(Shell shell, String projectPath) {
        Enumeration enumeration = SampleIncludedSourceEntry.getIncludedPng();
        while (enumeration.hasMoreElements()) {
            URL pngURL = (URL)enumeration.nextElement();
            String filename = pngURL.getFile();
            String desFileName = filename.substring(filename.lastIndexOf(47) + 1);
            PlaceResources.copy(shell, projectPath, desFileName, pngURL);
        }
    }

    public static void copyDrillThroughReport(Shell shell, String projectPath, String report) {
        Enumeration enumeration = SampleIncludedSourceEntry.getDrillDetailsReports();
        while (enumeration.hasMoreElements()) {
            URL reportURL = (URL)enumeration.nextElement();
            String filename = reportURL.getFile();
            String desFileName = filename.substring(filename.lastIndexOf(47) + 1);
            if (desFileName.equals(report)) continue;
            PlaceResources.copy(shell, projectPath, desFileName, reportURL);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyExcludedRptDesignes(Shell shell, String projectPath, String fileName) {
        try {
            String path = new URL(fileName).getPath();
            if (path == null) {
                return;
            }
            Enumeration enumeration = SampleIncludedSourceEntry.getEntries(path = path.substring(0, path.lastIndexOf(47)));
            if (enumeration == null) {
                return;
            }
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return;
                }
                URL reportURL = (URL)enumeration.nextElement();
                String filename = reportURL.getFile();
                String desFileName = filename.substring(filename.lastIndexOf(47) + 1);
                if (desFileName.toLowerCase().endsWith(".rptdesign")) continue;
                PlaceResources.copy(shell, projectPath, desFileName, reportURL);
            }
        }
        catch (Exception e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }
}

