/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.director.AttachmentHelper;
import org.eclipse.equinox.internal.p2.director.DirectorActivator;
import org.eclipse.equinox.internal.p2.director.Explanation;
import org.eclipse.equinox.internal.p2.director.HasMatchCollector;
import org.eclipse.equinox.internal.p2.director.Messages;
import org.eclipse.equinox.internal.p2.director.OperationGenerator;
import org.eclipse.equinox.internal.p2.director.Projector;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.internal.p2.rollback.FormerState;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerHelper;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.IUProfilePropertyQuery;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitPropertyOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.PropertyOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.CapabilityQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.UpdateQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.MatchQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class SimplePlanner
implements IPlanner {
    private static boolean DEBUG = Tracing.DEBUG_PLANNER_OPERANDS;
    private static final int ExpandWork = 12;
    private static final String INCLUDE_PROFILE_IUS = "org.eclipse.equinox.p2.internal.profileius";
    public static final String INCLUSION_RULES = "org.eclipse.equinox.p2.internal.inclusion.rules";
    private static final String ID_IU_FOR_ACTIONS = "org.eclipse.equinox.p2.engine.actions.root";
    private static final String EXPLANATION = "org.eclipse.equinox.p2.director.explain";
    private static final String CONSIDER_METAREQUIREMENTS = "org.eclipse.equinox.p2.planner.resolveMetaRequirements";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private ProvisioningPlan generateProvisioningPlan(Collection fromState, Collection toState, ProfileChangeRequest changeRequest, ProvisioningPlan installerPlan) {
        InstallableUnitOperand[] iuOperands = this.generateOperations(fromState, toState);
        PropertyOperand[] propertyOperands = this.generatePropertyOperations(changeRequest);
        Operand[] operands = new Operand[iuOperands.length + propertyOperands.length];
        System.arraycopy(iuOperands, 0, operands, 0, iuOperands.length);
        System.arraycopy(propertyOperands, 0, operands, iuOperands.length, propertyOperands.length);
        if (DEBUG) {
            int i = 0;
            while (i < operands.length) {
                Tracing.debug((String)operands[i].toString());
                ++i;
            }
        }
        return new ProvisioningPlan(Status.OK_STATUS, operands, this.computeActualChangeRequest(toState, changeRequest), null, installerPlan, changeRequest);
    }

    private Map[] buildDetailedErrors(ProfileChangeRequest changeRequest) {
        IInstallableUnit[] added = changeRequest.getAddedInstallableUnits();
        IInstallableUnit[] removed = changeRequest.getRemovedInstallableUnits();
        HashMap<IInstallableUnit, RequestStatus> requestStatus = new HashMap<IInstallableUnit, RequestStatus>(added.length + removed.length);
        int i = 0;
        while (i < added.length) {
            requestStatus.put(added[i], new RequestStatus(added[i], 0, 4, null));
            ++i;
        }
        i = 0;
        while (i < removed.length) {
            requestStatus.put(removed[i], new RequestStatus(removed[i], 1, 4, null));
            ++i;
        }
        Map[] mapArray = new Map[2];
        mapArray[0] = requestStatus;
        return mapArray;
    }

    private Map[] computeActualChangeRequest(Collection toState, ProfileChangeRequest changeRequest) {
        IInstallableUnit[] added = changeRequest.getAddedInstallableUnits();
        IInstallableUnit[] removed = changeRequest.getRemovedInstallableUnits();
        HashMap<IInstallableUnit, RequestStatus> requestStatus = new HashMap<IInstallableUnit, RequestStatus>(added.length + removed.length);
        int i = 0;
        while (i < added.length) {
            if (toState.contains(added[i])) {
                requestStatus.put(added[i], new RequestStatus(added[i], 0, 0, null));
            } else {
                requestStatus.put(added[i], new RequestStatus(added[i], 0, 4, null));
            }
            ++i;
        }
        i = 0;
        while (i < removed.length) {
            if (!toState.contains(removed[i])) {
                requestStatus.put(removed[i], new RequestStatus(removed[i], 1, 0, null));
            } else {
                requestStatus.put(removed[i], new RequestStatus(removed[i], 1, 4, null));
            }
            ++i;
        }
        HashSet includedIUs = new HashSet(changeRequest.getProfile().query((Query)new IUProfilePropertyQuery(changeRequest.getProfile(), INCLUSION_RULES, null), new Collector(), null).toCollection());
        HashMap<IInstallableUnit, RequestStatus> sideEffectStatus = new HashMap<IInstallableUnit, RequestStatus>(includedIUs.size());
        includedIUs.removeAll(toState);
        Iterator iterator = includedIUs.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit removal = (IInstallableUnit)iterator.next();
            if (requestStatus.containsKey(removal)) continue;
            sideEffectStatus.put(removal, new RequestStatus(removal, 1, 1, null));
        }
        return new Map[]{requestStatus, sideEffectStatus};
    }

    private IStatus convertExplanationToStatus(Set explanations) {
        if (explanations == null) {
            return new Status(4, "org.eclipse.equinox.p2.director", Messages.Director_Unsatisfied_Dependencies);
        }
        MultiStatus root = new MultiStatus("org.eclipse.equinox.p2.director", 1, Messages.Director_Unsatisfied_Dependencies, null);
        String specificMessage = null;
        Iterator it = explanations.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (next instanceof Explanation) {
                root.add(((Explanation)next).toStatus());
                if (specificMessage == null && next instanceof Explanation.MissingIU) {
                    specificMessage = Messages.Explanation_rootMissing;
                    continue;
                }
                if (specificMessage != null || !(next instanceof Explanation.Singleton)) continue;
                specificMessage = Messages.Explanation_rootSingleton;
                continue;
            }
            root.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", next.toString()));
        }
        if (specificMessage != null) {
            MultiStatus newRoot = new MultiStatus("org.eclipse.equinox.p2.director", 1, specificMessage, null);
            newRoot.merge((IStatus)root);
            root = newRoot;
        }
        return root;
    }

    private PropertyOperand[] generatePropertyOperations(ProfileChangeRequest profileChangeRequest) {
        IProfile profile = profileChangeRequest.getProfile();
        ArrayList<Object> operands = new ArrayList<Object>();
        String[] toRemove = profileChangeRequest.getPropertiesToRemove();
        Map existingProperties = profile.getProperties();
        int i = 0;
        while (i < toRemove.length) {
            if (existingProperties.containsKey(toRemove[i])) {
                operands.add(new PropertyOperand(toRemove[i], existingProperties.get(toRemove[i]), null));
            }
            ++i;
        }
        Map propertyChanges = profileChangeRequest.getPropertiesToAdd();
        Iterator iter = propertyChanges.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            operands.add(new PropertyOperand((String)entry.getKey(), existingProperties.get(entry.getKey()), entry.getValue()));
        }
        Map allIUPropertyChanges = profileChangeRequest.getInstallableUnitProfilePropertiesToAdd();
        iter = allIUPropertyChanges.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            IInstallableUnit iu = (IInstallableUnit)entry.getKey();
            Map iuPropertyChanges = (Map)entry.getValue();
            Iterator iuPropIter = iuPropertyChanges.entrySet().iterator();
            while (iuPropIter.hasNext()) {
                Map.Entry entry2 = iuPropIter.next();
                String oldValue = profile.getInstallableUnitProperty(iu, (String)entry2.getKey());
                operands.add(new InstallableUnitPropertyOperand(iu, (String)entry2.getKey(), (Object)oldValue, entry2.getValue()));
            }
        }
        Map allIUPropertyDeletions = profileChangeRequest.getInstallableUnitProfilePropertiesToRemove();
        iter = allIUPropertyDeletions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            IInstallableUnit iu = (IInstallableUnit)entry.getKey();
            Map existingIUProperties = profile.getInstallableUnitProperties(iu);
            List iuPropertyRemovals = (List)entry.getValue();
            Iterator it = iuPropertyRemovals.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!existingIUProperties.containsKey(key)) continue;
                operands.add(new InstallableUnitPropertyOperand(iu, key, existingIUProperties.get(key), null));
            }
        }
        return operands.toArray(new PropertyOperand[operands.size()]);
    }

    private InstallableUnitOperand[] generateOperations(Collection fromState, Collection toState) {
        return new OperationGenerator().generateOperation(fromState, toState);
    }

    public ProvisioningPlan getDiffPlan(IProfile currentProfile, IProfile targetProfile, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)12);
        sub.setTaskName(Messages.Director_Task_Resolving_Dependencies);
        try {
            ProfileChangeRequest profileChangeRequest = FormerState.generateProfileDeltaChangeRequest(currentProfile, targetProfile);
            ProvisioningContext context = new ProvisioningContext(new URI[0]);
            if (context.getProperty(INCLUDE_PROFILE_IUS) == null) {
                context.setProperty(INCLUDE_PROFILE_IUS, Boolean.FALSE.toString());
            }
            context.setExtraIUs(new ArrayList(targetProfile.available((Query)InstallableUnitQuery.ANY, new Collector(), null).toCollection()));
            ProvisioningPlan provisioningPlan = this.getProvisioningPlan(profileChangeRequest, context, (IProgressMonitor)sub.newChild(6));
            return provisioningPlan;
        }
        finally {
            sub.done();
        }
    }

    public static IInstallableUnit[] findPlannerMarkedIUs(final IProfile profile) {
        MatchQuery markerQuery = new MatchQuery(){

            public boolean isMatch(Object candidate) {
                if (!(candidate instanceof IInstallableUnit)) {
                    return false;
                }
                IInstallableUnit iu = (IInstallableUnit)candidate;
                String inclusion = profile.getInstallableUnitProperty(iu, SimplePlanner.INCLUSION_RULES);
                return inclusion != null;
            }
        };
        Collector collector = profile.query((Query)markerQuery, new Collector(), null);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IInstallableUnit[])collector.toArray((Class)clazz);
    }

    public static Dictionary createSelectionContext(Map properties) {
        Hashtable<String, String> result = new Hashtable<String, String>(properties);
        String environments = (String)properties.get("org.eclipse.equinox.p2.environments");
        if (environments == null) {
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(environments, ",");
        while (tokenizer.hasMoreElements()) {
            String entry = tokenizer.nextToken();
            int i = entry.indexOf(61);
            String key = entry.substring(0, i).trim();
            String value = entry.substring(i + 1).trim();
            result.put(key, value);
        }
        return result;
    }

    private IInstallableUnit[] gatherAvailableInstallableUnits(IInstallableUnit[] additionalSource, URI[] repositories, ProvisioningContext context, IProgressMonitor monitor) {
        Class<?> clazz;
        HashMap<String, IInstallableUnit> resultsMap = new HashMap<String, IInstallableUnit>();
        if (additionalSource != null) {
            int i = 0;
            while (i < additionalSource.length) {
                String key = String.valueOf(additionalSource[i].getId()) + "_" + additionalSource[i].getVersion().toString();
                resultsMap.put(key, additionalSource[i]);
                ++i;
            }
        }
        if (context != null) {
            Iterator iter = context.getExtraIUs().iterator();
            while (iter.hasNext()) {
                IInstallableUnit iu = (IInstallableUnit)iter.next();
                String key = String.valueOf(iu.getId()) + '_' + iu.getVersion().toString();
                resultsMap.put(key, iu);
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMetadataRepositoryManager repoMgr = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)DirectorActivator.context, (String)clazz.getName());
        if (repositories == null) {
            repositories = repoMgr.getKnownRepositories(0);
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(repositories.length * 200));
        int i = 0;
        while (i < repositories.length) {
            try {
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IMetadataRepository repository = repoMgr.loadRepository(repositories[i], (IProgressMonitor)sub.newChild(100));
                Collector matches = repository.query((Query)new InstallableUnitQuery(null, VersionRange.emptyRange), new Collector(), (IProgressMonitor)sub.newChild(100));
                Iterator it = matches.iterator();
                while (it.hasNext()) {
                    IInstallableUnit iu = (IInstallableUnit)it.next();
                    String key = String.valueOf(iu.getId()) + "_" + iu.getVersion().toString();
                    IInstallableUnit currentIU = (IInstallableUnit)resultsMap.get(key);
                    if (currentIU != null && !SimplePlanner.hasHigherFidelity(iu, currentIU)) continue;
                    resultsMap.put(key, iu);
                }
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
        sub.done();
        Collection results = resultsMap.values();
        return results.toArray(new IInstallableUnit[results.size()]);
    }

    private static boolean hasHigherFidelity(IInstallableUnit iu, IInstallableUnit currentIU) {
        return Boolean.valueOf(currentIU.getProperty("org.eclipse.equinox.p2.partial.iu")) != false && Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.partial.iu")) == false;
    }

    private boolean satisfyMetaRequirements(Map props) {
        if (props == null) {
            return true;
        }
        return props.get(CONSIDER_METAREQUIREMENTS) == null || "true".equalsIgnoreCase((String)props.get(CONSIDER_METAREQUIREMENTS));
    }

    private boolean satisfyMetaRequirements(IProfile p) {
        return this.satisfyMetaRequirements(p.getProperties());
    }

    private Object getSolutionFor(ProfileChangeRequest profileChangeRequest, ProvisioningContext context, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)12);
        sub.setTaskName(Messages.Director_Task_Resolving_Dependencies);
        try {
            IInstallableUnit[] availableIUs;
            Slicer slicer;
            IQueryable slice;
            IProfile profile = profileChangeRequest.getProfile();
            Object[] updatedPlan = this.updatePlannerInfo(profileChangeRequest, context);
            URI[] metadataRepositories = context != null ? context.getMetadataRepositories() : null;
            Dictionary newSelectionContext = SimplePlanner.createSelectionContext(profileChangeRequest.getProfileProperties());
            ArrayList<IInstallableUnit> extraIUs = new ArrayList<IInstallableUnit>(Arrays.asList(profileChangeRequest.getAddedInstallableUnits()));
            extraIUs.addAll(Arrays.asList(profileChangeRequest.getRemovedInstallableUnits()));
            if (context == null || context.getProperty(INCLUDE_PROFILE_IUS) == null || context.getProperty(INCLUDE_PROFILE_IUS).equalsIgnoreCase(Boolean.TRUE.toString())) {
                extraIUs.addAll(profile.available((Query)InstallableUnitQuery.ANY, new Collector(), null).toCollection());
            }
            if ((slice = (slicer = new Slicer(new QueryableArray(availableIUs = this.gatherAvailableInstallableUnits(extraIUs.toArray(new IInstallableUnit[extraIUs.size()]), metadataRepositories, context, (IProgressMonitor)sub.newChild(3))), newSelectionContext, this.satisfyMetaRequirements(profileChangeRequest.getProfileProperties()))).slice(new IInstallableUnit[]{(IInstallableUnit)updatedPlan[0]}, (IProgressMonitor)sub.newChild(3))) == null) {
                ProvisioningPlan provisioningPlan = new ProvisioningPlan((IStatus)slicer.getStatus(), profileChangeRequest, null);
                return provisioningPlan;
            }
            Projector projector = new Projector(slice, newSelectionContext, this.satisfyMetaRequirements(profileChangeRequest.getProfileProperties()));
            projector.encode((IInstallableUnit)updatedPlan[0], (IInstallableUnit[])updatedPlan[1], profileChangeRequest.getAddedInstallableUnits(), (IProgressMonitor)sub.newChild(3));
            IStatus s = projector.invokeSolver((IProgressMonitor)sub.newChild(3));
            if (s.getSeverity() == 8) {
                ProvisioningPlan provisioningPlan = new ProvisioningPlan(s, profileChangeRequest, null);
                return provisioningPlan;
            }
            if (s.getSeverity() == 4) {
                sub.setTaskName(Messages.Planner_NoSolution);
                if (context != null && context.getProperty(EXPLANATION) != null && !Boolean.TRUE.toString().equalsIgnoreCase(context.getProperty(EXPLANATION))) {
                    ProvisioningPlan provisioningPlan = new ProvisioningPlan(s, profileChangeRequest, null);
                    return provisioningPlan;
                }
                Set explanation = projector.getExplanation((IProgressMonitor)sub.newChild(3));
                IStatus explanationStatus = this.convertExplanationToStatus(explanation);
                ProvisioningPlan provisioningPlan = new ProvisioningPlan(explanationStatus, new Operand[0], this.buildDetailedErrors(profileChangeRequest), new RequestStatus(null, 1, 4, explanation), null, profileChangeRequest);
                return provisioningPlan;
            }
            if (Tracing.DEBUG && s.getSeverity() != 0) {
                LogHelper.log((IStatus)s);
            }
            s = Status.OK_STATUS;
            Projector projector2 = projector;
            return projector2;
        }
        finally {
            sub.done();
        }
    }

    public ProvisioningPlan getProvisioningPlan(ProfileChangeRequest profileChangeRequest, ProvisioningContext context, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)12);
        sub.setTaskName(Messages.Director_Task_Resolving_Dependencies);
        try {
            Object resolutionResult = this.getSolutionFor(profileChangeRequest, context, (IProgressMonitor)sub.newChild(6));
            if (resolutionResult instanceof ProvisioningPlan) {
                ProvisioningPlan provisioningPlan = (ProvisioningPlan)resolutionResult;
                return provisioningPlan;
            }
            Collection newState = ((Projector)resolutionResult).extractSolution();
            ArrayList fullState = new ArrayList();
            fullState.addAll(newState);
            newState = AttachmentHelper.attachFragments(newState, ((Projector)resolutionResult).getFragmentAssociation());
            ProvisioningPlan temporaryPlan = this.generatePlan((Projector)resolutionResult, newState, profileChangeRequest);
            ProvisioningPlan provisioningPlan = this.createInstallerPlan(profileChangeRequest.getProfile(), profileChangeRequest, fullState, newState, temporaryPlan, context, (IProgressMonitor)sub.newChild(6));
            return provisioningPlan;
        }
        catch (OperationCanceledException operationCanceledException) {
            ProvisioningPlan provisioningPlan = new ProvisioningPlan(Status.CANCEL_STATUS, profileChangeRequest, null);
            return provisioningPlan;
        }
        finally {
            sub.done();
        }
    }

    private Collection areMetaRequirementsSatisfied(IProfile oldProfile, Collection newProfile, ProvisioningPlan initialPlan) {
        Collection allMetaRequirements = this.extractMetaRequirements(newProfile, initialPlan);
        Iterator iterator = allMetaRequirements.iterator();
        while (iterator.hasNext()) {
            IRequiredCapability requirement = (IRequiredCapability)iterator.next();
            if (!oldProfile.query((Query)new CapabilityQuery(requirement), (Collector)new HasMatchCollector(), null).isEmpty()) continue;
            return allMetaRequirements;
        }
        return null;
    }

    private Collection extractMetaRequirements(Collection ius, ProvisioningPlan plan) {
        HashSet<IRequiredCapability> allMetaRequirements = new HashSet<IRequiredCapability>();
        Iterator iterator = ius.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            IRequiredCapability[] reqs = iu.getMetaRequiredCapabilities();
            int i = 0;
            while (i < reqs.length) {
                allMetaRequirements.add(reqs[i]);
                ++i;
            }
        }
        Collector c2 = plan.getRemovals().query((Query)InstallableUnitQuery.ANY, new Collector(), null);
        Iterator iterator2 = c2.iterator();
        while (iterator2.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator2.next();
            IRequiredCapability[] reqs = iu.getMetaRequiredCapabilities();
            int i = 0;
            while (i < reqs.length) {
                allMetaRequirements.add(reqs[i]);
                ++i;
            }
        }
        return allMetaRequirements;
    }

    private ProvisioningPlan createInstallerPlan(IProfile profile, ProfileChangeRequest initialRequest, Collection unattachedState, Collection expectedState, ProvisioningPlan initialPlan, ProvisioningContext initialContext, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)12);
        try {
            IProfileRegistry profileRegistry;
            sub.setTaskName(Messages.Director_Task_installer_plan);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)DirectorActivator.context, (String)clazz.getName())) == null) {
                ProvisioningPlan provisioningPlan = new ProvisioningPlan((IStatus)new Status(4, "org.eclipse.equinox.p2.director", Messages.Planner_no_profile_registry), initialRequest, null);
                return provisioningPlan;
            }
            IProfile agentProfile = profileRegistry.getProfile("_SELF_");
            if (agentProfile == null) {
                ProvisioningPlan provisioningPlan = initialPlan;
                return provisioningPlan;
            }
            if (profile.getProfileId().equals(agentProfile.getProfileId())) {
                if (profile.getTimestamp() != agentProfile.getTimestamp()) {
                    ProvisioningPlan provisioningPlan = new ProvisioningPlan((IStatus)new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Planner_profile_out_of_sync, (Object)profile.getProfileId())), initialRequest, null);
                    return provisioningPlan;
                }
                ProvisioningPlan provisioningPlan = this.createInstallerPlanForCohostedCase(profile, initialRequest, initialPlan, unattachedState, expectedState, initialContext, sub);
                return provisioningPlan;
            }
            if (this.satisfyMetaRequirements(profile) && !profile.getProfileId().equals(agentProfile.getProfileId())) {
                ProvisioningPlan provisioningPlan = this.createInstallerPlanForCohostedCaseFromExternalInstaller(profile, initialRequest, initialPlan, expectedState, initialContext, agentProfile, sub);
                return provisioningPlan;
            }
            ProvisioningPlan provisioningPlan = this.createInstallerPlanForExternalInstaller(profile, initialRequest, initialPlan, expectedState, initialContext, agentProfile, sub);
            return provisioningPlan;
        }
        finally {
            sub.done();
        }
    }

    private ProvisioningPlan createInstallerPlanForCohostedCaseFromExternalInstaller(IProfile profile, ProfileChangeRequest initialRequest, ProvisioningPlan initialPlan, Collection newState, ProvisioningContext initialContext, IProfile agentProfile, SubMonitor sub) {
        ProvisioningPlan planForProfile = this.generatePlan(null, newState, initialRequest);
        return this.createInstallerPlanForExternalInstaller(profile, initialRequest, planForProfile, newState, initialContext, agentProfile, sub);
    }

    private ProvisioningPlan createInstallerPlanForExternalInstaller(IProfile targetedProfile, ProfileChangeRequest initialRequest, ProvisioningPlan initialPlan, Collection expectedState, ProvisioningContext initialContext, IProfile agentProfile, SubMonitor sub) {
        Object externalInstallerPlan;
        Collection metaRequirements = this.areMetaRequirementsSatisfied(agentProfile, expectedState, initialPlan);
        if (metaRequirements == null) {
            return initialPlan;
        }
        IInstallableUnit actionsIU = this.createIUForMetaRequirements(targetedProfile, metaRequirements);
        IInstallableUnit previousActionsIU = this.getPreviousIUForMetaRequirements(agentProfile, this.getActionGatheringIUId(targetedProfile), (IProgressMonitor)sub);
        ProfileChangeRequest agentRequest = new ProfileChangeRequest(agentProfile);
        agentRequest.addInstallableUnits(new IInstallableUnit[]{actionsIU});
        if (previousActionsIU != null) {
            agentRequest.removeInstallableUnits(new IInstallableUnit[]{previousActionsIU});
        }
        if ((externalInstallerPlan = this.getSolutionFor(agentRequest, initialContext, (IProgressMonitor)sub.newChild(10))) instanceof ProvisioningPlan && ((ProvisioningPlan)externalInstallerPlan).getStatus().getSeverity() == 4) {
            MultiStatus externalInstallerStatus = new MultiStatus("org.eclipse.equinox.p2.director", 0, Messages.Planner_can_not_install_preq, null);
            externalInstallerStatus.add(((ProvisioningPlan)externalInstallerPlan).getStatus());
            return new ProvisioningPlan((IStatus)externalInstallerStatus, initialRequest, new ProvisioningPlan((IStatus)externalInstallerStatus, agentRequest, null));
        }
        initialPlan.setInstallerPlan(this.generatePlan((Projector)externalInstallerPlan, null, agentRequest));
        return initialPlan;
    }

    private ProvisioningPlan createInstallerPlanForCohostedCase(IProfile profile, ProfileChangeRequest initialRequest, ProvisioningPlan initialPlan, Collection unattachedState, Collection expectedState, ProvisioningContext initialContext, SubMonitor monitor) {
        Collection metaRequirements;
        Collection collection = metaRequirements = initialRequest.getRemovedInstallableUnits().length == 0 ? this.areMetaRequirementsSatisfied(profile, expectedState, initialPlan) : this.extractMetaRequirements(expectedState, initialPlan);
        if (metaRequirements == null || metaRequirements.isEmpty()) {
            return initialPlan;
        }
        IInstallableUnit metaRequirementIU = this.createIUForMetaRequirements(profile, metaRequirements);
        IInstallableUnit previousMetaRequirementIU = this.getPreviousIUForMetaRequirements(profile, this.getActionGatheringIUId(profile), (IProgressMonitor)monitor);
        ProfileChangeRequest agentRequest = new ProfileChangeRequest(profile);
        Iterator it = initialRequest.getPropertiesToAdd().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            agentRequest.setProfileProperty((String)entry.getKey(), entry.getValue());
        }
        String[] removedProperties = initialRequest.getPropertiesToRemove();
        int i = 0;
        while (i < removedProperties.length) {
            agentRequest.removeProfileProperty(removedProperties[i]);
            ++i;
        }
        Map removedIUProperties = initialRequest.getInstallableUnitProfilePropertiesToRemove();
        Iterator iterator = removedIUProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ArrayList value = (ArrayList)entry.getValue();
            Iterator iterator2 = value.iterator();
            while (iterator2.hasNext()) {
                agentRequest.removeInstallableUnitProfileProperty((IInstallableUnit)entry.getKey(), (String)iterator2.next());
            }
        }
        if (previousMetaRequirementIU != null) {
            agentRequest.removeInstallableUnits(new IInstallableUnit[]{previousMetaRequirementIU});
        }
        agentRequest.addInstallableUnits(new IInstallableUnit[]{metaRequirementIU});
        ProvisioningContext agentCtx = new ProvisioningContext(new URI[0]);
        ArrayList extraIUs = new ArrayList(unattachedState);
        agentCtx.setExtraIUs(extraIUs);
        Object agentSolution = this.getSolutionFor(agentRequest, agentCtx, (IProgressMonitor)monitor.newChild(3));
        if (agentSolution instanceof ProvisioningPlan && ((ProvisioningPlan)agentSolution).getStatus().getSeverity() == 4) {
            MultiStatus agentStatus = new MultiStatus("org.eclipse.equinox.p2.director", 0, Messages.Planner_actions_and_software_incompatible, null);
            agentStatus.add(((ProvisioningPlan)agentSolution).getStatus());
            return new ProvisioningPlan((IStatus)agentStatus, initialRequest, new ProvisioningPlan((IStatus)agentStatus, agentRequest, null));
        }
        Collection agentState = ((Projector)agentSolution).extractSolution();
        agentState.remove(metaRequirementIU);
        agentState = AttachmentHelper.attachFragments(agentState, ((Projector)agentSolution).getFragmentAssociation());
        ProvisioningContext noRepoContext = this.createNoRepoContext(initialRequest);
        Object initialSolution = this.getSolutionFor(new ProfileChangeRequest(new EverythingOptionalProfile(initialRequest.getProfile())), noRepoContext, (IProgressMonitor)new NullProgressMonitor());
        if (initialSolution instanceof ProvisioningPlan) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.director", "The resolution of the previous state contained in profile " + initialRequest.getProfile().getProfileId() + " version " + initialRequest.getProfile().getTimestamp() + " failed."));
            return (ProvisioningPlan)initialSolution;
        }
        Collection initialState = initialRequest.getProfile().query((Query)InstallableUnitQuery.ANY, new Collector(), null).toCollection();
        initialState = AttachmentHelper.attachFragments(initialState, ((Projector)initialSolution).getFragmentAssociation());
        ProvisioningPlan agentPlan = this.generateProvisioningPlan(initialState, agentState, initialRequest, null);
        return this.generateProvisioningPlan(agentState, expectedState, initialRequest, agentPlan);
    }

    private ProvisioningPlan generatePlan(Projector newSolution, Collection newState, ProfileChangeRequest request) {
        if (newState == null) {
            newState = newSolution.extractSolution();
            newState = AttachmentHelper.attachFragments(newState, newSolution.getFragmentAssociation());
        }
        ProvisioningContext noRepoContext = this.createNoRepoContext(request);
        Object initialSolution = this.getSolutionFor(new ProfileChangeRequest(new EverythingOptionalProfile(request.getProfile())), noRepoContext, (IProgressMonitor)new NullProgressMonitor());
        if (initialSolution instanceof ProvisioningPlan) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.director", "The resolution of the previous state contained in profile " + request.getProfile().getProfileId() + " version " + request.getProfile().getTimestamp() + " failed."));
            return (ProvisioningPlan)initialSolution;
        }
        Collection initialState = request.getProfile().query((Query)InstallableUnitQuery.ANY, new Collector(), null).toCollection();
        initialState = AttachmentHelper.attachFragments(initialState, ((Projector)initialSolution).getFragmentAssociation());
        return this.generateProvisioningPlan(initialState, newState, request, null);
    }

    private ProvisioningContext createNoRepoContext(ProfileChangeRequest request) {
        ProvisioningContext noRepoContext = new ProvisioningContext(new URI[0]);
        noRepoContext.setArtifactRepositories(new URI[0]);
        noRepoContext.setProperty(INCLUDE_PROFILE_IUS, Boolean.FALSE.toString());
        ArrayList extraIUs = new ArrayList();
        extraIUs.addAll(request.getProfile().query((Query)InstallableUnitQuery.ANY, new Collector(), (IProgressMonitor)new NullProgressMonitor()).toCollection());
        noRepoContext.setExtraIUs(extraIUs);
        return noRepoContext;
    }

    private IInstallableUnit getPreviousIUForMetaRequirements(IProfile profile, String iuId, IProgressMonitor monitor) {
        Collector c = profile.query((Query)new InstallableUnitQuery(iuId), new Collector(), monitor);
        if (c.size() == 0) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IInstallableUnit)c.toArray((Class)clazz)[0];
    }

    private String getActionGatheringIUId(IProfile profile) {
        return "org.eclipse.equinox.p2.engine.actions.root." + profile.getProfileId();
    }

    private IInstallableUnit createIUForMetaRequirements(IProfile profile, Collection metaRequirements) {
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        String id = this.getActionGatheringIUId(profile);
        description.setId(id);
        Version version = Version.createOSGi((int)1, (int)0, (int)0, (String)Long.toString(profile.getTimestamp()));
        description.setVersion(version);
        description.addRequiredCapabilities(metaRequirements);
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        IProvidedCapability providedCapability = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)id, (Version)version);
        providedCapabilities.add(providedCapability);
        description.addProvidedCapabilities(providedCapabilities);
        IInstallableUnit actionsIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
        return actionsIU;
    }

    private IInstallableUnit createIURepresentingTheProfile(ArrayList allRequirements) {
        MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
        String time = Long.toString(System.currentTimeMillis());
        iud.setId(time);
        iud.setVersion(Version.createOSGi((int)0, (int)0, (int)0, (String)time));
        iud.setRequiredCapabilities(allRequirements.toArray(new IRequiredCapability[allRequirements.size()]));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud);
    }

    private Object[] updatePlannerInfo(ProfileChangeRequest profileChangeRequest, ProvisioningContext context) {
        int i;
        Collection includedIUs = profileChangeRequest.getProfile().query((Query)new IUProfilePropertyQuery(profileChangeRequest.getProfile(), INCLUSION_RULES, null), new Collector(), null).toCollection();
        HashSet alreadyInstalled = new HashSet(includedIUs);
        IInstallableUnit[] added = profileChangeRequest.getAddedInstallableUnits();
        IInstallableUnit[] removed = profileChangeRequest.getRemovedInstallableUnits();
        Iterator iterator = profileChangeRequest.getInstallableUnitProfilePropertiesToRemove().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry object = iterator.next();
            if (!((List)object.getValue()).contains(INCLUSION_RULES)) continue;
            profileChangeRequest.setInstallableUnitProfileProperty((IInstallableUnit)object.getKey(), INCLUSION_RULES, PlannerHelper.createStrictInclusionRule((IInstallableUnit)object.getKey()));
        }
        if (removed.length != 0) {
            iterator = alreadyInstalled.iterator();
            block1: while (iterator.hasNext()) {
                IInstallableUnit iu = (IInstallableUnit)iterator.next();
                i = 0;
                while (i < removed.length) {
                    if (iu.equals((Object)removed[i])) {
                        profileChangeRequest.removeInstallableUnitProfileProperty(removed[i], INCLUSION_RULES);
                        iterator.remove();
                        continue block1;
                    }
                    ++i;
                }
            }
        }
        ArrayList<IRequiredCapability> gatheredRequirements = new ArrayList<IRequiredCapability>();
        Map iuPropertiesToAdd = profileChangeRequest.getInstallableUnitProfilePropertiesToAdd();
        i = 0;
        while (i < added.length) {
            Map propertiesForIU = (Map)iuPropertiesToAdd.get(added[i]);
            IRequiredCapability profileRequirement = null;
            if (propertiesForIU != null) {
                profileRequirement = this.createRequirement(added[i], (String)propertiesForIU.get(INCLUSION_RULES));
            }
            if (profileRequirement == null) {
                profileChangeRequest.setInstallableUnitProfileProperty(added[i], INCLUSION_RULES, PlannerHelper.createStrictInclusionRule(added[i]));
                profileRequirement = this.createStrictRequirement(added[i]);
            }
            gatheredRequirements.add(profileRequirement);
            ++i;
        }
        Iterator iterator2 = alreadyInstalled.iterator();
        while (iterator2.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator2.next();
            Map propertiesForIU = (Map)iuPropertiesToAdd.get(iu);
            IRequiredCapability profileRequirement = null;
            if (propertiesForIU != null) {
                profileRequirement = this.createRequirement(iu, (String)propertiesForIU.get(INCLUSION_RULES));
            }
            if (profileRequirement == null) {
                profileRequirement = this.createRequirement(iu, profileChangeRequest.getProfile().getInstallableUnitProperty(iu, INCLUSION_RULES));
            }
            gatheredRequirements.add(profileRequirement);
        }
        if (context != null && context.getAdditionalRequirements() != null) {
            gatheredRequirements.addAll(context.getAdditionalRequirements());
        }
        return new Object[]{this.createIURepresentingTheProfile(gatheredRequirements), alreadyInstalled.toArray(new IInstallableUnit[alreadyInstalled.size()])};
    }

    private IRequiredCapability createRequirement(IInstallableUnit iu, String rule) {
        if (rule == null) {
            return null;
        }
        if (rule.equals(PlannerHelper.createStrictInclusionRule(iu))) {
            return this.createStrictRequirement(iu);
        }
        if (rule.equals(PlannerHelper.createOptionalInclusionRule(iu))) {
            return this.createOptionalRequirement(iu);
        }
        return null;
    }

    private IRequiredCapability createOptionalRequirement(IInstallableUnit iu) {
        return MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)new VersionRange(iu.getVersion(), true, iu.getVersion(), true), null, (boolean)true, (boolean)false, (boolean)true);
    }

    private IRequiredCapability createStrictRequirement(IInstallableUnit iu) {
        return MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)new VersionRange(iu.getVersion(), true, iu.getVersion(), true), null, (boolean)false, (boolean)false, (boolean)true);
    }

    public IInstallableUnit[] updatesFor(IInstallableUnit toUpdate, ProvisioningContext context, IProgressMonitor monitor) {
        HashMap<String, IInstallableUnit> resultsMap = new HashMap<String, IInstallableUnit>();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMetadataRepositoryManager repoMgr = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)DirectorActivator.context, (String)clazz.getName());
        URI[] repositories = context.getMetadataRepositories();
        if (repositories == null) {
            repositories = repoMgr.getKnownRepositories(0);
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(repositories.length * 200));
        int i = 0;
        while (i < repositories.length) {
            try {
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IMetadataRepository repository = repoMgr.loadRepository(repositories[i], (IProgressMonitor)sub.newChild(100));
                Collector matches = repository.query((Query)new UpdateQuery(toUpdate), new Collector(), (IProgressMonitor)sub.newChild(100));
                Iterator it = matches.iterator();
                while (it.hasNext()) {
                    IInstallableUnit iu = (IInstallableUnit)it.next();
                    String key = String.valueOf(iu.getId()) + "_" + iu.getVersion().toString();
                    IInstallableUnit currentIU = (IInstallableUnit)resultsMap.get(key);
                    if (currentIU != null && !SimplePlanner.hasHigherFidelity(iu, currentIU)) continue;
                    resultsMap.put(key, iu);
                }
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
        sub.done();
        Collection results = resultsMap.values();
        return results.toArray(new IInstallableUnit[results.size()]);
    }

    private static class EverythingOptionalProfile
    implements IProfile {
        private IProfile profile;

        public EverythingOptionalProfile(IProfile p) {
            this.profile = p;
        }

        public Collector available(Query query, Collector collector, IProgressMonitor monitor) {
            return this.profile.available(query, collector, monitor);
        }

        public Map getInstallableUnitProperties(IInstallableUnit iu) {
            return this.profile.getInstallableUnitProperties(iu);
        }

        public String getInstallableUnitProperty(IInstallableUnit iu, String key) {
            if (SimplePlanner.INCLUSION_RULES.equals(key)) {
                return PlannerHelper.createOptionalInclusionRule(iu);
            }
            return this.profile.getInstallableUnitProperty(iu, key);
        }

        public Map getLocalProperties() {
            return this.profile.getLocalProperties();
        }

        public String getLocalProperty(String key) {
            return this.profile.getLocalProperty(key);
        }

        public IProfile getParentProfile() {
            return this.profile.getParentProfile();
        }

        public String getProfileId() {
            return this.profile.getProfileId();
        }

        public Map getProperties() {
            return this.profile.getProperties();
        }

        public String getProperty(String key) {
            return this.profile.getProperty(key);
        }

        public String[] getSubProfileIds() {
            return this.profile.getSubProfileIds();
        }

        public long getTimestamp() {
            return this.profile.getTimestamp();
        }

        public boolean hasSubProfiles() {
            return this.profile.hasSubProfiles();
        }

        public boolean isRootProfile() {
            return this.profile.isRootProfile();
        }

        public Collector query(Query query, Collector collector, IProgressMonitor monitor) {
            return this.profile.query(query, collector, monitor);
        }
    }
}

