/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.actions;

import java.util.HashMap;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.actions.IPreviewAction;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.forms.editor.FormEditor;

public class GenerateDocumentToolbarMenuAction
implements IWorkbenchWindowActionDelegate {
    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        this.gendoc(action);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void gendoc(IAction action) {
        System.clearProperty("MaxDataSetRows");
        System.clearProperty("MaxCubeRowLevels");
        System.clearProperty("MaxCubeColumnLevels");
        FormEditor editor = UIUtil.getActiveReportEditor((boolean)false);
        ModuleHandle model = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (model == null) {
            return;
        }
        if (editor != null && model.needsSave()) {
            editor.doSave(null);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("RESOURCE_FOLDER_KEY", ReportPlugin.getDefault().getResourceFolder());
        options.put("SERVLET_NAME_KEY", "document");
        Object adapter = ElementAdapterManager.getAdapter((Object)action, IPreviewAction.class);
        if (adapter instanceof IPreviewAction) {
            IPreviewAction delegate = (IPreviewAction)adapter;
            delegate.setProperty("ReportPreviewOptions", options);
            delegate.setProperty("ReportFilePath", model.getFileName());
            delegate.run();
            return;
        }
        WebViewer.display((String)model.getFileName(), options);
    }
}

