/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonTextSupport;
import org.eclipse.mylyn.internal.provisional.commons.ui.SelectionProviderAdapter;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.DeleteTaskEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewSubTaskAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractLocalEditorPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttributePart;
import org.eclipse.mylyn.internal.tasks.ui.editors.FocusTracker;
import org.eclipse.mylyn.internal.tasks.ui.editors.LocalTaskEditorContributionDescriptor;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.PlanningPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.SummaryPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionContributor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorContributionExtensionReader;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskListChangeAdapter;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskFormPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.handlers.IHandlerService;

public class TaskPlanningEditor
extends TaskFormPage {
    private Composite editorComposite;
    private TaskRepository repository;
    private AbstractTask task;
    private Button saveButton;
    private final IPropertyListener dirtyStateListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 257 && TaskPlanningEditor.this.saveButton != null) {
                TaskPlanningEditor.this.saveButton.setEnabled(TaskPlanningEditor.this.getEditor().isDirty());
            }
        }
    };
    private final ITaskListChangeListener taskListChangeListener = new TaskListChangeAdapter(){

        @Override
        public void containersChanged(Set<TaskContainerDelta> containers) {
            for (TaskContainerDelta taskContainerDelta : containers) {
                AbstractTask updateTask;
                if (!(taskContainerDelta.getElement() instanceof ITask) || (updateTask = (AbstractTask)taskContainerDelta.getElement()) == null || TaskPlanningEditor.this.task == null || !updateTask.getHandleIdentifier().equals(TaskPlanningEditor.this.task.getHandleIdentifier())) continue;
                if (PlatformUI.getWorkbench() == null || PlatformUI.getWorkbench().isClosing()) break;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TaskPlanningEditor.this.refresh();
                    }
                });
                break;
            }
        }
    };
    private CommonTextSupport textSupport;
    private ITaskActivityListener timingListener;
    private FormToolkit toolkit;
    private FocusTracker focusTracker;

    public TaskPlanningEditor(TaskEditor editor) {
        super((FormEditor)editor, "org.eclipse.mylyn.tasks.ui.pageFactory.Planning", Messages.TaskPlanningEditor_Planning);
        TasksUiInternal.getTaskList().addChangeListener(this.taskListChangeListener);
    }

    private void createContributions(final Composite editorComposite) {
        Collection<LocalTaskEditorContributionDescriptor> localEditorContributions = TaskEditorContributionExtensionReader.getLocalEditorContributions();
        for (final LocalTaskEditorContributionDescriptor descriptor : localEditorContributions) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error creating task editor contribution: \"" + descriptor.getId() + "\"", e));
                }

                public void run() throws Exception {
                    AbstractLocalEditorPart part = descriptor.createPart();
                    TaskPlanningEditor.this.initializePart(editorComposite, part);
                }
            });
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        TaskEditorInput taskEditorInput = (TaskEditorInput)this.getEditorInput();
        this.task = (AbstractTask)taskEditorInput.getTask();
        this.repository = TasksUi.getRepositoryManager().getRepository(this.task.getConnectorKind(), this.task.getRepositoryUrl());
        this.toolkit = managedForm.getToolkit();
        this.editorComposite = managedForm.getForm().getBody();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        this.editorComposite.setLayout((Layout)layout);
        if (this.task instanceof LocalTask) {
            SummaryPart part = new SummaryPart();
            part.setTextSupport(this.textSupport);
            this.initializePart(this.editorComposite, part);
            this.initializePart(this.editorComposite, new AttributePart());
            this.createContributions(this.editorComposite);
        }
        PlanningPart planningPart = new PlanningPart(0);
        boolean needsDueDate = true;
        if (this.task != null) {
            try {
                TaskData taskData = TasksUi.getTaskDataManager().getTaskData((ITask)this.task);
                if (taskData != null) {
                    AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector(taskData.getConnectorKind());
                    TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(taskData.getConnectorKind(), taskData.getRepositoryUrl());
                    if (connector != null && taskRepository != null && connector.hasRepositoryDueDate(taskRepository, (ITask)this.task, taskData)) {
                        needsDueDate = false;
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        planningPart.initialize(this.getManagedForm(), this.repository, this.task, needsDueDate, this, this.textSupport);
        planningPart.createControl(this.editorComposite, this.toolkit);
        planningPart.getSection().setLayoutData((Object)new GridData(1808));
        this.getManagedForm().addPart((IFormPart)planningPart);
        this.focusTracker = new FocusTracker();
        this.focusTracker.track(this.editorComposite);
    }

    public void dispose() {
        this.getEditor().removePropertyListener(this.dirtyStateListener);
        if (this.timingListener != null) {
            TasksUiPlugin.getTaskActivityManager().removeActivityListener(this.timingListener);
        }
        TasksUiInternal.getTaskList().removeChangeListener(this.taskListChangeListener);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        TasksUiInternal.getTaskList().notifyElementChanged((IRepositoryElement)this.task);
    }

    public void doSaveAs() {
    }

    public void fillToolBar(IToolBarManager toolBarManager) {
        TaskEditorInput taskEditorInput = (TaskEditorInput)this.getEditorInput();
        ITask task = taskEditorInput.getTask();
        if (task instanceof LocalTask && task.getAttribute("outgoingNewConnectorKind") == null) {
            DeleteTaskEditorAction deleteAction = new DeleteTaskEditorAction(taskEditorInput.getTask());
            toolBarManager.add((IAction)deleteAction);
            NewSubTaskAction newSubTaskAction = new NewSubTaskAction();
            newSubTaskAction.selectionChanged((IAction)newSubTaskAction, (ISelection)new StructuredSelection((Object)task));
            if (newSubTaskAction.isEnabled()) {
                toolBarManager.add((IAction)newSubTaskAction);
            }
        }
    }

    public TaskEditor getEditor() {
        return (TaskEditor)super.getEditor();
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.textSupport = new CommonTextSupport((IHandlerService)this.getSite().getService(IHandlerService.class));
        this.textSupport.setSelectionChangedListener((ISelectionChangedListener)((TaskEditorActionContributor)this.getEditorSite().getActionBarContributor()));
        site.setSelectionProvider((ISelectionProvider)new SelectionProviderAdapter((ISelection)new StructuredSelection((Object)((TaskEditorInput)input).getTask())));
    }

    private void initializePart(Composite editorComposite, AbstractLocalEditorPart part) {
        part.initialize(this.getManagedForm(), this.repository, this.task);
        Control control = part.createControl(editorComposite, this.toolkit);
        part.setControl(control);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(control);
        this.getManagedForm().addPart((IFormPart)part);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void refresh() {
        IFormPart[] parts;
        if (this.getManagedForm().getForm().isDisposed()) {
            return;
        }
        this.getEditor().updateHeaderToolBar();
        IFormPart[] iFormPartArray = parts = this.getManagedForm().getParts();
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPart part = iFormPartArray[n2];
            if (part instanceof AbstractLocalEditorPart) {
                ((AbstractLocalEditorPart)part).refresh(false);
            } else {
                part.refresh();
            }
            ++n2;
        }
        this.getManagedForm().reflow(true);
    }

    public void fillLeftHeaderToolBar(IToolBarManager toolBarManager) {
        if (this.getEditorInput() instanceof TaskEditorInput && ((TaskEditorInput)this.getEditorInput()).getTask() instanceof LocalTask) {
            ControlContribution submitButtonContribution = new ControlContribution("org.eclipse.mylyn.tasks.toolbars.save"){

                protected Control createControl(Composite parent) {
                    TaskPlanningEditor.this.saveButton = new Button(parent, 0x800000);
                    TaskPlanningEditor.this.saveButton.setText(Messages.TaskPlanningEditor_Save);
                    TaskPlanningEditor.this.saveButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.SAVE));
                    TaskPlanningEditor.this.saveButton.setBackground(null);
                    TaskPlanningEditor.this.saveButton.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            TaskPlanningEditor.this.doSave((IProgressMonitor)new NullProgressMonitor());
                        }
                    });
                    TaskPlanningEditor.this.saveButton.setEnabled(TaskPlanningEditor.this.getEditor().isDirty());
                    return TaskPlanningEditor.this.saveButton;
                }
            };
            this.getEditor().addPropertyListener(this.dirtyStateListener);
            toolBarManager.add((IContributionItem)submitButtonContribution);
        }
    }

    public void setFocus() {
        if (this.focusTracker.setFocus()) {
            return;
        }
        IFormPart[] parts = this.getManagedForm().getParts();
        if (parts.length > 0) {
            parts[0].setFocus();
            return;
        }
        super.setFocus();
    }
}

