/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.AutoUpdateQueryAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.DeleteAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.EditRepositoryPropertiesAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.GoIntoAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewSubTaskAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenTaskListElementAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenWithBrowserAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.RemoveFromCategoryAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.RenameAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.ShowInSearchViewAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.ShowInTaskListAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskActivateAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskDeactivateAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskEditorActionGroup;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskListViewActionGroup;
import org.eclipse.mylyn.internal.tasks.ui.views.Messages;
import org.eclipse.mylyn.internal.tasks.ui.views.UpdateRepositoryConfigurationAction;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryElementActionGroup {
    protected static final String ID_SEPARATOR_NEW = "new";
    private static final String ID_SEPARATOR_OPERATIONS = "operations";
    private static final String ID_SEPARATOR_TASKS = "tasks";
    protected static final String ID_SEPARATOR_REPOSITORY = "repository";
    private static final String ID_SEPARATOR_PROPERTIES = "properties";
    protected static final String ID_SEPARATOR_NAVIGATE = "navigate";
    private static final String ID_SEPARATOR_OPEN = "open";
    protected static final String ID_SEPARATOR_EDIT = "edit";
    private final CopyTaskDetailsAction copyUrlAction;
    private final CopyTaskDetailsAction copyKeyAction;
    private final CopyTaskDetailsAction copyDetailsAction;
    private final OpenTaskListElementAction openAction;
    private final OpenWithBrowserAction openWithBrowserAction;
    private final DeleteAction deleteAction;
    private final RemoveFromCategoryAction removeFromCategoryAction;
    private final ShowInSearchViewAction showInSearchViewAction;
    private final ShowInTaskListAction showInTaskListAction;
    private final TaskActivateAction activateAction;
    private final TaskDeactivateAction deactivateAction;
    private ISelectionProvider selectionProvider;
    private final List<ISelectionChangedListener> actions = new ArrayList<ISelectionChangedListener>();
    private final AutoUpdateQueryAction autoUpdateAction;
    private final NewSubTaskAction newSubTaskAction = this.add(new NewSubTaskAction());

    public RepositoryElementActionGroup() {
        this.activateAction = this.add(new TaskActivateAction());
        this.deactivateAction = new TaskDeactivateAction();
        this.copyKeyAction = this.add(new CopyTaskDetailsAction(CopyTaskDetailsAction.Mode.KEY));
        this.copyUrlAction = this.add(new CopyTaskDetailsAction(CopyTaskDetailsAction.Mode.URL));
        this.copyDetailsAction = this.add(new CopyTaskDetailsAction(CopyTaskDetailsAction.Mode.SUMMARY_URL));
        if (!this.isInEditor()) {
            this.copyDetailsAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        }
        this.removeFromCategoryAction = this.add(new RemoveFromCategoryAction());
        this.deleteAction = this.add(new DeleteAction());
        this.openAction = this.add(new OpenTaskListElementAction());
        this.openWithBrowserAction = this.add(new OpenWithBrowserAction());
        this.showInSearchViewAction = this.add(new ShowInSearchViewAction());
        this.showInTaskListAction = this.add(new ShowInTaskListAction());
        this.autoUpdateAction = this.add(new AutoUpdateQueryAction());
    }

    private <T extends ISelectionChangedListener> T add(T action) {
        this.actions.add(action);
        return action;
    }

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        if (this.selectionProvider != null) {
            for (ISelectionChangedListener action : this.actions) {
                this.selectionProvider.removeSelectionChangedListener(action);
            }
        }
        this.selectionProvider = selectionProvider;
        if (selectionProvider != null) {
            for (ISelectionChangedListener action : this.actions) {
                this.selectionProvider.addSelectionChangedListener(action);
                ISelection selection = selectionProvider.getSelection();
                if (selection == null) {
                    selection = StructuredSelection.EMPTY;
                }
                action.selectionChanged(new SelectionChangedEvent(selectionProvider, selection));
            }
        }
    }

    public void fillContextMenu(final IMenuManager manager) {
        manager.add((IContributionItem)new Separator(ID_SEPARATOR_NEW));
        manager.add((IContributionItem)new GroupMarker(ID_SEPARATOR_NAVIGATE));
        manager.add((IContributionItem)new Separator(ID_SEPARATOR_OPEN));
        manager.add((IContributionItem)new Separator(ID_SEPARATOR_EDIT));
        manager.add((IContributionItem)new Separator(ID_SEPARATOR_TASKS));
        manager.add((IContributionItem)new GroupMarker(ID_SEPARATOR_OPERATIONS));
        manager.add((IContributionItem)new Separator(ID_SEPARATOR_REPOSITORY));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator(ID_SEPARATOR_PROPERTIES));
        IStructuredSelection selection = this.getSelection();
        Object firstSelectedObject = selection.getFirstElement();
        final ITaskContainer element = firstSelectedObject instanceof ITaskContainer ? (ITaskContainer)firstSelectedObject : null;
        final List<IRepositoryElement> selectedElements = this.getSelectedTaskContainers(selection);
        AbstractTask task = null;
        if (element instanceof ITask) {
            task = (AbstractTask)element;
        }
        if (!this.isInTaskList() && this.newSubTaskAction.isEnabled()) {
            MenuManager newSubMenu = new MenuManager(Messages.RepositoryElementActionGroup_New);
            newSubMenu.add((IAction)this.newSubTaskAction);
            manager.appendToGroup(ID_SEPARATOR_NEW, (IContributionItem)newSubMenu);
        }
        if (element instanceof ITask && !this.isInEditor()) {
            this.addAction(ID_SEPARATOR_OPEN, (Action)this.openAction, manager, element);
        }
        if (this.openWithBrowserAction.isEnabled()) {
            manager.appendToGroup(ID_SEPARATOR_OPEN, (IAction)this.openWithBrowserAction);
        }
        this.showInSearchViewAction.selectionChanged(selection);
        if (this.showInSearchViewAction.isEnabled()) {
            manager.appendToGroup(ID_SEPARATOR_OPEN, (IAction)this.showInSearchViewAction);
        }
        this.showInTaskListAction.selectionChanged(selection);
        if (this.showInTaskListAction.isEnabled() && !this.isInTaskList()) {
            manager.appendToGroup(ID_SEPARATOR_OPEN, (IAction)this.showInTaskListAction);
        }
        if (task != null) {
            if (task.isActive()) {
                manager.appendToGroup(ID_SEPARATOR_OPEN, (IAction)this.deactivateAction);
            } else {
                manager.appendToGroup(ID_SEPARATOR_OPEN, (IAction)this.activateAction);
            }
        }
        if (!selection.isEmpty()) {
            MenuManager copyDetailsSubMenu = new MenuManager(Messages.RepositoryElementActionGroup_Copy_Detail_Menu_Label, "org.eclipse.mylyn.tasklist.actions.copy");
            copyDetailsSubMenu.add((IAction)this.copyKeyAction);
            copyDetailsSubMenu.add((IAction)this.copyUrlAction);
            copyDetailsSubMenu.add((IAction)this.copyDetailsAction);
            manager.appendToGroup(ID_SEPARATOR_EDIT, (IContributionItem)copyDetailsSubMenu);
        }
        if (this.isInTaskList()) {
            manager.appendToGroup(ID_SEPARATOR_EDIT, (IAction)this.deleteAction);
        }
        this.removeFromCategoryAction.selectionChanged(selection);
        this.removeFromCategoryAction.setEnabled(this.isRemoveFromCategoryEnabled(selectedElements));
        if (this.removeFromCategoryAction.isEnabled()) {
            manager.appendToGroup(ID_SEPARATOR_EDIT, (IAction)this.removeFromCategoryAction);
        }
        if (this.autoUpdateAction.isEnabled()) {
            manager.appendToGroup(ID_SEPARATOR_REPOSITORY, (IAction)this.autoUpdateAction);
        }
        if (element instanceof IRepositoryQuery) {
            EditRepositoryPropertiesAction repositoryPropertiesAction = new EditRepositoryPropertiesAction();
            repositoryPropertiesAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)element));
            if (repositoryPropertiesAction.isEnabled()) {
                MenuManager subMenu = new MenuManager(Messages.TaskListView_Repository);
                manager.appendToGroup(ID_SEPARATOR_OPERATIONS, (IContributionItem)subMenu);
                UpdateRepositoryConfigurationAction resetRepositoryConfigurationAction = new UpdateRepositoryConfigurationAction();
                resetRepositoryConfigurationAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)element));
                subMenu.add((IAction)resetRepositoryConfigurationAction);
                subMenu.add((IContributionItem)new Separator());
                subMenu.add((IAction)repositoryPropertiesAction);
            }
        }
        Map<String, List<IDynamicSubMenuContributor>> dynamicMenuMap = TasksUiPlugin.getDefault().getDynamicMenuMap();
        for (final String menuPath : dynamicMenuMap.keySet()) {
            for (final IDynamicSubMenuContributor contributor : dynamicMenuMap.get(menuPath)) {
                SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Menu contributor failed"));
                    }

                    public void run() throws Exception {
                        MenuManager subMenuManager = contributor.getSubMenuManager(selectedElements);
                        if (subMenuManager != null) {
                            RepositoryElementActionGroup.this.addMenuManager(menuPath, (IMenuManager)subMenuManager, manager, element);
                        }
                    }
                });
            }
        }
    }

    private boolean isInTaskList() {
        return this instanceof TaskListViewActionGroup;
    }

    private IStructuredSelection getSelection() {
        ISelection selection;
        ISelection iSelection = selection = this.selectionProvider != null ? this.selectionProvider.getSelection() : null;
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    private boolean isInEditor() {
        return this instanceof TaskEditorActionGroup;
    }

    private boolean isRemoveFromCategoryEnabled(List<IRepositoryElement> selectedElements) {
        if (selectedElements.isEmpty()) {
            return false;
        }
        for (IRepositoryElement element : selectedElements) {
            if (element instanceof AbstractTask) {
                boolean hasCategory = false;
                for (ITaskContainer container : ((AbstractTask)element).getParentContainers()) {
                    if (!(container instanceof TaskCategory)) continue;
                    hasCategory = true;
                }
                if (hasCategory) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void addMenuManager(String path, IMenuManager menuToAdd, IMenuManager manager, ITaskContainer element) {
        if (element instanceof ITask || element instanceof IRepositoryQuery) {
            manager.appendToGroup(path, (IContributionItem)menuToAdd);
        }
    }

    private void addAction(String path, Action action, IMenuManager manager, ITaskContainer element) {
        action.setEnabled(false);
        if (element != null) {
            this.updateActionEnablement(action, element);
        }
        manager.appendToGroup(path, (IAction)action);
    }

    private void updateActionEnablement(Action action, ITaskContainer element) {
        if (element instanceof ITask) {
            if (action instanceof OpenTaskListElementAction) {
                action.setEnabled(true);
            } else if (action instanceof CopyTaskDetailsAction) {
                action.setEnabled(true);
            } else if (action instanceof RenameAction) {
                action.setEnabled(true);
            }
        } else if (element != null) {
            if (action instanceof GoIntoAction) {
                TaskCategory cat = (TaskCategory)element;
                if (cat.getChildren().size() > 0) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
            } else if (action instanceof OpenTaskListElementAction) {
                action.setEnabled(true);
            } else if (action instanceof CopyTaskDetailsAction) {
                action.setEnabled(true);
            } else if (action instanceof RenameAction) {
                if (element instanceof AbstractTaskCategory) {
                    AbstractTaskCategory container = (AbstractTaskCategory)element;
                    action.setEnabled(container.isUserManaged());
                } else if (element instanceof IRepositoryQuery) {
                    action.setEnabled(true);
                }
            }
        } else {
            action.setEnabled(true);
        }
    }

    public List<IRepositoryElement> getSelectedTaskContainers(IStructuredSelection selection) {
        ArrayList<IRepositoryElement> selectedElements = new ArrayList<IRepositoryElement>();
        for (Object object : selection) {
            if (!(object instanceof ITaskContainer)) continue;
            selectedElements.add((IRepositoryElement)object);
        }
        return selectedElements;
    }

    public OpenTaskListElementAction getOpenAction() {
        return this.openAction;
    }

    public TaskActivateAction getActivateAction() {
        return this.activateAction;
    }

    public DeleteAction getDeleteAction() {
        return this.deleteAction;
    }

    public CopyTaskDetailsAction getCopyDetailsAction() {
        return this.copyDetailsAction;
    }
}

