/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.provisional.commons.ui.SelectionProviderAdapter;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TaskHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.RepositoryElementActionGroup;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.core.TaskActivationAdapter;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class TaskTrimWidget
extends WorkbenchWindowControlContribution {
    public static String ID_CONTAINER = "org.eclipse.mylyn.tasks.ui.trim.container";
    public static String ID_CONTROL = "org.eclipse.mylyn.tasks.ui.trim.control";
    private Composite composite;
    private ITask activeTask;
    private MenuManager menuManager;
    private Menu menu;
    private TaskHyperlink activeTaskLabel;
    private Point p;
    private final ITaskActivationListener TASK_ACTIVATION_LISTENER = new TaskActivationAdapter(){

        public void taskActivated(ITask task) {
            TaskTrimWidget.this.activeTask = task;
            TaskTrimWidget.this.indicateActiveTask();
        }

        public void taskDeactivated(ITask task) {
            TaskTrimWidget.this.activeTask = null;
            TaskTrimWidget.this.indicateNoActiveTask();
        }
    };
    private final IPropertyChangeListener SHOW_TRIM_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("org.eclipse.mylyn.tasks.ui.show.trim")) {
                TaskTrimWidget.this.setTrimVisible((Boolean)event.getNewValue());
            }
        }
    };
    private SelectionProviderAdapter activeTaskSelectionProvider;

    public TaskTrimWidget() {
        TasksUi.getTaskActivityManager().addActivationListener(this.TASK_ACTIVATION_LISTENER);
        TasksUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.SHOW_TRIM_LISTENER);
        this.hookContextMenu();
    }

    private void setTrimVisible(boolean visible) {
        IWindowTrim trim;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window instanceof WorkbenchWindow && (trim = ((WorkbenchWindow)window).getTrimManager().getTrim(ID_CONTAINER)) != null) {
            ((WorkbenchWindow)window).getTrimManager().setTrimVisible(trim, visible);
            ((WorkbenchWindow)window).getTrimManager().forceLayout();
        }
    }

    public void dispose() {
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.dispose();
        }
        this.composite = null;
        if (this.menuManager != null) {
            this.menuManager.removeAll();
            this.menuManager.dispose();
        }
        this.menuManager = null;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        TasksUi.getTaskActivityManager().removeActivationListener(this.TASK_ACTIVATION_LISTENER);
        TasksUiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.SHOW_TRIM_LISTENER);
    }

    protected Control createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, true));
        this.createStatusComposite(this.composite);
        parent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                IPreferenceStore uiPreferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
                TaskTrimWidget.this.setTrimVisible(uiPreferenceStore.getBoolean("org.eclipse.mylyn.tasks.ui.show.trim"));
            }
        });
        return this.composite;
    }

    private Composite createStatusComposite(final Composite container) {
        GC gc = new GC((Drawable)container);
        this.p = gc.textExtent("WWWWWWWWWWWWWWW");
        gc.dispose();
        this.activeTaskLabel = new TaskHyperlink(container, 131072);
        GridData gridData = new GridData(16384, 0x1000000, false, true);
        gridData.widthHint = this.p.x;
        gridData.minimumWidth = this.p.x;
        gridData.horizontalIndent = 0;
        this.activeTaskLabel.setLayoutData(gridData);
        this.activeTaskLabel.setText(Messages.TaskTrimWidget__no_task_active_);
        this.activeTask = TasksUi.getTaskActivityManager().getActiveTask();
        if (this.activeTask != null) {
            this.indicateActiveTask();
        }
        this.activeTaskLabel.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                if (TaskTrimWidget.this.menu != null) {
                    TaskTrimWidget.this.menu.dispose();
                }
                TaskTrimWidget.this.menu = TaskTrimWidget.this.menuManager.createContextMenu((Control)container);
                TaskTrimWidget.this.menu.setVisible(true);
            }
        });
        this.activeTaskLabel.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskListView taskListView = TaskListView.getFromActivePerspective();
                if (taskListView != null && taskListView.getDrilledIntoCategory() != null) {
                    taskListView.goUpToRoot();
                }
                TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)TasksUi.getTaskActivityManager().getActiveTask());
            }
        });
        this.activeTaskLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    if (TaskTrimWidget.this.activeTask == null) {
                        return;
                    }
                    TaskListView taskListView = TaskListView.getFromActivePerspective();
                    if (taskListView != null && taskListView.getDrilledIntoCategory() != null) {
                        taskListView.goUpToRoot();
                    }
                    TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)TaskTrimWidget.this.activeTask);
                }
            }
        });
        return this.activeTaskLabel;
    }

    private void hookContextMenu() {
        this.activeTaskSelectionProvider = new SelectionProviderAdapter();
        final RepositoryElementActionGroup actionGroup = new RepositoryElementActionGroup();
        actionGroup.setSelectionProvider((ISelectionProvider)this.activeTaskSelectionProvider);
        this.menuManager = new MenuManager("#PopupMenu");
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                actionGroup.fillContextMenu(manager);
                ObjectActionContributorManager.getManager().contributeObjectActions(null, manager, (ISelectionProvider)TaskTrimWidget.this.activeTaskSelectionProvider);
            }
        });
    }

    public void indicateActiveTask() {
        if (this.activeTaskLabel != null && this.activeTaskLabel.isDisposed()) {
            return;
        }
        this.activeTaskLabel.setText(this.activeTask.getSummary());
        this.activeTaskLabel.setUnderlined(true);
        this.activeTaskLabel.setToolTipText(this.activeTask.getSummary());
        this.activeTaskSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)this.activeTask));
    }

    public void indicateNoActiveTask() {
        if (this.activeTaskLabel != null && this.activeTaskLabel.isDisposed()) {
            return;
        }
        this.activeTaskLabel.setText(Messages.TaskTrimWidget__no_active_task_);
        this.activeTaskLabel.setUnderlined(false);
        this.activeTaskLabel.setToolTipText("");
        this.activeTaskSelectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
    }
}

