/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.tagregistry;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.LifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectTracker {
    private final IWorkspaceRoot _root;
    private final LifecycleListener _lifecycleListener;
    private final CopyOnWriteArrayList<ProjectTrackingListener> _myListeners;
    private Set<IProject> _validProjects;
    private final ResourceChangeListener _resourceChangeListener;
    private ProjectAdvisor _projectAdvisor;
    private static final ProjectAdvisor DEFAULT_ADVISOR = new ProjectAdvisor(){

        public boolean shouldTrack(IProject project) {
            return true;
        }
    };

    public ProjectTracker(IWorkspaceRoot root, ProjectAdvisor projectAdvisor) {
        this._root = root;
        this._lifecycleListener = new LifecycleListener();
        this._resourceChangeListener = new ResourceChangeListener();
        this._myListeners = new CopyOnWriteArrayList();
        this._projectAdvisor = projectAdvisor != null ? projectAdvisor : DEFAULT_ADVISOR;
    }

    public void startTracking() {
        this._lifecycleListener.addResource((IResource)this._root);
        this._validProjects = new HashSet<IProject>();
        IProject[] iProjectArray = this._root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (this._projectAdvisor.shouldTrack(project)) {
                this._validProjects.add(project);
                this._lifecycleListener.addResource((IResource)project);
            }
            ++n2;
        }
        this._lifecycleListener.addListener((IResourceLifecycleListener)this._resourceChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IProject> getProjects() {
        HashSet<IProject> projects = new HashSet<IProject>();
        ProjectTracker projectTracker = this;
        synchronized (projectTracker) {
            projects.addAll(this._validProjects);
        }
        return projects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addProject(IProject project) {
        if (this._projectAdvisor.shouldTrack(project)) {
            ProjectTracker projectTracker = this;
            synchronized (projectTracker) {
                this._validProjects.add(project);
                this._lifecycleListener.addResource((IResource)project);
            }
            this.fireChangeEvent(project, ProjectTrackingListener.Reason.ADDED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProject(IProject project) {
        ProjectTracker projectTracker = this;
        synchronized (projectTracker) {
            this._validProjects.remove(project);
            this._lifecycleListener.removeResource((IResource)project);
        }
        this.fireChangeEvent(project, ProjectTrackingListener.Reason.REMOVED);
    }

    public void addListener(ProjectTrackingListener listener) {
        this._myListeners.addIfAbsent(listener);
    }

    public void removeListener(ProjectTrackingListener listener) {
        this._myListeners.remove(listener);
    }

    private void fireChangeEvent(IProject project, ProjectTrackingListener.Reason reason) {
        for (ProjectTrackingListener listener : this._myListeners) {
            listener.projectsChanged(project, reason);
        }
    }

    public void dispose() {
        this._lifecycleListener.dispose();
        this._validProjects.clear();
        this._myListeners.clear();
    }

    public static abstract class ProjectAdvisor {
        public abstract boolean shouldTrack(IProject var1);
    }

    public static class ProjectTrackingListener {
        protected void projectsChanged(IProject project, Reason reason) {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Reason {
            ADDED,
            REMOVED;

        }
    }

    private class ResourceChangeListener
    implements IResourceLifecycleListener {
        private ResourceChangeListener() {
        }

        public IResourceLifecycleListener.EventResult acceptEvent(ResourceLifecycleEvent event) {
            IResource res = event.getAffectedResource();
            if (event.getEventType() == ResourceLifecycleEvent.EventType.RESOURCE_ADDED && event.getReasonType() == ResourceLifecycleEvent.ReasonType.PROJECT_OPENED && res instanceof IProject) {
                this.handleNewProject((IProject)res);
            } else if (ProjectTracker.this._validProjects.contains(res) && event.getEventType() == ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE) {
                this.handleProjectClosed((IProject)res);
            }
            return IResourceLifecycleListener.EventResult.getDefaultEventResult();
        }

        private void handleNewProject(IProject project) {
            ProjectTracker.this.addProject(project);
        }

        private void handleProjectClosed(IProject project) {
            ProjectTracker.this.removeProject(project);
        }
    }
}

