/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.dialogs;

import com.ibm.icu.text.Collator;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.UIRepositoryEvent;
import org.eclipse.equinox.internal.p2.ui.dialogs.ComboAutoCompleteField;
import org.eclipse.equinox.internal.p2.ui.dialogs.URLDropAdapter;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUIProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.AddRepositoryDialog;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.IRepositorySelectionListener;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.AddRepositoryOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.RepositoryOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IUViewQueryContext;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.RepositoryLocationValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.RepositoryManipulator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class RepositorySelectionGroup {
    private static final String SITE_NONE = ProvUIMessages.AvailableIUsPage_NoSites;
    private static final String SITE_ALL = ProvUIMessages.AvailableIUsPage_AllSites;
    private static final String SITE_LOCAL = ProvUIMessages.AvailableIUsPage_LocalSites;
    private static final int INDEX_SITE_NONE = 0;
    private static final int INDEX_SITE_ALL = 1;
    private static final int DEC_MARGIN_WIDTH = 2;
    private static final String LINKACTION = "linkAction";
    private static final int COUNT_VISIBLE_ITEMS = 20;
    IWizardContainer container;
    Policy policy;
    IUViewQueryContext queryContext;
    ListenerList listeners = new ListenerList();
    Combo repoCombo;
    Link repoManipulatorLink;
    ControlDecoration repoDec;
    ComboAutoCompleteField repoAutoComplete;
    ProvUIProvisioningListener comboRepoListener;
    Image info;
    Image warning;
    Image error;
    URI[] comboRepos;
    HashMap disabledRepoProposals = new HashMap();

    public RepositorySelectionGroup(IWizardContainer container, Composite parent, Policy policy, IUViewQueryContext queryContext) {
        this.container = container;
        this.queryContext = queryContext;
        this.policy = policy;
        this.createControl(parent);
    }

    public Control getDefaultFocusControl() {
        return this.repoCombo;
    }

    public void addRepositorySelectionListener(IRepositorySelectionListener listener) {
        this.listeners.add((Object)listener);
    }

    protected void createControl(Composite parent) {
        this.info = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
        this.warning = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
        this.error = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        Composite comboComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 0;
        layout.marginBottom = 4;
        layout.numColumns = 3;
        comboComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, false);
        comboComposite.setLayoutData((Object)gd);
        Label label = new Label(comboComposite, 0);
        label.setText(ProvUIMessages.AvailableIUsPage_RepoFilterLabel);
        this.repoCombo = new Combo(comboComposite, 4);
        this.repoCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                RepositorySelectionGroup.this.repoComboSelectionChanged();
            }

            public void widgetSelected(SelectionEvent e) {
                RepositorySelectionGroup.this.repoComboSelectionChanged();
            }
        });
        this.repoAutoComplete = new ComboAutoCompleteField(this.repoCombo);
        this.repoCombo.setVisibleItemCount(20);
        this.repoCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    RepositorySelectionGroup.this.addRepository(false);
                }
            }
        });
        this.repoCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = 4;
        this.repoCombo.setLayoutData((Object)gd);
        this.repoCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                URI location = null;
                IStatus status = null;
                String text = RepositorySelectionGroup.this.repoCombo.getText().trim();
                int index = RepositorySelectionGroup.this.getComboIndex(text);
                if (index < 0) {
                    location = RepositoryLocationValidator.locationFromString(RepositorySelectionGroup.this.repoCombo.getText());
                    if (location == null) {
                        status = RepositoryLocationValidator.getInvalidLocationStatus(RepositorySelectionGroup.this.repoCombo.getText());
                    } else {
                        RepositoryLocationValidator validator = RepositorySelectionGroup.this.policy.getRepositoryManipulator().getRepositoryLocationValidator(RepositorySelectionGroup.this.repoCombo.getShell());
                        status = validator.validateRepositoryLocation(location, false, (IProgressMonitor)new NullProgressMonitor());
                    }
                } else {
                    RepositorySelectionGroup.this.repoComboSelectionChanged();
                }
                RepositorySelectionGroup.this.setRepoComboDecoration(status);
            }
        });
        this.repoDec = new ControlDecoration((Control)this.repoCombo, 16512);
        this.repoDec.setMarginWidth(2);
        DropTarget target = new DropTarget((Control)this.repoCombo, 7);
        target.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new URLDropAdapter(true){

            protected void handleDrop(String urlText, DropTargetEvent event) {
                RepositorySelectionGroup.this.repoCombo.setText(urlText);
                event.detail = 4;
                RepositorySelectionGroup.this.addRepository(false);
            }
        });
        Button button = new Button(comboComposite, 8);
        button.setText(ProvUIMessages.AvailableIUsPage_AddButton);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                RepositorySelectionGroup.this.addRepository(true);
            }

            public void widgetSelected(SelectionEvent e) {
                RepositorySelectionGroup.this.addRepository(true);
            }
        });
        this.setButtonLayoutData(button);
        this.repoManipulatorLink = this.createLink(comboComposite, (IAction)new Action(){

            public void runWithEvent(Event event) {
                RepositorySelectionGroup.this.policy.getRepositoryManipulator().manipulateRepositories(RepositorySelectionGroup.this.repoCombo.getShell());
            }
        }, this.policy.getRepositoryManipulator().getManipulatorLinkLabel());
        gd = new GridData(0x1000008, 4, true, false);
        gd.horizontalSpan = 3;
        this.repoManipulatorLink.setLayoutData((Object)gd);
        this.addComboProvisioningListeners();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RepositorySelectionGroup.this.removeProvisioningListeners();
            }
        });
    }

    private void setButtonLayoutData(Button button) {
        GridData data = new GridData(4, 0x1000000, false, false);
        GC gc = new GC((Drawable)button);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fm, (int)61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
    }

    public void setRepositorySelection(int scope, URI location) {
        switch (scope) {
            case 1: {
                this.fillRepoCombo(SITE_ALL);
                break;
            }
            case 3: {
                this.fillRepoCombo(SITE_LOCAL);
                break;
            }
            case 4: {
                this.fillRepoCombo(this.getSiteString(location));
                break;
            }
            default: {
                this.fillRepoCombo(SITE_NONE);
            }
        }
        this.setRepoComboDecoration(null);
    }

    protected void setRepoComboDecoration(final IStatus status) {
        if (status == null || status.isOK() || status.getSeverity() == 8) {
            this.repoDec.setShowOnlyOnFocus(true);
            this.repoDec.setDescriptionText(ProvUIMessages.AvailableIUsPage_RepoFilterInstructions);
            this.repoDec.setImage(this.info);
            if (this.repoCombo.getText().length() > 0) {
                this.repoDec.showHoverText(null);
            }
            return;
        }
        Image image = status.getSeverity() == 2 ? this.warning : (status.getSeverity() == 4 ? this.error : this.info);
        this.repoDec.setImage(image);
        this.repoDec.setDescriptionText(status.getMessage());
        this.repoDec.setShowOnlyOnFocus(false);
        this.repoCombo.getDisplay().timerExec(500, new Runnable(){

            public void run() {
                if (RepositorySelectionGroup.this.repoDec != null && RepositorySelectionGroup.this.repoDec.getImage() != RepositorySelectionGroup.this.info) {
                    RepositorySelectionGroup.this.repoDec.showHoverText(status.getMessage());
                }
            }
        });
    }

    void fillRepoCombo(final String selection) {
        String[] items;
        boolean hasLocalSites;
        URI[] sites = this.policy.getRepositoryManipulator().getKnownRepositories();
        boolean bl = hasLocalSites = this.getLocalSites().length > 0;
        if (hasLocalSites) {
            this.comboRepos = new URI[sites.length + 3];
            items = new String[sites.length + 3];
        } else {
            this.comboRepos = new URI[sites.length + 2];
            items = new String[sites.length + 2];
        }
        items[0] = SITE_NONE;
        items[1] = SITE_ALL;
        int i = 0;
        while (i < sites.length) {
            items[i + 2] = this.getSiteString(sites[i]);
            this.comboRepos[i + 2] = sites[i];
            ++i;
        }
        if (hasLocalSites) {
            items[items.length - 1] = SITE_LOCAL;
        }
        if (sites.length > 0) {
            this.sortRepoItems(items, this.comboRepos, hasLocalSites);
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (RepositorySelectionGroup.this.repoCombo == null || RepositorySelectionGroup.this.repoCombo.isDisposed()) {
                    return;
                }
                String repoToSelect = selection;
                if (repoToSelect == null) {
                    int selIndex = RepositorySelectionGroup.this.repoCombo.getSelectionIndex();
                    repoToSelect = selIndex >= 0 ? RepositorySelectionGroup.this.repoCombo.getItem(selIndex) : RepositorySelectionGroup.this.repoCombo.getText();
                }
                RepositorySelectionGroup.this.repoCombo.setItems(items);
                RepositorySelectionGroup.this.repoAutoComplete.setProposalStrings(RepositorySelectionGroup.this.getComboProposals());
                boolean selected = false;
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(repoToSelect)) {
                        selected = true;
                        if (RepositorySelectionGroup.this.repoCombo.getListVisible()) {
                            RepositorySelectionGroup.this.repoCombo.select(i);
                        }
                        RepositorySelectionGroup.this.repoCombo.setText(repoToSelect);
                        break;
                    }
                    ++i;
                }
                if (!selected) {
                    if (RepositorySelectionGroup.this.repoCombo.getListVisible()) {
                        RepositorySelectionGroup.this.repoCombo.select(0);
                    }
                    RepositorySelectionGroup.this.repoCombo.setText(SITE_NONE);
                }
                RepositorySelectionGroup.this.repoComboSelectionChanged();
            }
        };
        if (Display.getCurrent() == null) {
            this.repoCombo.getDisplay().asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    String getSiteString(URI uri) {
        try {
            String nickname = ProvisioningUtil.getMetadataRepositoryProperty(uri, "p2.nickname");
            if (nickname != null && nickname.length() > 0) {
                return NLS.bind((String)ProvUIMessages.AvailableIUsPage_NameWithLocation, (Object)nickname, (Object)URIUtil.toUnencodedString((URI)uri));
            }
        }
        catch (ProvisionException provisionException) {}
        return URIUtil.toUnencodedString((URI)uri);
    }

    private Link createLink(Composite parent, IAction action, String text) {
        Link link = new Link(parent, 8);
        link.setText(text);
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IAction linkAction = RepositorySelectionGroup.this.getLinkAction(event.widget);
                if (linkAction != null) {
                    linkAction.runWithEvent(event);
                }
            }
        });
        link.setToolTipText(action.getToolTipText());
        link.setData(LINKACTION, (Object)action);
        return link;
    }

    IAction getLinkAction(Widget widget) {
        Object data = widget.getData(LINKACTION);
        if (data == null || !(data instanceof IAction)) {
            return null;
        }
        return (IAction)data;
    }

    private void sortRepoItems(String[] strings, URI[] locations, boolean hasLocalSites) {
        int sortEnd;
        int sortStart = 2;
        int n = sortEnd = hasLocalSites ? strings.length - 2 : strings.length - 1;
        if (sortStart >= sortEnd) {
            return;
        }
        final HashMap<URI, String> uriToString = new HashMap<URI, String>();
        int i = sortStart;
        while (i <= sortEnd) {
            uriToString.put(locations[i], strings[i]);
            ++i;
        }
        final Collator collator = Collator.getInstance((Locale)Locale.getDefault());
        Comparator stringComparator = new Comparator(){

            public int compare(Object a, Object b) {
                return collator.compare(a, b);
            }
        };
        Comparator uriComparator = new Comparator(){

            public int compare(Object a, Object b) {
                return collator.compare(uriToString.get(a), uriToString.get(b));
            }
        };
        Arrays.sort(strings, sortStart, sortEnd, stringComparator);
        Arrays.sort(locations, sortStart, sortEnd, uriComparator);
    }

    private URI[] getLocalSites() {
        int flags = this.queryContext.getMetadataRepositoryFlags() | 4;
        try {
            return ProvisioningUtil.getMetadataRepositories(flags);
        }
        catch (ProvisionException provisionException) {
            return null;
        }
    }

    String[] getComboProposals() {
        try {
            int flags = this.queryContext.getMetadataRepositoryFlags() | 8;
            String[] items = this.repoCombo.getItems();
            this.disabledRepoProposals = new HashMap();
            URI[] disabled = ProvisioningUtil.getMetadataRepositories(flags);
            String[] disabledItems = new String[disabled.length];
            int i = 0;
            while (i < disabledItems.length) {
                disabledItems[i] = this.getSiteString(disabled[i]);
                this.disabledRepoProposals.put(disabledItems[i], disabled[i]);
                ++i;
            }
            String[] both = new String[items.length + disabledItems.length];
            System.arraycopy(items, 0, both, 0, items.length);
            System.arraycopy(disabledItems, 0, both, items.length, disabledItems.length);
            return both;
        }
        catch (ProvisionException provisionException) {
            return new String[0];
        }
    }

    int getComboIndex(String repoText) {
        int i;
        if ((repoText = repoText.trim()).length() > 0) {
            String[] items = this.repoCombo.getItems();
            i = 0;
            while (i < items.length) {
                if (repoText.equals(items[i])) {
                    return i;
                }
                ++i;
            }
        }
        try {
            URI location = URIUtil.fromString((String)repoText);
            i = 0;
            while (i < this.comboRepos.length) {
                if (URIUtil.sameURI((URI)location, (URI)this.comboRepos[i])) {
                    return i;
                }
                ++i;
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        return -1;
    }

    void addComboProvisioningListeners() {
        this.comboRepoListener = new ProvUIProvisioningListener(1){

            protected void repositoryAdded(RepositoryEvent e) {
                if (e instanceof UIRepositoryEvent) {
                    RepositorySelectionGroup.this.fillRepoCombo(RepositorySelectionGroup.this.getSiteString(e.getRepositoryLocation()));
                }
            }

            protected void repositoryRemoved(RepositoryEvent e) {
                RepositorySelectionGroup.this.fillRepoCombo(null);
            }

            protected void refreshAll() {
                RepositorySelectionGroup.this.fillRepoCombo(null);
            }
        };
        ProvUI.addProvisioningListener(this.comboRepoListener);
    }

    void removeProvisioningListeners() {
        if (this.comboRepoListener != null) {
            ProvUI.removeProvisioningListener(this.comboRepoListener);
            this.comboRepoListener = null;
        }
    }

    void addRepository(boolean alwaysPrompt) {
        boolean isNewText;
        final RepositoryManipulator manipulator = this.policy.getRepositoryManipulator();
        final String selectedRepo = this.repoCombo.getText().trim();
        int selectionIndex = this.getComboIndex(selectedRepo);
        boolean bl = isNewText = selectionIndex < 0;
        if (!alwaysPrompt && !isNewText && selectionIndex != this.repoCombo.getSelectionIndex()) {
            this.repoComboSelectionChanged();
        } else if (alwaysPrompt) {
            AddRepositoryDialog dialog = new AddRepositoryDialog(this.repoCombo.getShell(), this.policy){

                protected AddRepositoryOperation getOperation(URI repositoryLocation) {
                    AddRepositoryOperation op = manipulator.getAddOperation(repositoryLocation);
                    op.setNotify(false);
                    return op;
                }

                protected String getInitialLocationText() {
                    if (isNewText) {
                        return selectedRepo;
                    }
                    return super.getInitialLocationText();
                }
            };
            dialog.setTitle(manipulator.getAddOperationLabel());
            dialog.open();
            URI location = dialog.getAddedLocation();
            if (location != null) {
                this.fillRepoCombo(this.getSiteString(location));
            }
        } else if (isNewText) {
            try {
                this.container.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        IStatus status;
                        URI location;
                        if (RepositorySelectionGroup.this.disabledRepoProposals.containsKey(selectedRepo)) {
                            location = (URI)RepositorySelectionGroup.this.disabledRepoProposals.get(selectedRepo);
                            status = Status.OK_STATUS;
                        } else {
                            location = RepositoryLocationValidator.locationFromString(selectedRepo);
                            if (location == null) {
                                status = RepositoryLocationValidator.getInvalidLocationStatus(selectedRepo);
                            } else {
                                RepositoryLocationValidator validator = manipulator.getRepositoryLocationValidator(RepositorySelectionGroup.this.repoCombo.getShell());
                                status = validator.validateRepositoryLocation(location, false, monitor);
                            }
                        }
                        if (status.isOK() && location != null) {
                            try {
                                AddRepositoryOperation op = manipulator.getAddOperation(location);
                                ((RepositoryOperation)op).setNotify(false);
                                op.execute(monitor);
                                RepositorySelectionGroup.this.fillRepoCombo(RepositorySelectionGroup.this.getSiteString(location));
                            }
                            catch (ProvisionException e) {
                                ProvUI.handleException(e, null, 2);
                            }
                        }
                        RepositorySelectionGroup.this.setRepoComboDecoration(status);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public ProvisioningContext getProvisioningContext() {
        int siteSel = this.getComboIndex(this.repoCombo.getText().trim());
        if (siteSel < 0 || siteSel == 1 || siteSel == 0) {
            return new ProvisioningContext();
        }
        URI[] locals = this.getLocalSites();
        if (locals.length > 0 && siteSel == this.repoCombo.getItemCount() - 1) {
            ProvisioningContext context = new ProvisioningContext(locals);
            context.setArtifactRepositories(locals);
            return context;
        }
        ProvisioningContext context = new ProvisioningContext(new URI[]{this.comboRepos[siteSel]});
        context.setArtifactRepositories(new URI[]{this.comboRepos[siteSel]});
        return context;
    }

    void repoComboSelectionChanged() {
        int localIndex;
        int repoChoice = -1;
        URI repoLocation = null;
        int selection = -1;
        selection = this.repoCombo.getListVisible() ? this.repoCombo.getSelectionIndex() : this.getComboIndex(this.repoCombo.getText().trim());
        int n = localIndex = this.getLocalSites().length == 0 ? this.repoCombo.getItemCount() : this.repoCombo.getItemCount() - 1;
        if (this.comboRepos == null || selection < 0) {
            selection = 0;
        }
        if (selection == 0) {
            repoChoice = 2;
        } else if (selection == 1) {
            repoChoice = 1;
        } else if (selection >= localIndex) {
            repoChoice = 3;
        } else {
            repoChoice = 4;
            repoLocation = this.comboRepos[selection];
        }
        Object[] selectionListeners = this.listeners.getListeners();
        int i = 0;
        while (i < selectionListeners.length) {
            ((IRepositorySelectionListener)selectionListeners[i]).repositorySelectionChanged(repoChoice, repoLocation);
            ++i;
        }
    }
}

