/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jpt.core.JptCorePlugin;

public class PlatformTools {
    public static IContentType getContentType(IFile file) {
        String fileName = file.getName();
        InputStream fileContents = null;
        try {
            fileContents = file.getContents();
        }
        catch (CoreException coreException) {
            return PlatformTools.findContentTypeFor(fileName);
        }
        IContentType contentType = null;
        try {
            try {
                contentType = PlatformTools.findContentTypeFor(fileContents, fileName);
            }
            catch (IOException ex) {
                JptCorePlugin.log(ex);
                try {
                    fileContents.close();
                }
                catch (IOException ex2) {
                    JptCorePlugin.log(ex2);
                }
            }
        }
        finally {
            try {
                fileContents.close();
            }
            catch (IOException ex) {
                JptCorePlugin.log(ex);
            }
        }
        return contentType;
    }

    private static IContentType findContentTypeFor(InputStream fileContents, String fileName) throws IOException {
        return PlatformTools.getContentTypeManager().findContentTypeFor(fileContents, fileName);
    }

    private static IContentType findContentTypeFor(String fileName) {
        return PlatformTools.getContentTypeManager().findContentTypeFor(fileName);
    }

    private static IContentTypeManager getContentTypeManager() {
        return Platform.getContentTypeManager();
    }

    private PlatformTools() {
        throw new UnsupportedOperationException();
    }
}

