/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.core.internal.resource.java.source.SourceNode;
import org.eclipse.jpt.core.internal.utility.jdt.ASTNodeTextRange;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterables.CloneIterable;
import org.eclipse.jpt.utility.internal.iterables.FixedCloneIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourcePersistentMember<E extends Member>
extends SourceNode
implements JavaResourcePersistentMember {
    final E member;
    final Vector<Annotation> mappingAnnotations = new Vector();
    final Vector<Annotation> supportingAnnotations = new Vector();
    boolean persistable;

    SourcePersistentMember(JavaResourceNode parent, E member) {
        super(parent);
        this.member = member;
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.member.getBodyDeclaration(astRoot).accept(this.buildInitialAnnotationVisitor(astRoot));
        this.persistable = this.buildPersistable(astRoot);
    }

    private ASTVisitor buildInitialAnnotationVisitor(CompilationUnit astRoot) {
        return new InitialAnnotationVisitor(astRoot, this.member.getBodyDeclaration(astRoot));
    }

    void addInitialAnnotation(org.eclipse.jdt.core.dom.Annotation node, CompilationUnit astRoot) {
        String jdtAnnotationName = JDTTools.resolveAnnotation(node);
        if (jdtAnnotationName == null) {
            return;
        }
        if (this.annotationIsValidSupportingAnnotation(jdtAnnotationName)) {
            if (this.selectAnnotationNamed(this.supportingAnnotations, jdtAnnotationName) == null) {
                Annotation annotation = this.buildSupportingAnnotation(jdtAnnotationName);
                annotation.initialize(astRoot);
                this.supportingAnnotations.add(annotation);
            }
        } else if (this.annotationIsValidMappingAnnotation(jdtAnnotationName) && this.selectAnnotationNamed(this.mappingAnnotations, jdtAnnotationName) == null) {
            Annotation annotation = this.buildMappingAnnotation(jdtAnnotationName);
            annotation.initialize(astRoot);
            this.mappingAnnotations.add(annotation);
        }
    }

    @Override
    public Iterator<Annotation> mappingAnnotations() {
        return new CloneIterator(this.mappingAnnotations);
    }

    private Iterable<Annotation> getMappingAnnotations() {
        return new CloneIterable(this.mappingAnnotations);
    }

    @Override
    public int mappingAnnotationsSize() {
        return this.mappingAnnotations.size();
    }

    @Override
    public Annotation getMappingAnnotation() {
        FixedCloneIterable annotations = new FixedCloneIterable(this.mappingAnnotations);
        ListIterator<String> stream = this.validMappingAnnotationNames();
        while (stream.hasNext()) {
            Annotation annotation = this.selectAnnotationNamed((Iterable<Annotation>)annotations, stream.next());
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    @Override
    public Annotation getMappingAnnotation(String annotationName) {
        return this.selectAnnotationNamed(this.getMappingAnnotations(), annotationName);
    }

    @Override
    public Annotation setMappingAnnotation(String annotationName) {
        Collection<Annotation> removedAnnotations = null;
        Annotation newMapping = null;
        if (annotationName == null) {
            removedAnnotations = this.removeMappingAnnotations();
        } else {
            if (this.selectAnnotationNamed(this.mappingAnnotations, annotationName) != null) {
                throw new IllegalStateException("duplicate mapping annotation: " + annotationName);
            }
            removedAnnotations = this.removeMappingAnnotations();
            newMapping = this.buildMappingAnnotation(annotationName);
            this.mappingAnnotations.add(newMapping);
            newMapping.newAnnotation();
            this.fireItemAdded("mappingAnnotations", newMapping);
        }
        this.fireItemsRemoved("mappingAnnotations", removedAnnotations);
        return newMapping;
    }

    private Collection<Annotation> removeMappingAnnotations() {
        Collection<Annotation> removedAnnotations = null;
        for (String mappingAnnotationName : CollectionTools.iterable(this.validMappingAnnotationNames())) {
            Annotation mappingAnnotation = this.selectAnnotationNamed(this.mappingAnnotations, mappingAnnotationName);
            if (mappingAnnotation == null) continue;
            this.mappingAnnotations.remove(mappingAnnotation);
            mappingAnnotation.removeAnnotation();
            if (removedAnnotations == null) {
                removedAnnotations = new ArrayList();
            }
            ((ArrayList)removedAnnotations).add(mappingAnnotation);
        }
        return removedAnnotations != null ? removedAnnotations : Collections.emptySet();
    }

    abstract Annotation buildMappingAnnotation(String var1);

    private boolean annotationIsValidMappingAnnotation(String annotationName) {
        return CollectionTools.contains(this.validMappingAnnotationNames(), (Object)annotationName);
    }

    abstract ListIterator<String> validMappingAnnotationNames();

    @Override
    public Iterator<Annotation> supportingAnnotations() {
        return new CloneIterator(this.supportingAnnotations);
    }

    private Iterable<Annotation> getSupportingAnnotations() {
        return new CloneIterable(this.supportingAnnotations);
    }

    @Override
    public int supportingAnnotationsSize() {
        return this.supportingAnnotations.size();
    }

    @Override
    public Annotation getSupportingAnnotation(String annotationName) {
        return this.selectAnnotationNamed(this.getSupportingAnnotations(), annotationName);
    }

    @Override
    public Annotation getNonNullSupportingAnnotation(String annotationName) {
        Annotation annotation = this.getSupportingAnnotation(annotationName);
        return annotation != null ? annotation : this.buildNullSupportingAnnotation(annotationName);
    }

    abstract Annotation buildNullSupportingAnnotation(String var1);

    @Override
    public Annotation addSupportingAnnotation(String annotationName) {
        Annotation annotation = this.buildSupportingAnnotation(annotationName);
        this.supportingAnnotations.add(annotation);
        annotation.newAnnotation();
        this.fireItemAdded("supportingAnnotations", annotation);
        return annotation;
    }

    abstract Annotation buildSupportingAnnotation(String var1);

    @Override
    public void removeSupportingAnnotation(String annotationName) {
        Annotation annotation = this.getSupportingAnnotation(annotationName);
        if (annotation != null) {
            this.removeSupportingAnnotation(annotation);
        }
    }

    private void removeSupportingAnnotation(Annotation annotation) {
        this.supportingAnnotations.remove(annotation);
        annotation.removeAnnotation();
        this.fireItemRemoved("supportingAnnotations", annotation);
    }

    private boolean annotationIsValidSupportingAnnotation(String annotationName) {
        return CollectionTools.contains(this.validSupportingAnnotationNames(), (Object)annotationName);
    }

    abstract ListIterator<String> validSupportingAnnotationNames();

    @Override
    public ListIterator<NestableAnnotation> supportingAnnotations(String nestableAnnotationName, String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getSupportingContainerAnnotation(containerAnnotationName);
        if (containerAnnotation != null) {
            return containerAnnotation.nestedAnnotations();
        }
        NestableAnnotation nestableAnnotation = this.getSupportingNestableAnnotation(nestableAnnotationName);
        if (nestableAnnotation != null) {
            return new SingleElementListIterator((Object)nestableAnnotation);
        }
        return EmptyListIterator.instance();
    }

    private ContainerAnnotation<NestableAnnotation> getSupportingContainerAnnotation(String annotationName) {
        return (ContainerAnnotation)this.getSupportingAnnotation(annotationName);
    }

    private NestableAnnotation getSupportingNestableAnnotation(String annotationName) {
        return (NestableAnnotation)this.getSupportingAnnotation(annotationName);
    }

    @Override
    public NestableAnnotation addSupportingAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getSupportingContainerAnnotation(containerAnnotationName);
        if (containerAnnotation != null) {
            return AnnotationContainerTools.addNestedAnnotation(index, containerAnnotation);
        }
        NestableAnnotation standAloneAnnotation = this.getSupportingNestableAnnotation(nestableAnnotationName);
        if (standAloneAnnotation == null) {
            return (NestableAnnotation)this.addSupportingAnnotation(nestableAnnotationName);
        }
        return this.addSecondNestedAnnotation(index, containerAnnotationName, standAloneAnnotation);
    }

    private NestableAnnotation addSecondNestedAnnotation(int index, String containerAnnotationName, NestableAnnotation standAloneAnnotation) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.buildSupportingContainerAnnotation(containerAnnotationName);
        this.supportingAnnotations.add(containerAnnotation);
        containerAnnotation.newAnnotation();
        NestableAnnotation nestedAnnotation0 = containerAnnotation.addNestedAnnotationInternal();
        nestedAnnotation0.newAnnotation();
        NestableAnnotation nestedAnnotation1 = containerAnnotation.addNestedAnnotationInternal();
        nestedAnnotation1.newAnnotation();
        this.removeSupportingAnnotation(standAloneAnnotation);
        this.fireItemAdded("supportingAnnotations", containerAnnotation);
        if (index == 0) {
            nestedAnnotation1.initializeFrom(standAloneAnnotation);
        } else {
            nestedAnnotation0.initializeFrom(standAloneAnnotation);
        }
        return index == 0 ? nestedAnnotation0 : nestedAnnotation1;
    }

    private ContainerAnnotation<NestableAnnotation> buildSupportingContainerAnnotation(String annotationName) {
        return (ContainerAnnotation)this.buildSupportingAnnotation(annotationName);
    }

    @Override
    public void moveSupportingAnnotation(int targetIndex, int sourceIndex, String containerAnnotationName) {
        this.moveAnnotation(targetIndex, sourceIndex, this.getSupportingContainerAnnotation(containerAnnotationName));
    }

    private void moveAnnotation(int targetIndex, int sourceIndex, ContainerAnnotation<NestableAnnotation> containerAnnotation) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, containerAnnotation);
    }

    @Override
    public void removeSupportingAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getSupportingContainerAnnotation(containerAnnotationName);
        if (containerAnnotation == null) {
            this.removeSupportingAnnotation(this.getSupportingAnnotation(nestableAnnotationName));
        } else {
            this.removeSupportingAnnotation(index, containerAnnotation);
        }
    }

    private void removeSupportingAnnotation(int index, ContainerAnnotation<NestableAnnotation> containerAnnotation) {
        AnnotationContainerTools.removeNestedAnnotation(index, containerAnnotation);
        switch (containerAnnotation.nestedAnnotationsSize()) {
            case 0: {
                this.removeSupportingAnnotation(containerAnnotation);
                break;
            }
            case 1: {
                this.convertLastNestedAnnotation(containerAnnotation);
                break;
            }
        }
    }

    private void convertLastNestedAnnotation(ContainerAnnotation<NestableAnnotation> containerAnnotation) {
        NestableAnnotation lastNestedAnnotation = (NestableAnnotation)containerAnnotation.nestedAnnotations().next();
        this.supportingAnnotations.remove(containerAnnotation);
        containerAnnotation.removeAnnotation();
        NestableAnnotation standAloneAnnotation = (NestableAnnotation)this.buildSupportingAnnotation(lastNestedAnnotation.getAnnotationName());
        this.supportingAnnotations.add(standAloneAnnotation);
        standAloneAnnotation.newAnnotation();
        this.fireItemRemoved("supportingAnnotations", containerAnnotation);
        this.fireItemAdded("supportingAnnotations", standAloneAnnotation);
        standAloneAnnotation.initializeFrom(lastNestedAnnotation);
    }

    @Override
    public boolean isPersistable() {
        return this.persistable;
    }

    private void setPersistable(boolean persistable) {
        boolean old = this.persistable;
        this.persistable = persistable;
        this.firePropertyChanged("persistable", old, persistable);
    }

    private boolean buildPersistable(CompilationUnit astRoot) {
        return this.member.isPersistable(astRoot);
    }

    @Override
    public boolean isPersisted() {
        return this.getMappingAnnotation() != null;
    }

    @Override
    public boolean isFor(String memberName, int occurrence) {
        return this.member.matches(memberName, occurrence);
    }

    @Override
    public TextRange getTextRange(CompilationUnit astRoot) {
        return this.fullTextRange(astRoot);
    }

    private TextRange fullTextRange(CompilationUnit astRoot) {
        return this.buildTextRange((ASTNode)this.member.getBodyDeclaration(astRoot));
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.member.getNameTextRange(astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        this.updateAnnotations(astRoot);
        this.setPersistable(this.buildPersistable(astRoot));
    }

    private void updateAnnotations(CompilationUnit astRoot) {
        HashSet<Annotation> mappingAnnotationsToRemove = new HashSet<Annotation>(this.mappingAnnotations);
        HashSet<Annotation> supportingAnnotationsToRemove = new HashSet<Annotation>(this.supportingAnnotations);
        this.member.getBodyDeclaration(astRoot).accept(this.buildUpdateAnnotationVisitor(astRoot, mappingAnnotationsToRemove, supportingAnnotationsToRemove));
        for (Annotation annotation : mappingAnnotationsToRemove) {
            this.removeItemFromCollection(annotation, this.mappingAnnotations, "mappingAnnotations");
        }
        for (Annotation annotation : supportingAnnotationsToRemove) {
            this.removeItemFromCollection(annotation, this.supportingAnnotations, "supportingAnnotations");
        }
    }

    private ASTVisitor buildUpdateAnnotationVisitor(CompilationUnit astRoot, Set<Annotation> mappingAnnotationsToRemove, Set<Annotation> supportingAnnotationsToRemove) {
        return new UpdateAnnotationVisitor(astRoot, this.member.getBodyDeclaration(astRoot), mappingAnnotationsToRemove, supportingAnnotationsToRemove);
    }

    void addOrUpdateAnnotation(org.eclipse.jdt.core.dom.Annotation node, CompilationUnit astRoot, Set<Annotation> mappingAnnotationsToRemove, Set<Annotation> supportingAnnotationsToRemove) {
        String jdtAnnotationName = JDTTools.resolveAnnotation(node);
        if (jdtAnnotationName == null) {
            return;
        }
        if (this.annotationIsValidSupportingAnnotation(jdtAnnotationName)) {
            this.addOrUpdateSupportingAnnotation(jdtAnnotationName, astRoot, supportingAnnotationsToRemove);
            return;
        }
        if (this.annotationIsValidMappingAnnotation(jdtAnnotationName)) {
            this.addOrUpdateMappingAnnotation(jdtAnnotationName, astRoot, mappingAnnotationsToRemove);
            return;
        }
    }

    private void addOrUpdateSupportingAnnotation(String jdtAnnotationName, CompilationUnit astRoot, Set<Annotation> supportingAnnotationsToRemove) {
        Annotation annotation = this.selectAnnotationNamed(supportingAnnotationsToRemove, jdtAnnotationName);
        if (annotation != null) {
            annotation.update(astRoot);
            supportingAnnotationsToRemove.remove(annotation);
        } else {
            annotation = this.buildSupportingAnnotation(jdtAnnotationName);
            annotation.initialize(astRoot);
            this.addItemToCollection(annotation, this.supportingAnnotations, "supportingAnnotations");
        }
    }

    private void addOrUpdateMappingAnnotation(String jdtAnnotationName, CompilationUnit astRoot, Set<Annotation> mappingAnnotationsToRemove) {
        Annotation annotation = this.selectAnnotationNamed(mappingAnnotationsToRemove, jdtAnnotationName);
        if (annotation != null) {
            annotation.update(astRoot);
            mappingAnnotationsToRemove.remove(annotation);
        } else {
            annotation = this.buildMappingAnnotation(jdtAnnotationName);
            annotation.initialize(astRoot);
            this.addItemToCollection(annotation, this.mappingAnnotations, "mappingAnnotations");
        }
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        this.setPersistable(this.buildPersistable(astRoot));
    }

    private Annotation selectAnnotationNamed(Iterable<Annotation> annotations, String annotationName) {
        for (Annotation annotation : annotations) {
            if (!annotation.getAnnotationName().equals(annotationName)) continue;
            return annotation;
        }
        return null;
    }

    private TextRange buildTextRange(ASTNode astNode) {
        return astNode == null ? null : new ASTNodeTextRange(astNode);
    }

    <T extends JavaResourcePersistentMember> Iterator<T> persistableMembers(Iterator<T> members) {
        return new FilteringIterator<T, T>(members){

            protected boolean accept(T m) {
                return m.isPersistable();
            }
        };
    }

    protected static abstract class AnnotationVisitor
    extends ASTVisitor {
        protected final CompilationUnit astRoot;
        protected final BodyDeclaration bodyDeclaration;

        protected AnnotationVisitor(CompilationUnit astRoot, BodyDeclaration bodyDeclaration) {
            this.astRoot = astRoot;
            this.bodyDeclaration = bodyDeclaration;
        }

        public boolean visit(SingleMemberAnnotation node) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)node);
        }

        public boolean visit(NormalAnnotation node) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)node);
        }

        public boolean visit(MarkerAnnotation node) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)node);
        }

        protected boolean visit_(org.eclipse.jdt.core.dom.Annotation node) {
            if (node.getParent() == this.bodyDeclaration) {
                this.visitChildAnnotation(node);
            }
            return false;
        }

        protected abstract void visitChildAnnotation(org.eclipse.jdt.core.dom.Annotation var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InitialAnnotationVisitor
    extends AnnotationVisitor {
        protected InitialAnnotationVisitor(CompilationUnit astRoot, BodyDeclaration bodyDeclaration) {
            super(astRoot, bodyDeclaration);
        }

        @Override
        protected void visitChildAnnotation(org.eclipse.jdt.core.dom.Annotation node) {
            SourcePersistentMember.this.addInitialAnnotation(node, this.astRoot);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UpdateAnnotationVisitor
    extends AnnotationVisitor {
        protected final Set<Annotation> mappingAnnotationsToRemove;
        protected final Set<Annotation> supportingAnnotationsToRemove;

        protected UpdateAnnotationVisitor(CompilationUnit astRoot, BodyDeclaration bodyDeclaration, Set<Annotation> mappingAnnotationsToRemove, Set<Annotation> supportingAnnotationsToRemove) {
            super(astRoot, bodyDeclaration);
            this.mappingAnnotationsToRemove = mappingAnnotationsToRemove;
            this.supportingAnnotationsToRemove = supportingAnnotationsToRemove;
        }

        @Override
        protected void visitChildAnnotation(org.eclipse.jdt.core.dom.Annotation node) {
            SourcePersistentMember.this.addOrUpdateAnnotation(node, this.astRoot, this.mappingAnnotationsToRemove, this.supportingAnnotationsToRemove);
        }
    }
}

