/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.core.internal.resource.java.source.SourceBaseTableAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourceJoinColumnAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourceUniqueConstraintAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableJoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.NestableUniqueConstraintAnnotation;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceJoinTableAnnotation
extends SourceBaseTableAnnotation
implements JoinTableAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.JoinTable");
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "name");
    private static final DeclarationAnnotationElementAdapter<String> SCHEMA_ADAPTER = ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "schema");
    private static final DeclarationAnnotationElementAdapter<String> CATALOG_ADAPTER = ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "catalog");
    private final Vector<NestableJoinColumnAnnotation> joinColumns = new Vector();
    private final JoinColumnsAnnotationContainer joinColumnsContainer = new JoinColumnsAnnotationContainer();
    private final Vector<NestableJoinColumnAnnotation> inverseJoinColumns = new Vector();
    private final InverseJoinColumnsContainerAnnotation inverseJoinColumnsContainer = new InverseJoinColumnsContainerAnnotation();

    public SourceJoinTableAnnotation(JavaResourceNode parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.JoinTable";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        AnnotationContainerTools.initialize(this.joinColumnsContainer, astRoot);
        AnnotationContainerTools.initialize(this.inverseJoinColumnsContainer, astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        AnnotationContainerTools.update(this.joinColumnsContainer, astRoot);
        AnnotationContainerTools.update(this.inverseJoinColumnsContainer, astRoot);
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getNameAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return NAME_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getSchemaAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return SCHEMA_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getCatalogAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return CATALOG_ADAPTER;
    }

    @Override
    String getUniqueConstraintsElementName() {
        return "uniqueConstraints";
    }

    @Override
    NestableUniqueConstraintAnnotation buildUniqueConstraint(int index) {
        return SourceUniqueConstraintAnnotation.createJoinTableUniqueConstraint(this, this.member, index);
    }

    @Override
    public ListIterator<JoinColumnAnnotation> joinColumns() {
        return new CloneListIterator(this.joinColumns);
    }

    ListIterator<NestableJoinColumnAnnotation> nestableJoinColumns() {
        return new CloneListIterator(this.joinColumns);
    }

    @Override
    public int joinColumnsSize() {
        return this.joinColumns.size();
    }

    @Override
    public NestableJoinColumnAnnotation joinColumnAt(int index) {
        return this.joinColumns.get(index);
    }

    @Override
    public int indexOfJoinColumn(JoinColumnAnnotation joinColumn) {
        return this.joinColumns.indexOf(joinColumn);
    }

    @Override
    public NestableJoinColumnAnnotation addJoinColumn(int index) {
        return (NestableJoinColumnAnnotation)AnnotationContainerTools.addNestedAnnotation(index, this.joinColumnsContainer);
    }

    NestableJoinColumnAnnotation addJoinColumnInternal() {
        NestableJoinColumnAnnotation joinColumn = this.buildJoinColumn(this.joinColumns.size());
        this.joinColumns.add(joinColumn);
        return joinColumn;
    }

    private NestableJoinColumnAnnotation buildJoinColumn(int index) {
        return SourceJoinColumnAnnotation.createJoinTableJoinColumn(this, this.member, index);
    }

    void joinColumnAdded(int index, NestableJoinColumnAnnotation joinColumn) {
        this.fireItemAdded("joinColumns", index, joinColumn);
    }

    @Override
    public void moveJoinColumn(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, this.joinColumnsContainer);
    }

    NestableJoinColumnAnnotation moveJoinColumnInternal(int targetIndex, int sourceIndex) {
        return (NestableJoinColumnAnnotation)CollectionTools.move(this.joinColumns, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    void joinColumnMoved(int targetIndex, int sourceIndex) {
        this.fireItemMoved("joinColumns", targetIndex, sourceIndex);
    }

    @Override
    public void removeJoinColumn(int index) {
        AnnotationContainerTools.removeNestedAnnotation(index, this.joinColumnsContainer);
    }

    NestableJoinColumnAnnotation removeJoinColumnInternal(int index) {
        return this.joinColumns.remove(index);
    }

    void joinColumnRemoved(int index, NestableJoinColumnAnnotation joinColumn) {
        this.fireItemRemoved("joinColumns", index, joinColumn);
    }

    @Override
    public ListIterator<JoinColumnAnnotation> inverseJoinColumns() {
        return new CloneListIterator(this.inverseJoinColumns);
    }

    ListIterator<NestableJoinColumnAnnotation> nestableInverseJoinColumns() {
        return new CloneListIterator(this.inverseJoinColumns);
    }

    @Override
    public int inverseJoinColumnsSize() {
        return this.inverseJoinColumns.size();
    }

    @Override
    public NestableJoinColumnAnnotation inverseJoinColumnAt(int index) {
        return this.inverseJoinColumns.get(index);
    }

    @Override
    public int indexOfInverseJoinColumn(JoinColumnAnnotation joinColumn) {
        return this.inverseJoinColumns.indexOf(joinColumn);
    }

    @Override
    public NestableJoinColumnAnnotation addInverseJoinColumn(int index) {
        return (NestableJoinColumnAnnotation)AnnotationContainerTools.addNestedAnnotation(index, this.inverseJoinColumnsContainer);
    }

    NestableJoinColumnAnnotation addInverseJoinColumnInternal() {
        NestableJoinColumnAnnotation joinColumn = this.buildInverseJoinColumn(this.inverseJoinColumns.size());
        this.inverseJoinColumns.add(joinColumn);
        return joinColumn;
    }

    private NestableJoinColumnAnnotation buildInverseJoinColumn(int index) {
        return SourceJoinColumnAnnotation.createJoinTableInverseJoinColumn(this, this.member, index);
    }

    void inverseJoinColumnAdded(int index, NestableJoinColumnAnnotation joinColumn) {
        this.fireItemAdded("inverseJoinColumns", index, joinColumn);
    }

    @Override
    public void moveInverseJoinColumn(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, this.inverseJoinColumnsContainer);
    }

    NestableJoinColumnAnnotation moveInverseJoinColumnInternal(int targetIndex, int sourceIndex) {
        return (NestableJoinColumnAnnotation)CollectionTools.move(this.inverseJoinColumns, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    void inverseJoinColumnMoved(int targetIndex, int sourceIndex) {
        this.fireItemMoved("inverseJoinColumns", targetIndex, sourceIndex);
    }

    @Override
    public void removeInverseJoinColumn(int index) {
        AnnotationContainerTools.removeNestedAnnotation(index, this.inverseJoinColumnsContainer);
    }

    NestableJoinColumnAnnotation removeInverseJoinColumnInternal(int index) {
        return this.inverseJoinColumns.remove(index);
    }

    void inverseJoinColumnRemoved(int index, NestableJoinColumnAnnotation joinColumn) {
        this.fireItemRemoved("inverseJoinColumns", index, joinColumn);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractJoinColumnAnnotationContainer
    implements AnnotationContainer<NestableJoinColumnAnnotation> {
        AbstractJoinColumnAnnotationContainer() {
        }

        @Override
        public String getContainerAnnotationName() {
            return SourceJoinTableAnnotation.this.getAnnotationName();
        }

        @Override
        public Annotation getContainerJdtAnnotation(CompilationUnit astRoot) {
            return SourceJoinTableAnnotation.this.getJdtAnnotation(astRoot);
        }

        @Override
        public String getNestableAnnotationName() {
            return "javax.persistence.JoinColumn";
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InverseJoinColumnsContainerAnnotation
    extends AbstractJoinColumnAnnotationContainer {
        InverseJoinColumnsContainerAnnotation() {
        }

        @Override
        public String getElementName() {
            return "inverseJoinColumns";
        }

        @Override
        public ListIterator<NestableJoinColumnAnnotation> nestedAnnotations() {
            return SourceJoinTableAnnotation.this.nestableInverseJoinColumns();
        }

        @Override
        public int nestedAnnotationsSize() {
            return SourceJoinTableAnnotation.this.inverseJoinColumnsSize();
        }

        @Override
        public NestableJoinColumnAnnotation addNestedAnnotationInternal() {
            return SourceJoinTableAnnotation.this.addInverseJoinColumnInternal();
        }

        @Override
        public void nestedAnnotationAdded(int index, NestableJoinColumnAnnotation nestedAnnotation) {
            SourceJoinTableAnnotation.this.inverseJoinColumnAdded(index, nestedAnnotation);
        }

        @Override
        public NestableJoinColumnAnnotation moveNestedAnnotationInternal(int targetIndex, int sourceIndex) {
            return SourceJoinTableAnnotation.this.moveInverseJoinColumnInternal(targetIndex, sourceIndex);
        }

        @Override
        public void nestedAnnotationMoved(int targetIndex, int sourceIndex) {
            SourceJoinTableAnnotation.this.inverseJoinColumnMoved(targetIndex, sourceIndex);
        }

        @Override
        public NestableJoinColumnAnnotation removeNestedAnnotationInternal(int index) {
            return SourceJoinTableAnnotation.this.removeInverseJoinColumnInternal(index);
        }

        @Override
        public void nestedAnnotationRemoved(int index, NestableJoinColumnAnnotation nestedAnnotation) {
            SourceJoinTableAnnotation.this.inverseJoinColumnRemoved(index, nestedAnnotation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JoinColumnsAnnotationContainer
    extends AbstractJoinColumnAnnotationContainer {
        JoinColumnsAnnotationContainer() {
        }

        @Override
        public String getElementName() {
            return "joinColumns";
        }

        @Override
        public ListIterator<NestableJoinColumnAnnotation> nestedAnnotations() {
            return SourceJoinTableAnnotation.this.nestableJoinColumns();
        }

        @Override
        public int nestedAnnotationsSize() {
            return SourceJoinTableAnnotation.this.joinColumnsSize();
        }

        @Override
        public NestableJoinColumnAnnotation addNestedAnnotationInternal() {
            return SourceJoinTableAnnotation.this.addJoinColumnInternal();
        }

        @Override
        public void nestedAnnotationAdded(int index, NestableJoinColumnAnnotation nestedAnnotation) {
            SourceJoinTableAnnotation.this.joinColumnAdded(index, nestedAnnotation);
        }

        @Override
        public NestableJoinColumnAnnotation moveNestedAnnotationInternal(int targetIndex, int sourceIndex) {
            return SourceJoinTableAnnotation.this.moveJoinColumnInternal(targetIndex, sourceIndex);
        }

        @Override
        public void nestedAnnotationMoved(int targetIndex, int sourceIndex) {
            SourceJoinTableAnnotation.this.joinColumnMoved(targetIndex, sourceIndex);
        }

        @Override
        public NestableJoinColumnAnnotation removeNestedAnnotationInternal(int index) {
            return SourceJoinTableAnnotation.this.removeJoinColumnInternal(index);
        }

        @Override
        public void nestedAnnotationRemoved(int index, NestableJoinColumnAnnotation nestedAnnotation) {
            SourceJoinTableAnnotation.this.joinColumnRemoved(index, nestedAnnotation);
        }
    }
}

