/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.EnumType;
import org.eclipse.jpt.core.resource.java.EnumeratedAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceEnumeratedAnnotation
extends SourceAnnotation<Attribute>
implements EnumeratedAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Enumerated");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = SourceEnumeratedAnnotation.buildValueAdapter();
    private final AnnotationElementAdapter<String> valueAdapter;
    private EnumType value;

    public SourceEnumeratedAnnotation(JavaResourceNode parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new ShortCircuitAnnotationElementAdapter<String>(attribute, VALUE_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Enumerated";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.value = this.buildValue(astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        this.setValue(this.buildValue(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append((Object)this.value);
    }

    @Override
    public EnumType getValue() {
        return this.value;
    }

    @Override
    public void setValue(EnumType value) {
        if (this.attributeValueHasNotChanged((Object)this.value, (Object)value)) {
            return;
        }
        EnumType old = this.value;
        this.value = value;
        this.valueAdapter.setValue(EnumType.toJavaAnnotationValue(value));
        this.firePropertyChanged("value", (Object)old, (Object)value);
    }

    private EnumType buildValue(CompilationUnit astRoot) {
        return EnumType.fromJavaAnnotationValue(this.valueAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value", false);
    }
}

