/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceBaseColumnAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.NestedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableColumnAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

public final class SourceColumnAnnotation
extends SourceBaseColumnAnnotation
implements NestableColumnAnnotation {
    public static final DeclarationAnnotationAdapter MAPPING_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Column");
    private final DeclarationAnnotationElementAdapter<Integer> lengthDeclarationAdapter = this.buildIntegerElementAdapter("length");
    private final AnnotationElementAdapter<Integer> lengthAdapter = this.buildShortCircuitIntegerElementAdapter(this.lengthDeclarationAdapter);
    private Integer length;
    private final DeclarationAnnotationElementAdapter<Integer> precisionDeclarationAdapter = this.buildIntegerElementAdapter("precision");
    private final AnnotationElementAdapter<Integer> precisionAdapter = this.buildShortCircuitIntegerElementAdapter(this.precisionDeclarationAdapter);
    private Integer precision;
    private final DeclarationAnnotationElementAdapter<Integer> scaleDeclarationAdapter = this.buildIntegerElementAdapter("scale");
    private final AnnotationElementAdapter<Integer> scaleAdapter = this.buildShortCircuitIntegerElementAdapter(this.scaleDeclarationAdapter);
    private Integer scale;

    public SourceColumnAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa) {
        super(parent, member, daa);
    }

    public String getAnnotationName() {
        return "javax.persistence.Column";
    }

    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.length = this.buildLength(astRoot);
        this.precision = this.buildPrecision(astRoot);
        this.scale = this.buildScale(astRoot);
    }

    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setLength(this.buildLength(astRoot));
        this.setPrecision(this.buildPrecision(astRoot));
        this.setScale(this.buildScale(astRoot));
    }

    String getNameElementName() {
        return "name";
    }

    String getColumnDefinitionElementName() {
        return "columnDefinition";
    }

    String getTableElementName() {
        return "table";
    }

    String getUniqueElementName() {
        return "unique";
    }

    String getNullableElementName() {
        return "nullable";
    }

    String getInsertableElementName() {
        return "insertable";
    }

    String getUpdatableElementName() {
        return "updatable";
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        if (this.attributeValueHasNotChanged(this.length, length)) {
            return;
        }
        Integer old = this.length;
        this.length = length;
        this.lengthAdapter.setValue(length);
        this.firePropertyChanged("length", old, length);
    }

    private Integer buildLength(CompilationUnit astRoot) {
        return this.lengthAdapter.getValue(astRoot);
    }

    public TextRange getLengthTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.lengthDeclarationAdapter, astRoot);
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        if (this.attributeValueHasNotChanged(this.precision, precision)) {
            return;
        }
        Integer old = this.precision;
        this.precision = precision;
        this.precisionAdapter.setValue(precision);
        this.firePropertyChanged("precision", old, precision);
    }

    private Integer buildPrecision(CompilationUnit astRoot) {
        return this.precisionAdapter.getValue(astRoot);
    }

    public TextRange getPrecisionTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.precisionDeclarationAdapter, astRoot);
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        if (this.attributeValueHasNotChanged(this.scale, scale)) {
            return;
        }
        Integer old = this.scale;
        this.scale = scale;
        this.scaleAdapter.setValue(scale);
        this.firePropertyChanged("scale", old, scale);
    }

    private Integer buildScale(CompilationUnit astRoot) {
        return this.scaleAdapter.getValue(astRoot);
    }

    public TextRange getScaleTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.scaleDeclarationAdapter, astRoot);
    }

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        super.initializeFrom(oldAnnotation);
        ColumnAnnotation oldColumn = (ColumnAnnotation)((Object)oldAnnotation);
        this.setLength(oldColumn.getLength());
        this.setPrecision(oldColumn.getPrecision());
        this.setScale(oldColumn.getScale());
    }

    public void moveAnnotation(int newIndex) {
        throw new UnsupportedOperationException();
    }

    static NestableColumnAnnotation createAttributeOverrideColumn(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter attributeOverrideAnnotationAdapter) {
        return new SourceColumnAnnotation(parent, member, SourceColumnAnnotation.buildAttributeOverrideAnnotationAdapter(attributeOverrideAnnotationAdapter));
    }

    static DeclarationAnnotationAdapter buildAttributeOverrideAnnotationAdapter(DeclarationAnnotationAdapter attributeOverrideAnnotationAdapter) {
        return new NestedDeclarationAnnotationAdapter(attributeOverrideAnnotationAdapter, "column", "javax.persistence.Column");
    }
}

