/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.ViewerDescriptor;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

public class CompareContentViewerSwitchingPane
extends CompareViewerSwitchingPane {
    private CompareEditorInput fCompareEditorInput;
    private ViewerDescriptor fSelectedViewerDescriptor;
    private ToolBar toolBar;

    public CompareContentViewerSwitchingPane(Splitter parent, int style, CompareEditorInput cei) {
        super((Composite)parent, style);
        this.fCompareEditorInput = cei;
    }

    private CompareConfiguration getCompareConfiguration() {
        return this.fCompareEditorInput.getCompareConfiguration();
    }

    protected Viewer getViewer(Viewer oldViewer, Object input) {
        if (this.fSelectedViewerDescriptor != null) {
            List<ViewerDescriptor> list;
            ViewerDescriptor[] array = CompareUIPlugin.getDefault().findContentViewerDescriptor(oldViewer, input, this.getCompareConfiguration());
            List<ViewerDescriptor> list2 = list = array != null ? Arrays.asList(array) : Collections.EMPTY_LIST;
            if (list.contains(this.fSelectedViewerDescriptor)) {
                this.fCompareEditorInput.setContentViewerDescriptor(this.fSelectedViewerDescriptor);
                Viewer viewer = this.fCompareEditorInput.findContentViewer(oldViewer, (ICompareInput)input, (Composite)this);
                return viewer;
            }
            this.fSelectedViewerDescriptor = null;
        }
        if (input instanceof ICompareInput) {
            this.fCompareEditorInput.setContentViewerDescriptor(null);
            Viewer viewer = this.fCompareEditorInput.findContentViewer(oldViewer, (ICompareInput)input, (Composite)this);
            this.fCompareEditorInput.setContentViewerDescriptor(this.fSelectedViewerDescriptor);
            return viewer;
        }
        return null;
    }

    protected Control createTopLeft(Composite p) {
        Composite composite = new Composite(p, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return super.computeSize(wHint, Math.max(24, hHint), changed);
            }
        };
        RowLayout layout = new RowLayout();
        layout.marginTop = 0;
        composite.setLayout((Layout)layout);
        CLabel cl = new CLabel(composite, 0);
        cl.setText(null);
        this.toolBar = new ToolBar(composite, 0x800000);
        this.toolBar.setVisible(false);
        ToolItem toolItem = new ToolItem(this.toolBar, 8, 0);
        toolItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_VIEW_MENU"));
        toolItem.setToolTipText(CompareMessages.CompareContentViewerSwitchingPane_switchButtonTooltip);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareContentViewerSwitchingPane.this.showMenu();
            }
        });
        this.toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CompareContentViewerSwitchingPane.this.showMenu();
            }
        });
        return composite;
    }

    protected boolean inputChanged(Object input) {
        return this.getInput() != input || this.fCompareEditorInput.getContentViewerDescriptor() != this.fSelectedViewerDescriptor;
    }

    public void setInput(Object input) {
        super.setInput(input);
        ViewerDescriptor[] vd = CompareUIPlugin.getDefault().findContentViewerDescriptor(this.getViewer(), this.getInput(), this.getCompareConfiguration());
        this.toolBar.setVisible(vd != null && vd.length > 1);
    }

    private void showMenu() {
        ViewerDescriptor[] vd = CompareUIPlugin.getDefault().findContentViewerDescriptor(this.getViewer(), this.getInput(), this.getCompareConfiguration());
        final Menu menu = new Menu((Decorations)this.getShell(), 8);
        String label = CompareMessages.CompareContentViewerSwitchingPane_defaultViewer;
        MenuItem defaultItem = new MenuItem(menu, 16);
        defaultItem.setText(label);
        defaultItem.addSelectionListener(this.createSelectionListener(null));
        defaultItem.setSelection(this.fSelectedViewerDescriptor == null);
        new MenuItem(menu, 2);
        int i = 0;
        while (i < vd.length) {
            block4: {
                ViewerDescriptor vdi;
                block3: {
                    vdi = vd[i];
                    label = vdi.getLabel();
                    if (label != null && !label.equals("")) break block3;
                    String l = CompareUIPlugin.getDefault().findContentTypeNameOrType((ICompareInput)this.getInput(), vdi, this.getCompareConfiguration());
                    if (l == null) break block4;
                    label = NLS.bind((String)CompareMessages.CompareContentViewerSwitchingPane_discoveredLabel, (Object[])new Object[]{l});
                }
                MenuItem item = new MenuItem(menu, 16);
                item.setText(label);
                item.addSelectionListener(this.createSelectionListener(vdi));
                item.setSelection(vdi == this.fSelectedViewerDescriptor);
            }
            ++i;
        }
        Rectangle bounds = this.toolBar.getItem(0).getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.toolBar.toDisplay(topLeft);
        menu.setLocation(topLeft.x, topLeft.y);
        menu.setVisible(true);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                e.display.asyncExec(new Runnable(this, menu){
                    final /* synthetic */ 4 this$1;
                    private final /* synthetic */ Menu val$menu;
                    {
                        this.this$1 = var1_1;
                        this.val$menu = menu;
                    }

                    public void run() {
                        this.val$menu.dispose();
                    }
                });
            }
        });
    }

    private SelectionListener createSelectionListener(final ViewerDescriptor vd) {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem mi = (MenuItem)e.widget;
                if (mi.getSelection()) {
                    Viewer oldViewer = CompareContentViewerSwitchingPane.this.getViewer();
                    CompareContentViewerSwitchingPane.this.fSelectedViewerDescriptor = vd;
                    CompareContentViewerSwitchingPane.this.setInput(oldViewer.getInput());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    public void setText(String label) {
        Composite c = (Composite)this.getTopLeft();
        Control[] children = c.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof CLabel) {
                CLabel cl = (CLabel)children[i];
                if (cl != null && !cl.isDisposed()) {
                    cl.setText(label);
                    c.layout();
                }
                return;
            }
            ++i;
        }
    }

    public void setImage(Image image) {
        Composite c = (Composite)this.getTopLeft();
        Control[] children = c.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof CLabel) {
                CLabel cl = (CLabel)children[i];
                if (cl != null && !cl.isDisposed()) {
                    cl.setImage(image);
                }
                return;
            }
            ++i;
        }
    }

    public void addMouseListener(MouseListener listener) {
        Composite c = (Composite)this.getTopLeft();
        Control[] children = c.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof CLabel) {
                CLabel cl = (CLabel)children[i];
                cl.addMouseListener(listener);
            }
            ++i;
        }
    }
}

