/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.extensions.GuiExtensionManager;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.IPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.AttributeViewPage;
import org.eclipse.birt.report.designer.ui.views.attributes.CategoryPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.ColumnPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.DataPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.GridPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.LabelPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.ListPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.TabPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.TextPageGenerator;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DynamicFilterParameterHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TemplateReportItemHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;

public class AttributesBuilder {
    private IPageGenerator pageGenerator;
    private String selectedTabText;
    private String typeInfo = Messages.getString((String)"AttributesBuilder.Label.None");

    public IPageGenerator getPageGenerator(List selection) {
        if (this.pageGenerator != null && this.pageGenerator instanceof TabPageGenerator) {
            this.selectedTabText = ((TabPageGenerator)this.pageGenerator).getSelectedTabText();
        }
        Class pageGeneratorClass = TabPageGenerator.class;
        String oldTypeInfo = this.typeInfo;
        if (this.isSameType(selection)) {
            pageGeneratorClass = this.getGeneratorClass(selection.get(0));
            Object element = null;
            element = selection.get(0);
            Object adapter = ElementAdapterManager.getAdapter(element, IPageGenerator.class);
            if (adapter instanceof IPageGenerator) {
                if (element instanceof ExtendedItemHandle) {
                    this.typeInfo = Messages.getFormattedString((String)"AttributesBuilder.Label.Generic", (Object[])new String[]{GuiExtensionManager.getExtensionDisplayName(selection.get(0))});
                }
                IPageGenerator ng = (IPageGenerator)adapter;
                boolean change = false;
                if (this.pageGenerator == null || ng != null && this.pageGenerator.getClass() != ng.getClass()) {
                    change = true;
                } else if (this.pageGenerator != null) {
                    Object input = this.pageGenerator.getInput();
                    if (input != null) {
                        input = DEUtil.getInputFirstElement((Object)input);
                    }
                    if (input == null) {
                        change = true;
                    } else if (element instanceof ExtendedItemHandle && input instanceof ExtendedItemHandle) {
                        if (!((ExtendedItemHandle)element).getExtensionName().equals(((ExtendedItemHandle)input).getExtensionName())) {
                            change = true;
                        }
                    } else if (element.getClass() != input.getClass()) {
                        change = true;
                    }
                }
                if (change) {
                    if (this.pageGenerator != null && this.pageGenerator.getControl() != null && !this.pageGenerator.getControl().isDisposed()) {
                        this.pageGenerator.getControl().dispose();
                    }
                    this.pageGenerator = ng;
                    if (this.pageGenerator instanceof TabPageGenerator) {
                        ((TabPageGenerator)this.pageGenerator).setSelectedTabText(this.selectedTabText);
                    }
                }
                return this.pageGenerator;
            }
        }
        try {
            if (this.pageGenerator != null && this.pageGenerator.getClass() == pageGeneratorClass) {
                if (this.pageGenerator instanceof CategoryPageGenerator) {
                    if (this.typeInfo.equals(oldTypeInfo)) {
                        return this.pageGenerator;
                    }
                } else {
                    return this.pageGenerator;
                }
            }
            if (this.pageGenerator != null && this.pageGenerator.getControl() != null && !this.pageGenerator.getControl().isDisposed()) {
                this.pageGenerator.getControl().dispose();
            }
            this.pageGenerator = (IPageGenerator)pageGeneratorClass.newInstance();
            if (this.pageGenerator instanceof TabPageGenerator) {
                ((TabPageGenerator)this.pageGenerator).setSelectedTabText(this.selectedTabText);
            }
        }
        catch (Exception e) {
            ExceptionUtil.handle((Throwable)e);
        }
        return this.pageGenerator;
    }

    private Class getGeneratorClass(Object obj) {
        Class<?> type = obj.getClass();
        if (type == TableHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Table");
            return ListPageGenerator.class;
        }
        if (type == ImageHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Picture");
            return TextPageGenerator.class;
        }
        if (type == TextItemHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Text");
            return TextPageGenerator.class;
        }
        if (type == TextDataHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.TextData");
            return TextPageGenerator.class;
        }
        if (type == ColumnHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Column");
            return ColumnPageGenerator.class;
        }
        if (type == RowHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Row");
            return ColumnPageGenerator.class;
        }
        if (type == GridHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Grid");
            return GridPageGenerator.class;
        }
        if (type == DataItemHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Data");
            return DataPageGenerator.class;
        }
        if (type == CellHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Cell");
            return ColumnPageGenerator.class;
        }
        if (type == ListHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.List");
            return ListPageGenerator.class;
        }
        if (type == TabularCubeHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Cube");
        } else if (type == DynamicFilterParameterHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.DynamicFilterParameter");
        } else {
            if (type == AttributeViewPage.ModelClassWrapper.class) {
                this.getGeneratorClass(((AttributeViewPage.ModelClassWrapper)obj).getElement());
                return AttributeViewPage.MessagePageGenerator.class;
            }
            if (type == LabelHandle.class) {
                this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Label");
                return LabelPageGenerator.class;
            }
            if (type == SimpleMasterPageHandle.class) {
                this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.MasterPage");
            } else if (DataSourceHandle.class.isAssignableFrom(type)) {
                this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.DataSourceHandle");
            } else if (DataSetHandle.class.isAssignableFrom(type)) {
                this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.DataSetHandle");
            } else if (type == ScalarParameterHandle.class) {
                this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.ScalarParameterHandle");
            } else if (type == TemplateReportItemHandle.class) {
                this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.TemplateReportItemHandle");
            } else if (type == ReportDesignHandle.class) {
                this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Report");
            } else if (type == LibraryHandle.class) {
                this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Library");
            } else if (type == AutoTextHandle.class) {
                this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.AutoText");
            } else if (type == ParameterGroupHandle.class) {
                this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.ParameterGroup");
            } else if (type == CascadingParameterGroupHandle.class) {
                this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.CascadingParameterGroup");
            } else if (obj instanceof ModuleHandle) {
                this.typeInfo = Messages.getFormattedString((String)"AttributesBuilder.Label.Generic", (Object[])new String[]{((DesignElementHandle)obj).getDefn().getDisplayName()});
            } else {
                this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.None");
                return TabPageGenerator.class;
            }
        }
        return CategoryPageGenerator.class;
    }

    public String getTypeInfo() {
        return this.typeInfo;
    }

    private boolean isSameType(List selection) {
        if (selection == null || selection.size() == 0) {
            return false;
        }
        if (selection.get(0) == null) {
            return false;
        }
        if (selection.get(0) instanceof ExtendedItemHandle) {
            String extName = ((ExtendedItemHandle)selection.get(0)).getExtensionName();
            int i = 1;
            while (i < selection.size()) {
                if (!(selection.get(i) instanceof ExtendedItemHandle)) {
                    return false;
                }
                String extName2 = ((ExtendedItemHandle)selection.get(i)).getExtensionName();
                if (!extName.equals(extName2)) {
                    return false;
                }
                ++i;
            }
        } else {
            Class<?> classObj = selection.get(0).getClass();
            int i = 1;
            while (i < selection.size()) {
                if (selection.get(i).getClass() != classObj) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

