/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.IColleague;
import org.eclipse.birt.report.designer.core.util.mediator.ReportMediator;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalActionFactory;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.IPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.AttributeView;
import org.eclipse.birt.report.designer.ui.views.attributes.AttributesBuilder;
import org.eclipse.birt.report.designer.ui.views.attributes.TabPageGenerator;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.Page;

public class AttributeViewPage
extends Page
implements INullSelectionListener,
IColleague,
IModelEventProcessor {
    protected List<String> PART_IDS = Arrays.asList("org.eclipse.birt.report.designer.ui.editors.ReportEditor", "org.eclipse.birt.report.designer.ui.editors.LibraryReportEditor", "org.eclipse.birt.report.designer.ui.editors.TemplateEditor", "org.eclipse.ui.views.ContentOutline");
    private ISelection selection;
    private AttributesBuilder builder;
    private RestoreLibraryPropertiesAction restoreLibraryPropertiesAction;
    private Composite container;
    List requesList = Collections.EMPTY_LIST;
    private IPageGenerator pageGenerator;

    public void resetLocalProperties(int ret) {
        try {
            DEUtil.getGroupElementHandle((List)this.getModelList((ISelection)new StructuredSelection(SessionHandleAdapter.getInstance().getMediator().getCurrentState().getSelectionObject()))).clearLocalProperties();
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }

    public void createControl(Composite parent) {
        this.addActions();
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.container.setLayout((Layout)layout);
        this.builder = new AttributesBuilder();
        IWorkbenchPage page = this.getSite().getPage();
        this.selection = page.getSelection();
        page.addSelectionListener((ISelectionListener)this);
        ReportMediator.addGlobalColleague((IColleague)this);
    }

    private void addActions() {
        if (this.restoreLibraryPropertiesAction == null) {
            this.restoreLibraryPropertiesAction = new RestoreLibraryPropertiesAction(this);
        }
        this.getSite().getActionBars().getToolBarManager().add((IAction)this.restoreLibraryPropertiesAction);
    }

    public void setFocus() {
        this.handleSelectionChanged(this.selection);
    }

    private void setPartName() {
        String typeInfo = this.builder.getTypeInfo();
        IViewPart view = UIUtil.getView((String)"org.eclipse.birt.report.designer.ui.attributes.AttributeView");
        if (view != null && typeInfo != null) {
            ((AttributeView)view).setPartName(typeInfo);
        }
    }

    private boolean hasLocalProperties(ISelection selection) {
        return this.hasLocalProperties(this.getModelList(selection));
    }

    private boolean hasLocalProperties(List modelList) {
        GroupElementHandle groupHandle = DEUtil.getGroupElementHandle((List)modelList);
        return groupHandle.hasLocalPropertiesForExtendedElements();
    }

    public void resetRestorePropertiesAction(List modelList) {
        this.restoreLibraryPropertiesAction.setEnabled(this.hasLocalProperties(modelList));
    }

    private List getModelList(ISelection selection) {
        List<Object> list = new ArrayList();
        if (selection == null) {
            return list;
        }
        if (!(selection instanceof StructuredSelection)) {
            return list;
        }
        StructuredSelection structured = (StructuredSelection)selection;
        if (structured.getFirstElement() instanceof ReportElementEditPart) {
            boolean bool = false;
            for (ReportElementEditPart object : structured) {
                if (object instanceof DummyEditpart) {
                    list.add(object.getModel());
                    bool = true;
                }
                if (bool) continue;
                list.add(object.getModel());
            }
        } else {
            list = structured.toList();
        }
        return list;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (SessionHandleAdapter.getInstance().getReportDesignHandle() != null && part != null && !ReportPlugin.getDefault().containIgnoreViewID(part.getSite().getId())) {
            this.handleSelectionChanged((ISelection)new StructuredSelection());
        }
    }

    public void dispose() {
        this.deRegisterEventManager();
        IWorkbenchPage page = this.getSite().getPage();
        page.removeSelectionListener((ISelectionListener)this);
        ReportMediator.removeGlobalColleague((IColleague)this);
        super.dispose();
    }

    private void handleGlobalAction() {
        int i = 0;
        while (i < GlobalActionFactory.GLOBAL_STACK_ACTIONS.length) {
            String id = GlobalActionFactory.GLOBAL_STACK_ACTIONS[i];
            this.getSite().getActionBars().setGlobalActionHandler(id, GlobalActionFactory.createStackAction((String)id, (CommandStack)SessionHandleAdapter.getInstance().getCommandStack()));
            ++i;
        }
        this.getSite().getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new SelectAllAction());
        this.getSite().getActionBars().updateActionBars();
    }

    public void performRequest(ReportRequest request) {
        if ("selection".equals(request.getType()) && !this.requesList.equals(request.getSelectionModelList())) {
            this.deRegisterEventManager();
            this.requesList = request.getSelectionModelList();
            this.handleSelectionChanged((ISelection)new StructuredSelection(this.requesList));
            this.registerEventManager();
        }
    }

    protected void deRegisterEventManager() {
        if (UIUtil.getModelEventManager() != null) {
            UIUtil.getModelEventManager().removeModelEventProcessor((IModelEventProcessor)this);
        }
    }

    protected void registerEventManager() {
        if (UIUtil.getModelEventManager() != null) {
            UIUtil.getModelEventManager().addModelEventProcessor((IModelEventProcessor)this);
        }
    }

    public void handleSelectionChanged(ISelection selection) {
        List modelList = this.getModelList(selection);
        if (modelList == null || modelList.size() == 0) {
            return;
        }
        this.pageGenerator = this.builder.getPageGenerator(modelList);
        if (this.container != null && !this.container.isDisposed()) {
            this.pageGenerator.createControl(this.container, (Object)modelList);
            this.pageGenerator.refresh();
        }
        if (SessionHandleAdapter.getInstance().getReportDesignHandle() != null) {
            this.restoreLibraryPropertiesAction.setEnabled(this.hasLocalProperties(selection));
            this.handleGlobalAction();
            this.setPartName();
        }
        this.selection = selection;
    }

    public Control getControl() {
        return this.container;
    }

    public void addElementEvent(DesignElementHandle focus, NotificationEvent ev) {
    }

    public void clear() {
    }

    public void postElementEvent() {
        this.restoreLibraryPropertiesAction.setEnabled(this.hasLocalProperties(this.selection));
        if (this.pageGenerator != null && this.pageGenerator.getControl() != null && !this.pageGenerator.getControl().isDisposed()) {
            this.pageGenerator.refresh();
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    static class MessageAttributePage
    extends Composite {
        private List model;

        public MessageAttributePage(Composite parent, int style, List input) {
            super(parent, style);
            this.model = input;
            this.buildUI();
        }

        private void buildUI() {
            FillLayout layout = new FillLayout();
            this.setLayout((Layout)layout);
            Label label = new Label((Composite)this, 16576);
            String extendsString = "";
            if (this.model.get(0) instanceof ModelClassWrapper) {
                extendsString = ((ModelClassWrapper)this.model.get(0)).getExtendsString();
            }
            label.setText(extendsString);
        }
    }

    static class MessagePageGenerator
    extends TabPageGenerator {
        MessagePageGenerator() {
        }

        public void createTabItems(List input) {
            super.createTabItems(input);
            Composite pane = new Composite((Composite)this.tabFolder, 0);
            pane.setLayout((Layout)new FillLayout());
            new MessageAttributePage(pane, 0, input);
            CTabItem tabItem = new CTabItem(this.tabFolder, 0);
            if (input.get(0) instanceof ModelClassWrapper) {
                tabItem.setText(((ModelClassWrapper)input.get(0)).getTypeMessage());
            }
            tabItem.setControl((Control)pane);
        }
    }

    static class ModelClassWrapper {
        private GroupElementHandle groupElementHandle;

        public ModelClassWrapper(List modelList) {
            this.groupElementHandle = DEUtil.getMultiSelectionHandle((List)modelList);
        }

        public String getTypeMessage() {
            if (this.groupElementHandle.getElements().get(0) instanceof DesignElementHandle) {
                return DEUtil.getDisplayLabel(this.groupElementHandle.getElements().get(0));
            }
            return "";
        }

        public String getExtendsString() {
            DesignElementHandle handle = (DesignElementHandle)this.groupElementHandle.getElements().get(0);
            String name = DEUtil.getDisplayLabel((Object)handle);
            String extendsFrom = handle.getExtends().getDisplayLabel();
            String libName = handle.getExtends().getRoot().getDisplayLabel();
            return Messages.getFormattedString((String)"AttributeView.view.message.Emptypage", (Object[])new Object[]{name, extendsFrom, libName, name});
        }

        public Object getElement() {
            if (this.groupElementHandle != null) {
                return this.groupElementHandle.getElements().get(0);
            }
            return new Object();
        }
    }

    public class RestoreLibraryPropertiesAction
    extends Action {
        AttributeViewPage view;

        RestoreLibraryPropertiesAction(AttributeViewPage view) {
            this.view = view;
            this.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"Enable Resotre Properties"));
            this.setEnabled(false);
            this.setToolTipText(Messages.getString((String)"AttributeView.toolbar.tooltip.RestoreLibraryPropertiesAction.RestoreMsg"));
        }

        public void run() {
            MessageDialog prefDialog;
            int ret;
            if (this.view != null && (ret = (prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"AttributeView.dialg.Message.Warning"), null, Messages.getString((String)"AttributeView.dialg.Message.PromptMsg"), 2, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.No")}, 0)).open()) != 2 && ret == 0) {
                AttributeViewPage.this.resetLocalProperties(ret);
                AttributeViewPage.this.pageGenerator = AttributeViewPage.this.builder.getPageGenerator(AttributeViewPage.this.getModelList(AttributeViewPage.this.selection));
                AttributeViewPage.this.pageGenerator.createControl(AttributeViewPage.this.container, (Object)AttributeViewPage.this.getModelList(AttributeViewPage.this.selection));
                this.setEnabled(false);
            }
        }
    }

    private static class SelectAllAction
    extends Action {
        protected static final Class[] NO_PARAMETERS = new Class[0];
        private static final String methodName = "selectAll";

        private SelectAllAction() {
            this.setId(ActionFactory.SELECT_ALL.getId());
        }

        public void runWithEvent(Event event) {
            try {
                this.execute();
            }
            catch (ExecutionException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        }

        public final Object execute() throws ExecutionException {
            block9: {
                Method methodToExecute = this.getMethodToExecute();
                if (methodToExecute != null) {
                    Control focusControl;
                    block8: {
                        focusControl = Display.getCurrent().getFocusControl();
                        if (!(focusControl instanceof Composite) || (((Composite)focusControl).getStyle() & 0x1000000) == 0) break block8;
                        return null;
                    }
                    try {
                        int numParams = methodToExecute.getParameterTypes().length;
                        if (numParams == 0) {
                            methodToExecute.invoke((Object)focusControl, null);
                            focusControl.notifyListeners(13, null);
                            break block9;
                        }
                        if (numParams == 1) {
                            Method textLimitAccessor = focusControl.getClass().getMethod("getTextLimit", NO_PARAMETERS);
                            Integer textLimit = (Integer)textLimitAccessor.invoke((Object)focusControl, null);
                            Object[] parameters = new Object[]{new Point(0, textLimit.intValue())};
                            methodToExecute.invoke((Object)focusControl, parameters);
                            focusControl.notifyListeners(13, null);
                            break block9;
                        }
                        throw new ExecutionException("Too many parameters on select all", (Throwable)new Exception());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException e) {
                        throw new ExecutionException("An exception occurred while executing " + this.getMethodToExecute(), e.getTargetException());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
            }
            return null;
        }

        protected Method getMethodToExecute() {
            Control focusControl = Display.getCurrent().getFocusControl();
            Method method = null;
            if (focusControl != null) {
                Class<?> clazz = focusControl.getClass();
                try {
                    method = clazz.getMethod(methodName, NO_PARAMETERS);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            if (method == null && focusControl instanceof Composite && (((Composite)focusControl).getStyle() & 0x1000000) != 0) {
                try {
                    Class<?> focusManagerClass = Class.forName("javax.swing.FocusManager");
                    Method focusManagerGetCurrentManagerMethod = focusManagerClass.getMethod("getCurrentManager", null);
                    Object focusManager = focusManagerGetCurrentManagerMethod.invoke(focusManagerClass, null);
                    Method focusManagerGetFocusOwner = focusManagerClass.getMethod("getFocusOwner", null);
                    Object focusComponent = focusManagerGetFocusOwner.invoke(focusManager, null);
                    Class<?> clazz = focusComponent.getClass();
                    try {
                        method = clazz.getMethod(methodName, NO_PARAMETERS);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new Error("Something is seriously wrong here");
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new Error("Something is seriously wrong here");
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new Error("Something is seriously wrong here");
                }
            }
            return method;
        }
    }
}

