/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline.providers;

import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.EditAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ImportCSSStyleAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.StyleBuilder;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;

public class StyleNodeProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        Object parent = this.getParent(object);
        if (parent != null) {
            menu.add((IAction)new InsertAction(parent, Messages.getString((String)"StyleNodeProvider.action.New")));
        }
        super.createContextMenu(sourceViewer, object, menu);
        if (((StyleHandle)object).canEdit()) {
            menu.insertAfter("additions", (IAction)new EditAction(object, Messages.getString((String)"StyleNodeProvider.action.Edit")));
        }
        menu.insertAfter("additions", (IContributionItem)new Separator());
        menu.insertAfter("additions", (IAction)new ImportCSSStyleAction(object));
    }

    protected boolean performEdit(ReportElementHandle handle) {
        StyleBuilder builder = new StyleBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), handle, handle.getContainer() instanceof ThemeHandle ? (ThemeHandle)handle.getContainer() : null, StyleBuilder.DLG_TITLE_EDIT);
        return builder.open() == 0;
    }

    public String getNodeDisplayName(Object model) {
        return DEUtil.getDisplayLabel((Object)model, (boolean)false);
    }

    public String getNodeTooltip(Object model) {
        if (model instanceof StyleHandle) {
            return ((StyleHandle)model).getName();
        }
        return super.getNodeTooltip(model);
    }
}

