/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline.providers;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.birt.report.designer.core.model.views.outline.EmbeddedImageNode;
import org.eclipse.birt.report.designer.core.model.views.outline.LibraryNode;
import org.eclipse.birt.report.designer.core.model.views.outline.ScriptsNode;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ExportToLibraryAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.PublishTemplateViewAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RefreshModuleHandleAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ReloadCssStyleAction;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;

public class ReportDesignNodeProvider
extends DefaultNodeProvider {
    public Object[] getChildren(Object model) {
        ReportDesignHandle handle = (ReportDesignHandle)model;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(handle.getParameters());
        if (handle instanceof ReportDesignHandle) {
            list.add(handle.getPropertyHandle("pageVariables"));
        }
        list.add(handle.getBody());
        list.add(handle.getMasterPages());
        list.add(handle.getStyles());
        list.add(new EmbeddedImageNode((ModuleHandle)handle));
        if (handle.getTheme() != null) {
            list.add(handle.getTheme());
        }
        list.add(new LibraryNode((ModuleHandle)handle));
        list.add(new ScriptsNode((ModuleHandle)handle));
        return list.toArray();
    }

    public String getNodeDisplayName(Object model) {
        ModuleHandle handle = (ModuleHandle)model;
        Object obj = handle.getProperty("title");
        if (obj != null && obj instanceof String) {
            return (String)obj;
        }
        if (handle.getFileName() != null) {
            return handle.getFileName().substring(handle.getFileName().lastIndexOf(File.separator) + 1);
        }
        return super.getNodeDisplayName(model);
    }

    public String getNodeTooltip(Object model) {
        return ((ModuleHandle)model).getFileName();
    }

    public String getIconName(Object model) {
        if (model instanceof ReportDesignHandle && ((ReportDesignHandle)model).isEnableACL()) {
            return "Report Lock";
        }
        return "Report";
    }

    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        super.createContextMenu(sourceViewer, object, menu);
        menu.add((IAction)new ReloadCssStyleAction(object));
        menu.add((IAction)new RefreshModuleHandleAction(object));
        menu.add((IAction)new ExportToLibraryAction(object));
        ReportDesignHandle report = (ReportDesignHandle)object;
        if (report.getModuleHandle().getFileName().endsWith(".rpttemplate") || ReportPlugin.getDefault().isReportDesignFile(report.getModuleHandle().getFileName())) {
            menu.add((IAction)new PublishTemplateViewAction(object));
        }
    }
}

