/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.TabbedPropertyTitle;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PreviewPropertyDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PreviewSection
extends Section {
    boolean isTabbed = false;
    private boolean showLabel = false;
    protected TabbedPropertyTitle title;
    IDescriptorProvider provider;
    private int height = -1;
    private int width = -1;
    boolean fillForm = false;
    protected PreviewPropertyDescriptor preview;
    PreviewPropertyDescriptor customPreview;

    public PreviewSection(String labelText, Composite parent, boolean isFormStyle) {
        super(labelText, parent, isFormStyle);
    }

    public PreviewSection(String labelText, Composite parent, boolean isFormStyle, boolean isTabbed) {
        super(labelText, parent, isFormStyle);
        this.isTabbed = isTabbed;
    }

    public void showDisplayLabel(boolean show) {
        this.showLabel = show;
    }

    public void createSection() {
        if (this.isTabbed) {
            this.getTitleControl(this.parent);
        } else if (this.showLabel) {
            this.getLabelControl(this.parent);
        }
        this.getPreviewControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public TabbedPropertyTitle getTitleControl() {
        return this.title;
    }

    protected TabbedPropertyTitle getTitleControl(Composite parent) {
        if (this.title == null) {
            this.title = new TabbedPropertyTitle(parent, FormWidgetFactory.getInstance());
            this.title.setLayoutData((Object)new GridData(768));
            this.title.setFont(parent.getFont());
            this.title.setLayoutData((Object)new GridData());
            String text = this.getLabelText();
            if (text != null) {
                this.title.setTitle(text, null);
            }
            this.title.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    PreviewSection.this.title = null;
                }
            });
        } else {
            this.checkParent((Control)this.title, parent);
        }
        return this.title;
    }

    public void layout() {
        GridData gd = (GridData)this.preview.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - this.placeholder;
        gd.horizontalAlignment = 4;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillForm;
        }
        if (this.height > -1) {
            gd.heightHint = this.height > this.preview.getControl().computeSize((int)-1, (int)-1).y ? this.height : this.preview.getControl().computeSize((int)-1, (int)-1).y;
            gd.grabExcessVerticalSpace = false;
        } else {
            gd.grabExcessVerticalSpace = this.fillForm;
        }
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        if (this.displayLabel != null) {
            gd = (GridData)this.displayLabel.getLayoutData();
            gd.horizontalSpan = ((GridLayout)this.parent.getLayout()).numColumns;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
        }
        if (this.title != null) {
            gd = (GridData)this.title.getLayoutData();
            gd.horizontalSpan = ((GridLayout)this.parent.getLayout()).numColumns;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
        }
    }

    public void load() {
        if (this.preview != null && !this.preview.getControl().isDisposed()) {
            this.preview.load();
        }
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.preview != null) {
            this.preview.setDescriptorProvider(provider);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setInput(Object input) {
        assert (input != null);
        this.preview.setInput(input);
    }

    public boolean isFillForm() {
        return this.fillForm;
    }

    public void setFillPreview(boolean fillForm) {
        this.fillForm = fillForm;
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, isHidden);
        }
        if (this.title != null) {
            WidgetUtil.setExcludeGridData((Control)this.title, isHidden);
        }
        if (this.preview != null) {
            this.preview.setHidden(isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.title != null) {
            this.title.setVisible(isVisible);
        }
        if (this.preview != null) {
            this.preview.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }

    public PreviewPropertyDescriptor getPreviewControl() {
        return this.preview;
    }

    protected PreviewPropertyDescriptor getPreviewControl(Composite parent) {
        if (this.preview == null) {
            if (this.customPreview == null) {
                return null;
            }
            this.preview = this.customPreview;
            this.preview.setDescriptorProvider(this.provider);
            this.preview.createControl(parent);
            this.preview.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    PreviewSection.this.preview = null;
                }
            });
        } else {
            this.checkParent(this.preview.getControl(), parent);
        }
        return this.preview;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setPreview(PreviewPropertyDescriptor preview) {
        this.customPreview = preview;
    }
}

