/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ColorPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ColorSection
extends Section {
    protected ColorPropertyDescriptor color;
    IDescriptorProvider provider;
    private int width = -1;
    boolean fillColor = false;
    private String colorValue;

    public ColorSection(String labelText, Composite parent, boolean isFormStyle) {
        super(labelText, parent, isFormStyle);
    }

    public void createSection() {
        this.getLabelControl(this.parent);
        this.getColorComboControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    protected ColorPropertyDescriptor getColorComboControl(Composite parent) {
        if (this.color == null) {
            this.color = DescriptorToolkit.createColorPropertyDescriptor(true);
            if (this.getProvider() != null) {
                this.color.setDescriptorProvider(this.getProvider());
            }
            this.color.createControl(parent);
            this.color.getControl().setLayoutData((Object)new GridData());
            this.color.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ColorSection.this.color = null;
                }
            });
            if (this.colorValue != null) {
                this.color.setColorValue(this.colorValue);
            }
        } else {
            this.checkParent(this.color.getControl(), parent);
        }
        return this.color;
    }

    public ColorPropertyDescriptor getColorComboControl() {
        return this.color;
    }

    public void layout() {
        GridData gd = (GridData)this.color.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - 1 - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - 1 - this.placeholder;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillColor;
        }
    }

    public void load() {
        if (this.color != null && !this.color.getControl().isDisposed()) {
            this.color.load();
        }
    }

    public void reset() {
        if (this.color != null && !this.color.getControl().isDisposed()) {
            this.color.reset();
        }
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.color != null) {
            this.color.setDescriptorProvider(provider);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setInput(Object input) {
        assert (input != null);
        this.color.setInput(input);
    }

    public boolean isFillColor() {
        return this.fillColor;
    }

    public void setFillColor(boolean fillColor) {
        this.fillColor = fillColor;
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, isHidden);
        }
        if (this.color != null) {
            this.color.setHidden(isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.color != null) {
            this.color.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }

    public void setFocus() {
        if (this.color != null) {
            this.color.getControl().setFocus();
        }
    }

    public void setColorValue(String value) {
        if (this.color != null) {
            this.color.setColorValue(value);
        }
        this.colorValue = value;
    }

    public RGB getColorValue() {
        if (this.color != null) {
            return this.color.getColorValue();
        }
        return null;
    }
}

