/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.PreviewPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.MapRuleBuilder;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.MapHandleProvider;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class MapDescriptorProvider
extends MapHandleProvider
implements PreviewPropertyDescriptorProvider {
    private static final MapRuleHandle[] EMPTY = new MapRuleHandle[0];
    protected Object input;
    private boolean canReset = false;

    public MapDescriptorProvider() {
    }

    public MapDescriptorProvider(int expressionType) {
        super(expressionType);
    }

    public String getColumnText(Object element, int columnIndex) {
        MapRuleHandle handle = (MapRuleHandle)element;
        switch (columnIndex) {
            case 0: {
                String pv = handle.getDisplay();
                return pv == null ? "" : pv;
            }
            case 1: {
                String exp = String.valueOf(this.resolveNull(handle.getTestExpression())) + " " + MapRuleBuilder.getNameForOperator((String)handle.getOperator());
                int vv = MapRuleBuilder.determineValueVisible((String)handle.getOperator());
                if (vv == 1) {
                    exp = String.valueOf(exp) + " " + this.resolveNull(handle.getValue1());
                } else if (vv == 2) {
                    exp = String.valueOf(exp) + " " + this.resolveNull(handle.getValue1()) + " , " + this.resolveNull(handle.getValue2());
                } else if (vv == 3) {
                    exp = String.valueOf(exp) + " ";
                    int count = handle.getValue1List().size();
                    int i = 0;
                    while (i < count) {
                        exp = i == 0 ? String.valueOf(exp) + handle.getValue1List().get(i).toString() : String.valueOf(exp) + "; " + handle.getValue1List().get(i).toString();
                        ++i;
                    }
                }
                return exp;
            }
        }
        return "";
    }

    private String resolveNull(String src) {
        if (src == null) {
            return "";
        }
        return src;
    }

    public boolean doSwapItem(int pos, int direction) throws PropertyValueException {
        PropertyHandle phandle = this.elementHandle.getPropertyHandle("mapRules");
        if (direction < 0) {
            phandle.moveItem(pos, pos - 1);
        } else {
            phandle.moveItem(pos, pos + 1);
        }
        return true;
    }

    public IStructuredContentProvider getContentProvider(IModelEventProcessor listener) {
        return new MapContentProvider(listener);
    }

    public LabelProvider getLabelProvider() {
        return new MapLabelProvider();
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            inputElement = ((List)inputElement).size() > 0 ? ((List)inputElement).get(0) : null;
        }
        if (inputElement instanceof DesignElementHandle) {
            this.elementHandle = (DesignElementHandle)inputElement;
            PropertyHandle mapRules = this.elementHandle.getPropertyHandle("mapRules");
            ArrayList list = new ArrayList();
            for (Object o : mapRules) {
                list.add(o);
            }
            return list.toArray(new MapRuleHandle[0]);
        }
        return EMPTY;
    }

    public boolean doDeleteItem(int pos) throws PropertyValueException {
        PropertyHandle phandle = this.elementHandle.getPropertyHandle("mapRules");
        phandle.removeItem(pos);
        return true;
    }

    public MapRuleHandle doAddItem(MapRule rule, int pos) {
        PropertyHandle phandle = this.elementHandle.getPropertyHandle("mapRules");
        try {
            phandle.addItem((IStructure)rule);
        }
        catch (SemanticException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        StructureHandle handle = rule.getHandle((SimpleValueHandle)phandle, pos);
        return (MapRuleHandle)handle;
    }

    public boolean edit(Object input, int handleCount) {
        boolean result = false;
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"MapPage.transName.editMapRule"));
            MapRuleBuilder builder = new MapRuleBuilder(UIUtil.getDefaultShell(), MapRuleBuilder.DLG_TITLE_EDIT, (MapHandleProvider)this);
            MapRuleHandle handle = (MapRuleHandle)input;
            builder.updateHandle(handle, handleCount);
            builder.setDesignHandle(this.getDesignElementHandle());
            Object reportElement = this.getDesignElementHandle();
            while (reportElement instanceof RowHandle || reportElement instanceof ColumnHandle || reportElement instanceof CellHandle) {
                DesignElementHandle designElement = reportElement.getContainer();
                if ((reportElement = designElement instanceof ReportItemHandle ? (ReportItemHandle)designElement : (designElement instanceof GroupHandle ? (ReportItemHandle)((GroupHandle)designElement).getContainer() : designElement)) == null) break;
            }
            if (reportElement instanceof ReportItemHandle) {
                builder.setReportElement((ReportElementHandle)((ReportItemHandle)reportElement));
            } else if (reportElement instanceof GroupHandle) {
                builder.setReportElement((ReportElementHandle)((ReportItemHandle)((GroupHandle)reportElement).getContainer()));
            }
            if (builder.open() == 0) {
                result = true;
            }
            stack.commit();
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionUtil.handle((Throwable)e);
            result = false;
        }
        return result;
    }

    public boolean add(int handleCount) {
        boolean result = false;
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"MapPage.transName.addMapRule"));
            MapRuleBuilder dialog = this.createAddDialog(handleCount);
            if (dialog.open() == 0) {
                result = true;
            }
            stack.commit();
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionUtil.handle((Throwable)e);
            result = false;
        }
        return result;
    }

    protected MapRuleBuilder createAddDialog(int handleCount) {
        MapRuleBuilder builder = new MapRuleBuilder(UIUtil.getDefaultShell(), MapRuleBuilder.DLG_TITLE_NEW, (MapHandleProvider)this);
        builder.updateHandle(null, handleCount);
        builder.setDesignHandle(this.getDesignElementHandle());
        Object reportElement = this.getDesignElementHandle();
        while (reportElement instanceof RowHandle || reportElement instanceof ColumnHandle || reportElement instanceof CellHandle) {
            DesignElementHandle designElement = reportElement.getContainer();
            if ((reportElement = designElement instanceof ReportItemHandle ? (ReportItemHandle)designElement : (designElement instanceof GroupHandle ? (ReportItemHandle)((GroupHandle)designElement).getContainer() : designElement)) == null) break;
        }
        if (reportElement instanceof ReportItemHandle) {
            builder.setReportElement((ReportElementHandle)((ReportItemHandle)reportElement));
        } else if (reportElement instanceof GroupHandle) {
            builder.setReportElement((ReportElementHandle)((ReportItemHandle)((GroupHandle)reportElement).getContainer()));
        }
        return builder;
    }

    public boolean delete(int index) {
        boolean result = false;
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"MapPage.transName.deleteMapRule"));
            this.doDeleteItem(index);
            stack.commit();
            result = true;
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionUtil.handle((Throwable)e);
            result = false;
        }
        return result;
    }

    public boolean moveUp(int index) {
        boolean result = false;
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"MapPage.transName.moveUpMapRule"));
            this.doSwapItem(index, -1);
            stack.commit();
            result = true;
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionUtil.handle((Throwable)e);
            result = false;
        }
        return result;
    }

    public boolean moveDown(int index) {
        boolean result = false;
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"MapPage.transName.moveDownRule"));
            this.doSwapItem(index, 1);
            stack.commit();
            result = true;
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionUtil.handle((Throwable)e);
            result = false;
        }
        return result;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public String getDisplayName() {
        return Messages.getString((String)"MapPage.label.mapList");
    }

    public Object load() {
        return null;
    }

    public void save(Object value) throws SemanticException {
    }

    public String getText(int key) {
        switch (key) {
            case 0: {
                return Messages.getString((String)"MapPage.label.mapList");
            }
            case 1: {
                return Messages.getString((String)"MapPage.label.add");
            }
            case 2: {
                return Messages.getString((String)"MapPage.label.delete");
            }
            case 3: {
                return Messages.getString((String)"FormPage.Button.Up");
            }
            case 4: {
                return Messages.getString((String)"MapPage.toolTipText.moveUp");
            }
            case 5: {
                return Messages.getString((String)"FormPage.Button.Down");
            }
            case 6: {
                return Messages.getString((String)"MapPage.toolTipText.moveDown");
            }
            case 7: {
                return Messages.getString((String)"MapPage.label.displayValue");
            }
            case 8: {
                return Messages.getString((String)"MapPage.label.condition");
            }
            case 9: {
                return Messages.getString((String)"");
            }
        }
        return "";
    }

    public String getDisplayText(Object handle) {
        return ((MapRuleHandle)handle).getDisplay();
    }

    public boolean canReset() {
        return this.canReset;
    }

    public void enableReset(boolean canReset) {
        this.canReset = canReset;
    }

    public void reset() throws SemanticException {
        if (this.canReset()) {
            this.save(null);
        }
    }

    class MapContentProvider
    implements IStructuredContentProvider {
        private IModelEventProcessor listener;

        public MapContentProvider(IModelEventProcessor listener) {
            this.listener = listener;
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = MapDescriptorProvider.this.getElements(inputElement);
            this.deRegisterEventManager();
            this.registerEventManager();
            return elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
            this.deRegisterEventManager();
        }

        protected void deRegisterEventManager() {
            if (UIUtil.getModelEventManager() != null) {
                UIUtil.getModelEventManager().removeModelEventProcessor(this.listener);
            }
        }

        protected void registerEventManager() {
            if (UIUtil.getModelEventManager() != null) {
                UIUtil.getModelEventManager().addModelEventProcessor(this.listener);
            }
        }
    }

    class MapLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        MapLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return MapDescriptorProvider.this.getColumnText(element, 1);
        }
    }
}

