/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.birt.report.designer.internal.ui.views.RenameInlineTool;
import org.eclipse.birt.report.designer.internal.ui.views.actions.EditAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RenameAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class RenameListener
extends KeyAdapter
implements MouseListener,
SelectionListener,
IDoubleClickListener {
    private TreeViewer sourceViewer;
    private TreeItem selectedItem = null;
    private Timer timer;
    private boolean readyToRename;

    public RenameListener(TreeViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    public void apply() {
        this.sourceViewer.getTree().addSelectionListener((SelectionListener)this);
        this.sourceViewer.getTree().addKeyListener((KeyListener)this);
        this.sourceViewer.addDoubleClickListener((IDoubleClickListener)this);
    }

    public void remove() {
        this.sourceViewer.getTree().removeSelectionListener((SelectionListener)this);
        this.sourceViewer.getTree().removeKeyListener((KeyListener)this);
        this.sourceViewer.removeDoubleClickListener((IDoubleClickListener)this);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.cancelTimer();
        if (e.button != 1) {
            this.cancelRenaming();
        }
    }

    public void mouseUp(MouseEvent e) {
        if (!this.readyToRename) {
            return;
        }
        this.readyToRename = false;
        this.timer = new Timer();
        final RenameAction renameAction = new RenameAction(this.sourceViewer);
        this.timer.schedule(new TimerTask(){

            public void run() {
                RenameListener.this.sourceViewer.getTree().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        renameAction.run();
                    }
                });
            }
        }, Display.getCurrent().getDoubleClickTime() + 100);
    }

    public void keyReleased(KeyEvent e) {
        RenameAction action;
        this.cancelTimer();
        if (e.keyCode == 0x100000B && e.stateMask == 0 && this.selectedItem != null && (action = new RenameAction(this.sourceViewer)).isEnabled() && action.isHandled()) {
            action.run();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        this.cancelTimer();
        TreeItem lastSelect = this.selectedItem;
        TreeItem[] selectedItems = ((Tree)e.getSource()).getSelection();
        if (selectedItems.length != 1) {
            this.readyToRename = false;
        } else {
            this.selectedItem = selectedItems[0];
            this.readyToRename = this.selectedItem == lastSelect;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void cancelRenaming() {
        RenameInlineTool.cancelActiveInstance();
        this.cancelTimer();
    }

    public void doubleClick(DoubleClickEvent event) {
        this.cancelTimer();
        if (this.selectedItem != null && !this.selectedItem.isDisposed()) {
            new EditAction(this.selectedItem.getData()).run();
        }
    }
}

