/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtil {
    public static final int INT_LENGTH = 4;
    public static final int RA_STREAM_BUFFER_LENGTH = 8192;
    public static final int MAX_NUMBER_OF_STREAM_BUFFER = 128;
    private static Map type2IndexMap = new HashMap();
    private static final int TYPE_NULL = 0;
    private static final int TYPE_INT = 1;
    private static final int TYPE_FLOAT = 2;
    private static final int TYPE_DOUBLE = 3;
    private static final int TYPE_BIG_DECIMAL = 4;
    private static final int TYPE_DATE_TIME = 5;
    private static final int TYPE_TIME = 6;
    private static final int TYPE_TIME_STAMP = 7;
    private static final int TYPE_BOOLEAN = 8;
    private static final int TYPE_STRING = 9;
    private static final int TYPE_BYTES = 10;
    private static final int TYPE_LIST = 11;
    private static final int TYPE_MAP = 12;
    private static final int TYPE_SERIALIZABLE = 13;
    private static final int TYPE_JSObject = 14;
    private static final int TYPE_LONG_STRING = 15;
    private static final int TYPE_DATE = 16;

    static {
        type2IndexMap.put(Integer.class, new Integer(1));
        type2IndexMap.put(Float.class, new Integer(2));
        type2IndexMap.put(Double.class, new Integer(3));
        type2IndexMap.put(BigDecimal.class, new Integer(4));
        type2IndexMap.put(java.util.Date.class, new Integer(5));
        type2IndexMap.put(Time.class, new Integer(6));
        type2IndexMap.put(Timestamp.class, new Integer(7));
        type2IndexMap.put(Boolean.class, new Integer(8));
        type2IndexMap.put(String.class, new Integer(9));
        type2IndexMap.put(byte[].class, new Integer(10));
        type2IndexMap.put(List.class, new Integer(11));
        type2IndexMap.put(Map.class, new Integer(12));
        type2IndexMap.put(Serializable.class, new Integer(13));
        type2IndexMap.put(null, new Integer(0));
        type2IndexMap.put(Date.class, new Integer(16));
        type2IndexMap.put(IdScriptableObject.class, new Integer(14));
    }

    public static final <T> T read(DataInputStream inputStream, Class<T> clazz) throws IOException {
        Object result = null;
        result = clazz == Short.TYPE || clazz == Short.class ? Short.valueOf(IOUtil.readShort(inputStream)) : (clazz == Boolean.TYPE || clazz == Boolean.class ? Boolean.valueOf(IOUtil.readBool(inputStream)) : (clazz == byte[].class ? (Object)IOUtil.readBytes(inputStream) : (clazz == Double.TYPE || clazz == Double.class ? Double.valueOf(IOUtil.readDouble(inputStream)) : (clazz == Float.TYPE || clazz == Float.class ? Float.valueOf(IOUtil.readFloat(inputStream)) : (clazz == Integer.TYPE || clazz == Integer.class ? Integer.valueOf(IOUtil.readInt(inputStream)) : (List.class.isAssignableFrom(clazz) ? IOUtil.readList(inputStream) : (clazz == Long.TYPE || clazz == Short.class ? Long.valueOf(IOUtil.readLong(inputStream)) : (Map.class.isAssignableFrom(clazz) ? IOUtil.readMap(inputStream) : (clazz == String.class ? IOUtil.readString(inputStream) : IOUtil.readObject(inputStream))))))))));
        return (T)result;
    }

    public static final <T> void write(DataOutputStream out, T object, Class<T> clazz) throws IOException {
        if (clazz == Short.TYPE || clazz == Short.class) {
            IOUtil.writeShort(out, (Short)object);
        } else if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            IOUtil.writeBool(out, (Boolean)object);
        } else if (clazz == byte[].class) {
            IOUtil.writeBytes(out, (byte[])object);
        } else if (clazz == Double.TYPE || clazz == Double.class) {
            IOUtil.writeDouble(out, (Double)object);
        } else if (clazz == Float.TYPE || clazz == Float.class) {
            IOUtil.writeFloat(out, ((Float)object).floatValue());
        } else if (clazz == Integer.TYPE || clazz == Integer.class) {
            IOUtil.writeInt(out, (Integer)object);
        } else if (List.class.isAssignableFrom(clazz)) {
            IOUtil.writeList(out, (List)object);
        } else if (clazz == Long.TYPE || clazz == Long.class) {
            IOUtil.writeLong(out, (Long)object);
        } else if (Map.class.isAssignableFrom(clazz)) {
            IOUtil.writeMap(out, (Map)object);
        } else if (clazz == String.class) {
            IOUtil.writeString(out, (String)object);
        } else {
            IOUtil.writeObject(out, object);
        }
    }

    public static final short readShort(InputStream inputStream) throws IOException {
        int ch1 = inputStream.read();
        int ch2 = inputStream.read();
        return (short)((ch1 << 8) + ch2);
    }

    public static final void writeShort(OutputStream outputStream, short value) throws IOException {
        outputStream.write(value >>> 8 & 0xFF);
        outputStream.write(value >>> 0 & 0xFF);
    }

    public static final int readInt(InputStream inputStream) throws IOException {
        int ch1 = inputStream.read();
        int ch2 = inputStream.read();
        int ch3 = inputStream.read();
        int ch4 = inputStream.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static final void writeInt(OutputStream outputStream, int value) throws IOException {
        outputStream.write(value >>> 24 & 0xFF);
        outputStream.write(value >>> 16 & 0xFF);
        outputStream.write(value >>> 8 & 0xFF);
        outputStream.write(value >>> 0 & 0xFF);
    }

    public static final int getInt(byte[] bytes) {
        assert (bytes.length == 4);
        int ch1 = bytes[0] & 0xFF;
        int ch2 = bytes[1] & 0xFF;
        int ch3 = bytes[2] & 0xFF;
        int ch4 = bytes[3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static final int bytesToInteger(byte[] b) {
        assert (b.length >= 4);
        return ((b[0] & 0xFF) << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + ((b[3] & 0xFF) << 0);
    }

    public static final long bytesToLong(byte[] b) {
        assert (b.length >= 8);
        return (((long)b[0] & 0xFFL) << 56) + (((long)b[1] & 0xFFL) << 48) + (((long)b[2] & 0xFFL) << 40) + (((long)b[3] & 0xFFL) << 32) + (((long)b[4] & 0xFFL) << 24) + (((long)b[5] & 0xFFL) << 16) + (((long)b[6] & 0xFFL) << 8) + (((long)b[7] & 0xFFL) << 0);
    }

    public static final void integerToBytes(int v, byte[] b) {
        assert (b.length >= 4);
        b[0] = (byte)(v >>> 24 & 0xFF);
        b[1] = (byte)(v >>> 16 & 0xFF);
        b[2] = (byte)(v >>> 8 & 0xFF);
        b[3] = (byte)(v >>> 0 & 0xFF);
    }

    public static final void longToBytes(long v, byte[] b) {
        assert (b.length >= 8);
        b[0] = (byte)(v >>> 56 & 0xFFL);
        b[1] = (byte)(v >>> 48 & 0xFFL);
        b[2] = (byte)(v >>> 40 & 0xFFL);
        b[3] = (byte)(v >>> 32 & 0xFFL);
        b[4] = (byte)(v >>> 24 & 0xFFL);
        b[5] = (byte)(v >>> 16 & 0xFFL);
        b[6] = (byte)(v >>> 8 & 0xFFL);
        b[7] = (byte)(v >>> 0 & 0xFFL);
    }

    public static final boolean readBool(InputStream inputStream) throws IOException {
        return inputStream.read() != 0;
    }

    public static final void writeBool(OutputStream outputStream, boolean bool) throws IOException {
        outputStream.write(!bool ? 0 : 1);
    }

    public static final float readFloat(DataInputStream inputStream) throws IOException {
        return inputStream.readFloat();
    }

    public static final void writeFloat(DataOutputStream outputStream, float value) throws IOException {
        outputStream.writeFloat(value);
    }

    public static final double readDouble(DataInputStream inputStream) throws IOException {
        return inputStream.readDouble();
    }

    public static final void writeDouble(DataOutputStream outputStream, double value) throws IOException {
        outputStream.writeDouble(value);
    }

    public static final long readLong(DataInputStream inputStream) throws IOException {
        return inputStream.readLong();
    }

    public static final void writeLong(DataOutputStream outputStream, long value) throws IOException {
        outputStream.writeLong(value);
    }

    public static final void writeRawBytes(DataOutputStream dos, byte[] bytes) throws IOException {
        assert (bytes != null);
        dos.write(bytes);
    }

    private static int getTypeIndex(Object obValue) {
        if (obValue == null) {
            return 0;
        }
        if (obValue instanceof String) {
            if (IOUtil.isLongString((String)obValue)) {
                return 15;
            }
            return 9;
        }
        Integer indexOb = (Integer)type2IndexMap.get(obValue.getClass());
        if (indexOb == null) {
            if (obValue instanceof Map) {
                return 12;
            }
            if (obValue instanceof List) {
                return 11;
            }
            if (obValue instanceof Scriptable) {
                return 14;
            }
            if (Timestamp.class.isAssignableFrom(obValue.getClass())) {
                return 7;
            }
            if (Time.class.isAssignableFrom(obValue.getClass())) {
                return 6;
            }
            if (Date.class.isAssignableFrom(obValue.getClass())) {
                return 16;
            }
            if (java.util.Date.class.isAssignableFrom(obValue.getClass())) {
                return 5;
            }
            if (obValue instanceof Serializable) {
                return 13;
            }
            return -1;
        }
        return indexOb;
    }

    public static final Object readObject(DataInputStream dis) throws IOException {
        return IOUtil.readObject(dis, null);
    }

    public static final Object readObject(DataInputStream dis, ClassLoader classLoader) throws IOException {
        int typeIndex = IOUtil.readInt(dis);
        Object obValue = null;
        switch (typeIndex) {
            case 0: {
                break;
            }
            case 1: {
                obValue = new Integer(dis.readInt());
                break;
            }
            case 2: {
                obValue = new Float(dis.readFloat());
                break;
            }
            case 3: {
                obValue = new Double(dis.readDouble());
                break;
            }
            case 4: {
                obValue = new BigDecimal(dis.readUTF());
                break;
            }
            case 5: {
                obValue = new java.util.Date(dis.readLong());
                break;
            }
            case 6: {
                obValue = new Time(dis.readLong());
                break;
            }
            case 16: {
                obValue = new Date(dis.readLong());
                break;
            }
            case 7: {
                obValue = new Timestamp(dis.readLong());
                break;
            }
            case 8: {
                obValue = new Boolean(dis.readBoolean());
                break;
            }
            case 9: {
                obValue = dis.readUTF();
                break;
            }
            case 15: {
                obValue = IOUtil.readUTF(dis);
                break;
            }
            case 10: {
                int len = IOUtil.readInt(dis);
                byte[] bytes = new byte[len];
                if (len > 0) {
                    dis.readFully(bytes);
                }
                obValue = bytes;
                break;
            }
            case 11: {
                obValue = IOUtil.readList(dis, classLoader);
                break;
            }
            case 12: {
                obValue = IOUtil.readMap(dis, classLoader);
                break;
            }
            case 13: {
                int len = IOUtil.readInt(dis);
                if (len == 0) break;
                byte[] bytes = new byte[len];
                dis.readFully(bytes);
                final ClassLoader loader = classLoader;
                try {
                    ObjectInputStream oo = new ObjectInputStream(new ByteArrayInputStream(bytes)){

                        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                            return Class.forName(desc.getName(), false, loader);
                        }
                    };
                    obValue = oo.readObject();
                    break;
                }
                catch (Exception ex) {
                    IOException ie = new IOException(ex.getMessage());
                    ie.initCause(ex);
                    throw ie;
                }
            }
            case 14: {
                Object ob = IOUtil.readObject(dis, classLoader);
                obValue = JavascriptEvalUtil.convertToJavascriptValue(ob);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return obValue;
    }

    public static final void writeObject(DataOutputStream dos, Object obValue) throws IOException {
        int typeIndex = IOUtil.getTypeIndex(obValue);
        if (typeIndex == -1) {
            IOUtil.writeInt(dos, 0);
            throw new IOException("Data type of " + obValue.getClass().toString() + " is not supported to be serialized");
        }
        IOUtil.writeInt(dos, typeIndex);
        switch (typeIndex) {
            case 0: {
                break;
            }
            case 1: {
                dos.writeInt((Integer)obValue);
                break;
            }
            case 2: {
                dos.writeFloat(((Float)obValue).floatValue());
                break;
            }
            case 3: {
                dos.writeDouble((Double)obValue);
                break;
            }
            case 4: {
                dos.writeUTF(((BigDecimal)obValue).toString());
                break;
            }
            case 5: {
                dos.writeLong(((java.util.Date)obValue).getTime());
                break;
            }
            case 6: {
                dos.writeLong(((Time)obValue).getTime());
                break;
            }
            case 16: {
                dos.writeLong(((Date)obValue).getTime());
                break;
            }
            case 7: {
                dos.writeLong(((Timestamp)obValue).getTime());
                break;
            }
            case 8: {
                dos.writeBoolean((Boolean)obValue);
                break;
            }
            case 9: {
                dos.writeUTF(obValue.toString());
                break;
            }
            case 15: {
                IOUtil.writeUTF(dos, obValue.toString());
                break;
            }
            case 10: {
                byte[] bytes = (byte[])obValue;
                int length = bytes.length;
                IOUtil.writeInt(dos, length);
                if (length <= 0) break;
                dos.write(bytes);
                break;
            }
            case 11: {
                IOUtil.writeList(dos, (List)obValue);
                break;
            }
            case 12: {
                IOUtil.writeMap(dos, (Map)obValue);
                break;
            }
            case 13: {
                byte[] bytes = null;
                try {
                    ByteArrayOutputStream buff = new ByteArrayOutputStream();
                    ObjectOutputStream oo = new ObjectOutputStream(buff);
                    oo.writeObject(obValue);
                    oo.close();
                    bytes = buff.toByteArray();
                }
                catch (Exception exception) {}
                if (bytes == null || bytes.length == 0) {
                    IOUtil.writeInt(dos, 0);
                    break;
                }
                IOUtil.writeInt(dos, bytes.length);
                dos.write(bytes);
                break;
            }
            case 14: {
                if (obValue instanceof IdScriptableObject) {
                    IdScriptableObject jsObject = (IdScriptableObject)obValue;
                    if (jsObject.getClassName().equals("Date")) {
                        java.util.Date date = (java.util.Date)JavascriptEvalUtil.convertJavascriptValue(obValue);
                        IOUtil.writeObject(dos, date);
                        break;
                    }
                    IOUtil.writeObject(dos, null);
                    break;
                }
                if (obValue instanceof NativeJavaObject) {
                    obValue = JavascriptEvalUtil.convertJavascriptValue(obValue);
                    IOUtil.writeObject(dos, obValue);
                    break;
                }
                IOUtil.writeObject(dos, null);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public static final String readString(DataInputStream dis) throws IOException {
        int type = IOUtil.readInt(dis);
        if (type == 0) {
            return null;
        }
        if (type == 9) {
            return dis.readUTF();
        }
        return IOUtil.readUTF(dis);
    }

    public static final void writeString(DataOutputStream dos, String str) throws IOException {
        if (str == null) {
            IOUtil.writeInt(dos, 0);
            return;
        }
        if (IOUtil.isLongString(str)) {
            IOUtil.writeInt(dos, 15);
            IOUtil.writeUTF(dos, str);
        } else {
            IOUtil.writeInt(dos, 9);
            dos.writeUTF(str);
        }
    }

    public static final byte[] readBytes(DataInputStream dis) throws IOException {
        if (IOUtil.readInt(dis) == 0) {
            return null;
        }
        int size = IOUtil.readInt(dis);
        byte[] bytes = new byte[size];
        if (size != 0) {
            dis.readFully(bytes);
        }
        return bytes;
    }

    public static final void writeBytes(DataOutputStream dos, byte[] bytes) throws IOException {
        if (bytes == null) {
            IOUtil.writeInt(dos, 0);
            return;
        }
        IOUtil.writeInt(dos, 10);
        int size = bytes.length;
        IOUtil.writeInt(dos, size);
        if (size == 0) {
            return;
        }
        dos.write(bytes);
    }

    public static final List readList(DataInputStream dis) throws IOException {
        return IOUtil.readList(dis, null);
    }

    public static final List readList(DataInputStream dis, ClassLoader classLoader) throws IOException {
        if (IOUtil.readInt(dis) == 0) {
            return null;
        }
        ArrayList<Object> dataList = new ArrayList<Object>();
        int size = IOUtil.readInt(dis);
        if (size == 0) {
            return dataList;
        }
        int i = 0;
        while (i < size) {
            dataList.add(IOUtil.readObject(dis, classLoader));
            ++i;
        }
        return dataList;
    }

    public static final void writeList(DataOutputStream dos, List list) throws IOException {
        if (list == null) {
            IOUtil.writeInt(dos, 0);
            return;
        }
        IOUtil.writeInt(dos, 11);
        int size = list.size();
        IOUtil.writeInt(dos, size);
        if (size == 0) {
            return;
        }
        int i = 0;
        while (i < size) {
            IOUtil.writeObject(dos, list.get(i));
            ++i;
        }
    }

    public static final Map readMap(DataInputStream dis) throws IOException {
        return IOUtil.readMap(dis, null);
    }

    public static final Map readMap(DataInputStream dis, ClassLoader loader) throws IOException {
        if (IOUtil.readInt(dis) == 0) {
            return null;
        }
        HashMap<Object, Object> dataMap = new HashMap<Object, Object>();
        int size = IOUtil.readInt(dis);
        if (size == 0) {
            return dataMap;
        }
        int i = 0;
        while (i < size) {
            Object key = IOUtil.readObject(dis, loader);
            Object value = IOUtil.readObject(dis, loader);
            dataMap.put(key, value);
            ++i;
        }
        return dataMap;
    }

    public static final void writeMap(DataOutputStream dos, Map map) throws IOException {
        if (map == null) {
            IOUtil.writeInt(dos, 0);
            return;
        }
        IOUtil.writeInt(dos, 12);
        int size = map.size();
        IOUtil.writeInt(dos, size);
        if (size == 0) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            IOUtil.writeObject(dos, key);
            IOUtil.writeObject(dos, value);
        }
    }

    private static boolean isLongString(String str) {
        int strlen = str.length();
        if (strlen > 65535) {
            return true;
        }
        if (strlen < 21845) {
            return false;
        }
        int utflen = IOUtil.getBytesSize(str);
        return utflen > 65535;
    }

    private static void writeUTF(DataOutputStream dos, String str) throws IOException {
        int strlen = str.length();
        char c = '\u0000';
        int utflen = IOUtil.getBytesSize(str);
        dos.writeInt(utflen);
        int i = 0;
        while (i < strlen) {
            c = str.charAt(i);
            if (c < '\u0001' || c > '\u007f') break;
            dos.writeByte((byte)c);
            ++i;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                dos.writeByte((byte)c);
            } else if (c > '\u07ff') {
                dos.writeByte((byte)(0xE0 | c >> 12 & 0xF));
                dos.writeByte((byte)(0x80 | c >> 6 & 0x3F));
                dos.writeByte((byte)(0x80 | c >> 0 & 0x3F));
            } else {
                dos.writeByte((byte)(0xC0 | c >> 6 & 0x1F));
                dos.writeByte((byte)(0x80 | c >> 0 & 0x3F));
            }
            ++i;
        }
    }

    private static String readUTF(DataInputStream dis) throws IOException {
        int length = dis.readInt();
        byte[] ret = new byte[length];
        dis.read(ret, 0, length);
        return IOUtil.convertBytes2String(ret);
    }

    private static int getBytesSize(String str) {
        int utflen = 0;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        return utflen;
    }

    private static int generateCharArray(char[] chararr, byte[] bytearr, int count, int chararr_count) throws UTFDataFormatException {
        int utflen = bytearr.length;
        while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("Malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("Malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("Malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("Malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException("Malformed input around byte " + count);
                }
            }
        }
        return chararr_count;
    }

    private static String convertBytes2String(byte[] bytearr) throws UTFDataFormatException {
        int utflen = bytearr.length;
        char[] chararr = new char[utflen];
        int chararr_count = 0;
        int count = 0;
        while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            if (c > 127) break;
            ++count;
            chararr[chararr_count++] = (char)c;
        }
        chararr_count = IOUtil.generateCharArray(chararr, bytearr, count, chararr_count);
        return new String(chararr, 0, chararr_count);
    }
}

