/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound.v3;

import java.io.IOException;
import org.eclipse.birt.core.archive.compound.v3.Ext2Block;
import org.eclipse.birt.core.archive.compound.v3.Ext2FileSystem;

public class DataBlock
extends Ext2Block {
    private byte[] buffer = new byte[4096];
    private boolean dirty = false;
    static final DataBlock READ_ONLY_BLOCK = new ReadOnlyBlock();

    DataBlock(Ext2FileSystem fs) {
        this(fs, -1);
    }

    DataBlock(Ext2FileSystem fs, int blockId) {
        super(fs, blockId);
    }

    public synchronized int write(int tgt, byte[] b, int off, int len) throws IOException {
        assert (b != null);
        assert (tgt + len < this.buffer.length);
        assert (off + len < b.length);
        if (len > 0) {
            System.arraycopy(b, off, this.buffer, tgt, len);
            this.dirty = true;
        }
        return len;
    }

    public synchronized int read(int src, byte[] b, int off, int len) throws IOException {
        assert (b != null);
        assert (off + len < b.length);
        assert (src + len < this.buffer.length);
        System.arraycopy(this.buffer, src, b, off, len);
        return len;
    }

    public void refresh() throws IOException {
        assert (this.blockId != -1);
        this.fs.readBlock(this.blockId, this.buffer, 0, 4096);
        this.dirty = false;
    }

    public void flush() throws IOException {
        if (this.blockId == -1) {
            throw new IllegalStateException("Must assign the block id before flush");
        }
        if (this.dirty) {
            this.fs.writeBlock(this.blockId, this.buffer, 0, 4096);
            this.dirty = false;
        }
    }

    private static class ReadOnlyBlock
    extends DataBlock {
        ReadOnlyBlock() {
            super(null, -1);
        }

        public int write(int tgt, byte[] b, int off, int len) throws IOException {
            throw new IOException("Can't change the read only buffer");
        }

        public int read(int src, byte[] b, int off, int len) throws IOException {
            assert (b != null);
            assert (off + len < b.length);
            int i = 0;
            while (i < len) {
                b[off + i] = 0;
                ++i;
            }
            return len;
        }

        public void refresh() throws IOException {
        }

        public void flush() throws IOException {
        }
    }
}

