/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.archive.compound.v3.Ext2Entry;
import org.eclipse.birt.core.archive.compound.v3.Ext2File;
import org.eclipse.birt.core.archive.compound.v3.Ext2FileSystem;
import org.eclipse.birt.core.archive.compound.v3.Ext2Node;

public class ArchiveFileV3
implements IArchiveFile {
    public static final String PROPERTY_SYSTEM_ID = "archive.system-id";
    public static final String PROPERTY_DEPEND_ID = "archive.depened-id";
    protected Ext2FileSystem fs;

    public ArchiveFileV3(String fileName, String mode) throws IOException {
        this(fileName, null, mode);
    }

    public ArchiveFileV3(String fileName, RandomAccessFile rf, String mode) throws IOException {
        this.fs = new Ext2FileSystem(fileName, rf, mode);
        this.fs.setCacheManager(ArchiveFile.systemCacheManager);
    }

    public void close() throws IOException {
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
    }

    public void setSystemId(String id) {
        this.fs.setProperty(PROPERTY_SYSTEM_ID, id);
    }

    public void setDependId(String id) {
        this.fs.setProperty(PROPERTY_DEPEND_ID, id);
    }

    public ArchiveEntry createEntry(String name) throws IOException {
        Ext2File file = this.fs.createFile(name);
        return new ArchiveEntryV3(file);
    }

    public boolean exists(String name) {
        return this.fs.existFile(name);
    }

    public void flush() throws IOException {
        this.fs.flush();
    }

    public String getDependId() {
        return this.fs.getProperty(PROPERTY_DEPEND_ID);
    }

    public ArchiveEntry openEntry(String name) throws IOException {
        if (this.fs.existFile(name)) {
            Ext2File file = this.fs.openFile(name);
            return new ArchiveEntryV3(file);
        }
        throw new FileNotFoundException(name);
    }

    public String getName() {
        return this.fs.getFileName();
    }

    public String getSystemId() {
        return this.fs.getProperty(PROPERTY_SYSTEM_ID);
    }

    public int getUsedCache() {
        return this.fs.getUsedCacheSize() * 4096;
    }

    public List listEntries(String namePattern) {
        ArrayList<String> files = new ArrayList<String>();
        String[] stringArray = this.fs.listFiles();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (file.startsWith(namePattern)) {
                files.add(file);
            }
            ++n2;
        }
        return files;
    }

    public synchronized Object lockEntry(String name) throws IOException {
        Ext2Entry entry;
        if (!this.fs.existFile(name) && !this.fs.isReadOnly()) {
            Ext2File file = this.fs.createFile(name);
            file.close();
        }
        if ((entry = this.fs.getEntry(name)) != null) {
            return entry;
        }
        throw new FileNotFoundException(name);
    }

    public void refresh() throws IOException {
    }

    public boolean removeEntry(String name) throws IOException {
        this.fs.removeFile(name);
        return true;
    }

    public void save() throws IOException {
        this.fs.flush();
        this.fs.setRemoveOnExit(false);
    }

    public void setCacheSize(int cacheSize) {
        this.fs.setCacheSize(cacheSize);
    }

    public synchronized void unlockEntry(Object locker) throws IOException {
        assert (locker instanceof Ext2Node);
    }

    private static class ArchiveEntryV3
    extends ArchiveEntry {
        Ext2File file;

        ArchiveEntryV3(Ext2File file) {
            this.file = file;
        }

        public String getName() {
            return this.file.getName();
        }

        public long getLength() throws IOException {
            return this.file.length();
        }

        public void close() throws IOException {
            this.file.close();
        }

        public void flush() throws IOException {
        }

        public int read(long pos, byte[] b, int off, int len) throws IOException {
            this.file.seek(pos);
            return this.file.read(b, off, len);
        }

        public void refresh() throws IOException {
        }

        public void setLength(long length) throws IOException {
            this.file.setLength(length);
        }

        public void write(long pos, byte[] b, int off, int len) throws IOException {
            this.file.seek(pos);
            this.file.write(b, off, len);
        }
    }
}

