/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.resource.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ExistenceType implements Enumerator
{
    CHECK_CACHE(0, "CHECK_CACHE", "CHECK_CACHE"),
    CHECK_DATABASE(1, "CHECK_DATABASE", "CHECK_DATABASE"),
    ASSUME_EXISTENCE(2, "ASSUME_EXISTENCE", "ASSUME_EXISTENCE"),
    ASSUME_NON_EXISTENCE(3, "ASSUME_NON_EXISTENCE", "ASSUME_NON_EXISTENCE");

    public static final int CHECK_CACHE_VALUE = 0;
    public static final int CHECK_DATABASE_VALUE = 1;
    public static final int ASSUME_EXISTENCE_VALUE = 2;
    public static final int ASSUME_NON_EXISTENCE_VALUE = 3;
    private static final ExistenceType[] VALUES_ARRAY;
    public static final List<ExistenceType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExistenceType[]{CHECK_CACHE, CHECK_DATABASE, ASSUME_EXISTENCE, ASSUME_NON_EXISTENCE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExistenceType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExistenceType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExistenceType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExistenceType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExistenceType get(int value) {
        switch (value) {
            case 0: {
                return CHECK_CACHE;
            }
            case 1: {
                return CHECK_DATABASE;
            }
            case 2: {
                return ASSUME_EXISTENCE;
            }
            case 3: {
                return ASSUME_NON_EXISTENCE;
            }
        }
        return null;
    }

    private ExistenceType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

