/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.resource.java.ConversionValueAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.NestableConversionValueAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.ObjectTypeConverterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SourceConversionValueAnnotation
extends SourceAnnotation<Member>
implements NestableConversionValueAnnotation {
    private final DeclarationAnnotationElementAdapter<String> dataValueDeclarationAdapter;
    private final AnnotationElementAdapter<String> dataValueAdapter;
    private String dataValue;
    private final DeclarationAnnotationElementAdapter<String> objectValueDeclarationAdapter;
    private final AnnotationElementAdapter<String> objectValueAdapter;
    private String objectValue;

    SourceConversionValueAnnotation(ObjectTypeConverterAnnotation parent, Member member, IndexedDeclarationAnnotationAdapter idaa) {
        super((JavaResourceNode)parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new MemberIndexedAnnotationAdapter(member, idaa));
        this.dataValueDeclarationAdapter = this.buildDataValueAdapter((DeclarationAnnotationAdapter)idaa);
        this.dataValueAdapter = this.buildAdapter(this.dataValueDeclarationAdapter);
        this.objectValueDeclarationAdapter = this.buildObjectValueAdapter((DeclarationAnnotationAdapter)idaa);
        this.objectValueAdapter = this.buildAdapter(this.objectValueDeclarationAdapter);
    }

    private AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter(this.member, daea);
    }

    private DeclarationAnnotationElementAdapter<String> buildDataValueAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)declarationAnnotationAdapter, (String)"dataValue", (boolean)false);
    }

    private DeclarationAnnotationElementAdapter<String> buildObjectValueAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)declarationAnnotationAdapter, (String)"objectValue", (boolean)false);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.ConversionValue";
    }

    public void initialize(CompilationUnit astRoot) {
        this.dataValue = this.buildDataValue(astRoot);
        this.objectValue = this.buildObjectValue(astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setDataValue(this.buildDataValue(astRoot));
        this.setObjectValue(this.buildObjectValue(astRoot));
    }

    public IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.dataValue);
        sb.append("=>");
        sb.append(this.objectValue);
    }

    @Override
    public String getDataValue() {
        return this.dataValue;
    }

    @Override
    public void setDataValue(String dataValue) {
        if (this.attributeValueHasNotChanged(this.dataValue, dataValue)) {
            return;
        }
        String old = this.dataValue;
        this.dataValue = dataValue;
        this.dataValueAdapter.setValue((Object)dataValue);
        this.firePropertyChanged("dataValue", old, dataValue);
    }

    private String buildDataValue(CompilationUnit astRoot) {
        return (String)this.dataValueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getDataValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.dataValueDeclarationAdapter, astRoot);
    }

    @Override
    public String getObjectValue() {
        return this.objectValue;
    }

    @Override
    public void setObjectValue(String objectValue) {
        if (this.attributeValueHasNotChanged(this.objectValue, objectValue)) {
            return;
        }
        String old = this.objectValue;
        this.objectValue = objectValue;
        this.objectValueAdapter.setValue((Object)objectValue);
        this.firePropertyChanged("objectValue", old, objectValue);
    }

    private String buildObjectValue(CompilationUnit astRoot) {
        return (String)this.objectValueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getObjectValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.objectValueDeclarationAdapter, astRoot);
    }

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        ConversionValueAnnotation oldConversionValue = (ConversionValueAnnotation)oldAnnotation;
        this.setDataValue(oldConversionValue.getDataValue());
        this.setObjectValue(oldConversionValue.getObjectValue());
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    static NestableConversionValueAnnotation createConversionValue(ObjectTypeConverterAnnotation parent, Member member, DeclarationAnnotationAdapter daa, int index) {
        return new SourceConversionValueAnnotation(parent, member, SourceConversionValueAnnotation.buildConversionValueAnnotationAdapter(daa, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildConversionValueAnnotationAdapter(DeclarationAnnotationAdapter daa, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(daa, "conversionValues", index, "org.eclipse.persistence.annotations.ConversionValue", false);
    }
}

