/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.eclipselink.core.resource.java.ChangeTrackingAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.ChangeTrackingType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceChangeTrackingAnnotation
extends SourceAnnotation<Type>
implements ChangeTrackingAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.ChangeTracking");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = SourceChangeTrackingAnnotation.buildValueAdapter();
    private final AnnotationElementAdapter<String> valueAdapter;
    private ChangeTrackingType value;

    public SourceChangeTrackingAnnotation(JavaResourcePersistentType parent, Type type) {
        super((JavaResourceNode)parent, (Member)type, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new ShortCircuitAnnotationElementAdapter((Member)type, VALUE_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.ChangeTracking";
    }

    public void initialize(CompilationUnit astRoot) {
        this.value = this.buildValue(astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setValue(this.buildValue(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append((Object)this.value);
    }

    @Override
    public ChangeTrackingType getValue() {
        return this.value;
    }

    @Override
    public void setValue(ChangeTrackingType value) {
        if (this.attributeValueHasNotChanged((Object)this.value, (Object)value)) {
            return;
        }
        ChangeTrackingType old = this.value;
        this.value = value;
        this.valueAdapter.setValue((Object)ChangeTrackingType.toJavaAnnotationValue(value));
        this.firePropertyChanged("value", (Object)old, (Object)value);
    }

    private ChangeTrackingType buildValue(CompilationUnit astRoot) {
        return ChangeTrackingType.fromJavaAnnotationValue(this.valueAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value", false);
    }
}

