/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.TypeStringExpressionConverter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.source.SourceNamedConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.BaseTypeConverterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceBaseTypeConverterAnnotation
extends SourceNamedConverterAnnotation
implements BaseTypeConverterAnnotation {
    final DeclarationAnnotationElementAdapter<String> dataTypeDeclarationAdapter = this.buildTypeAdapter(this.getDataTypeElementName());
    final AnnotationElementAdapter<String> dataTypeAdapter = new ShortCircuitAnnotationElementAdapter(this.member, this.dataTypeDeclarationAdapter);
    String dataType;
    final DeclarationAnnotationElementAdapter<String> objectTypeDeclarationAdapter = this.buildTypeAdapter(this.getObjectTypeElementName());
    final AnnotationElementAdapter<String> objectTypeAdapter = new ShortCircuitAnnotationElementAdapter(this.member, this.objectTypeDeclarationAdapter);
    String objectType;

    SourceBaseTypeConverterAnnotation(JavaResourcePersistentMember parent, Member member, DeclarationAnnotationAdapter daa) {
        super((JavaResourceNode)parent, member, daa);
    }

    private DeclarationAnnotationElementAdapter<String> buildTypeAdapter(String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter(this.daa, elementName, false, TypeStringExpressionConverter.instance());
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.dataType = this.buildDataType(astRoot);
        this.objectType = this.buildObjectType(astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setDataType(this.buildDataType(astRoot));
        this.setObjectType(this.buildObjectType(astRoot));
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String dataType) {
        if (this.attributeValueHasNotChanged(this.dataType, dataType)) {
            return;
        }
        String old = this.dataType;
        this.dataType = dataType;
        this.dataTypeAdapter.setValue((Object)dataType);
        this.firePropertyChanged("dataType", old, dataType);
    }

    private String buildDataType(CompilationUnit astRoot) {
        return (String)this.dataTypeAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getDataTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.dataTypeDeclarationAdapter, astRoot);
    }

    abstract String getDataTypeElementName();

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String objectType) {
        if (this.attributeValueHasNotChanged(this.objectType, objectType)) {
            return;
        }
        String old = this.objectType;
        this.objectType = objectType;
        this.objectTypeAdapter.setValue((Object)objectType);
        this.firePropertyChanged("objectType", old, objectType);
    }

    @Override
    public TextRange getObjectTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.objectTypeDeclarationAdapter, astRoot);
    }

    private String buildObjectType(CompilationUnit astRoot) {
        return (String)this.objectTypeAdapter.getValue(astRoot);
    }

    abstract String getObjectTypeElementName();
}

