/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.Policy;
import org.eclipse.ui.internal.navigator.dnd.NavigatorPluginDropAction;
import org.eclipse.ui.navigator.CommonDragAdapterAssistant;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorDnDService;
import org.eclipse.ui.part.PluginTransfer;

public final class CommonDragAdapter
extends DragSourceAdapter {
    private final INavigatorContentService contentService;
    private final ISelectionProvider provider;
    private CommonDragAdapterAssistant setDataAssistant;
    private List assistantsToUse;

    public CommonDragAdapter(INavigatorContentService aContentService, ISelectionProvider aProvider) {
        this.contentService = aContentService;
        this.provider = aProvider;
        this.assistantsToUse = new ArrayList();
    }

    public Transfer[] getSupportedDragTransfers() {
        CommonDragAdapterAssistant[] assistants = this.contentService.getDnDService().getCommonDragAssistants();
        LinkedHashSet<Object> supportedTypes = new LinkedHashSet<Object>();
        supportedTypes.add(PluginTransfer.getInstance());
        supportedTypes.add(LocalSelectionTransfer.getTransfer());
        Transfer[] transferTypes = null;
        int i = 0;
        while (i < assistants.length) {
            transferTypes = assistants[i].getSupportedTransferTypes();
            int j = 0;
            while (j < transferTypes.length) {
                if (transferTypes[j] != null) {
                    supportedTypes.add(transferTypes[j]);
                }
                ++j;
            }
            ++i;
        }
        Transfer[] transfers = supportedTypes.toArray(new Transfer[supportedTypes.size()]);
        return transfers;
    }

    public void dragStart(DragSourceEvent event) {
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDragAdapter.dragStart (begin): " + event);
        }
        try {
            Control control;
            DragSource dragSource = (DragSource)event.widget;
            if (Policy.DEBUG_DND) {
                System.out.println("CommonDragAdapter.dragStart source: " + dragSource);
            }
            if ((control = dragSource.getControl()) == control.getDisplay().getFocusControl()) {
                ISelection selection = this.provider.getSelection();
                this.assistantsToUse.clear();
                if (!selection.isEmpty()) {
                    LocalSelectionTransfer.getTransfer().setSelection(selection);
                    boolean doIt = false;
                    INavigatorDnDService dndService = this.contentService.getDnDService();
                    CommonDragAdapterAssistant[] assistants = dndService.getCommonDragAssistants();
                    if (assistants.length == 0) {
                        doIt = true;
                    }
                    int i = 0;
                    while (i < assistants.length) {
                        if (Policy.DEBUG_DND) {
                            System.out.println("CommonDragAdapter.dragStart assistant: " + assistants[i]);
                        }
                        event.doit = true;
                        assistants[i].dragStart(event, (IStructuredSelection)selection);
                        doIt |= event.doit;
                        if (event.doit) {
                            if (Policy.DEBUG_DND) {
                                System.out.println("CommonDragAdapter.dragStart assistant - event.doit == true");
                            }
                            this.assistantsToUse.add(assistants[i]);
                        }
                        ++i;
                    }
                    event.doit = doIt;
                } else {
                    event.doit = false;
                }
            } else {
                event.doit = false;
            }
        }
        catch (RuntimeException e) {
            NavigatorPlugin.logError(0, e.getMessage(), e);
        }
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDragAdapter.dragStart (end): doit=" + event.doit);
        }
    }

    public void dragSetData(DragSourceEvent event) {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDragAdapter.dragSetData: event" + event + " selection=" + selection);
        }
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            event.data = selection;
            if (Policy.DEBUG_DND) {
                System.out.println("CommonDragAdapter.dragSetData set LocalSelectionTransfer: " + event.data);
            }
        } else if (PluginTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = NavigatorPluginDropAction.createTransferData(this.contentService);
            if (Policy.DEBUG_DND) {
                System.out.println("CommonDragAdapter.dragSetData set PluginTransfer: " + event.data);
            }
        } else if (selection instanceof IStructuredSelection) {
            if (Policy.DEBUG_DND) {
                System.out.println("CommonDragAdapter.dragSetData looking for assistants");
            }
            int i = 0;
            int len = this.assistantsToUse.size();
            while (i < len) {
                CommonDragAdapterAssistant assistant = (CommonDragAdapterAssistant)this.assistantsToUse.get(i);
                if (Policy.DEBUG_DND) {
                    System.out.println("CommonDragAdapter.dragSetData assistant: " + assistant);
                }
                Transfer[] supportedTransferTypes = assistant.getSupportedTransferTypes();
                int j = 0;
                while (j < supportedTransferTypes.length) {
                    if (supportedTransferTypes[j].isSupportedType(event.dataType)) {
                        try {
                            if (Policy.DEBUG_DND) {
                                System.out.println("CommonDragAdapter.dragSetData supported xfer type");
                            }
                            if (assistant.setDragData(event, (IStructuredSelection)selection)) {
                                if (Policy.DEBUG_DND) {
                                    System.out.println("CommonDragAdapter.dragSetData set data " + event.data);
                                }
                                this.setDataAssistant = assistant;
                                return;
                            }
                        }
                        catch (RuntimeException re) {
                            NavigatorPlugin.logError(0, re.getMessage(), re);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (Policy.DEBUG_DND) {
                System.out.println("CommonDragAdapter.dragSetData FAILED no assistant handled it");
            }
            event.doit = false;
        } else {
            if (Policy.DEBUG_DND) {
                System.out.println("CommonDragAdapter.dragSetData FAILED can't identify transfer type");
            }
            event.doit = false;
        }
    }

    public void dragFinished(DragSourceEvent event) {
        if (Policy.DEBUG_DND) {
            System.out.println("CommonDragAdapter.dragFinished(): " + event);
        }
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (event.doit && selection instanceof IStructuredSelection && this.setDataAssistant != null) {
            this.setDataAssistant.dragFinished(event, (IStructuredSelection)selection);
        }
        this.setDataAssistant = null;
        LocalSelectionTransfer.getTransfer().setSelection(null);
    }
}

