/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.swt;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.NativePropertyListener;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.internal.databinding.swt.SWTObservableValueDecorator;
import org.eclipse.jface.internal.databinding.swt.WidgetListenerUtil;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public abstract class WidgetValueProperty
extends SimpleValueProperty
implements IWidgetValueProperty {
    private int[] changeEvents;
    private int[] staleEvents;

    protected WidgetValueProperty() {
        this(null, null);
    }

    protected WidgetValueProperty(int changeEvent) {
        this(new int[]{changeEvent}, null);
    }

    protected WidgetValueProperty(int[] changeEvents) {
        this(changeEvents, null);
    }

    public WidgetValueProperty(int[] changeEvents, int[] staleEvents) {
        this.changeEvents = changeEvents;
        this.staleEvents = staleEvents;
    }

    public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
        return this.changeEvents == null && this.staleEvents == null ? null : new WidgetListener((IProperty)this, listener);
    }

    public IObservableValue observe(Object source) {
        if (source instanceof Widget) {
            return this.observe((Widget)source);
        }
        return super.observe(source);
    }

    public IObservableValue observe(Realm realm, Object source) {
        return this.wrapObservable(super.observe(realm, source), (Widget)source);
    }

    protected ISWTObservableValue wrapObservable(IObservableValue observable, Widget widget) {
        return new SWTObservableValueDecorator(observable, widget);
    }

    public ISWTObservableValue observe(Widget widget) {
        return (ISWTObservableValue)this.observe(SWTObservables.getRealm(widget.getDisplay()), widget);
    }

    public ISWTObservableValue observeDelayed(int delay, Widget widget) {
        return SWTObservables.observeDelayedValue(delay, this.observe(widget));
    }

    public abstract /* synthetic */ Object getValueType();

    private class WidgetListener
    extends NativePropertyListener
    implements Listener {
        protected WidgetListener(IProperty property, ISimplePropertyListener listener) {
            super(property, listener);
        }

        public void handleEvent(Event event) {
            int i;
            if (WidgetValueProperty.this.staleEvents != null) {
                i = 0;
                while (i < WidgetValueProperty.this.staleEvents.length) {
                    if (event.type == WidgetValueProperty.this.staleEvents[i]) {
                        this.fireStale(event.widget);
                        break;
                    }
                    ++i;
                }
            }
            if (WidgetValueProperty.this.changeEvents != null) {
                i = 0;
                while (i < WidgetValueProperty.this.changeEvents.length) {
                    if (event.type == WidgetValueProperty.this.changeEvents[i]) {
                        this.fireChange(event.widget, null);
                        break;
                    }
                    ++i;
                }
            }
        }

        protected void doAddTo(Object source) {
            int event;
            int i;
            Widget widget = (Widget)source;
            if (WidgetValueProperty.this.changeEvents != null) {
                i = 0;
                while (i < WidgetValueProperty.this.changeEvents.length) {
                    event = WidgetValueProperty.this.changeEvents[i];
                    if (event != 0) {
                        WidgetListenerUtil.asyncAddListener(widget, event, this);
                    }
                    ++i;
                }
            }
            if (WidgetValueProperty.this.staleEvents != null) {
                i = 0;
                while (i < WidgetValueProperty.this.staleEvents.length) {
                    event = WidgetValueProperty.this.staleEvents[i];
                    if (event != 0) {
                        WidgetListenerUtil.asyncAddListener(widget, event, this);
                    }
                    ++i;
                }
            }
        }

        protected void doRemoveFrom(Object source) {
            Widget widget = (Widget)source;
            if (!widget.isDisposed()) {
                int event;
                int i;
                if (WidgetValueProperty.this.changeEvents != null) {
                    i = 0;
                    while (i < WidgetValueProperty.this.changeEvents.length) {
                        event = WidgetValueProperty.this.changeEvents[i];
                        if (event != 0) {
                            WidgetListenerUtil.asyncRemoveListener(widget, event, this);
                        }
                        ++i;
                    }
                }
                if (WidgetValueProperty.this.staleEvents != null) {
                    i = 0;
                    while (i < WidgetValueProperty.this.staleEvents.length) {
                        event = WidgetValueProperty.this.staleEvents[i];
                        if (event != 0) {
                            WidgetListenerUtil.asyncRemoveListener(widget, event, this);
                        }
                        ++i;
                    }
                }
            }
        }
    }
}

