/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import java.util.Iterator;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.commentelement.CommentElementAdapter;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.document.NodeContainer;
import org.eclipse.wst.xml.core.internal.document.NodeListImpl;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionUtil;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.parser.XMLSourceParser;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class ElementImpl
extends NodeContainer
implements IDOMElement {
    private static final byte FLAG_COMMENT = 1;
    private static final byte FLAG_EMPTY = 2;
    private static final byte FLAG_JSP = 4;
    private byte fTagFlags = 0;
    NodeListImpl attrNodes = null;
    private IStructuredDocumentRegion endStructuredDocumentRegion = null;
    private char[] fTagName = null;
    private char[] fNamespaceURI = null;
    static /* synthetic */ Class class$0;

    protected ElementImpl() {
    }

    protected ElementImpl(ElementImpl that) {
        super(that);
        if (that != null) {
            this.fTagName = that.fTagName;
            this.fTagFlags = that.fTagFlags;
            that.cloneAttributes(this);
        }
    }

    protected void addEndTag(Element endTag) {
        if (endTag == null) {
            return;
        }
        if (this.hasEndTag()) {
            return;
        }
        ElementImpl end = (ElementImpl)endTag;
        IStructuredDocumentRegion flatNode = end.getEndStructuredDocumentRegion();
        if (flatNode == null) {
            return;
        }
        end.setEndStructuredDocumentRegion(null);
        this.setEndStructuredDocumentRegion(flatNode);
    }

    public Attr appendAttributeNode(Attr newAttr) {
        if (newAttr == null) {
            return null;
        }
        AttrImpl attr = (AttrImpl)newAttr;
        if (attr.getOwnerElement() != null) {
            return null;
        }
        if (!this.isDataEditable()) {
            throw new DOMException(7, new String());
        }
        if (this.attrNodes == null) {
            this.attrNodes = new NodeListImpl();
        }
        this.attrNodes.appendNode(attr);
        attr.setOwnerElement(this);
        this.notifyAttrReplaced(attr, null);
        return attr;
    }

    protected void cloneAttributes(Element newOwner) {
        if (newOwner == null || newOwner == this) {
            return;
        }
        ElementImpl element = (ElementImpl)newOwner;
        element.removeAttributes();
        if (this.attrNodes == null) {
            return;
        }
        int length = this.attrNodes.getLength();
        int i = 0;
        while (i < length) {
            Attr cloned;
            Node node = this.attrNodes.item(i);
            if (node != null && (cloned = (Attr)node.cloneNode(false)) != null) {
                element.appendAttributeNode(cloned);
            }
            ++i;
        }
    }

    public Node cloneNode(boolean deep) {
        ElementImpl cloned = new ElementImpl(this);
        if (deep) {
            this.cloneChildNodes(cloned, deep);
        }
        this.notifyUserDataHandlers((short)1, cloned);
        return cloned;
    }

    public String getAttribute(String name) {
        Attr attr = this.getAttributeNode(name);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public Attr getAttributeNode(String name) {
        if (name == null) {
            return null;
        }
        if (this.attrNodes == null) {
            return null;
        }
        int length = this.attrNodes.getLength();
        int i = 0;
        while (i < length) {
            AttrImpl attr = (AttrImpl)this.attrNodes.item(i);
            if (attr != null && attr.matchName(name)) {
                return attr;
            }
            ++i;
        }
        return null;
    }

    public Attr getAttributeNodeNS(String uri, String name) {
        if (name == null) {
            return null;
        }
        if (this.attrNodes == null) {
            return null;
        }
        int length = this.attrNodes.getLength();
        int i = 0;
        while (i < length) {
            String localName;
            AttrImpl attr = (AttrImpl)this.attrNodes.item(i);
            if (attr != null && (localName = attr.getLocalName()) != null && localName.equals(name)) {
                String nsURI = attr.getNamespaceURI();
                if (!(uri == null ? nsURI != null : nsURI == null || !nsURI.equals(uri))) {
                    return attr;
                }
            }
            ++i;
        }
        return null;
    }

    public String getAttributeNS(String uri, String name) {
        Attr attr = this.getAttributeNodeNS(uri, name);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public NamedNodeMap getAttributes() {
        return new Attributes();
    }

    protected CMElementDeclaration getDeclaration() {
        Document document = this.getOwnerDocument();
        if (document == null) {
            return null;
        }
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery(document);
        if (modelQuery == null) {
            return null;
        }
        return modelQuery.getCMElementDeclaration(this);
    }

    public NodeList getElementsByTagName(String tagName) {
        if (tagName == null) {
            return new NodeListImpl();
        }
        DocumentImpl document = (DocumentImpl)this.getOwnerDocument();
        if (document == null) {
            return new NodeListImpl();
        }
        NodeIterator it = document.createNodeIterator(this, -1, null, false);
        if (it == null) {
            return new NodeListImpl();
        }
        NodeListImpl elements = new NodeListImpl();
        if (tagName.length() == 1 && tagName.charAt(0) == '*') {
            tagName = null;
        }
        Node node = it.nextNode();
        while (node != null) {
            ElementImpl element;
            if (node.getNodeType() == 1 && (tagName == null || (element = (ElementImpl)node).matchTagName(tagName))) {
                elements.appendNode(node);
            }
            node = it.nextNode();
        }
        return elements;
    }

    public NodeList getElementsByTagNameNS(String uri, String tagName) {
        if (tagName == null) {
            return new NodeListImpl();
        }
        DocumentImpl document = (DocumentImpl)this.getOwnerDocument();
        if (document == null) {
            return new NodeListImpl();
        }
        NodeIterator it = document.createNodeIterator(this, -1, null, false);
        if (it == null) {
            return new NodeListImpl();
        }
        NodeListImpl elements = new NodeListImpl();
        if (uri != null && uri.length() == 1 && uri.charAt(0) == '*') {
            uri = null;
        }
        if (tagName.length() == 1 && tagName.charAt(0) == '*') {
            tagName = null;
        }
        Node node = it.nextNode();
        while (node != null) {
            if (node.getNodeType() == 1) {
                String nsURI;
                String localName;
                ElementImpl element = (ElementImpl)node;
                if ((tagName == null || (localName = element.getLocalName()) != null && localName.equals(tagName)) && (uri == null || (nsURI = element.getNamespaceURI()) != null && nsURI.equals(uri))) {
                    elements.appendNode(element);
                }
            }
            node = it.nextNode();
        }
        return elements;
    }

    public int getEndOffset() {
        if (this.endStructuredDocumentRegion != null) {
            return this.endStructuredDocumentRegion.getEnd();
        }
        return super.getEndOffset();
    }

    public int getEndStartOffset() {
        if (this.endStructuredDocumentRegion != null) {
            return this.endStructuredDocumentRegion.getStart();
        }
        return super.getEndOffset();
    }

    public IStructuredDocumentRegion getEndStructuredDocumentRegion() {
        return this.endStructuredDocumentRegion;
    }

    public String getEndTagName() {
        if (this.endStructuredDocumentRegion == null) {
            return null;
        }
        ITextRegionList regions = this.endStructuredDocumentRegion.getRegions();
        if (regions == null) {
            return null;
        }
        Iterator e = regions.iterator();
        while (e.hasNext()) {
            ITextRegion region = (ITextRegion)e.next();
            String regionType = region.getType();
            if (regionType != "XML_TAG_NAME" && !this.isNestedEndTag(regionType)) continue;
            return this.endStructuredDocumentRegion.getText(region);
        }
        return null;
    }

    protected boolean isNestedEndTag(String regionType) {
        boolean result = false;
        return result;
    }

    public IStructuredDocumentRegion getFirstStructuredDocumentRegion() {
        IStructuredDocumentRegion flatNode = this.getStructuredDocumentRegion();
        if (flatNode != null) {
            return StructuredDocumentRegionUtil.getStructuredDocumentRegion(flatNode);
        }
        return StructuredDocumentRegionUtil.getStructuredDocumentRegion(this.endStructuredDocumentRegion);
    }

    public IStructuredDocumentRegion getLastStructuredDocumentRegion() {
        if (this.endStructuredDocumentRegion != null) {
            return StructuredDocumentRegionUtil.getStructuredDocumentRegion(this.endStructuredDocumentRegion);
        }
        return StructuredDocumentRegionUtil.getStructuredDocumentRegion(this.getStructuredDocumentRegion());
    }

    public String getLocalName() {
        if (this.fTagName == null) {
            return null;
        }
        int index = this.indexOf(this.fTagName, ':');
        if (index < 0) {
            return new String(this.fTagName);
        }
        return new String(this.fTagName, index + 1, this.fTagName.length - index - 1);
    }

    public String getNamespaceURI() {
        String nsAttrName = null;
        String prefix = this.getPrefix();
        nsAttrName = prefix != null && prefix.length() > 0 ? "xmlns:" + prefix : "xmlns";
        Node node = this;
        while (node != null) {
            if (node.getNodeType() != 1) break;
            Element element = node;
            Attr attr = element.getAttributeNode(nsAttrName);
            if (attr != null) {
                return attr.getValue();
            }
            node = node.getParentNode();
        }
        if (this.fNamespaceURI == null) {
            return null;
        }
        return new String(this.fNamespaceURI);
    }

    public String getNodeName() {
        return this.getTagName();
    }

    public short getNodeType() {
        return 1;
    }

    public String getPrefix() {
        if (this.fTagName == null) {
            return null;
        }
        int index = this.indexOf(this.fTagName, ':');
        if (index <= 0) {
            return null;
        }
        if (this.fTagName[0] == '<') {
            return null;
        }
        return new String(this.fTagName, 0, index);
    }

    public int getStartEndOffset() {
        IStructuredDocumentRegion flatNode = this.getStructuredDocumentRegion();
        if (flatNode != null) {
            return flatNode.getEnd();
        }
        return super.getStartOffset();
    }

    public int getStartOffset() {
        if (this.getStartStructuredDocumentRegion() == null && this.endStructuredDocumentRegion != null && !this.hasChildNodes()) {
            return this.endStructuredDocumentRegion.getStart();
        }
        return super.getStartOffset();
    }

    public IStructuredDocumentRegion getStartStructuredDocumentRegion() {
        return this.getStructuredDocumentRegion();
    }

    public String getTagName() {
        if (this.fTagName == null) {
            return new String();
        }
        return new String(this.fTagName);
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    public boolean hasAttributeNS(String uri, String name) {
        return this.getAttributeNodeNS(uri, name) != null;
    }

    public boolean hasAttributes() {
        return this.attrNodes != null && this.attrNodes.getLength() > 0;
    }

    public boolean hasEndTag() {
        return this.endStructuredDocumentRegion != null;
    }

    protected final boolean hasPrefix() {
        if (this.fTagName == null || this.fTagName.length == 0) {
            return false;
        }
        return this.indexOf(this.fTagName, ':') > 0 && this.fTagName[0] != '<';
    }

    public boolean hasStartTag() {
        return this.getStructuredDocumentRegion() != null;
    }

    protected final boolean ignoreCase() {
        DocumentImpl document = (DocumentImpl)this.getOwnerDocument();
        if (document != null && document.ignoreCase()) {
            return !this.hasPrefix();
        }
        return false;
    }

    private int indexOf(char[] array, char c) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected Attr insertAttributeNode(Attr newAttr, int index) {
        if (newAttr == null) {
            return null;
        }
        AttrImpl attr = (AttrImpl)newAttr;
        if (attr.getOwnerElement() != null) {
            return null;
        }
        if (this.attrNodes == null) {
            this.attrNodes = new NodeListImpl();
        }
        this.attrNodes.insertNode(attr, index);
        attr.setOwnerElement(this);
        this.notifyAttrReplaced(attr, null);
        return attr;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (newChild == null) {
            return null;
        }
        if (!this.isContainer()) {
            throw new DOMException(3, new String());
        }
        if (newChild.getNodeType() != 3 && (this.isJSPContainer() || this.isCDATAContainer())) {
            throw new DOMException(3, new String());
        }
        return super.insertBefore(newChild, refChild);
    }

    protected boolean isCDATAContainer() {
        IDOMModel model = this.getModel();
        if (model == null) {
            return false;
        }
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (structuredDocument == null || this.fTagName == null) {
            return false;
        }
        RegionParser parser = structuredDocument.getParser();
        if (parser == null || !(parser instanceof XMLSourceParser)) {
            return false;
        }
        return ((XMLSourceParser)parser).getBlockMarker(new String(this.fTagName)) != null;
    }

    public boolean isClosed() {
        IStructuredDocumentRegion flatNode = null;
        if (this.isEmptyTag() || !this.isContainer()) {
            flatNode = this.getStructuredDocumentRegion();
            if (flatNode == null) {
                return true;
            }
        } else {
            flatNode = this.getEndStructuredDocumentRegion();
            if (flatNode == null) {
                return false;
            }
        }
        String regionType = StructuredDocumentRegionUtil.getLastRegionType(flatNode);
        if (this.isCommentTag()) {
            return this.isNestedClosedComment(regionType) || regionType == "XML_COMMENT_CLOSE";
        }
        if (this.isJSPTag()) {
            return this.isNestedClosed(regionType);
        }
        return regionType == "XML_TAG_CLOSE" || regionType == "XML_EMPTY_TAG_CLOSE" || regionType == "XML_DECLARATION_CLOSE";
    }

    protected boolean isNestedClosed(String regionType) {
        boolean result = false;
        return result;
    }

    protected boolean isNestedClosedComment(String regionType) {
        boolean result = false;
        return result;
    }

    public final boolean isCommentTag() {
        return (this.fTagFlags & 1) != 0;
    }

    public boolean isContainer() {
        if (this.isCommentTag()) {
            CommentElementAdapter adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.commentelement.CommentElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (CommentElementAdapter)this.getAdapterFor(clazz)) != null) {
                return adapter.isContainer();
            }
            return this.getDeclaration() == null;
        }
        if (this.isJSPTag()) {
            return this.matchTagName("jsp:scriptlet") || this.matchTagName("jsp:declaration") || this.matchTagName("jsp:expression");
        }
        if (!this.isXMLTag()) {
            CMElementDeclaration decl = this.getDeclaration();
            if (decl == null) {
                return false;
            }
            return decl.getContentType() != 1;
        }
        return true;
    }

    public boolean isEmptyTag() {
        if (this.isJSPTag()) {
            return false;
        }
        if (this.isCommentTag()) {
            return false;
        }
        if (!this.isXMLTag()) {
            return false;
        }
        return (this.fTagFlags & 2) != 0;
    }

    public boolean isEndTag() {
        return this.hasEndTag() && !this.hasStartTag() && !this.hasChildNodes();
    }

    public boolean isGlobalTag() {
        return !this.hasPrefix();
    }

    public boolean isImplicitTag() {
        if (this.hasStartTag() || this.hasEndTag()) {
            return false;
        }
        return this.getContainerDocument() != null;
    }

    public boolean isJSPContainer() {
        return this.isJSPTag() && !this.isCommentTag() && this.isContainer();
    }

    public final boolean isJSPTag() {
        return (this.fTagFlags & 4) != 0;
    }

    public boolean isStartTagClosed() {
        IStructuredDocumentRegion flatNode = this.getStructuredDocumentRegion();
        if (flatNode == null) {
            return true;
        }
        String regionType = StructuredDocumentRegionUtil.getLastRegionType(flatNode);
        if (this.isCommentTag()) {
            return this.isNestedClosedComment(regionType) || regionType == "XML_COMMENT_CLOSE";
        }
        if (this.isJSPTag()) {
            if (this.isContainer()) {
                return true;
            }
            return this.isClosedNestedDirective(regionType);
        }
        return regionType == "XML_TAG_CLOSE" || regionType == "XML_EMPTY_TAG_CLOSE" || regionType == "XML_DECLARATION_CLOSE";
    }

    protected boolean isClosedNestedDirective(String regionType) {
        boolean result = false;
        return result;
    }

    public final boolean isXMLTag() {
        if (this.isJSPTag()) {
            return false;
        }
        if (this.isCommentTag()) {
            return false;
        }
        DocumentImpl document = (DocumentImpl)this.getOwnerDocument();
        if (document != null && !document.isXMLType()) {
            return this.hasPrefix();
        }
        return true;
    }

    protected boolean matchEndTag(Element element) {
        if (element == null) {
            return false;
        }
        ElementImpl impl = (ElementImpl)element;
        if (this.isJSPTag() && !this.isCommentTag()) {
            return impl.isJSPTag() && !impl.isCommentTag();
        }
        return this.matchTagName(element.getTagName());
    }

    public boolean matchTagName(String tagName) {
        if (tagName == null) {
            return this.fTagName == null;
        }
        if (this.fTagName == null) {
            return false;
        }
        if (this.fTagName.length != tagName.length()) {
            return false;
        }
        String stringName = new String(this.fTagName);
        if (!this.ignoreCase()) {
            return stringName.equals(tagName);
        }
        return stringName.equalsIgnoreCase(tagName);
    }

    protected void notifyAttrReplaced(Attr newAttr, Attr oldAttr) {
        DocumentImpl document = (DocumentImpl)this.getContainerDocument();
        if (document == null) {
            return;
        }
        DOMModelImpl model = (DOMModelImpl)document.getModel();
        if (model == null) {
            return;
        }
        model.attrReplaced(this, newAttr, oldAttr);
    }

    public void notifyEndTagChanged() {
        DocumentImpl document = (DocumentImpl)this.getContainerDocument();
        if (document == null) {
            return;
        }
        DOMModelImpl model = (DOMModelImpl)document.getModel();
        if (model == null) {
            return;
        }
        model.endTagChanged(this);
    }

    public void notifyStartTagChanged() {
        DocumentImpl document = (DocumentImpl)this.getContainerDocument();
        if (document == null) {
            return;
        }
        DOMModelImpl model = (DOMModelImpl)document.getModel();
        if (model == null) {
            return;
        }
        model.startTagChanged(this);
    }

    public boolean preferEmptyTag() {
        if (this.hasChildNodes()) {
            return false;
        }
        if (this.isJSPTag()) {
            return false;
        }
        if (this.isCommentTag()) {
            return false;
        }
        if (!this.isXMLTag()) {
            return false;
        }
        CMElementDeclaration decl = this.getDeclaration();
        if (decl == null) {
            return false;
        }
        return decl.getContentType() == 1;
    }

    public void removeAttribute(String name) throws DOMException {
        this.removeAttributeNode(name);
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (oldAttr == null) {
            return null;
        }
        if (!this.isDataEditable()) {
            throw new DOMException(7, new String());
        }
        if (this.attrNodes == null) {
            throw new DOMException(8, new String());
        }
        int length = this.attrNodes.getLength();
        int i = 0;
        while (i < length) {
            AttrImpl attr = (AttrImpl)this.attrNodes.item(i);
            if (attr == oldAttr) {
                this.attrNodes.removeNode(i);
                attr.setOwnerElement(null);
                this.notifyAttrReplaced(null, attr);
                return attr;
            }
            ++i;
        }
        throw new DOMException(8, new String());
    }

    public Attr removeAttributeNode(String name) {
        if (name == null) {
            return null;
        }
        if (this.attrNodes == null) {
            return null;
        }
        if (!this.isDataEditable()) {
            throw new DOMException(7, new String());
        }
        int length = this.attrNodes.getLength();
        int i = 0;
        while (i < length) {
            AttrImpl attr = (AttrImpl)this.attrNodes.item(i);
            if (attr != null && attr.matchName(name)) {
                this.attrNodes.removeNode(i);
                attr.setOwnerElement(null);
                this.notifyAttrReplaced(null, attr);
                return attr;
            }
            ++i;
        }
        return null;
    }

    public Attr removeAttributeNodeNS(String uri, String name) {
        if (name == null) {
            return null;
        }
        if (this.attrNodes == null) {
            return null;
        }
        if (!this.isDataEditable()) {
            throw new DOMException(7, new String());
        }
        int length = this.attrNodes.getLength();
        int i = 0;
        while (i < length) {
            String localName;
            AttrImpl attr = (AttrImpl)this.attrNodes.item(i);
            if (attr != null && (localName = attr.getLocalName()) != null && localName.equals(name)) {
                String nsURI = attr.getNamespaceURI();
                if (!(uri == null ? nsURI != null : nsURI == null || !nsURI.equals(uri))) {
                    this.attrNodes.removeNode(i);
                    attr.setOwnerElement(null);
                    this.notifyAttrReplaced(null, attr);
                    return attr;
                }
            }
            ++i;
        }
        return null;
    }

    public void removeAttributeNS(String uri, String name) throws DOMException {
        this.removeAttributeNodeNS(uri, name);
    }

    public void removeAttributes() {
        if (this.attrNodes == null) {
            return;
        }
        if (!this.isDataEditable()) {
            throw new DOMException(7, new String());
        }
        int length = this.attrNodes.getLength();
        int i = 0;
        while (i < length) {
            AttrImpl attr = (AttrImpl)this.attrNodes.item(i);
            if (attr != null) {
                attr.setOwnerElement(null);
                this.notifyAttrReplaced(null, attr);
            }
            ++i;
        }
        this.attrNodes = null;
    }

    protected Element removeEndTag() {
        if (!this.hasEndTag()) {
            return null;
        }
        NodeListImpl attrNodes = this.attrNodes;
        this.attrNodes = null;
        ElementImpl end = (ElementImpl)this.cloneNode(false);
        this.attrNodes = attrNodes;
        if (end == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = this.getEndStructuredDocumentRegion();
        if (flatNode == null) {
            return null;
        }
        this.setEndStructuredDocumentRegion(null);
        end.setEndStructuredDocumentRegion(flatNode);
        return end;
    }

    protected void removeStartTag() {
        this.removeAttributes();
    }

    void resetStructuredDocumentRegions() {
        if (this.attrNodes != null) {
            int length = this.attrNodes.getLength();
            int i = 0;
            while (i < length) {
                AttrImpl attr = (AttrImpl)this.attrNodes.item(i);
                if (attr != null) {
                    attr.resetRegions();
                }
                ++i;
            }
        }
        super.resetStructuredDocumentRegions();
        this.endStructuredDocumentRegion = null;
    }

    public void setAttribute(String name, String value) throws DOMException {
        if (name == null) {
            return;
        }
        if (!this.isDataEditable()) {
            throw new DOMException(7, new String());
        }
        Attr attr = this.getAttributeNode(name);
        if (attr != null) {
            attr.setValue(value);
            return;
        }
        Document doc = this.getOwnerDocument();
        if (doc == null) {
            return;
        }
        attr = doc.createAttribute(name);
        if (attr == null) {
            return;
        }
        attr.setValue(value);
        this.appendAttributeNode(attr);
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        if (newAttr == null) {
            return null;
        }
        if (!this.isDataEditable()) {
            throw new DOMException(7, new String());
        }
        AttrImpl attr = (AttrImpl)newAttr;
        Element owner = attr.getOwnerElement();
        if (owner != null) {
            if (owner == this) {
                return null;
            }
            throw new DOMException(10, new String());
        }
        Attr oldAttr = this.removeAttributeNode(newAttr.getName());
        this.appendAttributeNode(attr);
        return oldAttr;
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        if (newAttr == null) {
            return null;
        }
        if (!this.isDataEditable()) {
            throw new DOMException(7, new String());
        }
        AttrImpl attr = (AttrImpl)newAttr;
        Element owner = attr.getOwnerElement();
        if (owner != null) {
            if (owner == this) {
                return null;
            }
            throw new DOMException(10, new String());
        }
        String name = newAttr.getLocalName();
        String uri = newAttr.getNamespaceURI();
        Attr oldAttr = this.removeAttributeNodeNS(uri, name);
        this.appendAttributeNode(attr);
        return oldAttr;
    }

    public void setAttributeNS(String uri, String qualifiedName, String value) throws DOMException {
        if (qualifiedName == null) {
            return;
        }
        if (!this.isDataEditable()) {
            throw new DOMException(7, new String());
        }
        int index = qualifiedName.indexOf(58);
        String localName = index != -1 ? qualifiedName.substring(index + 1) : qualifiedName;
        Attr attr = this.getAttributeNodeNS(uri, localName);
        if (attr != null) {
            attr.setValue(value);
        } else {
            Document doc = this.getOwnerDocument();
            if (doc != null && (attr = doc.createAttributeNS(uri, qualifiedName)) != null) {
                attr.setValue(value);
                this.appendAttributeNode(attr);
            }
        }
    }

    public void setCommentTag(boolean isCommentTag) {
        IDOMNode parent = (IDOMNode)this.getParentNode();
        if (parent != null && !parent.isChildEditable()) {
            throw new DOMException(7, new String());
        }
        this.fTagFlags = isCommentTag ? (byte)(this.fTagFlags | 1) : (byte)(this.fTagFlags & 0xFFFFFFFE);
    }

    public void setEmptyTag(boolean isEmptyTag) {
        IDOMNode parent = (IDOMNode)this.getParentNode();
        if (parent != null && !parent.isChildEditable()) {
            throw new DOMException(7, new String());
        }
        this.fTagFlags = isEmptyTag ? (byte)(this.fTagFlags | 2) : (byte)(this.fTagFlags & 0xFFFFFFFD);
    }

    void setEndStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        this.endStructuredDocumentRegion = flatNode;
        NodeContainer parent = (NodeContainer)this.getParentNode();
        if (parent != null) {
            parent.syncChildEditableState(this);
        }
    }

    public void setJSPTag(boolean isJSPTag) {
        IDOMNode parent = (IDOMNode)this.getParentNode();
        if (parent != null && !parent.isChildEditable()) {
            throw new DOMException(7, new String());
        }
        this.fTagFlags = isJSPTag ? (byte)(this.fTagFlags | 4) : (byte)(this.fTagFlags & 0xFFFFFFFB);
    }

    protected void setNamespaceURI(String namespaceURI) {
        this.fNamespaceURI = (char[])(namespaceURI == null ? null : namespaceURI.toCharArray());
    }

    protected void setOwnerDocument(Document ownerDocument, boolean deep) {
        super.setOwnerDocument(ownerDocument, deep);
        if (this.attrNodes == null) {
            return;
        }
        int length = this.attrNodes.getLength();
        int i = 0;
        while (i < length) {
            AttrImpl attr = (AttrImpl)this.attrNodes.item(i);
            if (attr != null) {
                attr.setOwnerDocument(ownerDocument);
            }
            ++i;
        }
    }

    public void setPrefix(String prefix) throws DOMException {
        IDOMNode parent = (IDOMNode)this.getParentNode();
        if (parent != null && !parent.isChildEditable()) {
            throw new DOMException(7, new String());
        }
        int prefixLength = prefix != null ? prefix.length() : 0;
        String localName = this.getLocalName();
        if (prefixLength == 0) {
            if (localName == null || localName.length() == 0) {
                return;
            }
            this.setTagName(localName);
        } else {
            int localLength = localName != null ? localName.length() : 0;
            StringBuffer buffer = new StringBuffer(prefixLength + 1 + localLength);
            buffer.append(prefix);
            buffer.append(':');
            if (localName != null) {
                buffer.append(localName);
            }
            this.setTagName(buffer.toString());
        }
        boolean changeEndTag = this.hasEndTag();
        this.notifyStartTagChanged();
        if (changeEndTag) {
            this.notifyEndTagChanged();
        }
    }

    void setStartStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        this.setStructuredDocumentRegion(flatNode);
    }

    protected void setTagName(String tagName) {
        this.fTagName = tagName.toCharArray();
    }

    public String toString() {
        IStructuredDocumentRegion endStructuredDocumentRegion;
        IStructuredDocumentRegion startStructuredDocumentRegion;
        StringBuffer buffer = new StringBuffer();
        String tagName = this.getTagName();
        if (this.hasStartTag()) {
            buffer.append(tagName);
        }
        if (this.isEmptyTag()) {
            buffer.append('/');
        }
        if (this.hasEndTag()) {
            buffer.append('/');
            buffer.append(tagName);
        }
        if (buffer.length() == 0) {
            buffer.append(tagName);
        }
        if ((startStructuredDocumentRegion = this.getStartStructuredDocumentRegion()) != null) {
            buffer.append('@');
            buffer.append(startStructuredDocumentRegion.toString());
        }
        if ((endStructuredDocumentRegion = this.getEndStructuredDocumentRegion()) != null) {
            buffer.append('@');
            buffer.append(endStructuredDocumentRegion.toString());
        }
        return buffer.toString();
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new DOMException(9, "Not supported in this version");
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new DOMException(9, "Not supported in this version");
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new DOMException(9, "Not supported in this version");
    }

    private class Attributes
    implements NamedNodeMap {
        Attributes() {
        }

        public int getLength() {
            if (ElementImpl.this.attrNodes == null) {
                return 0;
            }
            return ElementImpl.this.attrNodes.getLength();
        }

        public Node getNamedItem(String name) {
            return ElementImpl.this.getAttributeNode(name);
        }

        public Node getNamedItemNS(String uri, String name) {
            return ElementImpl.this.getAttributeNodeNS(uri, name);
        }

        public Node item(int index) {
            if (ElementImpl.this.attrNodes == null) {
                return null;
            }
            return ElementImpl.this.attrNodes.item(index);
        }

        public Node removeNamedItem(String name) throws DOMException {
            return ElementImpl.this.removeAttributeNode(name);
        }

        public Node removeNamedItemNS(String uri, String name) throws DOMException {
            return ElementImpl.this.removeAttributeNodeNS(uri, name);
        }

        public Node setNamedItem(Node arg) throws DOMException {
            return ElementImpl.this.setAttributeNode((AttrImpl)arg);
        }

        public Node setNamedItemNS(Node arg) throws DOMException {
            return ElementImpl.this.setAttributeNodeNS((AttrImpl)arg);
        }
    }
}

