/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import java.util.Iterator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionUtil;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class CDATASectionImpl
extends TextImpl
implements CDATASection {
    protected CDATASectionImpl() {
    }

    protected CDATASectionImpl(CDATASectionImpl that) {
        super(that);
    }

    public Node cloneNode(boolean deep) {
        CDATASectionImpl cloned = new CDATASectionImpl(this);
        this.notifyUserDataHandlers((short)1, cloned);
        return cloned;
    }

    public String getData() throws DOMException {
        char[] data = this.getCharacterData();
        if (data == null) {
            String sdata = this.getData(this.getStructuredDocumentRegion());
            if (sdata != null) {
                return sdata;
            }
            return new String();
        }
        return new String(data);
    }

    private String getData(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return null;
        }
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return null;
        }
        ITextRegion contentRegion = null;
        StringBuffer buffer = null;
        Iterator e = regions.iterator();
        while (e.hasNext()) {
            ITextRegion region = (ITextRegion)e.next();
            String regionType = region.getType();
            if (regionType == "XML_CDATA_OPEN" || regionType == "XML_CDATA_CLOSE") continue;
            if (contentRegion == null) {
                contentRegion = region;
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuffer(flatNode.getText(contentRegion));
            }
            buffer.append(flatNode.getText(region));
        }
        if (buffer != null) {
            return buffer.toString();
        }
        if (contentRegion != null) {
            return flatNode.getText(contentRegion);
        }
        return null;
    }

    public String getNodeName() {
        return "#cdata-section";
    }

    public short getNodeType() {
        return 4;
    }

    public boolean isClosed() {
        IStructuredDocumentRegion flatNode = this.getStructuredDocumentRegion();
        if (flatNode == null) {
            return true;
        }
        String regionType = StructuredDocumentRegionUtil.getLastRegionType(flatNode);
        return regionType == "XML_CDATA_CLOSE";
    }
}

