/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal.vendor;

import java.util.ArrayList;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.jpt.db.internal.vendor.AbstractVendor;
import org.eclipse.jpt.db.internal.vendor.CatalogStrategy;
import org.eclipse.jpt.db.internal.vendor.FoldingStrategy;
import org.eclipse.jpt.db.internal.vendor.NonFoldingStrategy;
import org.eclipse.jpt.db.internal.vendor.SimpleCatalogStrategy;
import org.eclipse.jpt.db.internal.vendor.Vendor;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SQLServer
extends AbstractVendor {
    private static final Vendor INSTANCE = new SQLServer();
    private static final String MASTER_CATALOG_IDENTIFIER = "master";
    private static final String DEFAULT_SCHEMA_NAME = "dbo";
    private static final char[] EXTENDED_NORMAL_NAME_START_CHARACTERS = new char[]{'_', '@', '#'};
    private static final char[] EXTENDED_NORMAL_NAME_PART_CHARACTERS = new char[]{'$'};

    static Vendor instance() {
        return INSTANCE;
    }

    private SQLServer() {
    }

    @Override
    public String getDTPVendorName() {
        return "SQL Server";
    }

    @Override
    CatalogStrategy getCatalogStrategy() {
        return SimpleCatalogStrategy.instance();
    }

    @Override
    FoldingStrategy getFoldingStrategy() {
        return NonFoldingStrategy.instance();
    }

    @Override
    void addDefaultCatalogIdentifiersTo(Database database, String userName, ArrayList<String> identifiers) {
        identifiers.add(database.getName());
        identifiers.add(MASTER_CATALOG_IDENTIFIER);
    }

    @Override
    void addDefaultSchemaIdentifiersTo(Database database, String userName, ArrayList<String> identifiers) {
        identifiers.add(DEFAULT_SCHEMA_NAME);
    }

    @Override
    char[] getExtendedNormalNameStartCharacters() {
        return EXTENDED_NORMAL_NAME_START_CHARACTERS;
    }

    @Override
    char[] getExtendedNormalNamePartCharacters() {
        return EXTENDED_NORMAL_NAME_PART_CHARACTERS;
    }

    @Override
    boolean identifierIsDelimited(String identifier) {
        return StringTools.stringIsBracketed((String)identifier) || super.identifierIsDelimited(identifier);
    }
}

