/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Sequence;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.db.internal.DTPDatabaseObjectWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaContainerWrapper;
import org.eclipse.jpt.db.internal.DTPSequenceWrapper;
import org.eclipse.jpt.db.internal.DTPTableWrapper;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DTPSchemaWrapper
extends DTPDatabaseObjectWrapper
implements Schema {
    private final org.eclipse.datatools.modelbase.sql.schema.Schema dtpSchema;
    private DTPTableWrapper[] tables;
    private DTPSequenceWrapper[] sequences;
    private static final String PERSISTENT_AND_VIEW_TABLES_ONLY = "supportPersistentAndViewTablesOnly";

    DTPSchemaWrapper(DTPSchemaContainerWrapper container, org.eclipse.datatools.modelbase.sql.schema.Schema dtpSchema) {
        super(container, dtpSchema);
        this.dtpSchema = dtpSchema;
    }

    @Override
    synchronized void catalogObjectChanged() {
        super.catalogObjectChanged();
        this.getConnectionProfile().schemaChanged(this);
    }

    @Override
    public String getName() {
        return this.dtpSchema.getName();
    }

    @Override
    public DTPSchemaContainerWrapper getContainer() {
        return (DTPSchemaContainerWrapper)this.getParent();
    }

    @Override
    public Iterator<Table> tables() {
        return new ArrayIterator((Object[])this.getTables());
    }

    private Iterator<DTPTableWrapper> tableWrappers() {
        return new ArrayIterator((Object[])this.getTables());
    }

    private synchronized DTPTableWrapper[] getTables() {
        if (this.tables == null) {
            this.tables = this.buildTables();
        }
        return this.tables;
    }

    private DTPTableWrapper[] buildTables() {
        List<org.eclipse.datatools.modelbase.sql.tables.Table> dtpTables = this.getDTPTables();
        Object[] result = new DTPTableWrapper[dtpTables.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPTableWrapper(this, dtpTables.get(i));
        }
        return (DTPTableWrapper[])CollectionTools.sort((Object[])result);
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Table> getDTPTables() {
        String supportPersistentAndViewTablesOnly = Platform.getProduct().getProperty(PERSISTENT_AND_VIEW_TABLES_ONLY);
        if (supportPersistentAndViewTablesOnly != null && supportPersistentAndViewTablesOnly.equals("true")) {
            ArrayList<org.eclipse.datatools.modelbase.sql.tables.Table> result = new ArrayList<org.eclipse.datatools.modelbase.sql.tables.Table>();
            for (org.eclipse.datatools.modelbase.sql.tables.Table table : this.dtpSchema.getTables()) {
                if (!SQLTablesPackage.eINSTANCE.getPersistentTable().isSuperTypeOf(table.eClass()) && !SQLTablesPackage.eINSTANCE.getViewTable().isSuperTypeOf(table.eClass())) continue;
                result.add(table);
            }
            return result;
        }
        return this.dtpSchema.getTables();
    }

    @Override
    public int tablesSize() {
        return this.getTables().length;
    }

    DTPTableWrapper getTable(org.eclipse.datatools.modelbase.sql.tables.Table dtpTable) {
        return this.wraps(dtpTable.getSchema()) ? this.getTable_(dtpTable) : this.getContainer().getTable(dtpTable);
    }

    DTPTableWrapper getTable_(org.eclipse.datatools.modelbase.sql.tables.Table dtpTable) {
        DTPTableWrapper[] dTPTableWrapperArray = this.getTables();
        int n = dTPTableWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            DTPTableWrapper table = dTPTableWrapperArray[n2];
            if (table.wraps(dtpTable)) {
                return table;
            }
            ++n2;
        }
        throw new IllegalArgumentException("invalid DTP table: " + dtpTable);
    }

    @Override
    public DTPTableWrapper getTableNamed(String name) {
        return (DTPTableWrapper)this.selectDatabaseObjectNamed(this.getTables(), name);
    }

    @Override
    public Iterator<String> sortedTableIdentifiers() {
        return new TransformationIterator<DTPTableWrapper, String>(this.tableWrappers()){

            protected String transform(DTPTableWrapper table) {
                return table.getIdentifier();
            }
        };
    }

    @Override
    public DTPTableWrapper getTableForIdentifier(String identifier) {
        return (DTPTableWrapper)this.selectDatabaseObjectForIdentifier(this.getTables(), identifier);
    }

    @Override
    public Iterator<Sequence> sequences() {
        return new ArrayIterator((Object[])this.getSequences());
    }

    private Iterator<DTPSequenceWrapper> sequenceWrappers() {
        return new ArrayIterator((Object[])this.getSequences());
    }

    private synchronized DTPSequenceWrapper[] getSequences() {
        if (this.sequences == null) {
            this.sequences = this.buildSequences();
        }
        return this.sequences;
    }

    private DTPSequenceWrapper[] buildSequences() {
        List<org.eclipse.datatools.modelbase.sql.schema.Sequence> dtpSequences = this.getDTPSequences();
        Object[] result = new DTPSequenceWrapper[dtpSequences.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPSequenceWrapper(this, dtpSequences.get(i));
        }
        return (DTPSequenceWrapper[])CollectionTools.sort((Object[])result);
    }

    private List<org.eclipse.datatools.modelbase.sql.schema.Sequence> getDTPSequences() {
        return this.dtpSchema.getSequences();
    }

    @Override
    public int sequencesSize() {
        return this.getSequences().length;
    }

    @Override
    public DTPSequenceWrapper getSequenceNamed(String name) {
        return (DTPSequenceWrapper)this.selectDatabaseObjectNamed(this.getSequences(), name);
    }

    @Override
    public Iterator<String> sortedSequenceIdentifiers() {
        return new TransformationIterator<DTPSequenceWrapper, String>(this.sequenceWrappers()){

            protected String transform(DTPSequenceWrapper sequence) {
                return sequence.getIdentifier();
            }
        };
    }

    @Override
    public DTPSequenceWrapper getSequenceForIdentifier(String identifier) {
        return (DTPSequenceWrapper)this.selectDatabaseObjectForIdentifier(this.getSequences(), identifier);
    }

    @Override
    public int compareTo(Schema schema) {
        return Collator.getInstance().compare(this.getName(), schema.getName());
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.schema.Schema schema) {
        return this.dtpSchema == schema;
    }

    DTPColumnWrapper getColumn(Column dtpColumn) {
        return this.wraps(dtpColumn.getTable().getSchema()) ? this.getColumn_(dtpColumn) : this.getContainer().getColumn(dtpColumn);
    }

    DTPColumnWrapper getColumn_(Column dtpColumn) {
        return this.getTable_(dtpColumn.getTable()).getColumn_(dtpColumn);
    }

    @Override
    synchronized void startListening() {
        if (this.sequences != null) {
            this.startSequences();
        }
        if (this.tables != null) {
            this.startTables();
        }
        super.startListening();
    }

    private void startSequences() {
        DTPSequenceWrapper[] dTPSequenceWrapperArray = this.sequences;
        int n = this.sequences.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSequenceWrapper sequence = dTPSequenceWrapperArray[n2];
            sequence.startListening();
            ++n2;
        }
    }

    private void startTables() {
        DTPTableWrapper[] dTPTableWrapperArray = this.tables;
        int n = this.tables.length;
        int n2 = 0;
        while (n2 < n) {
            DTPTableWrapper table = dTPTableWrapperArray[n2];
            table.startListening();
            ++n2;
        }
    }

    @Override
    synchronized void stopListening() {
        if (this.sequences != null) {
            this.stopSequences();
        }
        if (this.tables != null) {
            this.stopTables();
        }
        super.stopListening();
    }

    private void stopSequences() {
        DTPSequenceWrapper[] dTPSequenceWrapperArray = this.sequences;
        int n = this.sequences.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSequenceWrapper sequence = dTPSequenceWrapperArray[n2];
            sequence.stopListening();
            ++n2;
        }
    }

    private void stopTables() {
        DTPTableWrapper[] dTPTableWrapperArray = this.tables;
        int n = this.tables.length;
        int n2 = 0;
        while (n2 < n) {
            DTPTableWrapper table = dTPTableWrapperArray[n2];
            table.stopListening();
            ++n2;
        }
    }

    @Override
    synchronized void clear() {
        if (this.sequences != null) {
            this.clearSequences();
        }
        if (this.tables != null) {
            this.clearTables();
        }
    }

    private void clearSequences() {
        this.stopSequences();
        DTPSequenceWrapper[] dTPSequenceWrapperArray = this.sequences;
        int n = this.sequences.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSequenceWrapper sequence = dTPSequenceWrapperArray[n2];
            sequence.clear();
            ++n2;
        }
        this.sequences = null;
    }

    private void clearTables() {
        this.stopTables();
        DTPTableWrapper[] dTPTableWrapperArray = this.tables;
        int n = this.tables.length;
        int n2 = 0;
        while (n2 < n) {
            DTPTableWrapper table = dTPTableWrapperArray[n2];
            table.clear();
            ++n2;
        }
        this.tables = null;
    }
}

