/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.launching.internal.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xsl.jaxp.launching.internal.ProcessorInvokerDescriptor;
import org.eclipse.wst.xsl.jaxp.launching.internal.registry.AbstractRegistryReader;
import org.eclipse.wst.xsl.jaxp.launching.internal.registry.InvokerRegistry;

public class InvokerRegistryReader
extends AbstractRegistryReader {
    public static final String TAG_INVOKE = "invoker";
    public static final String ATT_ID = "id";
    public static final String ATT_CLASS = "class";
    public static final String ATT_CLASSPATH = "classpath";
    private InvokerRegistry registry;

    protected boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(TAG_INVOKE)) {
            return false;
        }
        String id = element.getAttribute(ATT_ID);
        if (id == null) {
            InvokerRegistryReader.logMissingAttribute(element, ATT_ID);
            return true;
        }
        String classname = element.getAttribute(ATT_CLASS);
        if (classname == null) {
            InvokerRegistryReader.logMissingAttribute(element, ATT_CLASS);
            return true;
        }
        String classpath = element.getAttribute(ATT_CLASSPATH);
        if (classpath == null) {
            InvokerRegistryReader.logMissingAttribute(element, ATT_CLASSPATH);
            return true;
        }
        String[] entries = classpath.split(";");
        int i = 0;
        while (i < entries.length) {
            String string = entries[i];
            entries[i] = string.trim();
            ++i;
        }
        this.registry.addInvokerDescriptor(new ProcessorInvokerDescriptor(id, element.getContributor().getName(), classname, entries));
        return true;
    }

    public void readElement(InvokerRegistry registry, IConfigurationElement element) {
        this.registry = registry;
        this.readElement(element);
    }

    public void addConfigs(InvokerRegistry registry) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        this.registry = registry;
        this.readRegistry(extensionRegistry, "org.eclipse.wst.xsl.jaxp.launching", "invoke");
    }
}

