/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.sync;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.core.DelegatingProgressMonitor;
import org.eclipse.mylyn.commons.core.IDelegatingProgressMonitor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.sync.Messages;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizeQueriesJob;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizeRepositoriesJob
extends SynchronizationJob {
    private final TaskList taskList;
    private final TaskDataManager taskDataManager;
    private final IRepositoryManager repositoryManager;
    private Set<TaskRepository> repositories;
    private final IRepositoryModel tasksModel;
    private final IDelegatingProgressMonitor monitor;

    public SynchronizeRepositoriesJob(TaskList taskList, TaskDataManager taskDataManager, IRepositoryModel tasksModel, IRepositoryManager repositoryManager) {
        super(Messages.SynchronizeRepositoriesJob_Synchronizing_Task_List);
        this.taskList = taskList;
        this.taskDataManager = taskDataManager;
        this.tasksModel = tasksModel;
        this.repositoryManager = repositoryManager;
        this.monitor = new DelegatingProgressMonitor();
    }

    public Collection<TaskRepository> getRepositories() {
        return Collections.unmodifiableCollection(this.repositories);
    }

    public void setRepositories(Collection<TaskRepository> repositories) {
        this.repositories = repositories != null ? new HashSet<TaskRepository>(repositories) : null;
    }

    public IStatus run(IProgressMonitor jobMonitor) {
        this.monitor.attach(jobMonitor);
        Set<TaskRepository> repositories = this.repositories;
        if (repositories == null) {
            repositories = new HashSet<TaskRepository>(this.repositoryManager.getAllRepositories());
        }
        try {
            this.monitor.beginTask(Messages.SynchronizeRepositoriesJob_Processing, repositories.size() * 100);
            for (TaskRepository repository : repositories) {
                if (this.monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                try {
                    if (repository.isOffline()) {
                        this.monitor.worked(100);
                        continue;
                    }
                    this.monitor.setTaskName(MessageFormat.format(Messages.SynchronizeRepositoriesJob_Processing_, repository.getRepositoryLabel()));
                    AbstractRepositoryConnector connector = this.repositoryManager.getRepositoryConnector(repository.getConnectorKind());
                    HashSet<RepositoryQuery> queries = new HashSet<RepositoryQuery>(this.taskList.getRepositoryQueries(repository.getRepositoryUrl()));
                    if (!this.isUser()) {
                        Iterator it = queries.iterator();
                        while (it.hasNext()) {
                            if (((RepositoryQuery)it.next()).getAutoUpdate()) continue;
                            it.remove();
                        }
                    }
                    if (this.isUser() || queries.isEmpty()) {
                        this.monitor.worked(20);
                    } else {
                        this.updateRepositoryConfiguration(repository, connector, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)this.monitor, 20));
                    }
                    this.updateQueries(repository, connector, queries, (IProgressMonitor)this.monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
            }
        }
        finally {
            this.monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void updateQueries(TaskRepository repository, AbstractRepositoryConnector connector, Set<RepositoryQuery> queries, IProgressMonitor monitor) {
        if (this.isUser()) {
            for (RepositoryQuery query : queries) {
                query.setSynchronizing(true);
            }
            this.taskList.notifySynchronizationStateChanged(queries);
        }
        SynchronizeQueriesJob job = new SynchronizeQueriesJob(this.taskList, this.taskDataManager, this.tasksModel, connector, repository, queries){

            public boolean belongsTo(Object family) {
                return ITasksCoreConstants.JOB_FAMILY_SYNCHRONIZATION == family;
            }
        };
        job.setUser(this.isUser());
        job.setFullSynchronization(true);
        job.setPriority(50);
        if (this.isUser()) {
            job.schedule();
        } else {
            job.run((IProgressMonitor)new SubProgressMonitor(monitor, 80));
        }
    }

    public boolean belongsTo(Object family) {
        return ITasksCoreConstants.JOB_FAMILY_SYNCHRONIZATION == family;
    }

    private void updateRepositoryConfiguration(TaskRepository repository, AbstractRepositoryConnector connector, IProgressMonitor monitor) {
        try {
            try {
                if (!this.isUser()) {
                    monitor = Policy.backgroundMonitorFor((IProgressMonitor)monitor);
                }
                monitor.beginTask(MessageFormat.format(Messages.SynchronizeRepositoriesJob_Updating_repository_configuration_for_X, repository.getRepositoryUrl()), 100);
                if (connector.isRepositoryConfigurationStale(repository, monitor)) {
                    connector.updateRepositoryConfiguration(repository, monitor);
                    repository.setConfigurationDate(new Date());
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                repository.setStatus((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Updating of repository configuration failed", (Throwable)e));
                monitor.done();
            }
            catch (LinkageError e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Internal error while updating repository configuration for ''{0}''", (Object)repository.getUrl()), (Throwable)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public IDelegatingProgressMonitor getMonitor() {
        return this.monitor;
    }
}

