/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.actions.AbstractOpenAction;
import org.eclipse.jst.j2ee.internal.actions.ComponentEditorInput;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.componentcore.ComponentArchiveOptions;
import org.eclipse.jst.j2ee.internal.ejb.provider.J2EEJavaClassProviderHelper;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.webservice.wsdd.BeanLink;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.Listener;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.ui.internal.navigator.AbstractGroupProvider;
import org.eclipse.jst.jee.ui.internal.navigator.appclient.GroupAppClientProvider;
import org.eclipse.jst.jee.ui.internal.navigator.ear.GroupEARProvider;
import org.eclipse.jst.jee.ui.internal.navigator.ejb.BeanInterfaceNode;
import org.eclipse.jst.jee.ui.internal.navigator.ejb.BeanNode;
import org.eclipse.jst.jee.ui.internal.navigator.ejb.GroupEJBProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.WebAppProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.WebArtifactNode;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class OpenJEEResourceAction
extends AbstractOpenAction {
    public static final String ID = "com.sap.ide.j2ee.ui.actions.OpenJEEResourceAction";
    public static final String JAVA_EDITOR_ID = "org.eclipse.jst.j2ee.internal.internal.ejb.ui.java.EnterpriseBeanJavaEditor";
    public static final String BASE_JAVA_EDITOR_ID = "org.eclipse.jdt.ui.CompilationUnitEditor";
    protected static IEditorDescriptor javaEditorDescriptor;
    protected static IEditorDescriptor baseJavaEditorDescriptor;

    public OpenJEEResourceAction() {
        super("Open");
    }

    public String getID() {
        return ID;
    }

    public static IEditorDescriptor getJavaEditorDescriptor() {
        if (javaEditorDescriptor == null) {
            javaEditorDescriptor = OpenJEEResourceAction.findEditorDescriptor((String)JAVA_EDITOR_ID);
        }
        return javaEditorDescriptor;
    }

    public static IEditorDescriptor getBaseJavaEditorDescriptor() {
        if (baseJavaEditorDescriptor == null) {
            baseJavaEditorDescriptor = OpenJEEResourceAction.findEditorDescriptor((String)BASE_JAVA_EDITOR_ID);
        }
        return baseJavaEditorDescriptor;
    }

    protected void openAppropriateEditor(String c) {
        if (this.getStructuredSelection() instanceof TreeSelection) {
            TreePath path = ((TreeSelection)this.getStructuredSelection()).getPaths()[0];
            IProject project = null;
            while (path != null) {
                Object segment = path.getLastSegment();
                if (segment instanceof IProject) {
                    project = (IProject)segment;
                    break;
                }
                path = path.getParentPath();
            }
            if (project != null) {
                try {
                    IType findType = JavaCore.create(project).findType(c);
                    if (findType == null) {
                        return;
                    }
                    this.openAppropriateEditor(findType.getResource());
                }
                catch (JavaModelException e) {
                    JEEUIPlugin.logError("Error during open editor", (Exception)((Object)e));
                }
            }
        }
    }

    protected void openAppropriateEditor(IVirtualComponent c) {
        if (c == null) {
            return;
        }
        IWorkbenchPage page = null;
        IEditorPart editor = null;
        try {
            page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            editor = page.openEditor((IEditorInput)new ComponentEditorInput(c), this.currentDescriptor.getId());
            if (editor instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)editor).selectReveal((ISelection)this.getStructuredSelection());
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)J2EEUIMessages.getResourceString((String)"Problems_Opening_Editor_ERROR_"), (String)e.getMessage());
        }
    }

    protected void openAppropriateEditor(IJavaElement element) {
        if (element == null) {
            return;
        }
        IWorkbenchPage page = null;
        try {
            page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            JavaUI.openInEditor((IJavaElement)element);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)J2EEUIMessages.getResourceString((String)"Problems_Opening_Editor_ERROR_"), (String)e.getMessage());
        }
    }

    protected void openAppropriateEditor(IResource r) {
        if (r == null) {
            return;
        }
        IWorkbenchPage page = null;
        IEditorPart editor = null;
        try {
            page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String ID = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(r.getLocation().toPortableString()).getId();
            editor = page.openEditor((IEditorInput)new FileEditorInput((IFile)r), ID);
            if (editor instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)editor).selectReveal((ISelection)this.getStructuredSelection());
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)J2EEUIMessages.getResourceString((String)"Problems_Opening_Editor_ERROR_"), (String)e.getMessage());
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.srcObject instanceof J2EEJavaClassProviderHelper) {
            ((J2EEJavaClassProviderHelper)this.srcObject).openInEditor();
            return;
        }
        if (this.srcObject instanceof SessionBean || this.srcObject instanceof MessageDrivenBean || this.srcObject instanceof EntityBean || this.srcObject instanceof Servlet || this.srcObject instanceof Filter || this.srcObject instanceof Listener) {
            SessionBean bean;
            String name = "";
            if (this.srcObject instanceof SessionBean) {
                bean = (SessionBean)this.srcObject;
                name = bean.getEjbClass();
            } else if (this.srcObject instanceof MessageDrivenBean) {
                bean = (MessageDrivenBean)this.srcObject;
                name = bean.getEjbClass();
            } else if (this.srcObject instanceof EntityBean) {
                bean = (EntityBean)this.srcObject;
                name = bean.getEjbClass();
            } else if (this.srcObject instanceof Servlet) {
                Servlet servlet = (Servlet)this.srcObject;
                name = servlet.getServletClass();
            } else if (this.srcObject instanceof Filter) {
                Filter filter = (Filter)this.srcObject;
                name = filter.getFilterClass();
            } else if (this.srcObject instanceof Listener) {
                Listener listener = (Listener)this.srcObject;
                name = listener.getListenerClass();
            }
            IFile resource = WorkbenchResourceHelper.getFile((EObject)((EObject)this.srcObject));
            if (resource == null) {
                return;
            }
            IProject project = resource.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject.exists()) {
                IType type = null;
                try {
                    if (name != null) {
                        type = javaProject.findType(name);
                    }
                    if (type != null) {
                        ICompilationUnit cu = type.getCompilationUnit();
                        EditorUtility.openInEditor((Object)cu);
                    } else {
                        this.openAppropriateEditor((IResource)resource);
                    }
                }
                catch (JavaModelException e) {
                    JEEUIPlugin.logError(e.getMessage(), (Exception)((Object)e));
                }
                catch (PartInitException e) {
                    JEEUIPlugin.logError(e.getMessage(), (Exception)((Object)e));
                }
            }
            return;
        }
        if (this.srcObject instanceof EObject) {
            this.openEObject((EObject)this.srcObject);
        } else {
            if (this.srcObject instanceof BeanInterfaceNode) {
                this.openAppropriateEditor(((BeanInterfaceNode)this.srcObject).get_fqn());
                return;
            }
            if (this.srcObject instanceof BeanNode) {
                this.openAppropriateEditor(((BeanNode)this.srcObject).getEjbClassQualifiedName());
                return;
            }
            if (this.srcObject instanceof WebAppProvider) {
                IFile file = ((WebAppProvider)this.srcObject).getDDFile();
                if (file.isAccessible()) {
                    this.openAppropriateEditor((IResource)file);
                    return;
                }
            } else if (this.srcObject instanceof AbstractGroupProvider) {
                this.openEObject((EObject)((AbstractGroupProvider)this.srcObject).getJavaEEObject());
            } else if (this.srcObject instanceof WebArtifactNode) {
                this.openEObject((EObject)((WebArtifactNode)this.srcObject).getJavaEEObject());
            } else if (this.srcObject instanceof GroupEJBProvider) {
                this.openEObject((EObject)((GroupEJBProvider)this.srcObject).getEjbJar());
            } else if (this.srcObject instanceof GroupEARProvider) {
                IFile file = ((GroupEARProvider)this.srcObject).getDDFile();
                if (file.isAccessible()) {
                    this.openAppropriateEditor((IResource)file);
                    return;
                }
            } else if (this.srcObject instanceof GroupAppClientProvider) {
                IFile file = ((GroupAppClientProvider)this.srcObject).getDDFile();
                if (file.isAccessible()) {
                    this.openAppropriateEditor((IResource)file);
                    return;
                }
            } else if (this.srcObject instanceof Resource) {
                this.openAppropriateEditor((IResource)WorkbenchResourceHelper.getFile((Resource)((Resource)this.srcObject)));
            }
        }
    }

    private void openEObject(EObject _srcObject) {
        EObject ro = _srcObject;
        IFile resource = WorkbenchResourceHelper.getFile((EObject)_srcObject);
        if (resource != null) {
            this.openAppropriateEditor((IResource)resource);
        } else {
            ModuleFile moduleFile = ArchiveUtil.getModuleFile((EObject)ro);
            if (moduleFile != null) {
                ArchiveOptions options = moduleFile.getOptions();
                if (options instanceof ComponentArchiveOptions) {
                    IVirtualComponent component = ((ComponentArchiveOptions)options).getComponent();
                    this.openAppropriateEditor(component);
                }
            } else {
                IVirtualComponent component;
                IArchive archive = JavaEEArchiveUtilities.findArchive((Object)ro);
                if (archive != null && (component = JavaEEArchiveUtilities.findComponent((IArchive)archive)) != null) {
                    this.openAppropriateEditor(component);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean updateSelection(IStructuredSelection s) {
        Object obj;
        block17: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block16: {
                                            if (!super.updateSelection(s)) {
                                                return false;
                                            }
                                            obj = s.getFirstElement();
                                            this.setText("Open");
                                            if (!(obj instanceof J2EEJavaClassProviderHelper)) break block16;
                                            this.currentDescriptor = OpenJEEResourceAction.getJavaEditorDescriptor();
                                            break block17;
                                        }
                                        if (!(obj instanceof BeanLink)) break block18;
                                        this.currentDescriptor = OpenJEEResourceAction.getBaseJavaEditorDescriptor();
                                        break block17;
                                    }
                                    if (!(obj instanceof EObject)) break block19;
                                    IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                                    IFile file = WorkbenchResourceHelper.getFile((EObject)((EObject)obj));
                                    if (file != null) {
                                        IContentType contentType = IDE.getContentType((IFile)file);
                                        this.currentDescriptor = registry.getDefaultEditor(file.getName(), contentType);
                                        break block17;
                                    } else if (((EObject)obj).eResource() != null) {
                                        String name = new Path(((EObject)obj).eResource().getURI().toString()).lastSegment();
                                        this.currentDescriptor = registry.getDefaultEditor(name, null);
                                    }
                                    break block17;
                                }
                                if (!(obj instanceof Resource)) break block20;
                                IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                                IFile file = WorkbenchResourceHelper.getFile((Resource)((Resource)obj));
                                IContentType contentType = IDE.getContentType((IFile)file);
                                this.currentDescriptor = registry.getDefaultEditor(file.getName(), contentType);
                                break block17;
                            }
                            if (!(obj instanceof GroupEARProvider)) break block21;
                            IFile file = ((GroupEARProvider)obj).getDDFile();
                            if (!file.isAccessible()) {
                                this.currentDescriptor = null;
                                return false;
                            }
                            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                            IContentType contentType = IDE.getContentType((IFile)file);
                            this.currentDescriptor = registry.getDefaultEditor(file.getName(), contentType);
                            break block17;
                        }
                        if (!(obj instanceof GroupAppClientProvider)) break block22;
                        IFile file = ((GroupAppClientProvider)obj).getDDFile();
                        if (!file.isAccessible()) {
                            this.currentDescriptor = null;
                            return false;
                        }
                        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                        IContentType contentType = IDE.getContentType((IFile)file);
                        this.currentDescriptor = registry.getDefaultEditor(file.getName(), contentType);
                        break block17;
                    }
                    if (!(obj instanceof WebAppProvider)) break block23;
                    IFile file = ((WebAppProvider)obj).getDDFile();
                    if (file.isAccessible()) {
                        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                        IContentType contentType = IDE.getContentType((IFile)file);
                        this.currentDescriptor = registry.getDefaultEditor(file.getName(), contentType);
                    }
                    break block17;
                }
                if (!(obj instanceof BeanNode)) break block24;
                IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                JavaEEObject enterpriseBean = ((BeanNode)obj).getEnterpriseBean();
                IFile file = WorkbenchResourceHelper.getFile((EObject)((EObject)enterpriseBean));
                if (file != null) {
                    IContentType contentType = IDE.getContentType((IFile)file);
                    this.currentDescriptor = registry.getDefaultEditor(file.getName(), contentType);
                    break block17;
                } else if (((EObject)enterpriseBean).eResource() != null) {
                    String name = new Path(((EObject)enterpriseBean).eResource().getURI().toString()).lastSegment();
                    this.currentDescriptor = registry.getDefaultEditor(name, null);
                }
                break block17;
            }
            if (obj instanceof BeanInterfaceNode) {
                IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                JavaEEObject beanInterface = (JavaEEObject)((BeanInterfaceNode)obj).getAdapterNode();
                IFile file = WorkbenchResourceHelper.getFile((EObject)((EObject)beanInterface));
                if (file != null) {
                    IContentType contentType = IDE.getContentType((IFile)file);
                    this.currentDescriptor = registry.getDefaultEditor(file.getName(), contentType);
                } else if (((EObject)beanInterface).eResource() != null) {
                    String name = new Path(((EObject)beanInterface).eResource().getURI().toString()).lastSegment();
                    this.currentDescriptor = registry.getDefaultEditor(name, null);
                } else {
                    String fqn = ((BeanInterfaceNode)obj).get_fqn();
                    if (fqn == null) {
                        return false;
                    }
                    this.currentDescriptor = registry.getDefaultEditor(((BeanInterfaceNode)obj).getText(), null);
                }
            }
        }
        this.setAttributesFromDescriptor();
        this.srcObject = obj;
        return true;
    }
}

