/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.actions.BaseAction;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.jee.project.facet.IAppClientCreateDeploymentFilesDataModelProperties;
import org.eclipse.jst.jee.project.facet.IEJBCreateDeploymentFilesDataModelProperties;
import org.eclipse.jst.jee.project.facet.IEarCreateDeploymentFilesDataModelProperties;
import org.eclipse.jst.jee.project.facet.IWebCreateDeploymentFilesDataModelProperties;
import org.eclipse.jst.jee.ui.internal.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class CreateDeploymentFilesActionDelegate
extends BaseAction {
    public void selectionChanged(IAction action, ISelection aSelection) {
        super.selectionChanged(action, aSelection);
        boolean isEnabled = false;
        if (aSelection != null) {
            IStructuredSelection structuredSelection = (IStructuredSelection)aSelection;
            isEnabled = this.isValidSelection(this.getProjectFromSelection(structuredSelection), null);
        }
        this.setEnabled(isEnabled);
        action.setEnabled(isEnabled);
    }

    private IProject getProjectFromSelection(IStructuredSelection structuredSelection) {
        Object firstElement;
        IProject project = ProjectUtilities.getProject((Object)structuredSelection.getFirstElement());
        if (project == null && IAdaptable.class.isInstance(firstElement = structuredSelection.getFirstElement())) {
            return (IProject)((IAdaptable)firstElement).getAdapter(IProject.class);
        }
        return project;
    }

    private boolean isValidSelection(IProject project, Shell shell) {
        return project != null && J2EEProjectUtilities.isJEEProject((IProject)project) && !this.hasDeploymentDescriptor(project, shell);
    }

    private void informInvalidSelection(Shell shell) {
        MessageDialog.openInformation((Shell)shell, (String)Messages.INVALID_DEP_DESC_SELECTION_TITLE, (String)Messages.INFORM_INVALID_DEP_DESC_SELECTION);
    }

    private boolean hasDeploymentDescriptor(IProject project, Shell shell) {
        boolean ret = true;
        Path ddFilePath = null;
        if (J2EEProjectUtilities.isEARProject((IProject)project)) {
            ddFilePath = new Path("META-INF/application.xml");
        } else if (J2EEProjectUtilities.isEJBProject((IProject)project)) {
            ddFilePath = new Path("META-INF/ejb-jar.xml");
        } else if (J2EEProjectUtilities.isDynamicWebProject((IProject)project)) {
            ddFilePath = new Path("WEB-INF/web.xml");
        } else if (J2EEProjectUtilities.isApplicationClientProject((IProject)project)) {
            ddFilePath = new Path("META-INF/application-client.xml");
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component.getRootFolder() != null && component.getRootFolder().getUnderlyingFolder() != null) {
            IFile ddXmlFile = component.getRootFolder().getUnderlyingFolder().getFile((IPath)ddFilePath);
            ret = ddXmlFile.exists();
            if (shell != null && ret) {
                this.informInvalidSelection(shell);
            }
        }
        return ret;
    }

    protected void primRun(Shell shell) {
        IProject project = this.getProjectFromSelection(this.selection);
        if (!this.validateSelection(project, shell)) {
            return;
        }
        try {
            this.getDataModel(project).getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    private IDataModel getDataModel(IProject project) {
        Class<IEarCreateDeploymentFilesDataModelProperties> dataModelClass = null;
        if (J2EEProjectUtilities.isEARProject((IProject)project)) {
            dataModelClass = IEarCreateDeploymentFilesDataModelProperties.class;
        } else if (J2EEProjectUtilities.isEJBProject((IProject)project)) {
            dataModelClass = IEJBCreateDeploymentFilesDataModelProperties.class;
        } else if (J2EEProjectUtilities.isDynamicWebProject((IProject)project)) {
            dataModelClass = IWebCreateDeploymentFilesDataModelProperties.class;
        } else if (J2EEProjectUtilities.isApplicationClientProject((IProject)project)) {
            dataModelClass = IAppClientCreateDeploymentFilesDataModelProperties.class;
        }
        IDataModel dataModel = DataModelFactory.createDataModel(dataModelClass);
        dataModel.setProperty("ICreateDeploymentFilesDataModelProperties.TARGET_PROJECT", (Object)project);
        return dataModel;
    }

    private boolean validateSelection(IProject project, Shell shell) {
        boolean validSelection = true;
        if (!this.isValidSelection(project, shell)) {
            validSelection = false;
        }
        return validSelection;
    }
}

