/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import org.eclipse.debug.internal.core.commands.Request;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelLabelProviderTarget;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

class LabelUpdate
extends Request
implements ILabelUpdate {
    private TreePath fElementPath;
    private String[] fColumnIds;
    private RGB[] fBackgrounds;
    private RGB[] fForegrounds;
    private ImageDescriptor[] fImageDescriptors;
    private String[] fLabels;
    private FontData[] fFontDatas;
    private TreeModelLabelProvider fProvider;
    private ITreeModelLabelProviderTarget fTreeViewer;
    private int fNumColumns;
    private IPresentationContext fContext;
    private Object fViewerInput;

    public LabelUpdate(Object viewerInput, TreePath elementPath, TreeModelLabelProvider provider, ITreeModelLabelProviderTarget treeViewer, String[] columnIds, IPresentationContext context) {
        this.fContext = context;
        this.fViewerInput = viewerInput;
        this.fElementPath = elementPath;
        this.fProvider = provider;
        this.fColumnIds = columnIds;
        this.fNumColumns = 1;
        if (columnIds != null) {
            this.fNumColumns = columnIds.length;
        }
        this.fLabels = new String[this.fNumColumns];
        this.fTreeViewer = treeViewer;
    }

    public String[] getColumnIds() {
        return this.fColumnIds;
    }

    public TreePath getElementPath() {
        return this.fElementPath;
    }

    public void setBackground(RGB background, int columnIndex) {
        if (background == null) {
            return;
        }
        if (this.fBackgrounds == null) {
            this.fBackgrounds = new RGB[this.fNumColumns];
        }
        this.fBackgrounds[columnIndex] = background;
    }

    public void setFontData(FontData fontData, int columnIndex) {
        if (fontData == null) {
            return;
        }
        if (this.fFontDatas == null) {
            this.fFontDatas = new FontData[this.fNumColumns];
        }
        this.fFontDatas[columnIndex] = fontData;
    }

    public void setForeground(RGB foreground, int columnIndex) {
        if (foreground == null) {
            return;
        }
        if (this.fForegrounds == null) {
            this.fForegrounds = new RGB[this.fNumColumns];
        }
        this.fForegrounds[columnIndex] = foreground;
    }

    public void setImageDescriptor(ImageDescriptor image, int columnIndex) {
        if (image == null) {
            return;
        }
        if (this.fImageDescriptors == null) {
            this.fImageDescriptors = new ImageDescriptor[this.fNumColumns];
        }
        this.fImageDescriptors[columnIndex] = image;
    }

    public void setLabel(String text, int columnIndex) {
        this.fLabels[columnIndex] = text;
    }

    public IPresentationContext getPresentationContext() {
        return this.fContext;
    }

    public void done() {
        this.fProvider.complete(this);
    }

    public void update() {
        this.fTreeViewer.setElementData(this.fElementPath, this.fNumColumns, this.fLabels, this.fImageDescriptors, this.fFontDatas, this.fForegrounds, this.fBackgrounds);
        this.fProvider.updateComplete(this);
    }

    public Object getElement() {
        return this.getElementPath().getLastSegment();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ILabelUpdate: ");
        buf.append(this.getElement());
        return buf.toString();
    }

    public Object getViewerInput() {
        return this.fViewerInput;
    }
}

