/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.svg;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.LegendItemHints;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.device.image.MultiActionValuesScriptGenerator;
import org.eclipse.birt.chart.device.svg.CacheEvent;
import org.eclipse.birt.chart.device.svg.SVGGraphics2D;
import org.eclipse.birt.chart.device.svg.i18n.Messages;
import org.eclipse.birt.chart.device.util.CSSHelper;
import org.eclipse.birt.chart.device.util.ScriptUtil;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.AccessibilityValue;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.Cursor;
import org.eclipse.birt.chart.model.attribute.CursorType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.MenuStylesKeyType;
import org.eclipse.birt.chart.model.attribute.MultiURLValues;
import org.eclipse.birt.chart.model.attribute.ScriptValue;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.MultipleActions;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGInteractiveRenderer {
    private Map<Series, List<String>> labelPrimitives = SecurityUtil.newHashtable();
    private List<String> scripts = new Vector<String>();
    protected Element hotspotLayer;
    private Map<Object, List<String>> componentPrimitives = SecurityUtil.newHashtable();
    private IUpdateNotifier _iun;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.svg/trace");
    SVGGraphics2D svg_g2d;
    private ULocale locale;
    private List<CacheEvent> cacheEvents = new ArrayList<CacheEvent>();
    private String defaultCursor = "cursor:pointer";
    private Map<Object, Boolean> mapOnloadAdded = new HashMap<Object, Boolean>();
    private int iFirstDataPointIndex = -1;

    public SVGInteractiveRenderer(ULocale locale) {
        this.locale = locale == null ? ULocale.getDefault() : locale;
    }

    public void setIUpdateNotifier(IUpdateNotifier iun) {
        this._iun = iun;
    }

    public void setSVG2D(SVGGraphics2D svg2D) {
        this.svg_g2d = svg2D;
    }

    protected void groupPrimitive(PrimitiveRenderEvent pre, boolean drawText) {
        if (this._iun == null) {
            logger.log(2, Messages.getString("exception.missing.component.interaction", this.getULocale()));
            return;
        }
        if (pre.getSource() instanceof StructureSource) {
            StructureSource sourceObject = (StructureSource)pre.getSource();
            Series seDT = (Series)this.getElementFromSource(sourceObject, StructureType.SERIES);
            if (seDT != null) {
                String id;
                String groupIdentifier = null;
                try {
                    if (this.isColoredByCategories() && this.getElementFromSource(sourceObject, StructureType.SERIES_DATA_POINT) != null) {
                        seDT = this.findCategorySeries(seDT);
                        groupIdentifier = String.valueOf(seDT.hashCode());
                        DataPointHints dph = (DataPointHints)this.getElementFromSource(sourceObject, StructureType.SERIES_DATA_POINT);
                        groupIdentifier = String.valueOf(groupIdentifier) + "index";
                        groupIdentifier = String.valueOf(groupIdentifier) + dph.getIndex();
                        if (this.iFirstDataPointIndex < 0) {
                            this.iFirstDataPointIndex = dph.getIndex();
                        }
                    } else {
                        seDT = this.findDesignTimeSeries(seDT);
                        groupIdentifier = String.valueOf(seDT.hashCode());
                    }
                }
                catch (ChartException e) {
                    logger.log((Exception)((Object)e));
                    return;
                }
                if (drawText) {
                    id = Integer.toString(pre.hashCode());
                    List<String> components = this.labelPrimitives.get(seDT);
                    if (components == null) {
                        components = new ArrayList<String>();
                        this.labelPrimitives.put(seDT, components);
                    }
                    components.add(id);
                    Element outerGroup = this.svg_g2d.createElement("g");
                    this.svg_g2d.pushParent(outerGroup);
                    Element primGroup = this.svg_g2d.createElement("g");
                    outerGroup.appendChild(primGroup);
                    this.svg_g2d.pushParent(primGroup);
                    primGroup.setAttribute("id", String.valueOf(groupIdentifier) + "_" + id);
                    primGroup.setAttribute("style", "visibility:visible;");
                    outerGroup.setAttribute("id", String.valueOf(groupIdentifier) + "_" + id + "_g");
                    outerGroup.setAttribute("style", "visibility:visible;");
                } else {
                    id = Integer.toString(pre.hashCode());
                    List<String> components = this.componentPrimitives.get(seDT);
                    if (components == null) {
                        components = new ArrayList<String>();
                        this.componentPrimitives.put(seDT, components);
                    }
                    String idTemp = id;
                    if (components.size() > 0) {
                        idTemp = String.valueOf(id) + "@" + components.size();
                    }
                    components.add(idTemp);
                    Element primGroup = this.svg_g2d.createElement("g");
                    this.svg_g2d.pushParent(primGroup);
                    primGroup.setAttribute("id", String.valueOf(groupIdentifier) + "_" + idTemp);
                    primGroup.setAttribute("style", "visibility:visible;");
                    this.svg_g2d.setDeferStrokColor(primGroup);
                }
            } else {
                Object designObject = null;
                if (this.getElementFromSource(sourceObject, StructureType.TITLE) != null) {
                    designObject = sourceObject.getSource();
                } else if (this.getElementFromSource(sourceObject, StructureType.CHART_BLOCK) != null) {
                    designObject = sourceObject.getSource();
                } else if (this.getElementFromSource(sourceObject, StructureType.PLOT) != null) {
                    designObject = sourceObject.getSource();
                } else if (this.getElementFromSource(sourceObject, StructureType.AXIS) != null) {
                    designObject = sourceObject.getSource();
                }
                if (designObject != null) {
                    String groupIdentifier = String.valueOf(designObject.hashCode());
                    String id = Integer.toString(pre.hashCode());
                    List<String> components = this.componentPrimitives.get(designObject);
                    if (components == null) {
                        components = new ArrayList<String>();
                        this.componentPrimitives.put(designObject, components);
                    }
                    String idTemp = id;
                    if (components.size() > 0) {
                        idTemp = String.valueOf(id) + "@" + components.size();
                    }
                    components.add(idTemp);
                    Element primGroup = this.svg_g2d.createElement("g");
                    this.svg_g2d.pushParent(primGroup);
                    primGroup.setAttribute("id", String.valueOf(groupIdentifier) + "_" + idTemp);
                    primGroup.setAttribute("style", "visibility:visible;");
                    this.svg_g2d.setDeferStrokColor(primGroup);
                }
            }
        }
    }

    protected void ungroupPrimitive(PrimitiveRenderEvent pre, boolean drawText) {
        if (this._iun == null) {
            logger.log(2, Messages.getString("exception.missing.component.interaction", this.getULocale()));
            return;
        }
        if (pre.getSource() instanceof StructureSource) {
            StructureSource sourceObject = (StructureSource)pre.getSource();
            Series series = (Series)this.getElementFromSource(sourceObject, StructureType.SERIES);
            if (series != null) {
                if (drawText) {
                    this.svg_g2d.popParent();
                    this.svg_g2d.popParent();
                } else {
                    this.svg_g2d.setDeferStrokColor(null);
                    this.svg_g2d.popParent();
                }
            } else if (this.getElementFromSource(sourceObject, StructureType.TITLE) != null || this.getElementFromSource(sourceObject, StructureType.AXIS) != null || this.getElementFromSource(sourceObject, StructureType.CHART_BLOCK) != null || this.getElementFromSource(sourceObject, StructureType.PLOT) != null) {
                this.svg_g2d.setDeferStrokColor(null);
                this.svg_g2d.popParent();
            }
        }
    }

    private Object getElementFromSource(StructureSource src, StructureType type) {
        if (src instanceof WrappedStructureSource) {
            Object wss = (WrappedStructureSource)src;
            while (wss != null) {
                if (wss.getType() == type) {
                    return wss.getSource();
                }
                if (wss.getParent().getType() == type) {
                    return wss.getParent().getSource();
                }
                wss = wss.getParent() instanceof WrappedStructureSource ? (WrappedStructureSource)wss.getParent() : null;
            }
        } else if (src.getType() == type) {
            return src.getSource();
        }
        return null;
    }

    private Series findCategorySeries(Series seDT) {
        Chart cmDT = this._iun.getDesignTimeModel();
        if (cmDT instanceof ChartWithAxes) {
            return (Series)((SeriesDefinition)((ChartWithAxes)cmDT).getBaseAxes()[0].getSeriesDefinitions().get(0)).getRunTimeSeries().get(0);
        }
        return (Series)((SeriesDefinition)((ChartWithoutAxes)cmDT).getSeriesDefinitions().get(0)).getRunTimeSeries().get(0);
    }

    public void prepareInteractiveEvent(Element elm, InteractionEvent ie, Trigger[] triggers) {
        if ((triggers = this.removeAddedOnloadEvent(ie, triggers)) != null && triggers.length > 0) {
            this.cacheEvents.add(new CacheEvent(elm, ie.getStructureSource(), triggers, ie.getCursor()));
        }
    }

    private Trigger[] removeAddedOnloadEvent(InteractionEvent ie, Trigger[] triggers) {
        int indexOnload = -1;
        boolean bDelete = false;
        if (ie.getStructureSource().getType() == StructureType.SERIES_DATA_POINT) {
            int i = 0;
            while (i < triggers.length) {
                if (triggers[i].getCondition().getValue() == 15) {
                    if (this.isColoredByCategories() && (triggers[i].getAction().getType() == ActionType.TOGGLE_VISIBILITY_LITERAL || triggers[i].getAction().getType() == ActionType.TOGGLE_DATA_POINT_VISIBILITY_LITERAL)) {
                        Object dph = ie.getStructureSource().getSource();
                        if (!this.mapOnloadAdded.containsKey(dph)) {
                            this.mapOnloadAdded.put(dph, Boolean.TRUE);
                            return triggers;
                        }
                        bDelete = true;
                    }
                    indexOnload = i;
                    break;
                }
                ++i;
            }
            if (indexOnload >= 0) {
                Object series = ((WrappedStructureSource)ie.getStructureSource()).getParent().getSource();
                if (bDelete || this.mapOnloadAdded.containsKey(series)) {
                    if (triggers.length == 1) {
                        return null;
                    }
                    Trigger[] newTriggers = new Trigger[triggers.length - 1];
                    System.arraycopy(triggers, 0, newTriggers, 0, indexOnload);
                    System.arraycopy(triggers, indexOnload + 1, newTriggers, indexOnload, triggers.length - indexOnload - 1);
                    return newTriggers;
                }
                this.mapOnloadAdded.put(series, Boolean.TRUE);
            }
        }
        return triggers;
    }

    public void addInteractivity() {
        for (CacheEvent cEvent : this.cacheEvents) {
            this.addEventHandling(cEvent.getElement(), cEvent.getSource(), cEvent.getTriggers(), cEvent.getCursor());
        }
    }

    private void addEventHandling(Element elm, StructureSource src, Trigger[] triggers, Cursor cursor) {
        if (elm != null && triggers != null) {
            Trigger tg;
            if (triggers != null && triggers.length > 0) {
                this.setCursorAttribute(elm, cursor, this.defaultCursor);
            }
            boolean redirect = false;
            int x = 0;
            while (x < triggers.length) {
                tg = triggers[x];
                redirect = MultiActionValuesScriptGenerator.containsRedirection((Action)tg.getAction());
                ++x;
            }
            if (redirect) {
                Element aLink = this.svg_g2d.createElement("a");
                Element group = this.svg_g2d.createElement("g");
                group.appendChild(elm);
                aLink.setAttribute("xlink:href", "");
                aLink.appendChild(group);
                elm = group;
                this.hotspotLayer.appendChild(aLink);
            } else {
                this.hotspotLayer.appendChild(elm);
            }
            x = 0;
            while (x < triggers.length) {
                tg = triggers[x];
                String scriptEvent = this.getJsScriptEvent(tg.getCondition().getValue());
                if (scriptEvent != null) {
                    Action action;
                    boolean bDblClick = false;
                    if (scriptEvent.equals("ondblclick")) {
                        scriptEvent = "onclick";
                        bDblClick = true;
                    }
                    if ((action = tg.getAction()) instanceof MultipleActions) {
                        this.addMultiActionsJSCode(elm, src, tg, scriptEvent, bDblClick, (MultipleActions)action);
                    } else {
                        this.addActionJSCode(elm, src, tg, scriptEvent, bDblClick, action);
                    }
                }
                ++x;
            }
        }
    }

    private void addActionJSCode(Element elm, StructureSource src, Trigger tg, String scriptEvent, boolean bDblClick, Action action) {
        switch (action.getType().getValue()) {
            case 1: {
                this.addTooltipJSCode(elm, src, scriptEvent, bDblClick, action);
                break;
            }
            case 0: {
                this.addURLRedirectJSCode(elm, src, scriptEvent, bDblClick, action);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                this.addJSCodeOnElement(src, tg, elm, scriptEvent, action.getType().getValue(), bDblClick);
                break;
            }
            case 3: {
                this.addInvokeScriptJSCode(elm, src, tg, scriptEvent, bDblClick, action);
            }
        }
    }

    private void addMultiActionsJSCode(Element elm, StructureSource src, Trigger tg, String scriptEvent, boolean bDblClick, MultipleActions action) {
        List subActions = MultiActionValuesScriptGenerator.getValidActions((MultipleActions)action);
        if (subActions.size() == 1) {
            Action subAction = (Action)subActions.get(0);
            this.addActionJSCode(elm, src, tg, scriptEvent, bDblClick, subAction);
        } else if (subActions.size() > 1) {
            String callbackContent = this.getMultiActionsCallbackContent(action);
            StringBuffer callbackFunction = this.generateScriptCallbackFunctionName(callbackContent);
            String funcName = callbackFunction.toString();
            this.addCallBackScript(src, callbackFunction, false);
            boolean multipleTypes = false;
            for (Action subAction : subActions) {
                if (subAction instanceof MultipleActions) continue;
                int typeValue = subAction.getType().getValue();
                switch (typeValue) {
                    case 2: 
                    case 4: 
                    case 6: {
                        multipleTypes = true;
                    }
                }
                if (multipleTypes) break;
            }
            if (multipleTypes) {
                callbackFunction.append(this.getJSCodeFunctionSuffix(src));
            } else {
                callbackFunction.append(")");
            }
            String jsFunction = callbackFunction.toString();
            elm.setAttribute(scriptEvent, this.wrapJS(bDblClick, jsFunction));
            if (tg.getCondition().getValue() == 6) {
                elm.setAttribute("onmouseout", jsFunction);
            }
            if (!this.scripts.contains(callbackContent)) {
                this.svg_g2d.addScript(String.valueOf(this.generateCallBackMethodName(funcName)) + "{" + callbackContent + "}");
                this.scripts.add(callbackContent);
            }
        }
    }

    private void addTooltipJSCode(Element elm, StructureSource src, String scriptEvent, boolean bDblClick, Action action) {
        String tooltipText = ((TooltipValue)action.getValue()).getText();
        if (tooltipText != null && tooltipText.trim().length() > 0) {
            Element title = this.svg_g2d.dom.createElement("title");
            title.appendChild(this.svg_g2d.dom.createTextNode(tooltipText));
            elm.appendChild(title);
            String componentId = null;
            if (src instanceof WrappedStructureSource) {
                componentId = this.findFirstComponentId((WrappedStructureSource)src);
            }
            if (scriptEvent.equals("onmouseover")) {
                elm.setAttribute("onmouseout", "TM.remove()");
                if (componentId != null) {
                    elm.setAttribute("onmousemove", "TM.show(evt," + componentId + ")");
                } else {
                    elm.setAttribute("onmousemove", "TM.show(evt)");
                }
            } else if (componentId != null) {
                elm.setAttribute(scriptEvent, this.wrapJS(bDblClick, "TM.toggleToolTip(evt," + componentId + ")"));
            } else {
                elm.setAttribute(scriptEvent, this.wrapJS(bDblClick, "TM.toggleToolTip(evt)"));
            }
        }
    }

    private void addInvokeScriptJSCode(Element elm, StructureSource src, Trigger tg, String scriptEvent, boolean bDblClick, Action action) {
        if (tg.getCondition().equals((Object)TriggerCondition.ACCESSIBILITY_LITERAL)) {
            AccessibilityValue accessValue = (AccessibilityValue)action.getValue();
            if (accessValue.getText() != null) {
                Element title = this.svg_g2d.createElement("title");
                title.appendChild(this.svg_g2d.dom.createTextNode(accessValue.getText()));
                elm.appendChild(title);
            }
            if (accessValue.getAccessibility() != null) {
                Element description = this.svg_g2d.createElement("desc");
                description.appendChild(this.svg_g2d.dom.createTextNode(accessValue.getAccessibility()));
                elm.appendChild(description);
            }
        } else {
            String script = ((ScriptValue)action.getValue()).getScript();
            StringBuffer callbackFunction = this.generateScriptCallbackFunctionName(script);
            String funcName = callbackFunction.toString();
            this.addCallBackScript(src, callbackFunction, true);
            elm.setAttribute(scriptEvent, this.wrapJS(bDblClick, callbackFunction.toString()));
            if (!this.scripts.contains(script)) {
                this.svg_g2d.addScript(String.valueOf(this.generateCallBackMethodName(funcName)) + "{" + script + "}");
                this.scripts.add(script);
            }
        }
    }

    private void addURLRedirectJSCode(Element elm, StructureSource src, String scriptEvent, boolean bDblClick, Action action) {
        ActionValue av = action.getValue();
        if (av instanceof URLValue) {
            URLValue urlValue = (URLValue)av;
            this.setURLValueAttributes(urlValue, elm, src, scriptEvent, bDblClick);
        } else if (av instanceof MultiURLValues) {
            MultiURLValues muv = (MultiURLValues)av;
            List validURLValues = MultiActionValuesScriptGenerator.getValidURLValues((MultiURLValues)muv);
            int size = validURLValues.size();
            if (size == 1) {
                this.setURLValueAttributes((URLValue)validURLValues.get(0), elm, src, scriptEvent, bDblClick);
            } else if (size > 1) {
                this.setMultiURLValuesAttributes(muv, elm, src, scriptEvent, bDblClick);
            }
            this.setTooltipForURLRedirect(elm, src, muv.getTooltip());
        }
    }

    private static StringBuilder getPropertiesJS(EMap<String, String> propMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : propMap.entrySet()) {
            String key = (String)entry.getKey();
            String properties = (String)entry.getValue();
            if (MenuStylesKeyType.MENU.getName().equals(key)) {
                sb.append("\t menuInfo.menuStyles = '" + CSSHelper.getStylingHyphenFormat((String)properties) + "';\n");
                continue;
            }
            if (MenuStylesKeyType.MENU_ITEM.getName().equals(key)) {
                sb.append("\t menuInfo.menuItemStyles = '" + CSSHelper.getStylingHyphenFormat((String)properties) + "';\n");
                continue;
            }
            if (MenuStylesKeyType.ON_MOUSE_OVER.getName().equals(key)) {
                sb.append("\t menuInfo.mouseOverStyles = '" + CSSHelper.getStylingHyphenFormat((String)properties) + "';\n");
                continue;
            }
            if (!MenuStylesKeyType.ON_MOUSE_OUT.getName().equals(key)) continue;
            sb.append("\tmenuInfo.mouseOutStyles = '" + CSSHelper.getStylingHyphenFormat((String)properties) + "';\n");
        }
        return sb;
    }

    private String getMultiActionsCallbackContent(MultipleActions actions) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\t var menuInfo = new BirtChartMenuInfo();\n");
        EMap propMap = actions.getPropertiesMap();
        sb.append(SVGInteractiveRenderer.getPropertiesJS((EMap<String, String>)propMap).toString());
        int i = 0;
        for (Action subAction : MultiActionValuesScriptGenerator.getValidActions((MultipleActions)actions)) {
            int typeValue = subAction.getType().getValue();
            switch (typeValue) {
                case 0: {
                    sb = MultiActionValuesScriptGenerator.getURLValueJS((StringBuilder)sb, (int)i, (URLValue)((URLValue)subAction.getValue()));
                    break;
                }
                case 3: {
                    sb = MultiActionValuesScriptGenerator.getScriptValueJS((StringBuilder)sb, (int)i, (ScriptValue)((ScriptValue)subAction.getValue()));
                    break;
                }
                case 2: {
                    sb = MultiActionValuesScriptGenerator.getVisualJS((StringBuilder)sb, (int)i, (ActionValue)subAction.getValue(), (String)"BirtChartInteractivityActions.TOGGLE_VISIBILITY");
                    break;
                }
                case 6: {
                    sb = MultiActionValuesScriptGenerator.getVisualJS((StringBuilder)sb, (int)i, (ActionValue)subAction.getValue(), (String)"BirtChartInteractivityActions.TOGGLE_DATA_POINT_VISIBILITY");
                    break;
                }
                case 4: {
                    sb = MultiActionValuesScriptGenerator.getVisualJS((StringBuilder)sb, (int)i, (ActionValue)subAction.getValue(), (String)"BirtChartInteractivityActions.HIGHLIGHT");
                }
            }
            ++i;
        }
        MultiActionValuesScriptGenerator.appendInteractivityVariables((StringBuilder)sb);
        sb.append("\n");
        sb.append("  BirtChartActionsMenu.show( evt, source, menuInfo ); ");
        return sb.toString();
    }

    private void setMultiURLValuesAttributes(MultiURLValues values, Element elm, StructureSource src, String scriptEvent, boolean bDblClick) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\t var menuInfo = new BirtChartMenuInfo();\n");
        EMap propMap = values.getPropertiesMap();
        sb.append(SVGInteractiveRenderer.getPropertiesJS((EMap<String, String>)propMap).toString());
        int i = 0;
        for (URLValue uv : MultiActionValuesScriptGenerator.getValidURLValues((MultiURLValues)values)) {
            sb = MultiActionValuesScriptGenerator.getURLValueJS((StringBuilder)sb, (int)i, (URLValue)uv);
            ++i;
        }
        MultiActionValuesScriptGenerator.appendInteractivityVariables((StringBuilder)sb);
        sb.append("\n");
        sb.append("  BirtChartActionsMenu.show( evt, source, menuInfo ); ");
        String script = sb.toString();
        StringBuffer callbackFunction = this.generateScriptCallbackFunctionName(script);
        String funcName = callbackFunction.toString();
        this.addCallBackScript(src, callbackFunction, true);
        elm.setAttribute(scriptEvent, this.wrapJS(bDblClick, callbackFunction.toString()));
        if (!this.scripts.contains(script)) {
            this.svg_g2d.addScript(String.valueOf(this.generateCallBackMethodName(funcName)) + "{" + script + "}");
            this.scripts.add(script);
        }
    }

    private StringBuffer generateScriptCallbackFunctionName(String script) {
        StringBuffer callbackFunction = new StringBuffer("callback");
        int hashCode = script.hashCode();
        if (hashCode != Integer.MIN_VALUE) {
            callbackFunction.append(Math.abs(hashCode));
        } else {
            callbackFunction.append(Integer.MAX_VALUE);
        }
        return callbackFunction;
    }

    private void setURLValueAttributes(URLValue urlValue, Element elm, StructureSource src, String scriptEvent, boolean bDblClick) {
        String url = "";
        if (urlValue.getBaseUrl().startsWith("#")) {
            url = "top.document.location.hash='" + urlValue.getBaseUrl() + "';";
        } else if (urlValue.getBaseUrl().startsWith("javascript:")) {
            url = urlValue.getBaseUrl();
        } else {
            String target = urlValue.getTarget();
            if (target == null) {
                target = "null";
            }
            String jsRedirect = "redirect('" + target + "','" + urlValue.getBaseUrl() + "');";
            url = "try { parent." + jsRedirect + " } catch(e) { " + jsRedirect + " }";
        }
        elm.setAttribute(scriptEvent, this.wrapJS(bDblClick, url));
        this.setTooltipForURLRedirect(elm, src, urlValue);
    }

    private void setTooltipForURLRedirect(Element elm, StructureSource src, URLValue urlValue) {
        this.setTooltipForURLRedirect(elm, src, urlValue.getTooltip());
    }

    private void setTooltipForURLRedirect(Element elm, StructureSource src, String tooltipText) {
        if (tooltipText != null && tooltipText.trim().length() > 0) {
            Element title = this.svg_g2d.dom.createElement("title");
            title.appendChild(this.svg_g2d.dom.createTextNode(tooltipText));
            elm.appendChild(title);
            String componentId = null;
            if (src instanceof WrappedStructureSource) {
                componentId = this.findFirstComponentId((WrappedStructureSource)src);
            }
            elm.setAttribute("onmouseout", "TM.remove()");
            if (componentId != null) {
                elm.setAttribute("onmousemove", "TM.show(evt," + componentId + ")");
            } else {
                elm.setAttribute("onmousemove", "TM.show(evt)");
            }
        }
    }

    private final Series findDesignTimeSeries(Series seRT) throws ChartException {
        Series seDT = null;
        Chart cmRT = this._iun.getRunTimeModel();
        Chart cmDT = this._iun.getDesignTimeModel();
        if (cmDT instanceof ChartWithAxes) {
            EList elSE;
            SeriesDefinition sd;
            ChartWithAxes cwaRT = (ChartWithAxes)cmRT;
            ChartWithAxes cwaDT = (ChartWithAxes)cmDT;
            Axis[] axaBase = cwaRT.getPrimaryBaseAxes();
            Axis axBase = axaBase[0];
            Axis[] axaOrthogonal = cwaRT.getOrthogonalAxes(axBase, true);
            Series se = null;
            int i = -1;
            int j = 0;
            int k = 0;
            boolean bFound = false;
            EList elSD = axaBase[0].getSeriesDefinitions();
            j = 0;
            while (j < elSD.size()) {
                sd = (SeriesDefinition)elSD.get(j);
                elSE = sd.getSeries();
                k = 0;
                while (k < elSE.size()) {
                    se = (Series)elSE.get(k);
                    if (seRT == se) {
                        bFound = true;
                        break;
                    }
                    ++k;
                }
                if (bFound) break;
                ++j;
            }
            if (!bFound) {
                i = 0;
                while (i < axaOrthogonal.length) {
                    elSD = axaOrthogonal[i].getSeriesDefinitions();
                    j = 0;
                    while (j < elSD.size()) {
                        sd = (SeriesDefinition)elSD.get(j);
                        elSE = sd.getSeries();
                        k = 0;
                        while (k < elSE.size()) {
                            se = (Series)elSE.get(k);
                            if (seRT == se) {
                                bFound = true;
                                break;
                            }
                            ++k;
                        }
                        if (bFound) break;
                        ++j;
                    }
                    if (bFound) break;
                    ++i;
                }
            }
            if (!bFound) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 8, "info.cannot.find.series", new Object[]{seRT}, org.eclipse.birt.chart.device.extension.i18n.Messages.getResourceBundle((ULocale)this.getULocale()));
            }
            axaBase = cwaDT.getPrimaryBaseAxes();
            axBase = axaBase[0];
            axaOrthogonal = cwaDT.getOrthogonalAxes(axBase, true);
            elSD = i == -1 ? axaBase[0].getSeriesDefinitions() : axaOrthogonal[i].getSeriesDefinitions();
            sd = (SeriesDefinition)elSD.get(j);
            elSE = sd.getSeries();
            seDT = (Series)elSE.get(k);
        } else if (cmDT instanceof ChartWithoutAxes) {
            EList elSE;
            SeriesDefinition sd;
            ChartWithoutAxes cwoaRT = (ChartWithoutAxes)cmRT;
            ChartWithoutAxes cwoaDT = (ChartWithoutAxes)cmDT;
            Series se = null;
            int i = -1;
            int j = 0;
            int k = 0;
            boolean bFound = false;
            EList elSD = cwoaRT.getSeriesDefinitions();
            j = 0;
            while (j < elSD.size()) {
                sd = (SeriesDefinition)elSD.get(j);
                elSE = sd.getSeries();
                k = 0;
                while (k < elSE.size()) {
                    se = (Series)elSE.get(k);
                    if (seRT == se) {
                        bFound = true;
                        break;
                    }
                    ++k;
                }
                if (bFound) break;
                ++j;
            }
            if (!bFound) {
                i = 1;
                elSD = ((SeriesDefinition)cwoaRT.getSeriesDefinitions().get(0)).getSeriesDefinitions();
                j = 0;
                while (j < elSD.size()) {
                    sd = (SeriesDefinition)elSD.get(j);
                    elSE = sd.getSeries();
                    k = 0;
                    while (k < elSE.size()) {
                        se = (Series)elSE.get(k);
                        if (seRT == se) {
                            bFound = true;
                            break;
                        }
                        ++k;
                    }
                    if (bFound) break;
                    ++j;
                }
            }
            if (!bFound) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 8, "info.cannot.find.series", new Object[]{seRT}, org.eclipse.birt.chart.device.extension.i18n.Messages.getResourceBundle((ULocale)this.getULocale()));
            }
            elSD = i == -1 ? cwoaDT.getSeriesDefinitions() : ((SeriesDefinition)cwoaDT.getSeriesDefinitions().get(0)).getSeriesDefinitions();
            sd = (SeriesDefinition)elSD.get(j);
            elSE = sd.getSeries();
            seDT = (Series)elSE.get(k);
        }
        return seDT;
    }

    private String getJsScriptEvent(int condition) {
        switch (condition) {
            case 0: {
                return "onmouseover";
            }
            case 1: {
                return "onclick";
            }
            case 2: {
                return "onclick";
            }
            case 3: {
                return "ondblclick";
            }
            case 4: {
                return "onmousedown";
            }
            case 5: {
                return "onmouseup";
            }
            case 6: {
                return "onmouseover";
            }
            case 7: {
                return "onmousemove";
            }
            case 8: {
                return "onmouseout";
            }
            case 9: {
                return "onfocusin";
            }
            case 10: {
                return "onfocusout";
            }
            case 11: {
                return "onkeydown";
            }
            case 12: {
                return "onkeypress";
            }
            case 13: {
                return "onkeyup";
            }
            case 15: {
                return "onload";
            }
        }
        return null;
    }

    protected void setCursor(Element currentElement, Cursor cursor, String defaultCursor) {
        this.setCursorAttribute(currentElement, cursor, defaultCursor);
    }

    public void clear() {
        this.labelPrimitives.clear();
        this.componentPrimitives.clear();
        this.scripts.clear();
        this.mapOnloadAdded.clear();
    }

    public Node getHotspotLayer() {
        return this.hotspotLayer;
    }

    public void createHotspotLayer(Document dom) {
        this.hotspotLayer = dom.createElement("g");
        this.hotspotLayer.setAttribute("id", "hotSpots");
        this.hotspotLayer.setAttribute("style", "fill-opacity:0.01;fill:#FFFFFF;");
    }

    private ULocale getULocale() {
        return this.locale;
    }

    private boolean isColoredByCategories() {
        return this._iun.getRunTimeModel().getLegend().getItemType() == LegendItemType.CATEGORIES_LITERAL;
    }

    private String findFirstComponentId(WrappedStructureSource src) {
        Series seRT = (Series)this.getElementFromSource(src.getParent(), StructureType.SERIES);
        if (seRT != null) {
            Series seDT = null;
            String groupIdentifier = null;
            if (this.isColoredByCategories()) {
                seDT = this.findCategorySeries(seRT);
                StringBuffer sb = new StringBuffer();
                sb.append(seDT.hashCode());
                sb.append("index");
                sb.append(this.iFirstDataPointIndex);
                groupIdentifier = sb.toString();
            } else {
                try {
                    seDT = this.findDesignTimeSeries(seRT);
                }
                catch (ChartException e) {
                    logger.log((Exception)((Object)e));
                    return null;
                }
                groupIdentifier = String.valueOf(seDT.hashCode());
            }
            List<String> components = this.componentPrimitives.get(seDT);
            if (components != null && components.size() > 0) {
                return "'" + groupIdentifier + "_" + components.get(0) + "'";
            }
        }
        return null;
    }

    private String getJSCodeFunctionSuffix(StructureSource src) {
        String jsFunction = null;
        Series seRT = (Series)this.getElementFromSource(src, StructureType.SERIES);
        if (seRT != null) {
            Series seDT = null;
            String groupIdentifier = null;
            if (this.isColoredByCategories()) {
                seDT = this.findCategorySeries(seRT);
                int baseIndex = this.getDataPointHints(src).getIndex();
                StringBuffer sb = new StringBuffer();
                sb.append("'");
                sb.append(seDT.hashCode());
                sb.append("index");
                sb.append(baseIndex);
                sb.append("'");
                groupIdentifier = sb.toString();
            } else {
                try {
                    seDT = this.findDesignTimeSeries(seRT);
                }
                catch (ChartException e) {
                    logger.log((Exception)((Object)e));
                    return null;
                }
                groupIdentifier = String.valueOf(seDT.hashCode());
            }
            boolean includeLabels = true;
            boolean includeGraphics = true;
            if (includeGraphics || includeLabels) {
                StringBuffer sb = new StringBuffer();
                sb.append(", ");
                sb.append(groupIdentifier);
                sb.append(",new Array(");
                List<String> labelComponents = this.labelPrimitives.get(seDT);
                List<String> components = this.componentPrimitives.get(seDT);
                Iterator<String> iter = null;
                if (includeGraphics && components != null) {
                    iter = components.iterator();
                    this.appendArguments(sb, iter);
                    if (includeLabels && labelComponents != null) {
                        sb.append("), new Array(");
                    }
                }
                if (includeLabels && labelComponents != null) {
                    iter = labelComponents.iterator();
                    this.appendArguments(sb, iter);
                }
                sb.append(")");
                jsFunction = String.valueOf(sb.toString()) + ")";
            }
        } else {
            Object designObject = null;
            if (this.getElementFromSource(src, StructureType.TITLE) != null) {
                designObject = src.getSource();
            } else if (this.getElementFromSource(src, StructureType.PLOT) != null) {
                designObject = src.getSource();
            } else if (this.getElementFromSource(src, StructureType.CHART_BLOCK) != null) {
                designObject = src.getSource();
            } else if (this.getElementFromSource(src, StructureType.AXIS) != null) {
                designObject = src.getSource();
            }
            if (designObject != null) {
                List<String> components = this.componentPrimitives.get(designObject);
                Iterator<String> iter = null;
                if (components != null) {
                    String groupIdentifier = String.valueOf(designObject.hashCode());
                    StringBuffer sb = new StringBuffer();
                    sb.append(", ");
                    sb.append(groupIdentifier);
                    sb.append(",new Array(");
                    iter = components.iterator();
                    this.appendArguments(sb, iter);
                    sb.append(")");
                    jsFunction = String.valueOf(sb.toString()) + ")";
                }
            }
        }
        return jsFunction;
    }

    private void addJSCodeOnElement(StructureSource src, Trigger tg, Element elm, String scriptEvent, int type, boolean bDblClick) {
        Series seRT = (Series)this.getElementFromSource(src, StructureType.SERIES);
        if (seRT != null) {
            Series seDT = null;
            String groupIdentifier = null;
            if (this.isColoredByCategories()) {
                seDT = this.findCategorySeries(seRT);
                int baseIndex = this.getDataPointHints(src).getIndex();
                StringBuffer sb = new StringBuffer();
                sb.append("'");
                sb.append(seDT.hashCode());
                sb.append("index");
                sb.append(baseIndex);
                sb.append("'");
                groupIdentifier = sb.toString();
            } else {
                try {
                    seDT = this.findDesignTimeSeries(seRT);
                }
                catch (ChartException e) {
                    logger.log((Exception)((Object)e));
                    return;
                }
                groupIdentifier = String.valueOf(seDT.hashCode());
            }
            boolean includeLabels = false;
            boolean includeGraphics = false;
            String jsFunction = null;
            switch (type) {
                case 2: {
                    jsFunction = "toggleVisibility(evt";
                    includeLabels = true;
                    includeGraphics = true;
                    break;
                }
                case 6: {
                    jsFunction = "toggleLabelsVisibility(evt";
                    includeLabels = true;
                    includeGraphics = false;
                    break;
                }
                case 4: {
                    jsFunction = "highlight(evt";
                    includeLabels = true;
                    includeGraphics = true;
                }
            }
            if (jsFunction == null) {
                assert (false);
                return;
            }
            if (includeGraphics || includeLabels) {
                StringBuffer sb = new StringBuffer();
                sb.append(", ");
                sb.append(groupIdentifier);
                sb.append(",new Array(");
                List<String> labelComponents = this.labelPrimitives.get(seDT);
                List<String> components = this.componentPrimitives.get(seDT);
                Iterator<String> iter = null;
                if (includeGraphics && components != null) {
                    iter = components.iterator();
                    this.appendArguments(sb, iter);
                    if (includeLabels && labelComponents != null) {
                        sb.append("), new Array(");
                    }
                }
                if (includeLabels && labelComponents != null) {
                    iter = labelComponents.iterator();
                    this.appendArguments(sb, iter);
                }
                sb.append(")");
                jsFunction = String.valueOf(jsFunction) + sb.toString() + ")";
                elm.setAttribute(scriptEvent, this.wrapJS(bDblClick, jsFunction));
                if (tg.getCondition().getValue() == 6) {
                    elm.setAttribute("onmouseout", jsFunction);
                }
            }
        } else {
            Object designObject = null;
            if (this.getElementFromSource(src, StructureType.TITLE) != null) {
                designObject = src.getSource();
            } else if (this.getElementFromSource(src, StructureType.PLOT) != null) {
                designObject = src.getSource();
            } else if (this.getElementFromSource(src, StructureType.CHART_BLOCK) != null) {
                designObject = src.getSource();
            } else if (this.getElementFromSource(src, StructureType.AXIS) != null) {
                designObject = src.getSource();
            }
            if (designObject != null) {
                String jsFunction = null;
                switch (type) {
                    case 2: {
                        jsFunction = "toggleVisibility(evt";
                        break;
                    }
                    case 4: {
                        jsFunction = "highlight(evt";
                    }
                }
                if (jsFunction == null) {
                    assert (false);
                    return;
                }
                List<String> components = this.componentPrimitives.get(designObject);
                Iterator<String> iter = null;
                if (components != null) {
                    String groupIdentifier = String.valueOf(designObject.hashCode());
                    StringBuffer sb = new StringBuffer();
                    sb.append(", ");
                    sb.append(groupIdentifier);
                    sb.append(",new Array(");
                    iter = components.iterator();
                    this.appendArguments(sb, iter);
                    sb.append(")");
                    elm.setAttribute(scriptEvent, this.wrapJS(bDblClick, String.valueOf(jsFunction) + sb.toString() + ")"));
                    if (tg.getCondition().getValue() == 6) {
                        elm.setAttribute("onmouseout", String.valueOf(jsFunction) + sb.toString() + ")");
                    }
                }
            }
        }
    }

    private void appendArguments(StringBuffer sb, Iterator<String> iter) {
        if (iter != null) {
            while (iter.hasNext()) {
                sb.append("'").append(iter.next()).append("'");
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
        }
    }

    private String wrapJS(boolean bDblClick, String js) {
        if (!bDblClick) {
            return js;
        }
        return "if ( evt.detail==2 ){" + js + "}";
    }

    private void setCursorAttribute(Element elm, Cursor cursor, String defaultValue) {
        String style = elm.getAttribute("style");
        if (style == null) {
            style = "";
        }
        if (cursor == null || cursor.getType() == CursorType.AUTO) {
            return;
        }
        String value = String.valueOf(style) + CSSHelper.getCSSCursorValue((Cursor)cursor);
        if (value == null) {
            elm.setAttribute("style", String.valueOf(style) + defaultValue);
        } else {
            elm.setAttribute("style", String.valueOf(style) + value);
        }
    }

    private void addCallBackScript(StructureSource src, StringBuffer callbackFunction, boolean hasEndTag) {
        callbackFunction.append("(evt,");
        callbackFunction.append(src.getSource().hashCode());
        DataPointHints dph = StructureType.SERIES_DATA_POINT.equals(src.getType()) ? (DataPointHints)src.getSource() : null;
        LegendItemHints lerh = StructureType.LEGEND_ENTRY.equals(src.getType()) ? (LegendItemHints)src.getSource() : null;
        String axisLabel = StructureType.AXIS_LABEL.equals(src.getType()) ? (String)src.getSource() : null;
        ScriptUtil.script((StringBuffer)callbackFunction, (DataPointHints)dph, (LegendItemHints)lerh, (String)axisLabel);
        if (hasEndTag) {
            callbackFunction.append(");");
        }
    }

    private String generateCallBackMethodName(String funcName) {
        return "function " + funcName + "(evt,source," + "categoryData" + "," + "valueData" + "," + "valueSeriesName" + "," + "legendItemText" + "," + "legendItemValue" + "," + "axisLabel" + "," + "id" + "," + "compList" + "," + "labelList" + ")";
    }

    private DataPointHints getDataPointHints(StructureSource src) {
        if (src.getType() == StructureType.SERIES_DATA_POINT || src.getType() == StructureType.SERIES_ELEMENT) {
            return (DataPointHints)src.getSource();
        }
        if (src instanceof WrappedStructureSource) {
            return this.getDataPointHints(((WrappedStructureSource)src).getParent());
        }
        return null;
    }
}

