/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse;

import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Messages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.spi.p2.artifact.repository.AbstractArtifactRepository;

public class AggregatedBundleRepository
extends AbstractArtifactRepository
implements IFileArtifactRepository {
    private static final String REPOSITORY_TYPE;
    private final Collection bundleRepositories;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.p2.touchpoint.eclipse.AggregatedBundleRepository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REPOSITORY_TYPE = clazz.getName();
    }

    public AggregatedBundleRepository(Collection bundleRepositories) {
        super(REPOSITORY_TYPE, REPOSITORY_TYPE, "1.0", null, null, null, null);
        this.bundleRepositories = bundleRepositories;
    }

    public File getArtifactFile(IArtifactKey key) {
        Iterator it = this.bundleRepositories.iterator();
        while (it.hasNext()) {
            IFileArtifactRepository repository = (IFileArtifactRepository)it.next();
            File artifactFile = repository.getArtifactFile(key);
            if (artifactFile == null) continue;
            return artifactFile;
        }
        return null;
    }

    public File getArtifactFile(IArtifactDescriptor descriptor) {
        Iterator it = this.bundleRepositories.iterator();
        while (it.hasNext()) {
            IFileArtifactRepository repository = (IFileArtifactRepository)it.next();
            File artifactFile = repository.getArtifactFile(descriptor);
            if (artifactFile == null) continue;
            return artifactFile;
        }
        return null;
    }

    public boolean contains(IArtifactDescriptor descriptor) {
        Iterator it = this.bundleRepositories.iterator();
        while (it.hasNext()) {
            IFileArtifactRepository repository = (IFileArtifactRepository)it.next();
            if (!repository.contains(descriptor)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IArtifactKey key) {
        Iterator it = this.bundleRepositories.iterator();
        while (it.hasNext()) {
            IFileArtifactRepository repository = (IFileArtifactRepository)it.next();
            if (!repository.contains(key)) continue;
            return true;
        }
        return false;
    }

    public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        HashSet<IArtifactDescriptor> artifactDescriptors = new HashSet<IArtifactDescriptor>();
        Iterator it = this.bundleRepositories.iterator();
        while (it.hasNext()) {
            IFileArtifactRepository repository = (IFileArtifactRepository)it.next();
            IArtifactDescriptor[] descriptors = repository.getArtifactDescriptors(key);
            if (descriptors == null) continue;
            artifactDescriptors.addAll(Arrays.asList(descriptors));
        }
        return artifactDescriptors.toArray(new IArtifactDescriptor[artifactDescriptors.size()]);
    }

    public IArtifactKey[] getArtifactKeys() {
        HashSet<IArtifactKey> artifactKeys = new HashSet<IArtifactKey>();
        Iterator it = this.bundleRepositories.iterator();
        while (it.hasNext()) {
            IFileArtifactRepository repository = (IFileArtifactRepository)it.next();
            IArtifactKey[] keys = repository.getArtifactKeys();
            if (keys == null) continue;
            artifactKeys.addAll(Arrays.asList(keys));
        }
        return artifactKeys.toArray(new IArtifactKey[artifactKeys.size()]);
    }

    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        throw new UnsupportedOperationException(Messages.artifact_retrieval_unsupported);
    }

    public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        throw new UnsupportedOperationException(Messages.artifact_retrieval_unsupported);
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        throw new UnsupportedOperationException(Messages.artifact_retrieval_unsupported);
    }

    public OutputStream getOutputStream(IArtifactDescriptor descriptor) {
        throw new UnsupportedOperationException(Messages.artifact_write_unsupported);
    }

    public Collection testGetBundleRepositories() {
        return this.bundleRepositories;
    }
}

