/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withoutaxes;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.computation.withoutaxes.PlotWithoutAxes;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;

public class SeriesRenderingHints
implements ISeriesRenderingHints {
    private int iDataSetStructure = 0;
    private final DataSetIterator dsiBase;
    private final DataSetIterator dsiOrthogonal;
    private final DataPointHints[] dpha;
    private final PlotWithoutAxes pwoa;
    private static final IGObjectFactory goFactory = GObjectFactory.instance();

    SeriesRenderingHints(PlotWithoutAxes pwoa, DataPointHints[] dpha, DataSetIterator dsiBase, DataSetIterator dsiOrthogonal) {
        this.pwoa = pwoa;
        this.dpha = dpha;
        this.dsiBase = dsiBase;
        this.dsiOrthogonal = dsiOrthogonal;
        this.iDataSetStructure = dsiBase.size() != dsiOrthogonal.size() ? (this.iDataSetStructure |= 2) : 1;
        if (dsiBase.isEmpty()) {
            this.iDataSetStructure |= 4;
        }
        if (dsiOrthogonal.isEmpty()) {
            this.iDataSetStructure |= 8;
        }
    }

    public final DataPointHints[] getDataPoints() {
        return this.dpha;
    }

    public final Double[] asDoubleValues() throws ChartException {
        int iCount = this.dpha.length;
        Double[] doa = new Double[iCount];
        int i = 0;
        while (i < iCount) {
            Object o = this.dpha[i].getOrthogonalValue();
            if (o instanceof NumberDataElement) {
                NumberDataElement nde = (NumberDataElement)o;
                doa[i] = new Double(nde.getValue());
            } else if (o == null) {
                doa[i] = null;
            } else {
                throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.dataset.non.numerical.to.numerical", new Object[]{o}, Messages.getResourceBundle(this.pwoa.getRunTimeContext().getULocale()));
            }
            ++i;
        }
        return doa;
    }

    public final double[] asPrimitiveDoubleValues() throws ChartException {
        int iCount = this.dpha.length;
        double[] doa = new double[iCount];
        int i = 0;
        while (i < iCount) {
            Object o = this.dpha[i].getOrthogonalValue();
            if (o instanceof Double) {
                doa[i] = (Double)o;
            } else if (o == null) {
                doa[i] = Double.NaN;
            } else {
                throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.dataset.non.numerical.to.numerical", new Object[]{o}, Messages.getResourceBundle(this.pwoa.getRunTimeContext().getULocale()));
            }
            ++i;
        }
        return doa;
    }

    public int getDataSetStructure() {
        return this.iDataSetStructure;
    }

    public DataSetIterator getBaseDataSet() {
        return this.dsiBase;
    }

    public DataSetIterator getOrthogonalDataSet() {
        return this.dsiOrthogonal;
    }

    public Bounds getClientAreaBounds(boolean bReduceByInsets) {
        Bounds boClientArea = goFactory.copyOf(this.pwoa.getPlotBounds());
        if (bReduceByInsets) {
            boClientArea.adjust(this.pwoa.getPlotInsets());
        }
        return boClientArea;
    }
}

