/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

public final class AxisSubUnit {
    private double dValueLast = 0.0;
    private double dValueLastNegative = 0.0;
    private double dPositiveTotal = 0.0;
    private double dNegativeTotal = 0.0;
    private double dTotal = 0.0;
    private double dTotalMax = 0.0;
    private double dTotalMin = 0.0;
    private double dLastMaxPosition = Double.NaN;
    private double dLastMinPosition = Double.NaN;
    private final boolean bStackTogether;

    AxisSubUnit(boolean bStackTogether) {
        this.bStackTogether = bStackTogether;
    }

    public final void reset() {
        this.dValueLastNegative = 0.0;
        this.dValueLast = 0.0;
        this.dLastMaxPosition = Double.NaN;
        this.dLastMinPosition = Double.NaN;
    }

    public boolean isStackTogether() {
        return this.bStackTogether;
    }

    public final double stackValue(double dValue) {
        if (this.bStackTogether) {
            this.dValueLast += dValue;
        } else if (dValue > 0.0) {
            this.dValueLast += dValue;
        } else if (dValue < 0.0) {
            this.dValueLastNegative += dValue;
        }
        return this.getStackedValue(dValue);
    }

    public final double getStackedValue(double dValue) {
        if (this.bStackTogether) {
            return this.dValueLast;
        }
        if (dValue > 0.0) {
            return this.dValueLast;
        }
        if (dValue < 0.0) {
            return this.dValueLastNegative;
        }
        return this.dValueLast;
    }

    public final void computeTotal(double dValue) {
        if (this.bStackTogether) {
            this.dTotal += dValue;
            this.dTotalMax = Math.max(this.dTotalMax, this.dTotal);
            this.dTotalMin = Math.min(this.dTotalMin, this.dTotal);
        }
        if (dValue > 0.0) {
            this.dPositiveTotal += dValue;
        } else if (dValue < 0.0) {
            this.dNegativeTotal += dValue;
        }
    }

    public final double getPositiveTotal() {
        return this.dPositiveTotal;
    }

    public final double getNegativeTotal() {
        return this.dNegativeTotal;
    }

    final double getTotalMax() {
        return this.bStackTogether ? this.dTotalMax : this.dPositiveTotal;
    }

    final double getTotalMin() {
        return this.bStackTogether ? this.dTotalMin : this.dNegativeTotal;
    }

    public final double valuePercentage(double dValue) {
        if (this.dPositiveTotal - this.dNegativeTotal == 0.0) {
            return 0.0;
        }
        return dValue * 100.0 / (this.dPositiveTotal - this.dNegativeTotal);
    }

    public final void setLastPosition(double dValue, double dBaseLocation, double dMargin) {
        if (this.bStackTogether || dValue >= 0.0) {
            if (!Double.isNaN(this.dLastMaxPosition)) {
                dBaseLocation = this.dLastMaxPosition;
            }
            this.dLastMaxPosition = dBaseLocation += dMargin;
        } else {
            if (!Double.isNaN(this.dLastMinPosition)) {
                dBaseLocation = this.dLastMinPosition;
            }
            this.dLastMinPosition = dBaseLocation += dMargin;
        }
    }

    public final double getLastPosition(double dValue) {
        if (this.bStackTogether || dValue >= 0.0) {
            return this.dLastMaxPosition;
        }
        return this.dLastMinPosition;
    }
}

