/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import com.ibm.icu.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.datafeed.IDataPointEntry;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponent;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.emf.common.util.EList;

public final class DataPointHints {
    private boolean isVirtual = false;
    private final RunTimeContext rtc;
    private Object oBaseValue;
    private Object oOrthogonalValue;
    private Double oStackedOrthogonalValue;
    private Object oSeriesValue;
    private Object oPercentileOrthogonalValue;
    private Map<String, Object> userValueMap;
    private int index;
    private final Location lo;
    private final double[] dSize;
    private final DataPoint dp;
    private boolean bOutside = false;
    private final FormatSpecifier fsBase;
    private final FormatSpecifier fsOrthogonal;
    private final FormatSpecifier fsSeries;
    private final FormatSpecifier fsPercentile;
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/computation");

    public DataPointHints(Object _oBaseValue, Object _oOrthogonalValue, Object _oSeriesValue, Object _oPercentileValue, DataPoint _dp, FormatSpecifier _fsBase, FormatSpecifier _fsOrthogonal, FormatSpecifier _fsSeries, FormatSpecifier _fsPercentile, int _idx, Location _lo, double _dSize, RunTimeContext _rtc) throws ChartException {
        this.dp = _dp;
        this.oBaseValue = _oBaseValue;
        this.oOrthogonalValue = _oOrthogonalValue;
        this.oSeriesValue = _oSeriesValue instanceof String ? _rtc.externalizedMessage((String)_oSeriesValue) : _oSeriesValue;
        this.oPercentileOrthogonalValue = _oPercentileValue;
        this.fsBase = _fsBase;
        this.fsOrthogonal = _fsOrthogonal;
        this.fsSeries = _fsSeries;
        this.fsPercentile = _fsPercentile;
        this.index = _idx;
        this.lo = _lo;
        this.rtc = _rtc;
        this.dSize = new double[2];
        this.dSize[0] = _dSize;
    }

    public DataPointHints(Object _oBaseValue, Object _oOrthogonalValue, Object _oSeriesValue, Object _oPercentileValue, DataPoint _dp, FormatSpecifier _fsBase, FormatSpecifier _fsOrthogonal, FormatSpecifier _fsSeries, FormatSpecifier _fsPercentile, int _idx, Location _lo, double[] _dSize, RunTimeContext _rtc) throws ChartException {
        this(_oBaseValue, _oOrthogonalValue, _oSeriesValue, _oPercentileValue, _dp, _fsBase, _fsOrthogonal, _fsSeries, _fsPercentile, _idx, _lo, 0.0, _rtc);
        this.dSize[0] = _dSize[0];
        this.dSize[1] = _dSize[1];
    }

    public DataPointHints getVirtualCopy() throws ChartException {
        DataPointHints dph = new DataPointHints(this.oBaseValue, this.oOrthogonalValue, this.oSeriesValue, this.oPercentileOrthogonalValue, this.dp, this.fsBase, this.fsOrthogonal, this.fsSeries, this.fsPercentile, this.index, this.lo, this.dSize, this.rtc);
        dph.isVirtual = true;
        dph.userValueMap = this.userValueMap;
        return dph;
    }

    public void accumulate(Object _oBaseValue, Object _oOrthogonalValue, Object _oSeriesValue, Object _oPercentileOrthogonalValue) {
        if (this.oBaseValue instanceof Number) {
            if (_oBaseValue instanceof Number) {
                this.oBaseValue = new Double(((Number)this.oBaseValue).doubleValue() + ((Number)_oBaseValue).doubleValue());
            } else if (_oBaseValue instanceof NumberDataElement) {
                this.oBaseValue = new Double(((Number)this.oBaseValue).doubleValue() + ((NumberDataElement)_oBaseValue).getValue());
            }
        } else if (this.oBaseValue instanceof NumberDataElement) {
            if (_oBaseValue instanceof Number) {
                ((NumberDataElement)this.oBaseValue).setValue(((NumberDataElement)this.oBaseValue).getValue() + ((Number)_oBaseValue).doubleValue());
            } else if (_oBaseValue instanceof NumberDataElement) {
                ((NumberDataElement)this.oBaseValue).setValue(((NumberDataElement)this.oBaseValue).getValue() + ((NumberDataElement)_oBaseValue).getValue());
            }
        }
        if (this.oOrthogonalValue instanceof Number) {
            if (_oOrthogonalValue instanceof Number) {
                this.oOrthogonalValue = new Double(((Number)this.oOrthogonalValue).doubleValue() + ((Number)_oOrthogonalValue).doubleValue());
            } else if (_oOrthogonalValue instanceof NumberDataElement) {
                this.oOrthogonalValue = new Double(((Number)this.oOrthogonalValue).doubleValue() + ((NumberDataElement)_oOrthogonalValue).getValue());
            }
        } else if (this.oOrthogonalValue instanceof NumberDataElement) {
            if (_oOrthogonalValue instanceof Number) {
                ((NumberDataElement)this.oOrthogonalValue).setValue(((NumberDataElement)this.oOrthogonalValue).getValue() + ((Number)_oOrthogonalValue).doubleValue());
            } else if (_oOrthogonalValue instanceof NumberDataElement) {
                ((NumberDataElement)this.oOrthogonalValue).setValue(((NumberDataElement)this.oOrthogonalValue).getValue() + ((NumberDataElement)_oOrthogonalValue).getValue());
            }
        }
        if (this.oSeriesValue instanceof Number) {
            if (_oSeriesValue instanceof Number) {
                this.oSeriesValue = new Double(((Number)this.oSeriesValue).doubleValue() + ((Number)_oSeriesValue).doubleValue());
            } else if (_oSeriesValue instanceof NumberDataElement) {
                this.oSeriesValue = new Double(((Number)this.oSeriesValue).doubleValue() + ((NumberDataElement)_oSeriesValue).getValue());
            }
        } else if (this.oSeriesValue instanceof NumberDataElement) {
            if (_oSeriesValue instanceof Number) {
                ((NumberDataElement)this.oSeriesValue).setValue(((NumberDataElement)this.oSeriesValue).getValue() + ((Number)_oSeriesValue).doubleValue());
            } else if (_oSeriesValue instanceof NumberDataElement) {
                ((NumberDataElement)this.oSeriesValue).setValue(((NumberDataElement)this.oSeriesValue).getValue() + ((NumberDataElement)_oSeriesValue).getValue());
            }
        }
        if (this.oPercentileOrthogonalValue instanceof Number) {
            if (_oPercentileOrthogonalValue instanceof Number) {
                this.oPercentileOrthogonalValue = new Double(((Number)this.oPercentileOrthogonalValue).doubleValue() + ((Number)_oPercentileOrthogonalValue).doubleValue());
            } else if (_oPercentileOrthogonalValue instanceof NumberDataElement) {
                this.oPercentileOrthogonalValue = new Double(((Number)this.oPercentileOrthogonalValue).doubleValue() + ((NumberDataElement)_oPercentileOrthogonalValue).getValue());
            }
        } else if (this.oPercentileOrthogonalValue instanceof NumberDataElement) {
            if (_oPercentileOrthogonalValue instanceof Number) {
                ((NumberDataElement)this.oPercentileOrthogonalValue).setValue(((NumberDataElement)this.oPercentileOrthogonalValue).getValue() + ((Number)_oPercentileOrthogonalValue).doubleValue());
            } else if (_oPercentileOrthogonalValue instanceof NumberDataElement) {
                ((NumberDataElement)this.oPercentileOrthogonalValue).setValue(((NumberDataElement)this.oPercentileOrthogonalValue).getValue() + ((NumberDataElement)_oPercentileOrthogonalValue).getValue());
            }
        }
    }

    public final Object getBaseValue() {
        return this.oBaseValue;
    }

    public final Object getOrthogonalValue() {
        return this.oOrthogonalValue;
    }

    public final void setOrthogonalValue(Object value) {
        this.oOrthogonalValue = value;
    }

    public final Double getStackOrthogonalValue() {
        return this.oStackedOrthogonalValue;
    }

    public final void setStackOrthogonalValue(Double stackOrthogonalValue) {
        this.oStackedOrthogonalValue = stackOrthogonalValue;
    }

    public final void markOutside() {
        this.bOutside = true;
    }

    public final boolean isOutside() {
        return this.bOutside;
    }

    public final Object getSeriesValue() {
        return this.oSeriesValue;
    }

    public final Object getPercentileOrthogonalValue() {
        return this.oPercentileOrthogonalValue;
    }

    public final Location getLocation() {
        return this.lo;
    }

    public final Location3D getLocation3D() {
        if (this.lo instanceof Location3D) {
            return (Location3D)this.lo;
        }
        return null;
    }

    public final int getIndex() {
        return this.index;
    }

    public final double getSize() {
        return this.dSize[0];
    }

    public final Size getSize2D() {
        return SizeImpl.create(this.dSize[0], this.dSize[1]);
    }

    public final Object getUserValue(String key) {
        if (this.userValueMap == null) {
            return null;
        }
        Object value = this.userValueMap.get(key);
        if (value instanceof CDateTime) {
            return ((CDateTime)((Object)value)).getTime();
        }
        return value;
    }

    public final void setUserValue(String key, Object value) {
        if (this.userValueMap == null) {
            this.userValueMap = new HashMap<String, Object>();
        }
        this.userValueMap.put(key, value);
    }

    public final String getOrthogonalDisplayValue() {
        return this.getOrthogonalDisplayValue(this.fsOrthogonal);
    }

    public final String getBaseDisplayValue() {
        return this.getBaseDisplayValue(this.fsBase);
    }

    public final String getSeriesDisplayValue() {
        return this.getSeriesDisplayValue(this.fsSeries);
    }

    public final String getPercentileOrthogonalDisplayValue() {
        return this.getPercentileOrthogonalDisplayValue(this.fsPercentile);
    }

    private final String getBaseDisplayValue(FormatSpecifier fs) {
        if (this.oBaseValue == null) {
            return IConstants.NULL_STRING;
        }
        DecimalFormat df = null;
        if (fs == null && this.oBaseValue instanceof Number) {
            df = new DecimalFormat(ValueFormatter.getNumericPattern(((Number)this.oBaseValue).doubleValue()));
        }
        try {
            return ValueFormatter.format(this.oBaseValue, fs, this.rtc.getULocale(), df);
        }
        catch (Exception exception) {
            logger.log(4, Messages.getString("exception.parse.value.format.specifier", new Object[]{this.oBaseValue, fs}, this.rtc.getULocale()));
            return IConstants.NULL_STRING;
        }
    }

    private final String getOrthogonalDisplayValue(FormatSpecifier fs) {
        if (this.oOrthogonalValue == null) {
            return IConstants.NULL_STRING;
        }
        try {
            return ValueFormatter.format(this.oOrthogonalValue, fs, this.rtc.getULocale(), null);
        }
        catch (Exception exception) {
            logger.log(4, Messages.getString("exception.parse.value.format.specifier", new Object[]{this.oOrthogonalValue, fs}, this.rtc.getULocale()));
            return String.valueOf(this.oOrthogonalValue);
        }
    }

    private final String getSeriesDisplayValue(FormatSpecifier fs) {
        if (this.oSeriesValue == null) {
            return IConstants.NULL_STRING;
        }
        try {
            return ValueFormatter.format(this.oSeriesValue, fs, this.rtc.getULocale(), null);
        }
        catch (Exception exception) {
            logger.log(4, Messages.getString("exception.parse.value.format.specifier", new Object[]{this.oSeriesValue, fs}, this.rtc.getULocale()));
            return IConstants.NULL_STRING;
        }
    }

    private final String getPercentileOrthogonalDisplayValue(FormatSpecifier fs) {
        if (this.oPercentileOrthogonalValue == null) {
            return IConstants.NULL_STRING;
        }
        try {
            return ValueFormatter.format(this.oPercentileOrthogonalValue, fs, this.rtc.getULocale(), null);
        }
        catch (Exception exception) {
            logger.log(4, Messages.getString("exception.parse.value.format.specifier", new Object[]{this.oPercentileOrthogonalValue, fs}, this.rtc.getULocale()));
            return String.valueOf(this.oPercentileOrthogonalValue);
        }
    }

    public final String getDisplayValue() {
        StringBuffer sb;
        block8: {
            block7: {
                sb = new StringBuffer();
                if (this.dp != null) break block7;
                sb.append(this.getOrthogonalDisplayValue());
                break block8;
            }
            EList<DataPointComponent> el = this.dp.getComponents();
            if (this.dp.getPrefix() != null) {
                sb.append(this.dp.getPrefix());
            }
            int i = 0;
            while (i < el.size()) {
                block13: {
                    block10: {
                        DataPointComponentType dpct;
                        block11: {
                            String str;
                            String oType;
                            DataPointComponent dpc;
                            block12: {
                                block9: {
                                    dpc = (DataPointComponent)el.get(i);
                                    dpct = dpc.getType();
                                    if (dpct != DataPointComponentType.BASE_VALUE_LITERAL) break block9;
                                    sb.append(this.getBaseDisplayValue());
                                    break block10;
                                }
                                if (dpct != DataPointComponentType.ORTHOGONAL_VALUE_LITERAL) break block11;
                                oType = dpc.getOrthogonalType();
                                if (oType.length() != 0) break block12;
                                sb.append(this.getOrthogonalDisplayValue());
                                break block10;
                            }
                            if (!(this.oOrthogonalValue instanceof IDataPointEntry) || (str = ((IDataPointEntry)this.oOrthogonalValue).getFormattedString(oType, dpc.getFormatSpecifier(), this.rtc.getULocale())) == null) break block13;
                            sb.append(str);
                            break block10;
                        }
                        if (dpct == DataPointComponentType.SERIES_VALUE_LITERAL) {
                            sb.append(this.getSeriesDisplayValue());
                        } else if (dpct == DataPointComponentType.PERCENTILE_ORTHOGONAL_VALUE_LITERAL) {
                            sb.append(this.getPercentileOrthogonalDisplayValue());
                        }
                    }
                    if (i < el.size() - 1) {
                        sb.append(this.dp.getSeparator());
                    }
                }
                ++i;
            }
            if (this.dp.getSuffix() != null) {
                sb.append(this.dp.getSuffix());
            }
        }
        return sb.toString();
    }

    public final String toString() {
        return this.getDisplayValue();
    }

    public final void setBaseValue(Object newBaseValue) {
        this.oBaseValue = newBaseValue;
    }

    public final void setIndex(int index) {
        this.index = index;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }
}

