/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.ClosedBackupStoreException;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.LazyBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.Touchpoint;
import org.eclipse.osgi.util.NLS;

public class NativeTouchpoint
extends Touchpoint {
    public static final String PARM_BACKUP = "backup";
    private static Map backups = new WeakHashMap();

    public IStatus initializePhase(IProgressMonitor monitor, IProfile profile, String phaseId, Map touchpointParameters) {
        touchpointParameters.put(PARM_BACKUP, NativeTouchpoint.getBackupStore(profile));
        return null;
    }

    public String qualifyAction(String actionId) {
        return "org.eclipse.equinox.p2.touchpoint.natives." + actionId;
    }

    public IStatus prepare(IProfile profile) {
        return super.prepare(profile);
    }

    public IStatus commit(IProfile profile) {
        IBackupStore store = NativeTouchpoint.getBackupStore(profile);
        store.discard();
        return Status.OK_STATUS;
    }

    public static String escape(String toEscape) {
        StringBuffer buffer = new StringBuffer();
        int length = toEscape.length();
        int i = 0;
        while (i < length) {
            char ch = toEscape.charAt(i);
            switch (ch) {
                case '\"': 
                case '%': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    buffer.append("%" + ch + ";");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public IStatus rollback(IProfile profile) {
        IStatus returnStatus = Status.OK_STATUS;
        IBackupStore store = NativeTouchpoint.getBackupStore(profile);
        try {
            store.restore();
        }
        catch (IOException e) {
            returnStatus = new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", NLS.bind((String)Messages.failed_backup_restore, (Object)store.getBackupName()), (Throwable)e);
        }
        catch (ClosedBackupStoreException e) {
            returnStatus = new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", NLS.bind((String)Messages.failed_backup_restore, (Object)store.getBackupName()), (Throwable)e);
        }
        NativeTouchpoint.clearProfileState(profile);
        return returnStatus;
    }

    private static synchronized void clearProfileState(IProfile profile) {
        backups.remove(profile);
    }

    private static synchronized IBackupStore getBackupStore(IProfile profile) {
        IBackupStore store = (IBackupStore)backups.get(profile);
        if (store == null) {
            store = new LazyBackupStore(NativeTouchpoint.escape(profile.getProfileId()));
            backups.put(profile, store);
        }
        return store;
    }
}

