/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.dialogs;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.AbstractBindingDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ResourceEditDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BindingExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.AggregationArgument;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ChartCubeBindingDialogHelper
extends AbstractBindingDialogHelper {
    protected static final String NAME = Messages.getString((String)"BindingDialogHelper.text.Name");
    protected static final String DATA_TYPE = Messages.getString((String)"BindingDialogHelper.text.DataType");
    protected static final String FUNCTION = Messages.getString((String)"BindingDialogHelper.text.Function");
    protected static final String DATA_FIELD = Messages.getString((String)"BindingDialogHelper.text.DataField");
    protected static final String FILTER_CONDITION = Messages.getString((String)"BindingDialogHelper.text.Filter");
    protected static final String AGGREGATE_ON = Messages.getString((String)"BindingDialogHelper.text.AggOn");
    protected static final String EXPRESSION = Messages.getString((String)"BindingDialogHelper.text.Expression");
    protected static final String ALL = Messages.getString((String)"CrosstabBindingDialogHelper.AggOn.All");
    protected static final String DISPLAY_NAME = Messages.getString((String)"BindingDialogHelper.text.displayName");
    protected static final String DISPLAY_NAME_ID = Messages.getString((String)"BindingDialogHelper.text.displayNameID");
    protected static final String DEFAULT_ITEM_NAME = Messages.getString((String)"BindingDialogHelper.bindingName.dataitem");
    protected static final String DEFAULT_AGGREGATION_NAME = Messages.getString((String)"BindingDialogHelper.bindingName.aggregation");
    protected static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getStructure("ComputedColumn").getMember("dataType").getAllowedChoices();
    protected static final IChoice[] DATA_TYPE_CHOICES = DATA_TYPE_CHOICE_SET.getChoices(null);
    protected String[] dataTypes = ChoiceSetFactory.getDisplayNamefromChoiceSet((IChoiceSet)DATA_TYPE_CHOICE_SET);
    private Text txtName;
    private Text txtFilter;
    private Text txtExpression;
    private Combo cmbType;
    private Combo cmbFunction;
    private Combo cmbAggOn;
    private Composite paramsComposite;
    private Button btnDisplayNameID;
    private Map<String, Control> paramsMap = new HashMap<String, Control>();
    private Composite composite;
    private Text txtDisplayName;
    private Text txtDisplayNameID;
    private ComputedColumn newBinding;
    private CLabel messageLine;
    private Label lbName;
    private Label lbDisplayNameID;
    private Object container;

    public void createContent(Composite parent) {
        this.composite = parent;
        ((GridLayout)this.composite.getLayout()).numColumns = 3;
        this.lbName = new Label(this.composite, 0);
        this.lbName.setText(NAME);
        this.txtName = new Text(this.composite, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.txtName.setLayoutData((Object)gd);
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChartCubeBindingDialogHelper.this.validate();
            }
        });
        this.lbDisplayNameID = new Label(this.composite, 0);
        this.lbDisplayNameID.setText(DISPLAY_NAME_ID);
        this.lbDisplayNameID.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    ChartCubeBindingDialogHelper.this.openKeySelectionDialog();
                }
            }
        });
        this.txtDisplayNameID = new Text(this.composite, 2056);
        this.txtDisplayNameID.setLayoutData((Object)new GridData(768));
        this.btnDisplayNameID = new Button(this.composite, 0);
        this.btnDisplayNameID.setEnabled(this.getResourceURL() != null);
        this.btnDisplayNameID.setText("...");
        this.btnDisplayNameID.setToolTipText(Messages.getString((String)"ResourceKeyDescriptor.button.browse.tooltip"));
        this.btnDisplayNameID.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ChartCubeBindingDialogHelper.this.openKeySelectionDialog();
            }
        });
        new Label(this.composite, 0).setText(DISPLAY_NAME);
        this.txtDisplayName = new Text(this.composite, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.txtDisplayName.setLayoutData((Object)gd);
        new Label(this.composite, 0).setText(DATA_TYPE);
        this.cmbType = new Combo(this.composite, 2056);
        this.cmbType.setLayoutData((Object)gd);
        if (this.isAggregate()) {
            this.createAggregateSection(this.composite);
        } else {
            this.createCommonSection(this.composite);
        }
        this.createMessageSection(this.composite);
        gd = new GridData(1808);
        this.composite.setLayoutData((Object)gd);
        this.setContentSize(this.composite);
    }

    private void openKeySelectionDialog() {
        ResourceEditDialog dlg = new ResourceEditDialog(this.composite.getShell(), Messages.getString((String)"ResourceKeyDescriptor.title.SelectKey"));
        dlg.setResourceURL(this.getResourceURL());
        if (dlg.open() == 0) {
            String[] result = (String[])dlg.getDetailResult();
            this.txtDisplayNameID.setText(result[0]);
            this.txtDisplayName.setText(result[1]);
        }
    }

    public void initDialog() {
        this.txtDisplayName.setFocus();
        if (this.isAggregate()) {
            this.initFunction();
            this.initFilter();
            this.initAggOn();
        }
        if (this.getBinding() == null) {
            this.setTypeSelect(this.dataTypes[0]);
            this.newBinding = StructureFactory.newComputedColumn((DesignElementHandle)this.getBindingHolder(), (String)(this.isAggregate() ? DEFAULT_AGGREGATION_NAME : DEFAULT_ITEM_NAME));
            this.setName(this.newBinding.getName());
        } else {
            this.setName(this.getBinding().getName());
            this.setDisplayName(this.getBinding().getDisplayName());
            this.setDisplayNameID(this.getBinding().getDisplayNameID());
            if (this.getBinding().getDataType() != null) {
                if (DATA_TYPE_CHOICE_SET.findChoice(this.getBinding().getDataType()) != null) {
                    this.setTypeSelect(DATA_TYPE_CHOICE_SET.findChoice(this.getBinding().getDataType()).getDisplayName());
                } else {
                    this.cmbType.setText("");
                }
            }
            if (this.txtExpression != null) {
                ExpressionButtonUtil.initExpressionButtonControl((Control)this.txtExpression, (Object)this.getBinding(), (String)"expression");
            }
        }
        if (this.getBinding() != null) {
            this.txtName.setEnabled(false);
        }
        this.validate();
    }

    private void initAggOn() {
        ReportItemHandle handle = this.getBindingHolder();
        String[] aggOns = this.getAggOns(handle);
        this.cmbAggOn.setItems(aggOns);
        String aggstr = "";
        if (this.getBinding() != null) {
            List aggOnList = this.getBinding().getAggregateOnList();
            int i = 0;
            Iterator iterator = aggOnList.iterator();
            while (iterator.hasNext()) {
                if (i > 0) {
                    aggstr = String.valueOf(aggstr) + ",";
                }
                String name = (String)iterator.next();
                aggstr = String.valueOf(aggstr) + name;
                ++i;
            }
        }
        int j = 0;
        while (j < aggOns.length) {
            if (aggOns[j].equals(aggstr)) {
                this.cmbAggOn.select(j);
                return;
            }
            ++j;
        }
        this.cmbAggOn.select(0);
    }

    private String[] getAggOns(ReportItemHandle handle) {
        SeriesDefinition yopgrouping;
        String yopName;
        String catExpr = null;
        String yopExpr = null;
        ArrayList<String> aggOnList = new ArrayList<String>();
        aggOnList.add(ALL);
        Chart chart = this.container instanceof ChartWizardContext ? ((ChartWizardContext)this.container).getModel() : ChartItemUtil.getChartFromHandle((ExtendedItemHandle)((ExtendedItemHandle)handle));
        SeriesDefinition category = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)chart).get(0);
        String catName = ChartExpressionUtil.getCubeBindingName((String)ChartUIUtil.getDataQuery((SeriesDefinition)category, (int)0).getDefinition(), (boolean)true);
        if (catName != null) {
            int i = 0;
            while (i < handle.getColumnBindings().getListValue().size()) {
                ComputedColumnHandle bindingHandle = (ComputedColumnHandle)handle.getColumnBindings().getAt(i);
                if (bindingHandle.getName().equalsIgnoreCase(catName)) {
                    catExpr = bindingHandle.getExpression();
                }
                ++i;
            }
            String[] cat = ChartExpressionUtil.getLevelNameFromDimensionExpression(catExpr);
            catExpr = String.valueOf(cat[0]) + "/" + cat[1];
            aggOnList.add(catExpr);
        }
        if ((yopName = ChartExpressionUtil.getCubeBindingName((String)(yopgrouping = (SeriesDefinition)ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)chart, (int)0).get(0)).getQuery().getDefinition(), (boolean)true)) != null) {
            int i = 0;
            while (i < handle.getColumnBindings().getListValue().size()) {
                ComputedColumnHandle bindingHandle = (ComputedColumnHandle)handle.getColumnBindings().getAt(i);
                if (bindingHandle.getName().equalsIgnoreCase(yopName)) {
                    yopExpr = bindingHandle.getExpression();
                }
                ++i;
            }
            String[] yop = ChartExpressionUtil.getLevelNameFromDimensionExpression(yopExpr);
            yopExpr = String.valueOf(yop[0]) + "/" + yop[1];
            aggOnList.add(yopExpr);
        }
        if (catName != null && yopName != null) {
            aggOnList.add(String.valueOf(yopExpr) + "," + yopExpr);
        }
        return aggOnList.toArray(new String[aggOnList.size()]);
    }

    private void initFilter() {
        ExpressionButtonUtil.initExpressionButtonControl((Control)this.txtFilter, (Object)this.binding, (String)"filterExpr");
    }

    private void initFunction() {
        this.cmbFunction.setItems(this.getFunctionDisplayNames());
        if (this.binding == null) {
            this.cmbFunction.select(0);
            this.handleFunctionSelectEvent();
            return;
        }
        try {
            String functionString = this.getFunctionDisplayName(DataAdapterUtil.adaptModelAggregationType((String)this.binding.getAggregateFunction()));
            int itemIndex = this.getItemIndex(this.getFunctionDisplayNames(), functionString);
            this.cmbFunction.select(itemIndex);
            this.handleFunctionSelectEvent();
        }
        catch (AdapterException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        Iterator iterator = this.binding.argumentsIterator();
        while (iterator.hasNext()) {
            AggregationArgumentHandle arg = (AggregationArgumentHandle)iterator.next();
            if (!this.paramsMap.containsKey(arg.getName()) || arg.getValue() == null) continue;
            Control control = this.paramsMap.get(arg.getName());
            if (ExpressionButtonUtil.getExpressionButton((Control)control) != null) {
                ExpressionButtonUtil.initExpressionButtonControl((Control)control, (Object)arg, (String)"value");
                continue;
            }
            ExpressionHandle expr = arg.getExpressionProperty("value");
            if (expr == null || expr.getStringExpression() == null) continue;
            ((Combo)control).setText(expr.getStringExpression());
        }
    }

    private String[] getFunctionDisplayNames() {
        IAggrFunction[] choices = this.getFunctions();
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getDisplayName();
            ++i;
        }
        return displayNames;
    }

    private IAggrFunction getFunctionByDisplayName(String displayName) {
        IAggrFunction[] choices = this.getFunctions();
        if (choices == null) {
            return null;
        }
        int i = 0;
        while (i < choices.length) {
            if (choices[i].getDisplayName().equals(displayName)) {
                return choices[i];
            }
            ++i;
        }
        return null;
    }

    private String getFunctionDisplayName(String function) {
        try {
            return DataUtil.getAggregationManager().getAggregation(function).getDisplayName();
        }
        catch (BirtException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    private IAggrFunction[] getFunctions() {
        try {
            List aggrInfoList = DataUtil.getAggregationManager().getAggregations(1);
            return aggrInfoList.toArray(new IAggrFunction[0]);
        }
        catch (BirtException e) {
            ExceptionHandler.handle((Throwable)e);
            return new IAggrFunction[0];
        }
    }

    private String getDataTypeDisplayName(String dataType) {
        int i = 0;
        while (i < DATA_TYPE_CHOICES.length) {
            if (dataType.equals(DATA_TYPE_CHOICES[i].getName())) {
                return DATA_TYPE_CHOICES[i].getDisplayName();
            }
            ++i;
        }
        return "";
    }

    private void initDataFields(Combo cmbDataField) {
        String[] items = this.getMesures();
        cmbDataField.setItems(items);
        if (this.binding != null && this.binding.getExpression() != null) {
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(this.binding.getExpression())) {
                    cmbDataField.select(i);
                }
                ++i;
            }
        }
    }

    private String[] getMesures() {
        List mesureList = ChartCubeUtil.getAllMeasures((CubeHandle)this.getBindingHolder().getCube());
        String[] mesures = new String[mesureList.size() + 1];
        mesures[0] = "";
        int i = 1;
        while (i < mesures.length) {
            mesures[i] = DEUtil.getExpression(mesureList.get(i - 1));
            ++i;
        }
        return mesures;
    }

    private void setName(String name) {
        if (name != null && this.txtName != null) {
            this.txtName.setText(name);
        }
    }

    private void setDisplayNameID(String displayNameID) {
        if (displayNameID != null && this.txtDisplayNameID != null) {
            this.txtDisplayNameID.setText(displayNameID);
        }
    }

    private void setDisplayName(String displayName) {
        if (displayName != null && this.txtDisplayName != null) {
            this.txtDisplayName.setText(displayName);
        }
    }

    private void setTypeSelect(String typeSelect) {
        if (this.dataTypes != null && this.cmbType != null) {
            this.cmbType.setItems(this.dataTypes);
            if (typeSelect != null) {
                this.cmbType.select(this.getItemIndex(this.cmbType.getItems(), typeSelect));
            } else {
                this.cmbType.select(0);
            }
        }
    }

    private int getItemIndex(String[] items, String item) {
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void createAggregateSection(Composite composite) {
        new Label(composite, 0).setText(FUNCTION);
        this.cmbFunction = new Combo(composite, 2056);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.cmbFunction.setLayoutData((Object)gd);
        this.cmbFunction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartCubeBindingDialogHelper.this.handleFunctionSelectEvent();
                ChartCubeBindingDialogHelper.this.validate();
            }
        });
        this.paramsComposite = new Composite(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.exclude = true;
        this.paramsComposite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        this.paramsComposite.setLayout((Layout)layout);
        new Label(composite, 0).setText(FILTER_CONDITION);
        this.txtFilter = new Text(composite, 2048);
        gridData = new GridData(768);
        this.txtFilter.setLayoutData((Object)gridData);
        this.createExpressionButton(composite, this.txtFilter);
        Label lblAggOn = new Label(composite, 0);
        lblAggOn.setText(AGGREGATE_ON);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        lblAggOn.setLayoutData((Object)gridData);
        this.cmbAggOn = new Combo(composite, 2056);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.cmbAggOn.setLayoutData((Object)gridData);
    }

    private void createCommonSection(Composite composite) {
        new Label(composite, 0).setText(EXPRESSION);
        this.txtExpression = new Text(composite, 2048);
        this.txtExpression.setLayoutData((Object)new GridData(768));
        this.createExpressionButton(composite, this.txtExpression);
        this.txtExpression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChartCubeBindingDialogHelper.this.validate();
            }
        });
    }

    private void createMessageSection(Composite composite) {
        this.messageLine = new CLabel(composite, 0);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        this.messageLine.setLayoutData((Object)layoutData);
    }

    protected void handleFunctionSelectEvent() {
        Control[] children = this.paramsComposite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        IAggrFunction function = this.getFunctionByDisplayName(this.cmbFunction.getText());
        if (function != null) {
            this.paramsMap.clear();
            IParameterDefn[] params = function.getParameterDefn();
            if (params.length > 0) {
                ((GridData)this.paramsComposite.getLayoutData()).exclude = false;
                ((GridData)this.paramsComposite.getLayoutData()).heightHint = -1;
                IParameterDefn[] iParameterDefnArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    IParameterDefn param = iParameterDefnArray[n2];
                    Label lblParam = new Label(this.paramsComposite, 0);
                    lblParam.setText(String.valueOf(param.getDisplayName()) + ":");
                    GridData gd = new GridData();
                    gd.widthHint = this.lbName.getBounds().width - this.lbName.getBorderWidth();
                    lblParam.setLayoutData((Object)gd);
                    if (param.isDataField()) {
                        Combo cmbDataField = new Combo(this.paramsComposite, 2048);
                        gd = new GridData(768);
                        gd.horizontalSpan = 2;
                        cmbDataField.setLayoutData((Object)gd);
                        cmbDataField.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                ChartCubeBindingDialogHelper.this.validate();
                            }
                        });
                        this.initDataFields(cmbDataField);
                        this.paramsMap.put(param.getName(), (Control)cmbDataField);
                    } else {
                        Text txtParam = new Text(this.paramsComposite, 2048);
                        txtParam.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                ChartCubeBindingDialogHelper.this.validate();
                            }
                        });
                        GridData gridData = new GridData(768);
                        gridData.horizontalIndent = 0;
                        txtParam.setLayoutData((Object)gridData);
                        this.createExpressionButton(this.paramsComposite, txtParam);
                        this.paramsMap.put(param.getName(), (Control)txtParam);
                    }
                    ++n2;
                }
            } else {
                ((GridData)this.paramsComposite.getLayoutData()).heightHint = 0;
            }
            try {
                this.cmbType.setText(this.getDataTypeDisplayName(DataAdapterUtil.adapterToModelDataType((int)DataUtil.getAggregationManager().getAggregation(function.getName()).getDataType())));
            }
            catch (BirtException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            ((GridData)this.paramsComposite.getLayoutData()).heightHint = 0;
        }
        this.paramsComposite.layout();
        this.composite.layout();
        this.setContentSize(this.composite);
    }

    private void createExpressionButton(Composite parent, Text text) {
        if (this.expressionProvider == null) {
            this.expressionProvider = new BindingExpressionProvider((DesignElementHandle)this.bindingHolder, this.binding);
        }
        ExpressionButtonUtil.createExpressionButton((Composite)parent, (Control)text, (IExpressionProvider)this.expressionProvider, (Object)this.bindingHolder);
    }

    public void validate() {
        if (this.txtName != null && (this.txtName.getText() == null || this.txtName.getText().trim().equals(""))) {
            this.dialog.setCanFinish(false);
        } else if (this.txtExpression != null && (this.txtExpression.getText() == null || this.txtExpression.getText().trim().equals(""))) {
            this.dialog.setCanFinish(false);
        } else {
            if (this.binding == null) {
                for (ComputedColumnHandle computedColumn : this.bindingHolder.getColumnBindings()) {
                    if (!computedColumn.getName().equals(this.txtName.getText())) continue;
                    this.dialog.setCanFinish(false);
                    this.messageLine.setText(Messages.getFormattedString((String)"BindingDialogHelper.error.nameduplicate", (Object[])new Object[]{this.txtName.getText()}));
                    this.messageLine.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
                    return;
                }
            }
            this.dialog.setCanFinish(true);
            this.messageLine.setText("");
            this.messageLine.setImage(null);
            if (this.txtExpression != null && (this.txtExpression.getText() == null || this.txtExpression.getText().trim().equals(""))) {
                this.dialog.setCanFinish(false);
                return;
            }
            if (this.isAggregate()) {
                try {
                    IAggrFunction aggregation = DataUtil.getAggregationManager().getAggregation(this.getFunctionByDisplayName(this.cmbFunction.getText()).getName());
                    if (aggregation.getParameterDefn().length > 0) {
                        IParameterDefn[] parameters;
                        IParameterDefn[] iParameterDefnArray = parameters = aggregation.getParameterDefn();
                        int n = parameters.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String paramValue;
                            IParameterDefn param = iParameterDefnArray[n2];
                            if (!param.isOptional() && ((paramValue = this.getControlValue(this.paramsMap.get(param.getName()))) == null || paramValue.trim().equals(""))) {
                                this.dialog.setCanFinish(false);
                                return;
                            }
                            ++n2;
                        }
                    }
                }
                catch (BirtException birtException) {}
            }
            this.dialog.setCanFinish(true);
        }
    }

    public boolean differs(ComputedColumnHandle binding) {
        if (this.isAggregate()) {
            if (!this.strEquals(binding.getName(), this.txtName.getText())) {
                return true;
            }
            if (!this.strEquals(binding.getDisplayName(), this.txtDisplayName.getText())) {
                return true;
            }
            if (!this.strEquals(binding.getDisplayNameID(), this.txtDisplayNameID.getText())) {
                return true;
            }
            if (!this.strEquals(binding.getDataType(), this.getDataType())) {
                return true;
            }
            if (!this.strEquals(binding.getAggregateFunction(), this.getFunctionByDisplayName(this.cmbFunction.getText()).getName())) {
                return true;
            }
            if (!this.exprEquals((Expression)binding.getExpressionProperty("filterExpr").getValue(), ExpressionButtonUtil.getExpression((Control)this.txtFilter))) {
                return true;
            }
            if (!this.strEquals(this.cmbAggOn.getText(), binding.getAggregateOn())) {
                return true;
            }
            Iterator iterator = binding.argumentsIterator();
            while (iterator.hasNext()) {
                AggregationArgumentHandle handle = (AggregationArgumentHandle)iterator.next();
                if (this.paramsMap.containsKey(handle.getName())) {
                    if (this.exprEquals((Expression)handle.getExpressionProperty("value").getValue(), ExpressionButtonUtil.getExpression((Control)this.paramsMap.get(handle.getName())))) continue;
                    return true;
                }
                return true;
            }
        } else {
            if (!this.strEquals(this.txtName.getText(), binding.getName())) {
                return true;
            }
            if (!this.strEquals(this.txtDisplayName.getText(), binding.getDisplayName())) {
                return true;
            }
            if (!this.strEquals(this.txtDisplayNameID.getText(), binding.getDisplayNameID())) {
                return true;
            }
            if (!this.strEquals(this.getDataType(), binding.getDataType())) {
                return true;
            }
            if (!this.exprEquals(ExpressionButtonUtil.getExpression((Control)this.txtExpression), (Expression)binding.getExpressionProperty("expression").getValue())) {
                return true;
            }
        }
        return false;
    }

    private boolean exprEquals(Expression left, Expression right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null && right != null) {
            return false;
        }
        if (left != null && right == null) {
            return false;
        }
        if (left.getStringExpression() == null && right.getStringExpression() == null) {
            return true;
        }
        return this.strEquals(left.getStringExpression(), right.getStringExpression()) && this.strEquals(left.getType(), right.getType());
    }

    private String getControlValue(Control control) {
        if (control instanceof Text) {
            return ((Text)control).getText();
        }
        if (control instanceof Combo) {
            return ((Combo)control).getText();
        }
        return null;
    }

    private boolean strEquals(String left, String right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return "".equals(right);
        }
        if (right == null) {
            return "".equals(left);
        }
        return left.equals(right);
    }

    private String getDataType() {
        int i = 0;
        while (i < DATA_TYPE_CHOICES.length) {
            if (DATA_TYPE_CHOICES[i].getDisplayName().equals(this.cmbType.getText())) {
                return DATA_TYPE_CHOICES[i].getName();
            }
            ++i;
        }
        return "";
    }

    public ComputedColumnHandle editBinding(ComputedColumnHandle binding) throws SemanticException {
        if (this.isAggregate()) {
            binding.setDisplayName(this.txtDisplayName.getText());
            binding.setDisplayNameID(this.txtDisplayNameID.getText());
            int i = 0;
            while (i < DATA_TYPE_CHOICES.length) {
                if (DATA_TYPE_CHOICES[i].getDisplayName().equals(this.cmbType.getText())) {
                    binding.setDataType(DATA_TYPE_CHOICES[i].getName());
                    break;
                }
                ++i;
            }
            binding.setAggregateFunction(this.getFunctionByDisplayName(this.cmbFunction.getText()).getName());
            ExpressionButtonUtil.saveExpressionButtonControl((Control)this.txtFilter, (Object)binding, (String)"filterExpr");
            binding.clearAggregateOnList();
            String aggStr = this.cmbAggOn.getText();
            StringTokenizer token = new StringTokenizer(aggStr, ",");
            while (token.hasMoreTokens()) {
                String agg = token.nextToken();
                if (agg.equals(ALL)) continue;
                binding.addAggregateOn(agg);
            }
            binding.clearArgumentList();
            binding.setExpression(null);
            for (String arg : this.paramsMap.keySet()) {
                String value = this.getControlValue(this.paramsMap.get(arg));
                if (value == null) continue;
                AggregationArgument argHandle = StructureFactory.createAggregationArgument();
                argHandle.setName(arg);
                if (ExpressionButtonUtil.getExpressionButton((Control)this.paramsMap.get(arg)) != null) {
                    ExpressionButtonUtil.saveExpressionButtonControl((Control)this.paramsMap.get(arg), (Object)argHandle, (String)"value");
                } else {
                    Expression expression = new Expression((Object)value, "javascript");
                    argHandle.setExpressionProperty("value", expression);
                }
                binding.addArgument(argHandle);
            }
        } else {
            int i = 0;
            while (i < DATA_TYPE_CHOICES.length) {
                if (DATA_TYPE_CHOICES[i].getDisplayName().equals(this.cmbType.getText())) {
                    binding.setDataType(DATA_TYPE_CHOICES[i].getName());
                    break;
                }
                ++i;
            }
            binding.setDisplayName(this.txtDisplayName.getText());
            binding.setDisplayNameID(this.txtDisplayNameID.getText());
            if (ExpressionButtonUtil.getExpressionButton((Control)this.txtExpression) != null) {
                ExpressionButtonUtil.saveExpressionButtonControl((Control)this.txtExpression, (Object)binding, (String)"expression");
            } else {
                Expression expression = new Expression((Object)this.getControlValue((Control)this.txtExpression), "javascript");
                binding.setExpressionProperty("value", expression);
            }
        }
        return binding;
    }

    public ComputedColumnHandle newBinding(ReportItemHandle bindingHolder, String name) throws SemanticException {
        ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)bindingHolder, (String)(name == null ? this.txtName.getText() : name));
        ComputedColumnHandle binding = DEUtil.addColumn((DesignElementHandle)bindingHolder, (ComputedColumn)column, (boolean)true);
        return this.editBinding(binding);
    }

    public void setContainer(Object container) {
        this.container = container;
    }

    public boolean canProcessAggregation() {
        return true;
    }

    private URL getResourceURL() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle().findResource(this.getBaseName(), 5);
    }

    private String getBaseName() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle().getIncludeResource();
    }
}

