/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.model.type.BubbleSeries;
import org.eclipse.birt.chart.model.type.DifferenceSeries;
import org.eclipse.birt.chart.model.type.GanttSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.ui.ChartXTabUIUtil;
import org.eclipse.birt.chart.reportitem.ui.ColumnNamesTableDragListener;
import org.eclipse.birt.chart.reportitem.ui.ReportDataServiceProvider;
import org.eclipse.birt.chart.reportitem.ui.dialogs.ChartColumnBindingDialog;
import org.eclipse.birt.chart.reportitem.ui.dialogs.ExtendedItemFilterDialog;
import org.eclipse.birt.chart.reportitem.ui.dialogs.ReportItemParametersDialog;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.reportitem.ui.views.attributes.provider.ChartCubeFilterHandleProvider;
import org.eclipse.birt.chart.reportitem.ui.views.attributes.provider.ChartFilterProviderDelegate;
import org.eclipse.birt.chart.ui.swt.ColorPalette;
import org.eclipse.birt.chart.ui.swt.ColumnBindingInfo;
import org.eclipse.birt.chart.ui.swt.CustomPreviewTable;
import org.eclipse.birt.chart.ui.swt.DataDefinitionTextManager;
import org.eclipse.birt.chart.ui.swt.DefaultChartDataSheet;
import org.eclipse.birt.chart.ui.swt.SimpleTextTransfer;
import org.eclipse.birt.chart.ui.swt.interfaces.IExpressionButton;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.data.SelectDataDynamicArea;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ITask;
import org.eclipse.birt.report.designer.internal.ui.data.DataService;
import org.eclipse.birt.report.designer.internal.ui.views.ViewsTreeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractFilterHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IFormProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.action.NewCubeAction;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardChartDataSheet
extends DefaultChartDataSheet
implements Listener {
    private static final String KEY_PREVIEW_DATA = "Preview Data";
    protected final ExtendedItemHandle itemHandle;
    protected final ReportDataServiceProvider dataProvider;
    private Button btnInherit = null;
    private Button btnUseData = null;
    private boolean bIsInheritSelected = true;
    private CCombo cmbInherit = null;
    private CCombo cmbDataItems = null;
    private StackLayout stackLayout = null;
    private Composite cmpStack = null;
    private Composite cmpCubeTree = null;
    private Composite cmpDataPreview = null;
    private Composite cmpColumnsList = null;
    private CustomPreviewTable tablePreview = null;
    private TreeViewer cubeTreeViewer = null;
    private Button btnFilters = null;
    private Button btnParameters = null;
    private Button btnBinding = null;
    private String currentData = null;
    private String previousData = null;
    public static final int SELECT_NONE = 1;
    public static final int SELECT_NEXT = 2;
    public static final int SELECT_DATA_SET = 4;
    public static final int SELECT_DATA_CUBE = 8;
    public static final int SELECT_REPORT_ITEM = 16;
    public static final int SELECT_NEW_DATASET = 32;
    public static final int SELECT_NEW_DATACUBE = 64;
    private final int iSupportedDataItems;
    private List<Integer> selectDataTypes = new ArrayList<Integer>();
    private Button btnShowDataPreviewA;
    private Button btnShowDataPreviewB;
    private TableViewer tableViewerColumns;
    private Label columnListDescription;
    private Label dataPreviewDescription;
    protected final ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();

    public StandardChartDataSheet(ExtendedItemHandle itemHandle, ReportDataServiceProvider dataProvider, int iSupportedDataItems) {
        this.itemHandle = itemHandle;
        this.dataProvider = dataProvider;
        this.iSupportedDataItems = iSupportedDataItems;
        this.addListener(this);
    }

    public StandardChartDataSheet(ExtendedItemHandle itemHandle, ReportDataServiceProvider dataProvider) {
        this(itemHandle, dataProvider, 0);
    }

    public Composite createActionButtons(Composite parent) {
        Composite composite = ChartUIUtil.createCompositeWrapper((Composite)parent);
        composite.setLayoutData((Object)new GridData(776));
        this.btnFilters = new Button(composite, 0);
        this.btnFilters.setAlignment(0x1000000);
        GridData gridData = new GridData(768);
        this.btnFilters.setLayoutData((Object)gridData);
        this.btnFilters.setText(Messages.getString("StandardChartDataSheet.Label.Filters"));
        this.btnFilters.addListener(13, (Listener)this);
        this.btnParameters = new Button(composite, 0);
        this.btnParameters.setAlignment(0x1000000);
        gridData = new GridData(768);
        this.btnParameters.setLayoutData((Object)gridData);
        this.btnParameters.setText(Messages.getString("StandardChartDataSheet.Label.Parameters"));
        this.btnParameters.addListener(13, (Listener)this);
        this.btnBinding = new Button(composite, 0);
        this.btnBinding.setAlignment(0x1000000);
        gridData = new GridData(768);
        this.btnBinding.setLayoutData((Object)gridData);
        this.btnBinding.setText(Messages.getString("StandardChartDataSheet.Label.DataBinding"));
        this.btnBinding.addListener(13, (Listener)this);
        this.setEnabledForButtons();
        return composite;
    }

    private void setEnabledForButtons() {
        if (this.isCubeMode()) {
            boolean disabled = this.getDataServiceProvider().isInXTabAggrCell() || this.getDataServiceProvider().isInXTabMeasureCell();
            this.btnFilters.setEnabled(!disabled && !this.getDataServiceProvider().isInheritColumnsGroups());
            this.btnBinding.setEnabled(!this.getDataServiceProvider().isInheritColumnsGroups() && this.getDataServiceProvider().isInvokingSupported() || this.getDataServiceProvider().isSharedBinding());
            this.btnParameters.setEnabled(false);
        } else {
            this.btnFilters.setEnabled(this.hasDataSet() && !this.getDataServiceProvider().isInheritColumnsGroups());
            this.btnParameters.setEnabled(this.getDataServiceProvider().getDataSet() != null && this.getDataServiceProvider().isInvokingSupported());
            this.btnBinding.setEnabled(this.hasDataSet() && !this.getDataServiceProvider().isInheritColumnsGroups() && (this.getDataServiceProvider().isInvokingSupported() || this.getDataServiceProvider().isSharedBinding()));
        }
    }

    private boolean hasDataSet() {
        return this.getDataServiceProvider().getInheritedDataSet() != null || this.getDataServiceProvider().getDataSet() != null;
    }

    void fireEvent(Widget widget, int eventType) {
        Event event = new Event();
        event.data = this;
        event.widget = widget;
        event.type = eventType;
        this.notifyListeners(event);
    }

    public Composite createDataDragSource(Composite parent) {
        this.cmpStack = new Composite(parent, 0);
        this.cmpStack.setLayoutData((Object)new GridData(1808));
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.cmpStack.setLayout((Layout)this.stackLayout);
        this.cmpCubeTree = ChartUIUtil.createCompositeWrapper((Composite)this.cmpStack);
        this.cmpDataPreview = ChartUIUtil.createCompositeWrapper((Composite)this.cmpStack);
        this.createColumnsViewerArea(this.cmpStack);
        Label label = new Label(this.cmpCubeTree, 0);
        label.setText(Messages.getString("StandardChartDataSheet.Label.CubeTree"));
        label.setFont(JFaceResources.getBannerFont());
        if (!this.dataProvider.isInXTabMeasureCell() && !this.dataProvider.isInMultiView()) {
            Label description = new Label(this.cmpCubeTree, 64);
            GridData gd = new GridData(768);
            description.setLayoutData((Object)gd);
            description.setText(Messages.getString("StandardChartDataSheet.Label.DragCube"));
        }
        this.cubeTreeViewer = new TreeViewer(this.cmpCubeTree, 2820);
        this.cubeTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        ((GridData)this.cubeTreeViewer.getTree().getLayoutData()).heightHint = 120;
        ViewsTreeProvider provider = new ViewsTreeProvider(){

            public boolean hasChildren(Object element) {
                if (element instanceof TabularLevelHandle) {
                    return false;
                }
                return super.hasChildren(element);
            }
        };
        this.cubeTreeViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.cubeTreeViewer.setContentProvider((IContentProvider)provider);
        this.cubeTreeViewer.setInput((Object)this.getCube());
        DragSource dragSource = new DragSource((Control)this.cubeTreeViewer.getTree(), 1);
        dragSource.setTransfer(new Transfer[]{SimpleTextTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){
            private String text = null;

            public void dragFinished(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = this.text;
            }

            public void dragStart(DragSourceEvent event) {
                this.text = StandardChartDataSheet.this.createCubeExpression();
                if (this.text == null) {
                    event.doit = false;
                }
            }
        });
        this.cubeTreeViewer.getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 3 && event.widget instanceof Tree) {
                    Tree tree = (Tree)event.widget;
                    TreeItem treeItem = tree.getSelection()[0];
                    if (treeItem.getData() instanceof LevelHandle || treeItem.getData() instanceof MeasureHandle) {
                        if (StandardChartDataSheet.this.dataProvider.checkState(2048)) {
                            tree.setMenu(null);
                        } else {
                            tree.setMenu(StandardChartDataSheet.this.createMenuManager(treeItem.getData()).createContextMenu((Control)tree));
                        }
                    } else {
                        tree.setMenu(null);
                    }
                }
            }
        });
        label = new Label(this.cmpDataPreview, 0);
        label.setText(Messages.getString("StandardChartDataSheet.Label.DataPreview"));
        label.setFont(JFaceResources.getBannerFont());
        if (!this.dataProvider.isInXTabMeasureCell() && !this.dataProvider.isInMultiView()) {
            this.dataPreviewDescription = new Label(this.cmpDataPreview, 64);
            GridData gd = new GridData(768);
            this.dataPreviewDescription.setLayoutData((Object)gd);
            this.dataPreviewDescription.setText(Messages.getString("StandardChartDataSheet.Label.ToBindADataColumn"));
        }
        this.btnShowDataPreviewA = new Button(this.cmpDataPreview, 32);
        this.btnShowDataPreviewA.setText(Messages.getString("StandardChartDataSheet.Label.ShowDataPreview"));
        this.btnShowDataPreviewA.addListener(13, (Listener)this);
        this.tablePreview = new CustomPreviewTable(this.cmpDataPreview, 66308);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 400;
        gridData.heightHint = 120;
        this.tablePreview.setLayoutData((Object)gridData);
        this.tablePreview.setHeaderAlignment(16384);
        this.tablePreview.addListener(0, (Listener)this);
        this.updateDragDataSource();
        return this.cmpStack;
    }

    private void createColumnsViewerArea(Composite parent) {
        this.cmpColumnsList = ChartUIUtil.createCompositeWrapper((Composite)parent);
        Label label = new Label(this.cmpColumnsList, 0);
        label.setText(Messages.getString("StandardChartDataSheet.Label.DataPreview"));
        label.setFont(JFaceResources.getBannerFont());
        if (!this.dataProvider.isInXTabMeasureCell()) {
            this.columnListDescription = new Label(this.cmpColumnsList, 64);
            GridData gd = new GridData(768);
            this.columnListDescription.setLayoutData((Object)gd);
            this.columnListDescription.setText(Messages.getString("StandardChartDataSheet.Label.ToBindADataColumn"));
        }
        this.btnShowDataPreviewB = new Button(this.cmpColumnsList, 32);
        this.btnShowDataPreviewB.setText(Messages.getString("StandardChartDataSheet.Label.ShowDataPreview"));
        this.btnShowDataPreviewB.addListener(13, (Listener)this);
        final Table table = new Table(this.cmpColumnsList, 68356);
        GridData gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        table.setLinesVisible(true);
        this.tableViewerColumns = new TableViewer(table);
        this.tableViewerColumns.setUseHashlookup(true);
        new TableColumn(table, 16384);
        table.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                List data;
                if (!StandardChartDataSheet.this.dataProvider.isLivePreviewEnabled()) {
                    table.setToolTipText(null);
                    return;
                }
                String tooltip = null;
                TableItem item = ((Table)e.widget).getItem(new Point(e.x, e.y));
                if (item != null && (data = (List)StandardChartDataSheet.this.tableViewerColumns.getData(StandardChartDataSheet.KEY_PREVIEW_DATA)) != null) {
                    StringBuilder sb = new StringBuilder();
                    int index = ((Table)e.widget).indexOf(item);
                    int i = 0;
                    while (i < data.size()) {
                        if (sb.length() > 45) break;
                        if (((Object[])data.get(i))[index] != null) {
                            if (i != 0) {
                                sb.append("; ");
                            }
                            sb.append(String.valueOf(((Object[])data.get(i))[index]));
                        }
                        ++i;
                    }
                    if (i == 1 && sb.length() > 45) {
                        sb = new StringBuilder(sb.substring(0, 45));
                        sb.append("...");
                    } else if (i < data.size()) {
                        sb.append(";...");
                    }
                    tooltip = sb.toString();
                }
                table.setToolTipText(tooltip);
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 3) {
                    if (StandardChartDataSheet.this.isCubeMode()) {
                        table.setMenu(null);
                    } else {
                        TableItem item = ((Table)e.widget).getItem(new Point(e.x, e.y));
                        if (item == null) {
                            StandardChartDataSheet.this.tableViewerColumns.getTable().select(-1);
                        }
                        boolean isSharingChart = StandardChartDataSheet.this.dataProvider.checkState(2048);
                        if (item != null && !isSharingChart) {
                            if (table.getMenu() != null) {
                                table.getMenu().dispose();
                            }
                            table.setMenu(StandardChartDataSheet.this.createMenuManager(item.getData()).createContextMenu((Control)table));
                        } else {
                            table.setMenu(null);
                        }
                        if (table.getMenu() != null && !isSharingChart) {
                            table.getMenu().setVisible(true);
                        }
                    }
                }
            }
        });
        table.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Table table = (Table)event.widget;
                int totalWidth = table.getClientArea().width;
                table.getColumn(0).setWidth(totalWidth);
            }
        });
        DragSource ds = new DragSource((Control)table, 3);
        ds.setTransfer(new Transfer[]{SimpleTextTransfer.getInstance()});
        ColumnNamesTableDragListener dragSourceAdapter = new ColumnNamesTableDragListener(table, this.itemHandle);
        ds.addDragListener((DragSourceListener)dragSourceAdapter);
        this.tableViewerColumns.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object arg0) {
                if (arg0 == null) {
                    return null;
                }
                return (ColumnBindingInfo[])arg0;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }
        });
        this.tableViewerColumns.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public Image getImage(Object arg0) {
                String imageName = ((ColumnBindingInfo)arg0).getImageName();
                if (imageName == null) {
                    return null;
                }
                return UIHelper.getImage((String)imageName);
            }

            public String getText(Object arg0) {
                return ((ColumnBindingInfo)arg0).getName();
            }

            public void addListener(ILabelProviderListener arg0) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }

            public void removeListener(ILabelProviderListener arg0) {
            }
        });
    }

    private void updateDragDataSource() {
        String cValue;
        if (this.dataProvider.checkState(2048)) {
            if (this.columnListDescription != null) {
                ((GridData)this.columnListDescription.getLayoutData()).exclude = true;
                this.columnListDescription.setVisible(false);
                this.cmpColumnsList.layout();
            }
            if (this.dataPreviewDescription != null) {
                ((GridData)this.dataPreviewDescription.getLayoutData()).exclude = true;
                this.dataPreviewDescription.setVisible(false);
                this.cmpDataPreview.layout();
            }
        }
        if (this.isCubeMode()) {
            if (this.getDataServiceProvider().checkState(256)) {
                if (!this.getDataServiceProvider().checkState(2048)) {
                    ((GridData)this.columnListDescription.getLayoutData()).exclude = false;
                    this.columnListDescription.setVisible(true);
                    this.columnListDescription.setText(Messages.getString("StandardChartDataSheet.Label.ShareCrossTab"));
                    this.cmpColumnsList.layout();
                }
                this.getContext().setShowingDataPreview(Boolean.FALSE);
                this.btnShowDataPreviewB.setSelection(false);
                this.btnShowDataPreviewB.setEnabled(false);
                this.stackLayout.topControl = this.cmpColumnsList;
                this.refreshDataPreviewPane();
            } else {
                this.stackLayout.topControl = this.cmpCubeTree;
                this.cubeTreeViewer.setInput((Object)this.getCube());
            }
            this.cmpStack.layout();
            return;
        }
        if (this.columnListDescription != null && !this.dataProvider.checkState(2048)) {
            ((GridData)this.columnListDescription.getLayoutData()).exclude = false;
            this.columnListDescription.setVisible(true);
            this.columnListDescription.setText(Messages.getString("StandardChartDataSheet.Label.ToBindADataColumn"));
            this.cmpColumnsList.layout();
        }
        this.btnShowDataPreviewB.setEnabled(true);
        String pValue = this.previousData == null ? "" : this.previousData;
        String string = cValue = this.currentData == null ? "" : this.currentData;
        if (!pValue.equals(cValue)) {
            this.getContext().setShowingDataPreview(null);
        }
        this.previousData = this.currentData;
        try {
            if (!this.getContext().isSetShowingDataPreview() && this.getDataServiceProvider().getPreviewHeadersInfo().length >= 6) {
                this.getContext().setShowingDataPreview(Boolean.FALSE);
            }
            ChartWizard.removeException((String)"StandardChartDataSheet.getPreviewHeaders");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ChartException e) {
            ChartWizard.showException((String)"StandardChartDataSheet.getPreviewHeaders", (String)e.getMessage());
        }
        this.btnShowDataPreviewA.setSelection(this.getContext().isShowingDataPreview());
        this.btnShowDataPreviewB.setSelection(this.getContext().isShowingDataPreview());
        this.stackLayout.topControl = this.getContext().isShowingDataPreview() ? this.cmpDataPreview : this.cmpColumnsList;
        this.refreshDataPreviewPane();
        this.cmpStack.layout();
    }

    private void refreshDataPreviewPane() {
        if (this.getContext().isShowingDataPreview()) {
            this.refreshTablePreview();
        } else {
            this.refreshColumnsListView();
        }
    }

    private void refreshColumnsListView() {
        Runnable runnable = new Runnable(){

            public void run() {
                ColumnBindingInfo[] headers = null;
                List dataList = null;
                try {
                    headers = StandardChartDataSheet.this.getDataServiceProvider().getPreviewHeadersInfo();
                    if (StandardChartDataSheet.this.dataProvider.isLivePreviewEnabled()) {
                        dataList = StandardChartDataSheet.this.getPreviewData();
                    }
                    final ColumnBindingInfo[] headerInfo = headers;
                    final List data = dataList;
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            StandardChartDataSheet.this.updateColumnsTableViewer(headerInfo, data);
                            ChartWizard.removeException((String)"StandChartDataSheet.dataPreview");
                        }
                    });
                }
                catch (Exception e) {
                    final ColumnBindingInfo[] headerInfo = headers;
                    final List data = dataList;
                    final String message = e.getLocalizedMessage();
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            StandardChartDataSheet.this.updateColumnsTableViewer(headerInfo, data);
                            ChartWizard.showException((String)"StandChartDataSheet.dataPreview", (String)message);
                        }
                    });
                }
            }
        };
        new Thread(runnable).start();
    }

    private void updateColumnsTableViewer(ColumnBindingInfo[] headerInfo, List<?> data) {
        if (this.tableViewerColumns.getTable().isDisposed()) {
            return;
        }
        this.tableViewerColumns.setInput((Object)headerInfo);
        this.tableViewerColumns.setData(KEY_PREVIEW_DATA, data);
        int index = this.tablePreview.getCurrentColumnIndex();
        if (index >= 0) {
            this.tableViewerColumns.getTable().setFocus();
            this.tableViewerColumns.getTable().select(index);
            this.tableViewerColumns.getTable().showSelection();
        }
        this.updateColumnsTableViewerColor();
    }

    public Composite createDataSelector(Composite parent) {
        if (this.itemHandle.getDataBindingType() == 0 && this.itemHandle.getContainer() instanceof ModuleHandle) {
            String[] dataSets = this.dataProvider.getAllDataSets();
            if (this.dataProvider.getAllDataCubes().length == 0 && dataSets.length == 1) {
                this.dataProvider.setDataSet(dataSets[0]);
            }
        }
        Composite cmpDataSet = ChartUIUtil.createCompositeWrapper((Composite)parent);
        cmpDataSet.setLayoutData((Object)new GridData(768));
        Label label = new Label(cmpDataSet, 0);
        label.setText(Messages.getString("StandardChartDataSheet.Label.SelectDataSet"));
        label.setFont(JFaceResources.getBannerFont());
        Composite cmpDetail = new Composite(cmpDataSet, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 0;
        cmpDetail.setLayout((Layout)gridLayout);
        cmpDetail.setLayoutData((Object)new GridData(768));
        Composite compRadios = ChartUIUtil.createCompositeWrapper((Composite)cmpDetail);
        GridData gd = new GridData();
        gd.verticalSpan = 2;
        compRadios.setLayoutData((Object)gd);
        this.btnInherit = new Button(compRadios, 16);
        this.btnInherit.setText(Messages.getString("StandardChartDataSheet.Label.UseReportData"));
        this.btnInherit.addListener(13, (Listener)this);
        this.btnUseData = new Button(compRadios, 16);
        this.btnUseData.setText(Messages.getString("StandardChartDataSheet.Label.UseDataSet"));
        this.btnUseData.addListener(13, (Listener)this);
        this.cmbInherit = new CCombo(cmpDetail, 2060);
        this.cmbInherit.setLayoutData((Object)new GridData(768));
        this.cmbInherit.addListener(13, (Listener)this);
        this.cmbDataItems = new CCombo(cmpDetail, 2060);
        this.cmbDataItems.setLayoutData((Object)new GridData(768));
        this.cmbDataItems.addListener(13, (Listener)this);
        this.cmbDataItems.setVisibleItemCount(30);
        this.initDataSelector();
        this.updatePredefinedQueries();
        this.checkColBindingForCube();
        if (this.dataProvider.checkState(8)) {
            this.autoSelect(false);
        }
        return cmpDataSet;
    }

    int invokeNewDataSet() {
        int count = this.getDataServiceProvider().getAllDataSets().length;
        DataService.getInstance().createDataSet();
        if (this.getDataServiceProvider().getAllDataSets().length == count) {
            return 1;
        }
        return 0;
    }

    int invokeEditFilter() {
        ExtendedItemHandle handle = this.getItemHandle();
        handle.getModuleHandle().getCommandStack().startTrans(null);
        ExtendedItemFilterDialog page = new ExtendedItemFilterDialog(handle);
        AbstractFilterHandleProvider provider = ChartFilterProviderDelegate.createFilterProvider(handle, handle);
        if (provider instanceof ChartCubeFilterHandleProvider) {
            ((ChartCubeFilterHandleProvider)provider).setContext(this.getContext());
        }
        page.setFilterHandleProvider((IFormProvider)provider);
        int openStatus = page.open();
        if (openStatus == 0) {
            handle.getModuleHandle().getCommandStack().commit();
        } else {
            handle.getModuleHandle().getCommandStack().rollback();
        }
        return openStatus;
    }

    int invokeEditParameter() {
        ReportItemParametersDialog page = new ReportItemParametersDialog((ReportItemHandle)this.getItemHandle());
        return page.open();
    }

    int invokeDataBinding() {
        Shell shell = new Shell(Display.getDefault(), 67696);
        ExtendedItemHandle handle = this.getItemHandle();
        handle.getModuleHandle().getCommandStack().startTrans(null);
        ChartColumnBindingDialog page = new ChartColumnBindingDialog((ReportItemHandle)handle, shell, this.getContext());
        ExpressionProvider ep = new ExpressionProvider((DesignElementHandle)this.getItemHandle());
        ep.addFilter(new ExpressionFilter(){

            public boolean select(Object parentElement, Object element) {
                return !parentElement.equals(ExpressionProvider.BIRT_OBJECTS) || !(element instanceof IClassInfo) || !((IClassInfo)element).getName().equals("Total");
            }
        });
        page.setExpressionProvider(ep);
        page.setReadOnly(this.getDataServiceProvider().isSharedBinding() || this.getDataServiceProvider().isInheritanceOnly());
        int openStatus = page.open();
        if (openStatus == 0) {
            handle.getModuleHandle().getCommandStack().commit();
            this.updatePredefinedQueries();
            this.checkColBindingForCube();
        } else {
            handle.getModuleHandle().getCommandStack().rollback();
        }
        return openStatus;
    }

    private void initDataSelector() {
        boolean isInheritingSummaryTable = this.isInheritingSummaryTable();
        this.cmbInherit.setItems(new String[]{Messages.getString("StandardChartDataSheet.Combo.InheritColumnsGroups"), Messages.getString("StandardChartDataSheet.Combo.InheritColumnsOnly")});
        if (isInheritingSummaryTable) {
            this.cmbInherit.select(0);
            this.getContext().setInheritColumnsOnly(true);
        } else if (this.dataProvider.isInheritColumnsSet()) {
            this.cmbInherit.select(this.dataProvider.isInheritColumnsOnly() ? 1 : 0);
        } else if (ChartReportItemUtil.hasAggregation((Chart)this.getChartModel())) {
            this.cmbInherit.select(1);
            this.getContext().setInheritColumnsOnly(true);
        } else {
            this.cmbInherit.select(0);
            this.getContext().setInheritColumnsOnly(false);
        }
        this.cmbInherit.setEnabled(false);
        this.cmbDataItems.setItems(this.createDataComboItems());
        String sItemRef = this.getDataServiceProvider().getReportItemReference();
        if (sItemRef != null) {
            this.btnUseData.setSelection(true);
            this.bIsInheritSelected = false;
            ChartUIUtil.setText((Control)this.cmbDataItems, (String)sItemRef);
            this.currentData = sItemRef;
            return;
        }
        String sDataSet = this.getDataServiceProvider().getDataSet();
        if (sDataSet != null && !this.getDataServiceProvider().isInheritanceOnly()) {
            this.btnUseData.setSelection(true);
            this.bIsInheritSelected = false;
            ChartUIUtil.setText((Control)this.cmbDataItems, (String)sDataSet);
            this.currentData = sDataSet;
            return;
        }
        String sDataCube = this.getDataServiceProvider().getDataCube();
        if (sDataCube != null && !this.getDataServiceProvider().isInheritanceOnly()) {
            this.btnUseData.setSelection(true);
            this.bIsInheritSelected = false;
            ChartUIUtil.setText((Control)this.cmbDataItems, (String)sDataCube);
            this.currentData = sDataCube;
            return;
        }
        this.cmbInherit.setEnabled(!isInheritingSummaryTable && this.getDataServiceProvider().getInheritedDataSet() != null && ChartReportItemUtil.isContainerInheritable((ReportItemHandle)this.itemHandle));
        if (!this.cmbInherit.isEnabled()) {
            if (this.itemHandle.getContainer() instanceof MultiViewsHandle || this.itemHandle.getDataBindingReference() != null) {
                this.cmbInherit.select(0);
            } else {
                this.cmbInherit.select(1);
            }
        }
        this.btnInherit.setSelection(true);
        this.bIsInheritSelected = true;
        if (this.getDataServiceProvider().isInheritanceOnly()) {
            this.btnUseData.setSelection(false);
            this.btnUseData.setEnabled(false);
        }
        this.cmbDataItems.select(0);
        this.currentData = null;
        this.cmbDataItems.setEnabled(false);
        this.getDataServiceProvider().setDataSet(null);
    }

    private boolean isInheritingSummaryTable() {
        if (ChartReportItemUtil.isContainerInheritable((ReportItemHandle)this.itemHandle)) {
            TableHandle table = null;
            DesignElementHandle container = this.itemHandle.getContainer();
            while (container != null) {
                if (container instanceof TableHandle) {
                    table = (TableHandle)container;
                    break;
                }
                container = container.getContainer();
            }
            if (table != null) {
                return table.getBooleanProperty("isSummaryTable");
            }
        }
        return false;
    }

    public void handleEvent(Event event) {
        if (event.type == 2) {
            if (event.detail == 4) {
                this.updateColorAndText();
            } else if (event.detail == 3 && event.data instanceof ISelectDataComponent) {
                this.refreshTableColor();
            }
            return;
        }
        if (event.type == 0) {
            if ((this.getDataServiceProvider().getDataSet() != null || this.getDataServiceProvider().getInheritedDataSet() != null) && event.widget instanceof Button) {
                Button header = (Button)event.widget;
                boolean isSharingChart = this.dataProvider.checkState(2048);
                if (header.getMenu() == null && !isSharingChart) {
                    header.setMenu(this.createMenuManager(event.data).createContextMenu((Control)this.tablePreview));
                }
                if (event.doit && !isSharingChart) {
                    header.getMenu().setVisible(true);
                }
            }
        } else if (event.type == 13) {
            if (event.widget instanceof MenuItem) {
                IAction action;
                MenuItem item = (MenuItem)event.widget;
                action.setChecked(!(action = (IAction)item.getData()).isChecked());
                action.run();
            } else if (event.widget == this.btnFilters) {
                if (this.invokeEditFilter() == 0) {
                    this.refreshDataPreviewPane();
                    this.fireEvent((Widget)this.btnFilters, 1);
                }
            } else if (event.widget == this.btnParameters) {
                if (this.invokeEditParameter() == 0) {
                    this.refreshDataPreviewPane();
                    this.fireEvent((Widget)this.btnParameters, 1);
                }
            } else if (event.widget == this.btnBinding && this.invokeDataBinding() == 0) {
                this.refreshDataPreviewPane();
                this.fireEvent((Widget)this.btnBinding, 1);
            }
            try {
                if (event.widget == this.btnInherit) {
                    ColorPalette.getInstance().restore();
                    if (!this.btnInherit.getSelection()) {
                        return;
                    }
                    if (this.bIsInheritSelected) {
                        return;
                    }
                    this.bIsInheritSelected = true;
                    this.getDataServiceProvider().setReportItemReference(null);
                    this.getDataServiceProvider().setDataCube(null);
                    this.getDataServiceProvider().setDataSet(null);
                    this.switchDataSet(null);
                    this.cmbDataItems.select(0);
                    this.currentData = null;
                    this.cmbDataItems.setEnabled(false);
                    this.cmbInherit.setEnabled(!this.isInheritingSummaryTable() && this.getDataServiceProvider().getInheritedDataSet() != null && ChartReportItemUtil.isContainerInheritable((ReportItemHandle)this.itemHandle));
                    this.setEnabledForButtons();
                    this.updateDragDataSource();
                    this.updatePredefinedQueries();
                } else if (event.widget == this.btnUseData) {
                    if (!this.btnUseData.getSelection()) {
                        return;
                    }
                    if (!this.bIsInheritSelected) {
                        return;
                    }
                    this.bIsInheritSelected = false;
                    this.getDataServiceProvider().setReportItemReference(null);
                    this.getDataServiceProvider().setDataSet(null);
                    this.selectDataSet();
                    this.cmbDataItems.setEnabled(true);
                    this.cmbInherit.setEnabled(false);
                    this.setEnabledForButtons();
                    this.updateDragDataSource();
                    this.updatePredefinedQueries();
                } else if (event.widget == this.cmbInherit) {
                    this.getContext().setInheritColumnsOnly(this.cmbInherit.getSelectionIndex() == 1);
                    this.setEnabledForButtons();
                    this.fireEvent((Widget)this.btnBinding, 2);
                    this.refreshDataPreviewPane();
                } else if (event.widget == this.cmbDataItems) {
                    ColorPalette.getInstance().restore();
                    int selectedIndex = this.cmbDataItems.getSelectionIndex();
                    Integer selectState = this.selectDataTypes.get(selectedIndex);
                    switch (selectState) {
                        case 1: {
                            this.btnInherit.setSelection(true);
                            this.btnUseData.setSelection(false);
                            this.btnInherit.notifyListeners(13, new Event());
                            break;
                        }
                        case 2: {
                            selectState = this.selectDataTypes.get(++selectedIndex);
                            this.cmbDataItems.select(selectedIndex);
                        }
                    }
                    switch (selectState) {
                        case 4: {
                            if (this.getDataServiceProvider().getReportItemReference() == null && this.getDataServiceProvider().getDataSet() != null && this.getDataServiceProvider().getDataSet().equals(ChartUIUtil.getText((Control)this.cmbDataItems))) {
                                return;
                            }
                            this.getDataServiceProvider().setDataSet(ChartUIUtil.getText((Control)this.cmbDataItems));
                            this.currentData = ChartUIUtil.getText((Control)this.cmbDataItems);
                            this.switchDataSet(ChartUIUtil.getText((Control)this.cmbDataItems));
                            this.setEnabledForButtons();
                            this.updateDragDataSource();
                            break;
                        }
                        case 8: {
                            this.getDataServiceProvider().setDataCube(ChartUIUtil.getText((Control)this.cmbDataItems));
                            this.currentData = ChartUIUtil.getText((Control)this.cmbDataItems);
                            this.updateDragDataSource();
                            this.setEnabledForButtons();
                            DataDefinitionTextManager.getInstance().refreshAll();
                            this.fireEvent((Widget)this.tablePreview, 1);
                            break;
                        }
                        case 16: {
                            if (ChartUIUtil.getText((Control)this.cmbDataItems).equals(this.getDataServiceProvider().getReportItemReference())) {
                                return;
                            }
                            this.getDataServiceProvider().setReportItemReference(ChartUIUtil.getText((Control)this.cmbDataItems));
                            ChartReportItemUtil.reviseChartModel((int)1, (Chart)this.getContext().getModel(), (ReportItemHandle)this.itemHandle);
                            if (this.getDataServiceProvider().checkState(2048)) {
                                ChartAdapter.beginIgnoreNotifications();
                                this.getDataServiceProvider().update("CopySeriesDefinition", null);
                                ChartAdapter.endIgnoreNotifications();
                            }
                            this.currentData = ChartUIUtil.getText((Control)this.cmbDataItems);
                            DataDefinitionTextManager.getInstance().refreshAll();
                            this.fireEvent((Widget)this.tablePreview, 1);
                            this.setEnabledForButtons();
                            this.updateDragDataSource();
                            break;
                        }
                        case 32: {
                            int result = this.invokeNewDataSet();
                            if (result == 1) {
                                if (this.currentData == null) {
                                    this.cmbDataItems.select(0);
                                } else {
                                    this.cmbDataItems.setText(this.currentData);
                                }
                                return;
                            }
                            this.cmbDataItems.removeAll();
                            this.cmbDataItems.setItems(this.createDataComboItems());
                            String[] datasets = this.getDataServiceProvider().getAllDataSets();
                            this.currentData = datasets[datasets.length - 1];
                            this.getDataServiceProvider().setDataSet(this.currentData);
                            this.cmbDataItems.setText(this.currentData);
                            this.setEnabledForButtons();
                            this.updateDragDataSource();
                            break;
                        }
                        case 64: {
                            if (this.getDataServiceProvider().getAllDataSets().length == 0) {
                                this.invokeNewDataSet();
                            }
                            int count = this.getDataServiceProvider().getAllDataCubes().length;
                            if (this.getDataServiceProvider().getAllDataSets().length != 0) {
                                new NewCubeAction().run();
                            }
                            String[] datacubes = this.getDataServiceProvider().getAllDataCubes();
                            this.cmbDataItems.removeAll();
                            this.cmbDataItems.setItems(this.createDataComboItems());
                            if (datacubes.length == count) {
                                if (this.currentData == null) {
                                    this.cmbDataItems.select(0);
                                } else {
                                    this.cmbDataItems.setText(this.currentData);
                                }
                                return;
                            }
                            this.currentData = datacubes[datacubes.length - 1];
                            this.getDataServiceProvider().setDataCube(this.currentData);
                            this.cmbDataItems.setText(this.currentData);
                            this.updateDragDataSource();
                            this.setEnabledForButtons();
                            DataDefinitionTextManager.getInstance().refreshAll();
                            this.fireEvent((Widget)this.tablePreview, 1);
                        }
                    }
                    this.updatePredefinedQueries();
                    this.autoSelect(true);
                } else if (event.widget == this.btnShowDataPreviewA || event.widget == this.btnShowDataPreviewB) {
                    Button w = (Button)event.widget;
                    this.getContext().setShowingDataPreview(Boolean.valueOf(w.getSelection()));
                    this.updateDragDataSource();
                }
                this.checkColBindingForCube();
                ChartWizard.removeException((String)"StandardChartDataSheet.swtichDataSet");
            }
            catch (ChartException e1) {
                ChartWizard.showException((String)"StandardChartDataSheet.swtichDataSet", (String)e1.getLocalizedMessage());
            }
        }
    }

    private void autoSelect(boolean force) {
        if (this.dataProvider.checkState(256) && !this.dataProvider.checkState(2048)) {
            Query query = (Query)((SeriesDefinition)ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.getContext().getModel()).get(0)).getDesignTimeSeries().getDataDefinition().get(0);
            Object[] valueExprs = this.getContext().getPredefinedQuery("value");
            if ((force || query.getDefinition() == null || query.getDefinition().trim().length() == 0) && valueExprs != null && valueExprs.length == 1) {
                String text = valueExprs[0].toString();
                query.setDefinition(text);
                if (this.dataProvider.update("value", text)) {
                    Event e = new Event();
                    e.type = 2;
                    this.notifyListeners(e);
                }
                if (force) {
                    this.fireEvent((Widget)this.tablePreview, 1);
                }
            }
        }
    }

    private void selectDataSet() {
        String currentDS = this.getDataServiceProvider().getDataSet();
        if (currentDS == null) {
            this.cmbDataItems.select(0);
            this.currentData = null;
        } else {
            ChartUIUtil.setText((Control)this.cmbDataItems, (String)currentDS);
            this.currentData = currentDS;
        }
    }

    private void refreshTablePreview() {
        if (this.dataProvider.getDataSetFromHandle() == null) {
            return;
        }
        this.tablePreview.clearContents();
        this.switchDataTable();
        this.tablePreview.layout();
    }

    private void switchDataSet(String datasetName) throws ChartException {
        if (this.isCubeMode()) {
            return;
        }
        try {
            this.tablePreview.clearContents();
            this.tableViewerColumns.setInput(null);
            if (datasetName == null) {
                datasetName = this.getDataServiceProvider().getInheritedDataSet();
            }
            this.tablePreview.createDummyTable();
            this.tablePreview.layout();
        }
        catch (Throwable t) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, t);
        }
        DataDefinitionTextManager.getInstance().refreshAll();
        this.fireEvent((Widget)this.tablePreview, 1);
    }

    private void updateTablePreview(ColumnBindingInfo[] headers, List<?> dataList) {
        this.fireEvent((Widget)this.tablePreview, 2);
        if (this.tablePreview.isDisposed()) {
            return;
        }
        if (headers == null || headers.length == 0) {
            this.tablePreview.setEnabled(false);
            this.tablePreview.createDummyTable();
        } else {
            this.tablePreview.setEnabled(true);
            this.tablePreview.setColumns(headers);
            this.refreshTableColor();
            if (dataList != null) {
                for (String[] dataRow : dataList) {
                    int i = 0;
                    while (i < dataRow.length) {
                        this.tablePreview.addEntry(dataRow[i], i);
                        ++i;
                    }
                }
            }
        }
        this.tablePreview.layout();
        int index = this.tableViewerColumns.getTable().getSelectionIndex();
        if (index >= 0) {
            this.tablePreview.moveTo(index);
        }
    }

    private synchronized List<?> getPreviewData() throws ChartException {
        return this.getDataServiceProvider().getPreviewData();
    }

    private void switchDataTable() {
        if (this.isCubeMode()) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                ColumnBindingInfo[] headers = null;
                List dataList = null;
                try {
                    headers = StandardChartDataSheet.this.getDataServiceProvider().getPreviewHeadersInfo();
                    dataList = StandardChartDataSheet.this.getPreviewData();
                    final ColumnBindingInfo[] headerInfo = headers;
                    final List data = dataList;
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            StandardChartDataSheet.this.updateTablePreview(headerInfo, data);
                            ChartWizard.removeException((String)"StandChartDataSheet.dataPreview");
                        }
                    });
                }
                catch (Exception e) {
                    final ColumnBindingInfo[] headerInfo = headers;
                    final List data = dataList;
                    final String message = e.getMessage();
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            StandardChartDataSheet.this.updateTablePreview(headerInfo, data);
                            ChartWizard.showException((String)"StandChartDataSheet.dataPreview", (String)message);
                        }
                    });
                }
            }
        };
        new Thread(runnable).start();
    }

    private void refreshTableColor() {
        if (this.isCubeMode()) {
            return;
        }
        if (this.getContext().isShowingDataPreview()) {
            int i = 0;
            while (i < this.tablePreview.getColumnNumber()) {
                this.tablePreview.setColumnColor(i, ColorPalette.getInstance().getColor(this.tablePreview.getColumnHeading(i)));
                ++i;
            }
        } else {
            this.updateColumnsTableViewerColor();
        }
    }

    private void updateColumnsTableViewerColor() {
        TableItem[] tableItemArray = this.tableViewerColumns.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            ColumnBindingInfo cbi = (ColumnBindingInfo)item.getData();
            Color c = ColorPalette.getInstance().getColor(cbi.getName());
            if (c == null) {
                c = Display.getDefault().getSystemColor(25);
            }
            item.setBackground(c);
            ++n2;
        }
    }

    private String getActualExpression(String expr) {
        ColumnBindingInfo cbi;
        int type;
        if (!this.dataProvider.checkState(16)) {
            return expr;
        }
        Object obj = this.getCurrentColumnHeadObject();
        if (obj instanceof ColumnBindingInfo && ((type = (cbi = (ColumnBindingInfo)obj).getColumnType()) == 1 || type == 2)) {
            return cbi.getExpression();
        }
        return expr;
    }

    protected void manageColorAndQuery(Query query, String expr) {
        if (DataDefinitionTextManager.getInstance().getNumberOfSameDataDefinition(query.getDefinition()) == 1) {
            ColorPalette.getInstance().retrieveColor(query.getDefinition());
        }
        query.setDefinition(this.getActualExpression(expr));
        DataDefinitionTextManager.getInstance().refreshAll();
        this.refreshTableColor();
    }

    protected void updateColorAndText() {
        DataDefinitionTextManager.getInstance().refreshAll();
        this.refreshTableColor();
    }

    Object getCurrentColumnHeadObject() {
        if (this.getContext().isShowingDataPreview()) {
            return this.tablePreview.getCurrentColumnHeadObject();
        }
        int index = this.tableViewerColumns.getTable().getSelectionIndex();
        if (index < 0) {
            return null;
        }
        return this.tableViewerColumns.getTable().getItem(index).getData();
    }

    ExtendedItemHandle getItemHandle() {
        return this.itemHandle;
    }

    ReportDataServiceProvider getDataServiceProvider() {
        return this.dataProvider;
    }

    protected List<Object> getActionsForTableHead(String expr) {
        ArrayList<Object> actions = new ArrayList<Object>(3);
        actions.add(this.getBaseSeriesMenu(this.getChartModel(), expr));
        actions.add(this.getOrthogonalSeriesMenu(this.getChartModel(), expr));
        actions.add(this.getGroupSeriesMenu(this.getChartModel(), expr));
        return actions;
    }

    protected Object getMenuForMeasure(Chart chart, String expr) {
        return this.getOrthogonalSeriesMenu(this.getChartModel(), expr);
    }

    protected Object getMenuForDimension(Chart chart, String expr) {
        ArrayList<Object> menus = new ArrayList<Object>(2);
        if (((Boolean)this.dataProvider.checkData("category", expr)).booleanValue()) {
            menus.add(this.getBaseSeriesMenu(this.getChartModel(), expr));
        }
        if (this.dataProvider.checkState(64) && ((Boolean)this.dataProvider.checkData("optional", expr)).booleanValue()) {
            menus.add(this.getGroupSeriesMenu(this.getChartModel(), expr));
        }
        return menus;
    }

    private MenuManager createMenuManager(final Object data) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                String expr;
                if (data instanceof ColumnBindingInfo) {
                    this.addMenu(manager, (Object)new HeaderShowAction(((ColumnBindingInfo)data).getName()));
                    List<Object> actions = StandardChartDataSheet.this.getActionsForTableHead(((ColumnBindingInfo)data).getName());
                    for (Object act : actions) {
                        this.addMenu(manager, act);
                    }
                } else if (data instanceof Integer) {
                    this.addMenu(manager, (Object)new HeaderShowAction(StandardChartDataSheet.this.tablePreview.getCurrentColumnHeading()));
                    String expr2 = ExpressionUtil.createJSRowExpression((String)StandardChartDataSheet.this.tablePreview.getCurrentColumnHeading());
                    List<Object> actions = StandardChartDataSheet.this.getActionsForTableHead(expr2);
                    for (Object act : actions) {
                        this.addMenu(manager, act);
                    }
                } else if (data instanceof MeasureHandle) {
                    String expr3 = StandardChartDataSheet.this.createCubeExpression();
                    if (expr3 != null) {
                        this.addMenu(manager, StandardChartDataSheet.this.getMenuForMeasure(StandardChartDataSheet.this.getChartModel(), expr3));
                    }
                } else if (data instanceof LevelHandle && (expr = StandardChartDataSheet.this.createCubeExpression()) != null) {
                    this.addMenu(manager, StandardChartDataSheet.this.getMenuForDimension(StandardChartDataSheet.this.getChartModel(), expr));
                }
            }

            private void addMenu(IMenuManager manager, Object item) {
                if (item instanceof IAction) {
                    manager.add((IAction)item);
                } else if (item instanceof IContributionItem) {
                    manager.add((IContributionItem)item);
                } else if (item instanceof List) {
                    for (Object o : (List)item) {
                        this.addMenu(manager, o);
                    }
                }
                if (StandardChartDataSheet.this.getDataServiceProvider().isPartChart() && item instanceof IAction) {
                    ((IAction)item).setEnabled(false);
                }
            }
        });
        return menuManager;
    }

    protected Object getBaseSeriesMenu(Chart chart, String expr) {
        EList sds = ChartUIUtil.getBaseSeriesDefinitions((Chart)chart);
        if (sds.size() == 1) {
            return new CategoryXAxisAction(expr);
        }
        return null;
    }

    protected Object getGroupSeriesMenu(Chart chart, String expr) {
        MenuManager topManager = new MenuManager(this.getGroupSeriesTitle(this.getChartModel()));
        int axisNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)chart);
        int axisIndex = 0;
        while (axisIndex < axisNum) {
            EList sds = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)chart, (int)axisIndex);
            if (!sds.isEmpty()) {
                SeriesDefinition sd = (SeriesDefinition)sds.get(0);
                GroupYSeriesAction action = new GroupYSeriesAction(sd.getQuery(), expr, sd);
                return action;
            }
            ++axisIndex;
        }
        return topManager;
    }

    protected Object getOrthogonalSeriesMenu(Chart chart, String expr) {
        MenuManager topManager = new MenuManager(this.getOrthogonalSeriesTitle(this.getChartModel()));
        int axisNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)chart);
        int axisIndex = 0;
        while (axisIndex < axisNum) {
            EList sds = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)chart, (int)axisIndex);
            int i = 0;
            while (i < sds.size()) {
                ValueYSeriesAction action;
                int j;
                MenuManager secondManager;
                Series series = ((SeriesDefinition)sds.get(i)).getDesignTimeSeries();
                EList dataDefns = series.getDataDefinition();
                if (series instanceof StockSeries) {
                    secondManager = new MenuManager(this.getSecondMenuText(axisIndex, i, series));
                    topManager.add((IContributionItem)secondManager);
                    j = 0;
                    while (j < dataDefns.size()) {
                        action = new ValueYSeriesAction((Query)dataDefns.get(j), expr);
                        action.setText(String.valueOf(ChartUIUtil.getStockTitle((int)j)) + Messages.getString("StandardChartDataSheet.Label.Component"));
                        secondManager.add((IAction)action);
                        ++j;
                    }
                } else if (series instanceof BubbleSeries) {
                    secondManager = new MenuManager(this.getSecondMenuText(axisIndex, i, series));
                    topManager.add((IContributionItem)secondManager);
                    j = 0;
                    while (j < dataDefns.size()) {
                        action = new ValueYSeriesAction((Query)dataDefns.get(j), expr);
                        action.setText(String.valueOf(ChartUIUtil.getBubbleTitle((int)j)) + Messages.getString("StandardChartDataSheet.Label.Component"));
                        secondManager.add((IAction)action);
                        ++j;
                    }
                } else if (series instanceof DifferenceSeries) {
                    secondManager = new MenuManager(this.getSecondMenuText(axisIndex, i, series));
                    topManager.add((IContributionItem)secondManager);
                    j = 0;
                    while (j < dataDefns.size()) {
                        action = new ValueYSeriesAction((Query)dataDefns.get(j), expr);
                        action.setText(String.valueOf(ChartUIUtil.getDifferenceTitle((int)j)) + Messages.getString("StandardChartDataSheet.Label.Component"));
                        secondManager.add((IAction)action);
                        ++j;
                    }
                } else if (series instanceof GanttSeries) {
                    secondManager = new MenuManager(this.getSecondMenuText(axisIndex, i, series));
                    topManager.add((IContributionItem)secondManager);
                    j = 0;
                    while (j < dataDefns.size()) {
                        action = new ValueYSeriesAction((Query)dataDefns.get(j), expr);
                        action.setText(String.valueOf(ChartUIUtil.getGanttTitle((int)j)) + Messages.getString("StandardChartDataSheet.Label.Component"));
                        secondManager.add((IAction)action);
                        ++j;
                    }
                } else {
                    ValueYSeriesAction action2 = new ValueYSeriesAction((Query)dataDefns.get(0), expr);
                    if (axisNum == 1 && sds.size() == 1) {
                        return action2;
                    }
                    action2.setText(this.getSecondMenuText(axisIndex, i, series));
                    topManager.add((IAction)action2);
                }
                ++i;
            }
            ++axisIndex;
        }
        return topManager;
    }

    private String getSecondMenuText(int axisIndex, int seriesIndex, Series series) {
        StringBuffer sb = new StringBuffer();
        if (ChartUIUtil.getOrthogonalAxisNumber((Chart)this.getChartModel()) > 1) {
            sb.append(Messages.getString("StandardChartDataSheet.Label.Axis"));
            sb.append(axisIndex + 1);
            sb.append(" - ");
        }
        sb.append(String.valueOf(Messages.getString("StandardChartDataSheet.Label.Series")) + (seriesIndex + 1) + " (" + series.getDisplayName() + ")");
        return sb.toString();
    }

    private String getBaseSeriesTitle(Chart chart) {
        if (chart instanceof ChartWithAxes) {
            return Messages.getString("StandardChartDataSheet.Label.UseAsCategoryXAxis");
        }
        return Messages.getString("StandardChartDataSheet.Label.UseAsCategorySeries");
    }

    private String getOrthogonalSeriesTitle(Chart chart) {
        if (chart instanceof ChartWithAxes) {
            return Messages.getString("StandardChartDataSheet.Label.PlotAsValueYSeries");
        }
        if (chart instanceof DialChart) {
            return Messages.getString("StandardChartDataSheet.Label.PlotAsGaugeValue");
        }
        return Messages.getString("StandardChartDataSheet.Label.PlotAsValueSeries");
    }

    private String getGroupSeriesTitle(Chart chart) {
        if (chart instanceof ChartWithAxes) {
            return Messages.getString("StandardChartDataSheet.Label.UseToGroupYSeries");
        }
        return Messages.getString("StandardChartDataSheet.Label.UseToGroupValueSeries");
    }

    private boolean isCubeMode() {
        boolean bCube;
        boolean bl = bCube = ChartCubeUtil.getBindingCube((DesignElementHandle)this.itemHandle) != null;
        if (bCube) {
            return this.isDataItemSupported(8);
        }
        return false;
    }

    private CubeHandle getCube() {
        return ChartCubeUtil.getBindingCube((DesignElementHandle)this.itemHandle);
    }

    private String createCubeExpression() {
        if (this.cubeTreeViewer == null) {
            return null;
        }
        TreeItem[] selection = this.cubeTreeViewer.getTree().getSelection();
        String expr = null;
        if (selection.length > 0 && !this.dataProvider.isSharedBinding() && !this.dataProvider.isPartChart()) {
            TreeItem treeItem = selection[0];
            ComputedColumnHandle binding = null;
            if (treeItem.getData() instanceof LevelHandle) {
                binding = ChartCubeUtil.findBinding((ReportItemHandle)this.itemHandle, (String)ChartCubeUtil.createDimensionExpression((LevelHandle)((LevelHandle)treeItem.getData())));
            } else if (treeItem.getData() instanceof MeasureHandle) {
                binding = ChartCubeUtil.findBinding((ReportItemHandle)this.itemHandle, (String)ChartCubeUtil.createMeasureExpression((MeasureHandle)((MeasureHandle)treeItem.getData())));
            }
            if (binding != null) {
                expr = binding.getName();
            }
        }
        return expr;
    }

    private boolean isDataItemSupported(int type) {
        return this.iSupportedDataItems == 0 || (this.iSupportedDataItems & type) == type;
    }

    private String[] createDataComboItems() {
        String[] dataRefs;
        int i;
        ArrayList<String> items = new ArrayList<String>();
        this.selectDataTypes.clear();
        if (this.isDataItemSupported(1)) {
            if (DEUtil.getDataSetList((DesignElementHandle)this.itemHandle.getContainer()).size() > 0) {
                items.add(Messages.getString("ReportDataServiceProvider.Option.Inherits", ((DataSetHandle)DEUtil.getDataSetList((DesignElementHandle)this.itemHandle.getContainer()).get(0)).getName()));
            } else {
                items.add(ReportDataServiceProvider.OPTION_NONE);
            }
            this.selectDataTypes.add(1);
        }
        if (this.isDataItemSupported(4)) {
            String[] dataSets = this.getDataServiceProvider().getAllDataSets();
            if (dataSets.length > 0) {
                if (this.isDataItemSupported(2)) {
                    items.add(Messages.getString("StandardChartDataSheet.Combo.DataSets"));
                    this.selectDataTypes.add(2);
                }
                i = 0;
                while (i < dataSets.length) {
                    items.add(dataSets[i]);
                    this.selectDataTypes.add(4);
                    ++i;
                }
            }
            if (this.isDataItemSupported(32)) {
                items.add(Messages.getString("StandardChartDataSheet.NewDataSet"));
                this.selectDataTypes.add(32);
            }
        }
        if (this.isDataItemSupported(8)) {
            String[] dataCubes = this.getDataServiceProvider().getAllDataCubes();
            if (dataCubes.length > 0) {
                if (this.isDataItemSupported(2)) {
                    items.add(Messages.getString("StandardChartDataSheet.Combo.DataCubes"));
                    this.selectDataTypes.add(2);
                }
                i = 0;
                while (i < dataCubes.length) {
                    items.add(dataCubes[i]);
                    this.selectDataTypes.add(8);
                    ++i;
                }
            }
            if (this.isDataItemSupported(64)) {
                items.add(Messages.getString("StandardChartDataSheet.NewDataCube"));
                this.selectDataTypes.add(64);
            }
        }
        if (this.isDataItemSupported(16) && (dataRefs = this.getDataServiceProvider().getAllReportItemReferences()).length > 0) {
            int curSize = items.size();
            if (this.isDataItemSupported(2)) {
                items.add(Messages.getString("StandardChartDataSheet.Combo.ReportItems"));
                this.selectDataTypes.add(2);
            }
            int i2 = 0;
            while (i2 < dataRefs.length) {
                if (this.isDataItemSupported(8) || ((ReportItemHandle)this.getDataServiceProvider().getReportDesignHandle().findElement(dataRefs[i2])).getCube() == null) {
                    items.add(dataRefs[i2]);
                    this.selectDataTypes.add(16);
                }
                ++i2;
            }
            if (items.size() == curSize + 1) {
                items.remove(curSize);
                this.selectDataTypes.remove(curSize);
            }
        }
        return items.toArray(new String[items.size()]);
    }

    protected void updatePredefinedQueriesForSharingCube() {
        Object[] categoryExprs;
        ArrayList<String> dimensionExprs = new ArrayList<String>();
        ArrayList<String> measureExprs = new ArrayList<String>();
        ReportItemHandle reportItemHandle = this.dataProvider.getReportItemHandle();
        for (ComputedColumnHandle cch : reportItemHandle.getColumnBindings()) {
            String dataExpr = ExpressionUtil.createJSDataExpression((String)cch.getName());
            if (ChartCubeUtil.isDimensionExpresion((String)cch.getExpression())) {
                dimensionExprs.add(dataExpr);
                continue;
            }
            if (!ChartCubeUtil.isMeasureExpresion((String)cch.getExpression())) continue;
            measureExprs.add(dataExpr);
        }
        Object[] yOptionalExprs = categoryExprs = dimensionExprs.toArray(new String[dimensionExprs.size()]);
        Object[] valueExprs = measureExprs.toArray(new String[measureExprs.size()]);
        ReportItemHandle referenceHandle = ChartReportItemUtil.getReportItemReference((ReportItemHandle)this.itemHandle);
        ReportDataServiceProvider rdsp = this.getDataServiceProvider();
        if (referenceHandle instanceof ExtendedItemHandle && ChartItemUtil.isChartReportItemHandle((ReportItemHandle)referenceHandle)) {
            Chart referenceCM = ChartItemUtil.getChartFromHandle((ExtendedItemHandle)((ExtendedItemHandle)referenceHandle));
            categoryExprs = rdsp.getSeriesExpressionsFrom(referenceCM, "category");
            yOptionalExprs = rdsp.getSeriesExpressionsFrom(referenceCM, "optional");
            valueExprs = rdsp.getSeriesExpressionsFrom(referenceCM, "value");
            Chart cm = this.getContext().getModel();
            if (categoryExprs.length > 0) {
                this.updateCategoryExpression(cm, (String)categoryExprs[0]);
            }
            if (yOptionalExprs.length > 0) {
                this.updateYOptionalExpressions(cm, (String)yOptionalExprs[0]);
            }
        } else if (this.dataProvider.checkState(256)) {
            categoryExprs = null;
            yOptionalExprs = null;
        }
        this.getContext().addPredefinedQuery("category", categoryExprs);
        this.getContext().addPredefinedQuery("optional", yOptionalExprs);
        this.getContext().addPredefinedQuery("value", valueExprs);
    }

    private void updatePredefinedQueries() {
        block13: {
            if (this.dataProvider.isInXTabMeasureCell()) {
                try {
                    CrosstabReportItemHandle xtab = ChartCubeUtil.getXtabContainerCell((DesignElementHandle)this.itemHandle).getCrosstab();
                    if (this.dataProvider.isPartChart()) {
                        List levels = ChartCubeUtil.getAllLevelsBindingName((CrosstabReportItemHandle)xtab);
                        Object[] exprs = levels.toArray(new String[levels.size()]);
                        if (exprs.length == 2 && this.dataProvider.isInXTabAggrCell()) {
                            exprs = ((ChartWithAxes)this.getChartModel()).isTransposed() ? new String[]{exprs[1]} : new String[]{exprs[0]};
                        }
                        this.getContext().addPredefinedQuery("category", exprs);
                        break block13;
                    }
                    Iterator columnBindings = ChartCubeUtil.getAllColumnBindingsIterator((ReportItemHandle)this.itemHandle);
                    List levels = ChartCubeUtil.getAllLevelsBindingName((Iterator)columnBindings);
                    Object[] exprs = levels.toArray(new String[levels.size()]);
                    this.getContext().addPredefinedQuery("category", exprs);
                    this.getContext().addPredefinedQuery("optional", exprs);
                    columnBindings = ChartCubeUtil.getAllColumnBindingsIterator((ReportItemHandle)this.itemHandle);
                    List measures = ChartCubeUtil.getAllMeasuresBindingName((Iterator)columnBindings);
                    exprs = measures.toArray(new String[measures.size()]);
                    this.getContext().addPredefinedQuery("value", exprs);
                }
                catch (BirtException e) {
                    WizardBase.displayException((Throwable)e);
                }
            } else if (this.getCube() == null) {
                try {
                    ColumnBindingInfo[] headers = this.dataProvider.getPreviewHeadersInfo();
                    this.getDataServiceProvider().setPredefinedExpressions(headers);
                }
                catch (ChartException chartException) {
                    this.getContext().addPredefinedQuery("category", null);
                    this.getContext().addPredefinedQuery("value", null);
                    this.getContext().addPredefinedQuery("optional", null);
                }
            } else if (this.isDataItemSupported(8)) {
                if (this.dataProvider.isInheritanceOnly() || this.dataProvider.isSharedBinding()) {
                    this.updatePredefinedQueriesForSharingCube();
                } else {
                    Iterator columnBindings = ChartCubeUtil.getAllColumnBindingsIterator((ReportItemHandle)this.itemHandle);
                    List levels = ChartCubeUtil.getAllLevelsBindingName((Iterator)columnBindings);
                    Object[] exprs = levels.toArray(new String[levels.size()]);
                    this.getContext().addPredefinedQuery("category", exprs);
                    this.getContext().addPredefinedQuery("optional", exprs);
                    columnBindings = ChartCubeUtil.getAllColumnBindingsIterator((ReportItemHandle)this.itemHandle);
                    List measures = ChartCubeUtil.getAllMeasuresBindingName((Iterator)columnBindings);
                    exprs = measures.toArray(new String[measures.size()]);
                    this.getContext().addPredefinedQuery("value", exprs);
                }
            }
        }
        this.fireEvent((Widget)this.btnBinding, 2);
    }

    protected void updateYOptionalExpressions(Chart cm, String expr) {
        this.dataProvider.update("optional", expr);
    }

    protected void updateCategoryExpression(Chart cm, String expr) {
        this.dataProvider.update("category", expr);
    }

    private void checkColBindingForCube() {
        if (this.getCube() != null && !ChartXTabUIUtil.checkColumnbindingForCube((Iterator)DEUtil.getBindingColumnIterator((DesignElementHandle)DEUtil.getBindingHolder((DesignElementHandle)this.itemHandle)))) {
            ChartWizard.showException((String)"StandardChartDataSheet.checkCubeColumnBinding", (String)Messages.getString("StandardChartDataSheet.CheckCubeWarning"));
        } else {
            ChartWizard.removeException((String)"StandardChartDataSheet.checkCubeColumnBinding");
        }
    }

    public ISelectDataCustomizeUI createCustomizeUI(ITask task) {
        return new SelectDataDynamicArea(task);
    }

    private class CategoryXAxisAction
    extends Action {
        private final IExpressionButton eb;
        private final String bindingName;

        CategoryXAxisAction(String bindingName) {
            super(StandardChartDataSheet.this.getBaseSeriesTitle(StandardChartDataSheet.this.getChartModel()));
            SeriesDefinition seriesDefintion = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)StandardChartDataSheet.this.getChartModel()).get(0);
            Query query = (Query)seriesDefintion.getDesignTimeSeries().getDataDefinition().get(0);
            this.bindingName = bindingName;
            this.eb = DataDefinitionTextManager.getInstance().findExpressionButton(query);
            if (this.eb != null) {
                StandardChartDataSheet.this.exprCodec.setType(this.eb.getExpressionType());
                StandardChartDataSheet.this.exprCodec.setBindingName(bindingName, this.eb.isCube());
            }
            this.setEnabled(this.eb != null && DataDefinitionTextManager.getInstance().isAcceptableExpression(query, StandardChartDataSheet.this.exprCodec.getExpression(), StandardChartDataSheet.this.dataProvider.isSharedBinding() || StandardChartDataSheet.this.dataProvider.isInheritColumnsGroups()));
        }

        public void run() {
            if (this.eb != null) {
                this.eb.setBindingName(this.bindingName, true);
            }
        }
    }

    private class GroupYSeriesAction
    extends Action {
        private final IExpressionButton eb;
        private final String bindingName;
        private final String expr;

        GroupYSeriesAction(Query query, String bindingName, SeriesDefinition seriesDefinition) {
            super(StandardChartDataSheet.this.getGroupSeriesTitle(StandardChartDataSheet.this.getChartModel()));
            this.bindingName = bindingName;
            this.eb = DataDefinitionTextManager.getInstance().findExpressionButton(query);
            if (this.eb != null) {
                StandardChartDataSheet.this.exprCodec.setType(this.eb.getExpressionType());
                StandardChartDataSheet.this.exprCodec.setBindingName(bindingName, this.eb.isCube());
                this.expr = StandardChartDataSheet.this.exprCodec.getExpression();
            } else {
                this.expr = null;
            }
            this.setEnabled(this.eb != null && DataDefinitionTextManager.getInstance().isAcceptableExpression(query, this.expr, StandardChartDataSheet.this.dataProvider.isSharedBinding() || StandardChartDataSheet.this.dataProvider.isInheritColumnsGroups()));
        }

        public void run() {
            ChartAdapter.beginIgnoreNotifications();
            ChartUIUtil.setAllGroupingQueryExceptFirst((Chart)StandardChartDataSheet.this.getChartModel(), (String)this.expr);
            ChartAdapter.endIgnoreNotifications();
            if (this.eb != null) {
                this.eb.setBindingName(this.bindingName, true);
            }
        }
    }

    static class HeaderShowAction
    extends Action {
        HeaderShowAction(String header) {
            super(header);
            this.setEnabled(false);
        }
    }

    private class ValueYSeriesAction
    extends Action {
        private final IExpressionButton eb;
        private final String bindingName;

        ValueYSeriesAction(Query query, String bindingName) {
            Object obj;
            boolean enabled;
            super(StandardChartDataSheet.this.getOrthogonalSeriesTitle(StandardChartDataSheet.this.getChartModel()));
            this.bindingName = bindingName;
            this.eb = DataDefinitionTextManager.getInstance().findExpressionButton(query);
            boolean bl = enabled = this.eb != null;
            if ((StandardChartDataSheet.this.dataProvider.isSharedBinding() || StandardChartDataSheet.this.dataProvider.isInheritColumnsGroups()) && (obj = StandardChartDataSheet.this.getCurrentColumnHeadObject()) instanceof ColumnBindingInfo && ((ColumnBindingInfo)obj).getColumnType() == 1) {
                enabled = false;
            }
            this.setEnabled(enabled);
        }

        public void run() {
            if (this.eb != null) {
                this.eb.setBindingName(this.bindingName, true);
            }
        }
    }
}

